/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.CustomerSelectionChangeException;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.NumberUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class MemberPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    private static final String MEMBER_ACCOUNT = "MEMBER ACCOUNT";
    private SettleTicketProcessor settleTicketProcessor;

    public String getName() {
        return MEMBER_ACCOUNT;
    }

    public void pay(Ticket ticket, double tenderAmount, SettleTicketProcessor settleTicketProcessor) throws Exception {
        this.settleTicketProcessor = settleTicketProcessor;
        this.doSetMember(ticket);
        CustomerAccountTransaction transaction = (CustomerAccountTransaction)PaymentType.MEMBER_ACCOUNT.createTransaction(ticket, tenderAmount);
        settleTicketProcessor.settleTicket(transaction, this);
    }

    public String getId() {
        return MEMBER_ACCOUNT;
    }

    @Override
    public void paymentDone(PosTransaction transaction, Session session) {
        Ticket ticket = transaction.getTicket();
        Customer member = ticket.getCustomer();
        double customerBalance = member.getBalance() - transaction.getAmount();
        double customerCreditSpent = customerBalance < 0.0 ? -customerBalance : customerBalance;
        member.setBalance(customerBalance);
        member.setCreditSpent(customerCreditSpent);
        CustomerDAO.getInstance().saveOrUpdate(member, session);
        ticket.updateCustomerRef(member);
    }

    public double doRefund(Ticket ticket, List<PosTransaction> selectedTransactions) throws Exception {
        Session session = null;
        Transaction tx = null;
        try {
            ticket.setShouldUpdateStock(true);
            Customer member = this.doSetMember(ticket);
            double refundableAmount = this.getRefundableAmount(ticket);
            double refundAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("MemberPaymentPlugin.1"), refundableAmount);
            if (refundAmount <= 0.0) {
                throw new PosException(Messages.getString("MemberPaymentPlugin.2"));
            }
            if (refundAmount > refundableAmount) {
                throw new PosException(Messages.getString("MemberPaymentPlugin.3") + NumberUtil.round(refundableAmount));
            }
            double totalTransactionTaxAmount = this.calculateTaxAmount(ticket);
            Double refundTaxAmount = NumberUtil.roundToTwoDigit(totalTransactionTaxAmount * refundAmount / ticket.getPaidAmount());
            User currentUser = Application.getCurrentUser();
            session = CustomerDAO.getInstance().createNewSession();
            tx = session.beginTransaction();
            PosTransactionService transactionService = PosTransactionService.getInstance();
            RefundTransaction refundTransaction = transactionService.createRefundTransaction(ticket, null, refundAmount, true);
            refundTransaction.setPaymentType(PaymentType.MEMBER_ACCOUNT);
            refundTransaction.setCustomPaymentFieldName("MEMBER ID");
            refundTransaction.setCustomPaymentRef(member.getId());
            refundTransaction.setUser(currentUser);
            refundTransaction.setAmount(refundAmount);
            refundTransaction.setTaxAmount(refundTaxAmount);
            refundTransaction.setCustomerId(member.getId());
            member.setBalance(member.getBalance() + refundAmount);
            ticket.setRefundAmount(ticket.getRefundAmount() + refundAmount);
            ticket.addTotransactions(refundTransaction);
            ticket.calculateRefundAmount();
            ticket.calculatePrice();
            if (NumberUtil.isZero(ticket.getDueAmount())) {
                ticket.setClosed(true);
            }
            CustomerDAO.getInstance().saveOrUpdate(member, session);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
            double d = refundAmount;
            return d;
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            ticket.setShouldUpdateStock(false);
            if (session != null) {
                session.close();
            }
        }
    }

    private Customer doSetMember(Ticket ticket) {
        Customer member = ticket.getCustomer();
        if (member == null) {
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (ticket != null) {
                dialog.setTicket(ticket);
            }
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            member = dialog.getSelectedCustomer();
            if (member == null) {
                throw new PosException(Messages.getString("MemberNotSelected"));
            }
            ticket.setCustomer(member);
            OrderController.saveOrder(ticket);
            this.settleTicketProcessor.doInformListenerPaymentUpdate();
            throw new CustomerSelectionChangeException(POSConstants.CUSTOMER + " " + member.getName() + " " + Messages.getString("PaymentView.57"));
        }
        if (member.isRequireCashOrCredit()) {
            throw new PosException(Messages.getString("MemberPaymentPlugin.7"));
        }
        CustomerDAO.getInstance().refresh(member);
        return member;
    }

    public void voidPayment(PosTransaction transaction, Session session) {
        String customerId = transaction.getCustomerId();
        if (StringUtils.isEmpty((String)customerId)) {
            customerId = transaction.getTicket().getCustomerId();
        }
        if (StringUtils.isEmpty((String)customerId)) {
            throw new PosException(Messages.getString("MemberPaymentPlugin.8"));
        }
        Customer customer = CustomerDAO.getInstance().get(customerId);
        customer.setBalance(customer.getBalance() + transaction.getAmount());
        customer.setCreditSpent(customer.getCreditSpent() - transaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
    }

    public String getProductName() {
        return this.getName();
    }
}

