/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.print;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.ComboTicketItem;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseKitchenTicketItem;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.AwtReceiptPrinter;
import com.floreantpos.print.ITextPrinter;
import com.floreantpos.print.PrinterType;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.report.KitchenTicketDataSource;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.report.TicketDataSource;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Paragraph;
import io.github.escposjava.PrinterService;
import io.github.escposjava.print.Commands;
import io.github.escposjava.print.NetworkPrinter;
import io.github.escposjava.print.Printer;
import io.github.escposjava.print.SerialPortPrinter;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;

public class EscPosPrintService
extends ReceiptPrintServiceProvider {
    public static final int COL_RIGHT_FIELD_LENGTH = 13;
    public int totalCharLength;
    public int colLeftFieldLength;

    @Override
    public void printTicket(Ticket ticket, HashMap map, String deviceName) throws Exception {
        this.doPrint(deviceName, map, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printTransaction(Ticket ticket, HashMap map, PosTransaction transaction, String deviceName) throws Exception {
        this.doPrint(deviceName, map, ticket, transaction, new TicketDataSource(ticket, false));
    }

    @Override
    public void printRefundTicket(Ticket ticket, HashMap map, String deviceName) throws Exception {
        this.doPrint(deviceName, map, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printVoidTicket(Ticket ticket, HashMap map, String deviceName) throws Exception {
        this.doPrint(deviceName, map, ticket, new TicketDataSource(ticket, false));
    }

    @Override
    public void printKitchenTicket(KitchenTicket kitchenTicket, HashMap map, Ticket ticket, String printerName, String deviceName) throws Exception {
        this.doPrint(deviceName, map, ticket, new KitchenTicketDataSource(kitchenTicket));
    }

    @Override
    public void printVoidKitchenTicket(KitchenTicket kitchenTicket, HashMap map, String printerName, String deviceName) throws Exception {
        this.doPrint(deviceName, map, null, new KitchenTicketDataSource(kitchenTicket));
    }

    @Override
    public void rendererTicketReceipt(Ticket ticket, JPanel reportPanel) throws Exception {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
        ITextPrinter printer = ITextPrinter.create();
        printer.createReport(null, map, new TicketDataSource(ticket));
        printer.rendererReport(reportPanel);
    }

    @Override
    public void rendererPosTransactionReceipt(PosTransaction transaction, JPanel reportPanel) throws Exception {
        try {
            Ticket ticket = transaction.getTicket();
            TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            map.put("IS_IGNORE_PAGINATION", true);
            if (transaction != null && transaction.isCard()) {
                CardReader cardReader = CardReader.fromString(transaction.getCardReader());
                if (cardReader == CardReader.EXTERNAL_TERMINAL) {
                    return;
                }
                map.put("copyType", Messages.getString("ReceiptPrintService.5"));
                ITextPrinter printer = ITextPrinter.create();
                printer.createReport(null, map, new TicketDataSource(ticket));
                printer.rendererReport(reportPanel);
            } else {
                ITextPrinter printer = ITextPrinter.create();
                printer.createReport(null, map, new TicketDataSource(ticket));
                printer.rendererReport(reportPanel);
            }
        }
        catch (Exception e) {
            ReceiptPrintService.getLogger().error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    @Override
    public void rendererKitchenReceipt(Ticket ticket, JPanel reportPanel) throws Exception {
        block0: {
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, false);
            Iterator<KitchenTicket> iterator = kitchenTickets.iterator();
            if (!iterator.hasNext()) break block0;
            KitchenTicket kitchenTicket = iterator.next();
            kitchenTicket.setParentTicket(ticket);
            HashMap<String, Object> map = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, "", "", true);
            ITextPrinter printer = ITextPrinter.create();
            printer.createReport(null, map, new KitchenTicketDataSource(kitchenTicket));
            printer.rendererReport(reportPanel);
        }
    }

    private void doPrint(String deviceName, Map<String, Object> params, Ticket ticket, AbstractReportDataSource dataSource) throws Exception {
        this.doPrint(deviceName, params, ticket, null, dataSource);
    }

    private void doPrint(String deviceName, Map<String, Object> params, Ticket ticket, PosTransaction transaction, AbstractReportDataSource dataSource) throws Exception {
        this.calculateTextLength(params);
        PrinterService ps = this.createPrintService(deviceName, params);
        Object fontWeight = params.get("headerLine1.font-weight");
        if (fontWeight == null || StringUtils.isBlank((String)fontWeight.toString())) {
            this.addBoldText(ps, params, "headerLine1", Commands.TXT_ALIGN_CT);
        } else {
            this.addText(ps, params, "headerLine1", Commands.TXT_ALIGN_CT);
        }
        this.addText(ps, params, "ticketHeader", Commands.TXT_ALIGN_CT);
        this.br(ps);
        this.addText(ps, params, "additionalOrderInfo", Commands.TXT_ALIGN_LT);
        this.addSeparator(ps);
        Store store = DataProvider.get().getStore();
        List rows = dataSource.getRows();
        if (rows != null) {
            this.applyFontWeightStyle(params, ps, "orderDetails");
            if (dataSource instanceof TicketDataSource) {
                this.applyFontTextSizeAndTypeStyle(ps, params, "orderDetails", null);
                TicketDataSource ticketDataSource = (TicketDataSource)dataSource;
                for (Object item : rows) {
                    String name;
                    if (StringUtils.isEmpty((String)item.getNameDisplay())) continue;
                    this.renderTextColor(ps, ticketDataSource.getColorCode(store, (ITicketItem)item));
                    String displayString = name = this.getText(item.getNameDisplay(), "left", this.colLeftFieldLength);
                    String subTotalAmountDisplay = item.getSubTotalAmountDisplay();
                    if (StringUtils.isNotEmpty((String)subTotalAmountDisplay)) {
                        int comboItemNameIndex;
                        if (item instanceof ComboTicketItem && (comboItemNameIndex = name.indexOf("\n")) != -1) {
                            ps.printRight(this.wrapLine(this.getText(name.substring(0, comboItemNameIndex), "left", this.colLeftFieldLength), this.colLeftFieldLength, subTotalAmountDisplay));
                            this.br(ps);
                            String[] comboItems = name.substring(comboItemNameIndex).split("\n");
                            if (comboItems.length <= 0) continue;
                            for (String comboItem : comboItems) {
                                if (StringUtils.isBlank((String)comboItem)) continue;
                                ps.printRight(this.wrapLine(this.getText(comboItem, "left", this.colLeftFieldLength), this.colLeftFieldLength, " "));
                                this.br(ps);
                            }
                            continue;
                        }
                        displayString = name.length() > this.colLeftFieldLength ? this.wrapLine(name, this.colLeftFieldLength, subTotalAmountDisplay) : displayString + this.getText(subTotalAmountDisplay, "right", 13);
                    } else {
                        displayString = displayString + this.getText(" ", "right", 13);
                    }
                    ps.printRight(displayString);
                    this.br(ps);
                }
            } else if (dataSource instanceof KitchenTicketDataSource) {
                this.applyFontTextSizeAndTypeStyle(ps, params, "orderDetails", new byte[]{27, 33, 22});
                KitchenTicketDataSource kitchenTicketDataSource = (KitchenTicketDataSource)dataSource;
                for (Object item : rows) {
                    if (StringUtils.isEmpty((String)((KitchenTicketItem)item).getMenuItemNameDisplay())) continue;
                    this.renderTextColor(ps, kitchenTicketDataSource.getColorCode((KitchenTicketItem)item, ((BaseKitchenTicketItem)item).getKitchenTicket().getOrderTypeId()));
                    ps.printLeft(((KitchenTicketItem)item).getMenuItemNameDisplay());
                    this.br(ps);
                }
            }
        }
        ps.setTextColor(Commands.COLOR_BLACK);
        ps.setTextNormal();
        this.addSeparator(ps);
        this.applyFontWeightStyle(params, ps, "orderDetails");
        this.applyFontTextSizeAndTypeStyle(ps, params, "orderDetails", null);
        if (dataSource instanceof TicketDataSource) {
            boolean showTipsSection;
            this.addRow(ps, params, "totalText", "grandSubtotal", false);
            this.addRow(ps, params, "discountText", "discountAmount");
            boolean isShowTaxBreakdown = Boolean.parseBoolean(String.valueOf(params.get("isShowTaxBreakdown")));
            if (!isShowTaxBreakdown) {
                this.addRow(ps, params, "taxText", "taxAmount");
            } else {
                params.put("taxBreakdownText", ReceiptPrintService.getTaxBreakdown(ticket, this.colLeftFieldLength, 13, true, store));
                this.addText(ps, params, "taxBreakdownText", Commands.TXT_ALIGN_RT);
            }
            this.addRow(ps, params, "serviceChargeText", "serviceCharge");
            this.addRow(ps, params, "deliveryChargeText", "deliveryCharge");
            this.addSeparator(ps);
            this.addRow(ps, params, "netAmountText", "netAmount", false);
            this.addRow(ps, params, "paidAmountText", "paidAmount", false);
            this.addRow(ps, params, "refundAmountText", "refundAmount");
            this.addRow(ps, params, "tenderAmountText", "tenderAmount");
            this.addRow(ps, params, "dueAmountText", "dueAmount", false);
            if (params.get("tenderAmount") != null) {
                this.addRow(ps, params, "changeAmountText", "changedAmount");
            }
            this.addRow(ps, params, "tipsText", "tipAmount");
            if (params.get("showTips") != null) {
                this.br(ps);
                this.addText(ps, params, "showTips", Commands.TXT_ALIGN_CT);
            }
            this.addRow(ps, params, "feeAmountText", "feeAmount");
            params.put("additionalPaymentProperties", EscPosPrintService.buildPayments(ticket, true));
            this.addText(ps, params, "additionalPaymentProperties", Commands.TXT_ALIGN_RT);
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                StringBuilder multiCurrencyBreakdownCashBack = ReceiptPrintService.buildMultiCurrency(ticket, transaction, null, true);
                if (multiCurrencyBreakdownCashBack != null) {
                    params.put("additionalProperties", multiCurrencyBreakdownCashBack.toString());
                } else {
                    StringBuilder multiCurrencyTotalAmount = ReceiptPrintService.buildMulticurrencyBreakdown(ticket, null, true);
                    if (multiCurrencyTotalAmount != null) {
                        params.put("additionalProperties", multiCurrencyTotalAmount.toString());
                    }
                }
            }
            this.addText(ps, params, "additionalProperties", Commands.TXT_ALIGN_RT);
            boolean cardPayment = Boolean.parseBoolean(String.valueOf(params.get("cardPayment")));
            boolean bl = showTipsSection = cardPayment && Boolean.parseBoolean(String.valueOf(params.get("showTipsBlock")));
            if (showTipsSection) {
                this.addTextWithUnderline(ps, this.getText(Messages.getString("EscPosPrintService.4"), "left", this.colLeftFieldLength));
                this.addTextWithUnderline(ps, this.getText(Messages.getString("EscPosPrintService.5"), "left", this.colLeftFieldLength));
                this.addTextWithUnderline(ps, this.getText(Messages.getString("EscPosPrintService.6"), "left", this.colLeftFieldLength));
            }
            if (cardPayment) {
                this.addText(ps, params, "approvalCode", Commands.TXT_ALIGN_LT);
            }
            this.addText(ps, params, "bottomMessage", Commands.TXT_ALIGN_LT);
            this.br(ps);
            this.addText(ps, params, "copyType", Commands.TXT_ALIGN_CT);
            this.addText(ps, params, "footerMessage", Commands.TXT_ALIGN_CT);
        } else {
            this.addText(ps, params, "printerName", Commands.TXT_ALIGN_LT);
            this.addText(ps, params, "bottomMessage", Commands.TXT_ALIGN_LT);
            this.addText(ps, params, "footerMessage", Commands.TXT_ALIGN_CT);
        }
        ps.lineBreak(3);
        this.close(ps);
    }

    public PrinterService createPrintService(String deviceName, Map<String, Object> params) {
        String printerType = EscPosPrintService.valueOf(params.get("printerType"));
        PrinterService ps = null;
        ps = printerType.equals(PrinterType.NETWORK.getName()) ? new PrinterService((Printer)EscPosPrintService.getNetworkPrinter(params)) : (printerType.equals(PrinterType.SERIAL.getName()) ? new PrinterService((Printer)new SerialPortPrinter(String.valueOf(params.get("serialPort")))) : new PrinterService((Printer)new AwtReceiptPrinter(deviceName)));
        ps.open();
        ps.init();
        return ps;
    }

    public static NetworkPrinter getNetworkPrinter(Map params) {
        String printerIp = EscPosPrintService.valueOf(params.get("ipAddress"));
        int printerPort = POSUtil.parseInteger(String.valueOf(params.get("ipPort")));
        return new NetworkPrinter(printerIp, printerPort);
    }

    public void close(PrinterService ps) throws Exception {
        ps.cutPart();
        ps.close();
    }

    private void renderTextColor(PrinterService ps, String color) {
        if (StringUtils.isEmpty((String)color)) {
            ps.setTextColor(Commands.COLOR_BLACK);
            return;
        }
        if (color.equalsIgnoreCase("#ff0000")) {
            ps.setTextColor(Commands.COLOR_RED);
        } else {
            ps.setTextColor(Commands.COLOR_BLACK);
        }
    }

    private String wrapLine(String line, int lineLength, String subtotalAmount) {
        String linebreak = "\n";
        if (line.length() == 0) {
            return "";
        }
        if (line.length() <= lineLength) {
            return line + this.getText(subtotalAmount, "right", 13);
        }
        String[] words = line.split(" ");
        StringBuilder allLines = new StringBuilder();
        StringBuilder trimmedLine = new StringBuilder();
        for (String word : words) {
            if (trimmedLine.length() + 1 + word.length() <= lineLength) {
                trimmedLine.append(word).append(" ");
                continue;
            }
            allLines.append(this.getText(trimmedLine.toString(), "left", this.colLeftFieldLength) + this.getText(subtotalAmount, "right", 13)).append(linebreak);
            trimmedLine = new StringBuilder();
            trimmedLine.append(word).append(" ");
            subtotalAmount = " ";
        }
        if (trimmedLine.length() > 0) {
            allLines.append(this.getText(trimmedLine.toString(), "left", this.colLeftFieldLength) + this.getText(subtotalAmount, "right", 13));
        }
        return allLines.toString();
    }

    private void calculateTextLength(Map<String, Object> params) {
        this.totalCharLength = POSUtil.getInteger(params.get("textLength"));
        if (this.totalCharLength <= 0) {
            this.totalCharLength = 42;
        }
        this.colLeftFieldLength = this.totalCharLength - 13;
    }

    private void br(PrinterService ps) {
        ps.lineBreak();
    }

    private void addImage(Map<String, Object> parameters, PrinterService service) {
        Image is = (Image)parameters.get("storeLogoIcon");
        if (is != null) {
            try {
                service.printImage(POSUtil.convertBlackAndWhiteImage(is));
            }
            catch (Exception e) {
                PosLog.error(ReceiptPrintService.class, e);
            }
        }
    }

    private void addBarcode(Map<String, Object> parameters, PrinterService service) {
        Object barcode = parameters.get(ReceiptParam.BARCODE.getParamName());
        if (barcode != null) {
            try {
                service.printBarcode(barcode.toString(), "CODE128", 255, 2, "OFF", "A");
            }
            catch (Exception e) {
                PosLog.error(ReceiptPrintService.class, e);
            }
        }
    }

    private void addRow(PrinterService service, Map<String, Object> parameters, String labelKey, String valueKey) {
        this.addRow(service, parameters, labelKey, valueKey, true);
    }

    private void addRow(PrinterService service, Map<String, Object> parameters, String labelKey, String valueKey, boolean removeNullOrBlank) {
        Object value = parameters.get(valueKey);
        if (removeNullOrBlank && (value == null || value.equals("null") || value.equals("0.00"))) {
            return;
        }
        service.printRight(parameters.get(labelKey) + this.getText(String.valueOf(parameters.get(valueKey)), "right", 13));
        this.br(service);
    }

    public String getText(String txt, String align, int length) {
        if (txt == null) {
            txt = "";
        }
        if (align.equals("center")) {
            int space = (length - txt.length()) / 2;
            for (int i = 1; i <= space; ++i) {
                txt = " " + txt + " ";
            }
            return txt;
        }
        if (align.equals("right")) {
            int space = length - txt.length();
            for (int i = 1; i <= space; ++i) {
                txt = " " + txt;
            }
            return txt;
        }
        if (align.equals("left")) {
            int space = length - txt.length();
            for (int i = 1; i <= space; ++i) {
                txt = txt + " ";
            }
            return txt;
        }
        return null;
    }

    private void addSeparator(PrinterService ps) {
        String sep = "";
        for (int i = 0; i < this.totalCharLength; ++i) {
            sep = sep + "-";
        }
        ps.printLn(Commands.TXT_ALIGN_RT, sep);
    }

    public void addBoldText(PrinterService service, Map<String, Object> parameters, String key, byte[] align) {
        service.setTextTypeBold();
        this.addText(service, parameters, key, align, true);
        service.setTextTypeNormal();
        this.br(service);
    }

    public void addText(PrinterService service, Map<String, Object> parameters, String key, byte[] align) {
        boolean bold = POSUtil.getBoolean(parameters.getOrDefault(key + ".font-weight", "false").toString());
        this.applyFontTextSizeAndTypeStyle(service, parameters, key, null);
        this.addText(service, parameters, key, align, bold);
        service.setTextTypeNormal();
        service.setTextFontA();
    }

    private void applyFontTextSizeAndTypeStyle(PrinterService service, Map<String, Object> parameters, String key, byte[] defaultFontSize) {
        try {
            byte[] fontTypeValue;
            String fontSize = parameters.getOrDefault(key + ".font-size", "").toString();
            if (StringUtils.isNotBlank((String)fontSize)) {
                byte[] fontSizeValue = this.convertStringToByteArray("1b21" + fontSize);
                if (fontSizeValue != null) {
                    service.write(fontSizeValue);
                }
            } else if (defaultFontSize != null) {
                service.write(defaultFontSize);
            }
            String fontType = parameters.getOrDefault(key + ".font-type", "").toString();
            if (StringUtils.isNotBlank((String)fontType) && (fontTypeValue = this.convertStringToByteArray("1b4d" + fontType)) != null) {
                service.write(fontTypeValue);
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void applyFontWeightStyle(Map<String, Object> params, PrinterService ps, String key) {
        try {
            Object detailsFontWeight = params.get(key + ".font-weight");
            if (detailsFontWeight != null && StringUtils.isNotBlank((String)detailsFontWeight.toString())) {
                boolean bold = POSUtil.getBoolean(detailsFontWeight.toString());
                if (bold) {
                    ps.setTextTypeBold();
                } else {
                    ps.setTextTypeNormal();
                }
            }
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public void addText(PrinterService service, Map<String, Object> parameters, String key, byte[] align, boolean bold) {
        String[] splitTexts;
        String text = String.valueOf(parameters.get(key));
        if (StringUtils.isEmpty((String)text) || text.equals("null")) {
            return;
        }
        if (text.contains("<strike>")) {
            text = text.replaceAll("<div><span><strike>", Messages.getString("EscPosPrintService.25"));
        }
        if ((splitTexts = text.split("<br>")).length > 0) {
            for (int i = 0; i < splitTexts.length; ++i) {
                String p = splitTexts[i];
                if (StringUtils.isEmpty((String)p)) {
                    service.print("\n");
                    continue;
                }
                if (p.contains("<storeLogo")) {
                    this.addImage(parameters, service);
                    continue;
                }
                if (p.contains("<barcode>")) {
                    this.addText(service, align, bold, p, false);
                    this.addBarcode(parameters, service);
                    continue;
                }
                this.addText(service, align, bold, p);
            }
        }
    }

    private void addText(PrinterService service, byte[] align, boolean bold, String text) {
        this.addText(service, align, bold, text, true);
    }

    private void addText(PrinterService service, byte[] align, boolean bold, String text, boolean newLine) {
        String displayText;
        if (text.contains("<b>") || bold) {
            service.setTextTypeBold();
        }
        if (StringUtils.isBlank((String)(displayText = text.replaceAll("<.*?>", "").replaceAll("</", "").replaceAll("&nbsp;", " ")))) {
            return;
        }
        if (newLine) {
            service.printLn(align, displayText);
        } else {
            service.print(align, displayText);
        }
        if (text.contains("</b>")) {
            service.setTextTypeNormal();
        }
    }

    private byte[] convertStringToByteArray(String string) {
        try {
            if (StringUtils.isBlank((String)string)) {
                return null;
            }
            return Hex.decodeHex((char[])string.toCharArray());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void addTextWithUnderline(PrinterService service, String text) {
        this.br(service);
        service.setTextTypeUnderline();
        service.printLn(Commands.TXT_ALIGN_RT, text);
        service.setTextTypeNormal();
        this.br(service);
    }

    public void addLine(Document document, int number) throws DocumentException {
        for (int i = 0; i < number; ++i) {
            document.add((Element)new Paragraph(" "));
        }
    }

    @Override
    public void testPrinter(HashMap<String, Object> map, String deviceName) throws Exception {
        PrinterService pService = this.createPrintService(deviceName, map);
        this.addBoldText(pService, map, "title", Commands.TXT_ALIGN_CT);
        this.addText(pService, map, "data", Commands.TXT_ALIGN_LT);
        this.close(pService);
    }

    public static String valueOf(Object object) {
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static StringBuilder buildPayments(Ticket ticket, boolean escPrint) {
        Set<PosTransaction> transactionList = ticket.getTransactions();
        if (transactionList == null || transactionList.size() < 1) {
            return null;
        }
        ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>(transactionList);
        Collections.sort(transactions, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction o1, PosTransaction o2) {
                if (o1.getTransactionTime() == null) {
                    return -1;
                }
                if (o2.getTransactionTime() == null) {
                    return 1;
                }
                return o1.getTransactionTime().compareTo(o2.getTransactionTime());
            }
        });
        StringBuilder paymentsBuilder = new StringBuilder();
        paymentsBuilder.append("<html><table>");
        ReceiptPrintService.beginRow(paymentsBuilder);
        String sp = " ";
        ReceiptPrintService.addColumn(paymentsBuilder, sp);
        ReceiptPrintService.addColumn(paymentsBuilder, sp);
        ReceiptPrintService.addColumn(paymentsBuilder, sp);
        ReceiptPrintService.endRow(paymentsBuilder);
        ReceiptPrintService.beginRow(paymentsBuilder);
        ReceiptPrintService.addColumn(paymentsBuilder, "Settlements:");
        ReceiptPrintService.endRow(paymentsBuilder);
        String tagStart = "";
        String tagEng = "";
        int amtLength = 13;
        int tipsLength = 0;
        boolean tipsExists = false;
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        for (PosTransaction transaction : transactions) {
            if (!(transaction.getTipsAmount() > 0.0)) continue;
            tipsExists = true;
            tipsLength = 13;
            break;
        }
        for (PosTransaction transaction : transactions) {
            String tipsAmountText;
            ReceiptPrintService.beginRow(paymentsBuilder);
            tagStart = transaction.isVoided() != false ? "<strike>" : "";
            tagEng = transaction.isVoided() != false ? "</strike>" : "";
            Double amount = transaction.getAmount();
            String amountText = NumberUtil.formatNumberAcceptNegative(transaction instanceof RefundTransaction ? -amount.doubleValue() : amount);
            String string = tipsAmountText = transaction.getTipsAmount() > 0.0 ? NumberUtil.formatNumber(transaction.getTipsAmount()) : "";
            if (!escPrint) {
                amtLength = amountText.length() + (14 - amountText.length()) * 2;
                tipsLength = tipsAmountText.length() + (7 - tipsAmountText.length()) * 2;
            }
            String paymentTypeText = transaction.getPaymentType().getDisplayString() + currencySymbol;
            ReceiptPrintService.addColumn(paymentsBuilder, tagStart + ReceiptPrintService.getHtmlText(paymentTypeText, paymentTypeText.length(), "right") + tagEng);
            if (tipsExists) {
                ReceiptPrintService.addColumn(paymentsBuilder, tagStart + ReceiptPrintService.getHtmlText(tipsAmountText, tipsLength, "right") + tagEng);
            }
            ReceiptPrintService.addColumn(paymentsBuilder, ReceiptPrintService.getHtmlText(tagStart + amountText, amtLength, "right") + tagEng);
            ReceiptPrintService.endRow(paymentsBuilder);
        }
        paymentsBuilder.append("</table></html>");
        return paymentsBuilder;
    }
}

