/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.DeliverySummaryReportData;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.DeliverySummaryReportModel;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class DeliverySummaryReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;

    public DeliverySummaryReportView() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = DateUtil.startOfDay(this.fromDatePicker.getDate());
        if (fromDate.after(toDate = DateUtil.endOfDay(this.toDatePicker.getDate()))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        PosLog.debug(this.getClass(), String.format("Delivery summary report, start: %s end: %s", fromDate, toDate));
        List<DeliverySummaryReportData> ticketList = TicketDAO.getInstance().findTicketsForDeliverySummaryReport(fromDate, toDate);
        PosLog.debug(this.getClass(), String.format("Found %s tickets", ticketList.size()));
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("delivery_summary_report"));
        HashMap properties = new HashMap();
        ReportUtil.populateRestaurantProperties(properties);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        DeliverySummaryReportModel reportModel = new DeliverySummaryReportModel();
        reportModel.setRows(ticketList);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap properties) {
        properties.put("reportTitle", POSConstants.DELIVERY_SUMMARY_REPORT);
        properties.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("colSubtotal", POSConstants.SUBTOTAL + ":");
        properties.put("colMName", Messages.getString("MEMBER"));
        properties.put("colTID", POSConstants.TICKET_ID);
        properties.put("colTAmount", POSConstants.TICKET + " " + POSConstants.AMOUNT.toLowerCase());
        properties.put("colSC", POSConstants.S_C);
        properties.put("colTips", Messages.getString("GRATUITY"));
        properties.put("colTax", POSConstants.TAX);
        properties.put("colTotal", POSConstants.TOTAL);
        properties.put("colMCharge", Messages.getString("MEMBER") + "<br/>" + Messages.getString("CHARGE"));
        properties.put("colCCard", Messages.getString("colCredit") + "<br/>" + Messages.getString("CARD"));
        properties.put("colCPayment", Messages.getString("CashPayment"));
        properties.put("colOthersPymt", Messages.getString("OthersPayment"));
        properties.put("colDiscount", POSConstants.DISCOUNT);
        properties.put("colCreateDate", POSConstants.CREATED);
        properties.put("colDelDate", Messages.getString("DeliveryDate"));
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        this.fromDatePicker = UiUtil.getDeafultDate();
        this.fromDatePicker.setDate(new Date());
        this.toDatePicker = UiUtil.getDeafultDate();
        this.toDatePicker.setDate(new Date());
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DeliverySummaryReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public JComponent getRootComponent() {
        return this.contentPane;
    }
}

