/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.util.DateUtil;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.ListTableModel;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class JournalReportModel {
    private Date fromDate;
    private Date toDate;
    private Date reportTime;
    private List<JournalReportData> reportDatas = new ArrayList<JournalReportData>();
    private JournalReportTableModel tableModel;

    public JournalReportTableModel getTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new JournalReportTableModel(this.reportDatas);
        }
        return this.tableModel;
    }

    public Date getFromDate() {
        if (this.fromDate == null) {
            return DateUtil.startOfDay(new Date());
        }
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getReportTime() {
        return this.reportTime;
    }

    public void setReportTime(Date reportTime) {
        this.reportTime = reportTime;
    }

    public Date getToDate() {
        if (this.toDate == null) {
            return DateUtil.endOfDay(new Date());
        }
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void addReportData(JournalReportData data) {
        this.reportDatas.add(data);
    }

    public static class JournalReportTableModel
    extends ListTableModel {
        public JournalReportTableModel(List<JournalReportData> datas) {
            super(new String[]{"time", "action", "user", "comment"}, datas);
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            JournalReportData data = (JournalReportData)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ReportService.formatFullDate(data.getTime());
                }
                case 1: {
                    return data.getAction();
                }
                case 2: {
                    return data.getUserInfo();
                }
                case 3: {
                    return data.getComments();
                }
            }
            return null;
        }
    }

    public static class JournalReportData {
        private Date time;
        private String action;
        private String userInfo;
        private String comments;

        public String getAction() {
            return this.action;
        }

        public void setAction(String action) {
            this.action = action;
        }

        public String getComments() {
            return this.comments;
        }

        public void setComments(String comments) {
            this.comments = comments;
        }

        public Date getTime() {
            return this.time;
        }

        public void setTime(Date time) {
            this.time = time;
        }

        public String getUserInfo() {
            return this.userInfo;
        }

        public void setUserInfo(String userInfo) {
            this.userInfo = userInfo;
        }
    }
}

