/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.report.AbstractReportDataSource;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class KitchenStickerModel
extends AbstractReportDataSource {
    public KitchenStickerModel(List<KitchenSticker> items) {
        super(new String[]{"itemCount", "item", "itemModifier", "cookingInstruction", "time", "other", "token", "customerName"});
        this.setRows(items);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        KitchenSticker item = (KitchenSticker)this.rows.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getItemCount();
            }
            case 1: {
                return item.getItemName();
            }
            case 2: {
                return this.getModifiers(item);
            }
            case 3: {
                return this.getCookingInsgtruction(item);
            }
            case 4: {
                return item.getTime();
            }
            case 5: {
                return item.getOrderType();
            }
            case 6: {
                return item.getToken();
            }
            case 7: {
                String customerName = item.getCustomerName();
                if (!StringUtils.isNotEmpty((String)customerName)) break;
                return customerName;
            }
        }
        return null;
    }

    public String getModifiers(KitchenSticker item) {
        List<KitchenTicketItem> modifiers = item.getModifiers();
        String modifierName = "<html><body>";
        if (modifiers == null) {
            return modifierName + "</body></html>";
        }
        for (KitchenTicketItem kitchenTicketItem : modifiers) {
            modifierName = modifierName + kitchenTicketItem.getMenuItemName() + "<br>";
        }
        return modifierName + "</body></html>";
    }

    public String getCookingInsgtruction(KitchenSticker item) {
        List<KitchenTicketItem> kitchenTicketItems = item.getCookingInstructions();
        String instruction = "<html><body>";
        if (kitchenTicketItems == null) {
            return instruction + "</body></html>";
        }
        for (KitchenTicketItem kitchenTicketItem : kitchenTicketItems) {
            instruction = instruction + kitchenTicketItem.getMenuItemName() + "<br>";
        }
        return instruction;
    }

    public static class KitchenSticker {
        private String itemName;
        private List<KitchenTicketItem> cookingInstructions;
        private List<KitchenTicketItem> modifiers;
        private String time;
        private String orderType;
        private String itemCount;
        private Integer token;
        private String customerName;

        public String getItemName() {
            return this.itemName;
        }

        public void setItemName(String itemName) {
            this.itemName = itemName;
        }

        public String getTime() {
            return this.time;
        }

        public void setTime(String time) {
            this.time = time;
        }

        public String getOrderType() {
            return this.orderType;
        }

        public void setOrderType(String orderType) {
            this.orderType = orderType;
        }

        public String getItemCount() {
            return this.itemCount;
        }

        public void setItemCount(String itemCount) {
            this.itemCount = itemCount;
        }

        public List<KitchenTicketItem> getCookingInstructions() {
            return this.cookingInstructions;
        }

        public void setCookingInstructions(List<KitchenTicketItem> cookingInstructions) {
            this.cookingInstructions = cookingInstructions;
        }

        public List<KitchenTicketItem> getModifiers() {
            return this.modifiers;
        }

        public void setModifiers(List<KitchenTicketItem> modifiers) {
            this.modifiers = modifiers;
        }

        public Integer getToken() {
            return this.token;
        }

        public void setToken(Integer token) {
            this.token = token;
        }

        public String getCustomerName() {
            return this.customerName;
        }

        public void setCustomerName(String customerName) {
            this.customerName = customerName;
        }
    }
}

