/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AttendenceHistoryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.AttendanceReportData;
import com.floreantpos.report.AttendanceReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class PayrollReportView
extends TransparentPanel {
    private JButton btnGo;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private JPanel reportPanel;
    private JPanel contentPane;
    private MultiSelectComboBox<User> jcbEmployee;
    private OverflowCombobox cbEmployeeType;
    private JCheckBox chkMemberFirstName;
    private JCheckBox chkMemberLastName;

    public PayrollReportView() {
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void viewReport() throws Exception {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        toDate = calendar.getTime();
        List<User> users = this.jcbEmployee.getSelectedItems();
        Object selectedItem = this.cbEmployeeType.getSelectedItem();
        UserType userType = null;
        if (selectedItem instanceof UserType) {
            userType = (UserType)selectedItem;
        }
        AttendenceHistoryDAO dao = new AttendenceHistoryDAO();
        List<AttendanceReportData> findPayroll = dao.findAttendance(fromDate, toDate, users, userType);
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("PayrollReport"));
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, true);
        ReportUtil.populateReportTime(properties, fromDate, toDate);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        properties.put("rate", Messages.getString("PayrollReportView.1") + CurrencyUtil.getCurrencySymbolWithBracket());
        properties.put("payment", Messages.getString("PayrollReportView.5") + CurrencyUtil.getCurrencySymbolWithBracket());
        AttendanceReportModel reportModel = new AttendanceReportModel();
        Comparator<AttendanceReportData> comparatorEmployeeFirstName = Comparator.comparing(AttendanceReportData::getEmployeeFirstName, Comparator.nullsLast(Comparator.naturalOrder()));
        Comparator<AttendanceReportData> comparatorEmployeeLastName = Comparator.comparing(AttendanceReportData::getEmployeeLastName, Comparator.nullsLast(Comparator.naturalOrder()));
        if (this.chkMemberFirstName.isSelected() && this.chkMemberLastName.isSelected()) {
            findPayroll.sort(comparatorEmployeeFirstName.thenComparing(comparatorEmployeeLastName));
        } else if (this.chkMemberFirstName.isSelected()) {
            findPayroll.sort(comparatorEmployeeFirstName);
        } else if (this.chkMemberLastName.isSelected()) {
            findPayroll.sort(comparatorEmployeeLastName);
        } else {
            Collections.sort(findPayroll, new Comparator<AttendanceReportData>(){

                @Override
                public int compare(AttendanceReportData o1, AttendanceReportData o2) {
                    if (o1.getUser().getParentUserId() == null || o2.getUser().getParentUserId() == null) {
                        return 0;
                    }
                    return o1.getUser().getParentUserId().compareTo(o2.getUser().getParentUserId());
                }
            });
        }
        reportModel.setRows(findPayroll);
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    private void populateReportParams(HashMap map) {
        map.put("RTitle", Messages.getString("PayrollReport"));
        map.put("colEID", Messages.getString("EmployeeId") + ":");
        map.put("colEName", Messages.getString("EmployeeName") + ":");
        map.put("colCIn", Messages.getString("PayrollReportView.2"));
        map.put("colCOut", Messages.getString("PayrollReportView.3"));
        map.put("colWHour", Messages.getString("WorkHour"));
        map.put("colRole", Messages.getString("colRole") + ":");
        map.put("rowTotal", POSConstants.TOTAL + ":");
        map.put("rowGrandTotal", POSConstants.GRAND_TOTAL);
    }

    private void createUI() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getDeafultDate();
        this.toDatePicker.setDate(new Date());
        this.cbEmployeeType = new OverflowCombobox();
        List<UserType> userTypes = UserTypeDAO.getInstance().findAll();
        Vector<Object> userTypesList = new Vector<Object>();
        userTypesList.add(POSConstants.ALL);
        userTypesList.addAll(userTypes);
        this.cbEmployeeType.setModel(new DefaultComboBoxModel(userTypesList));
        JLabel lblSortBy = new JLabel(Messages.getString("EndOfDaySummaryReportView.1") + ":");
        this.chkMemberFirstName = new JCheckBox(Messages.getString("PayrollReportView.4"));
        this.chkMemberLastName = new JCheckBox(Messages.getString("PayrollReportView.6"));
        this.btnGo = new JButton();
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PayrollReportView.this.viewReport();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
        List<User> users = UserDAO.getInstance().findAllActive();
        this.jcbEmployee = new MultiSelectionOverflowCombobox<User>();
        this.jcbEmployee.setItems(users);
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        topPanel.add(new JLabel(POSConstants.EMPLOYEE + ":"));
        topPanel.add(this.jcbEmployee);
        topPanel.add(new JLabel(Messages.getString("ROLE") + ":"));
        topPanel.add((Component)this.cbEmployeeType, "width 120!");
        topPanel.add(new JLabel(POSConstants.START_DATE + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(new JLabel(POSConstants.END_DATE + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(lblSortBy);
        topPanel.add(this.chkMemberFirstName);
        topPanel.add(this.chkMemberLastName);
        topPanel.add((Component)this.btnGo, "width 60!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    public JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    public static class LaborReportData {
        private String period;
        private int noOfChecks;
        private int noOfGuests;
        private double sales;
        private double manHour;
        private double labor;
        private double salesPerMHr;
        private double guestsPerMHr;
        private double checkPerMHr;
        private double laborCost;

        public double getCheckPerMHr() {
            return this.checkPerMHr;
        }

        public void setCheckPerMHr(double checkPerMHr) {
            this.checkPerMHr = checkPerMHr;
        }

        public double getGuestsPerMHr() {
            return this.guestsPerMHr;
        }

        public void setGuestsPerMHr(double guestsPerMHr) {
            this.guestsPerMHr = guestsPerMHr;
        }

        public double getLabor() {
            return this.labor;
        }

        public void setLabor(double labor) {
            this.labor = labor;
        }

        public double getLaborCost() {
            return this.laborCost;
        }

        public void setLaborCost(double laborCost) {
            this.laborCost = laborCost;
        }

        public double getManHour() {
            return this.manHour;
        }

        public void setManHour(double manHour) {
            this.manHour = manHour;
        }

        public int getNoOfChecks() {
            return this.noOfChecks;
        }

        public void setNoOfChecks(int noOfChecks) {
            this.noOfChecks = noOfChecks;
        }

        public int getNoOfGuests() {
            return this.noOfGuests;
        }

        public void setNoOfGuests(int noOfGuests) {
            this.noOfGuests = noOfGuests;
        }

        public String getPeriod() {
            return this.period;
        }

        public void setPeriod(String period) {
            this.period = period;
        }

        public double getSales() {
            return this.sales;
        }

        public void setSales(double sales) {
            this.sales = sales;
        }

        public double getSalesPerMHr() {
            return this.salesPerMHr;
        }

        public void setSalesPerMHr(double salesPerMHr) {
            this.salesPerMHr = salesPerMHr;
        }
    }
}

