/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Address;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.LabelItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Printer;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.PurchaseOrder;
import com.floreantpos.model.ReceiptParam;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.SubOrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalPrinters;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.User;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalPrintersDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.ext.KitchenStatus;
import com.floreantpos.model.ext.KitchenStickerPaperSize;
import com.floreantpos.model.ext.ReciptPaperSize;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.EscPosPrintService;
import com.floreantpos.print.JasperPrintService;
import com.floreantpos.print.ReceiptPrintServiceProvider;
import com.floreantpos.report.KitchenStickerModel;
import com.floreantpos.report.LabelPrinterTableModel;
import com.floreantpos.report.OrderDataSource;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.TicketPrintProperties;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PreviewTicketUtil;
import com.floreantpos.util.PrintServiceUtil;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.versioning.VersionInfo;
import com.floreantpos.webservice.CloudDataUploader;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import us.fatehi.magnetictrack.bankcard.BankCardMagneticTrack;

public class ReceiptPrintService {
    public static final String SYSTEM_INFORMATION = "System Information";
    public static final String ADDITIONAL_ORDER_INFO = "additionalOrderInfo";
    public static final String SPLIT_TICKET_ID = "splitTicketId";
    public static final String PREVIOUS_DUE = "previousDue";
    public static final String PREVIOUS_DUE_TEXT = "previousDueText";
    public static final String CASH_REFUND = "cashRefund";
    public static final String CASH_REFUND_TEXT = "cashRefundText";
    public static final String TICKET_HEADER = "ticketHeader";
    public static final String TAX_BREAKDOWN_TEXT = "taxBreakdownText";
    public static final String IS_SHOW_TAX_BREAKDOWN = "isShowTaxBreakdown";
    public static final String SHOW_TIPS_BLOCK = "showTipsBlock";
    public static final String SHOW_TIPS = "showTips";
    public static final String STORE_LOGO_IMAGE = "storeLogoIcon";
    public static final String STORE_LOGO_ICON = "storeLogoIcon";
    public static final String ADDITIONAL_PROPERTIES = "additionalProperties";
    public static final String ADDITIONAL_PAYMENT_PROPERTIES = "additionalPaymentProperties";
    public static final String APPROVAL_CODE = "approvalCode";
    public static final String CARD_PAYMENT = "cardPayment";
    public static final String CHANGED_AMOUNT = "changedAmount";
    public static final String COPY_TYPE = "copyType";
    public static final String BOTTOM_MESSAGE = "bottomMessage";
    public static final String FOOTER_MESSAGE = "footerMessage";
    public static final String ORDER_DETAILS = "orderDetails";
    public static final String GRAND_SUBTOTAL = "grandSubtotal";
    public static final String DUE_AMOUNT = "dueAmount";
    public static final String REFUND_AMOUNT = "refundAmount";
    public static final String REFUND_AMOUNT_TEXT = "refundAmountText";
    public static final String TENDER_AMOUNT = "tenderAmount";
    public static final String TENDER_AMOUNT_TEXT = "tenderAmountText";
    public static final String PAID_AMOUNT = "paidAmount";
    public static final String NET_AMOUNT = "netAmount";
    public static final String FEE_AMOUNT = "feeAmount";
    public static final String FEE_AMOUNT_TEXT = "feeAmountText";
    public static final String CHANGE_AMOUNT_TEXT = "changeAmountText";
    public static final String DUE_AMOUNT_TEXT = "dueAmountText";
    public static final String PAID_AMOUNT_TEXT = "paidAmountText";
    public static final String NET_AMOUNT_TEXT = "netAmountText";
    public static final String TIPS_TEXT = "tipsText";
    public static final String DELIVERY_CHARGE_TEXT = "deliveryChargeText";
    public static final String SERVICE_CHARGE_TEXT = "serviceChargeText";
    public static final String TAX_TEXT = "taxText";
    public static final String DISCOUNT_TEXT = "discountText";
    public static final String TOTAL_TEXT = "totalText";
    public static final String DATA = "data";
    public static final String TITLE = "title";
    public static final String ORDER_ = "ORDER-";
    public static final String PROP_PRINTER_NAME = "printerName";
    public static final String TIP_AMOUNT = "tipAmount";
    public static final String SERVICE_CHARGE = "serviceCharge";
    public static final String DELIVERY_CHARGE = "deliveryCharge";
    public static final String TAX_AMOUNT = "taxAmount";
    public static final String DISCOUNT_AMOUNT = "discountAmount";
    public static final String HEADER_LINE1 = "headerLine1";
    private static final String REPORT_DATE = "reportDate";
    private static final String SHOW_FOOTER = "showFooter";
    public static final String SHOW_HEADER_SEPARATOR = "showHeaderSeparator";
    private static final String SHOW_SUBTOTAL = "showSubtotal";
    private static final String RECEIPT_TYPE = "receiptType";
    private static final String SUB_TOTAL_TEXT = "subTotalText";
    private static final String QUANTITY_TEXT = "quantityText";
    private static final String ITEM_TEXT = "itemText";
    public static final String CUSTOMER_COPY = "Customer Copy";
    public static final String DRIVER_COPY = "Driver Copy";
    public static final String CENTER = "center";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String FONT_TYPE = ".font-type";
    public static final String FONT_SIZE = ".font-size";
    public static final String FONT_WEIGHT = ".font-weight";
    public static final String OROPOS_PDF_PRINTER = Messages.getString("ReceiptPrintService.11");
    private static File pdfPrinterDir;
    private static Log logger;

    public static void printGenericReport(String title, String data) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(TITLE, title);
        map.put(DATA, data);
        ReceiptPrintService.getJasperPrintService().printGenericReport(map);
    }

    public static void testPrinter(Printer printer, String title, String data) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        map.put(TITLE, title);
        map.put(DATA, data);
        ReceiptPrintService.setPrintProperty(map, printer);
        ReceiptPrintService.getReceiptPrintServiceProvider(printer).testPrinter(map, printer.getDeviceName());
    }

    public static String getSystemInfo(String printerName, String deviceName) {
        String data = printerName + "-" + deviceName;
        data = data + "\n Terminal : " + Application.getInstance().getTerminal().getName();
        data = data + "\n Current User : " + Application.getCurrentUser().getFirstName();
        data = data + "\n " + VersionInfo.getAppName() + Messages.getString("PrinterGroupView.1") + VersionInfo.getVersion();
        data = data + "\n Database Name : " + AppConfig.getDatabaseName() + AppConfig.getDatabaseHost() + AppConfig.getDatabasePort();
        return data;
    }

    private static void setPrintProperty(HashMap<String, Object> map, Printer printer) {
        map.put("receipt.printer_type", printer.getPrintSystem());
        map.put("printerType", printer.getPrinterType());
        map.put("ipAddress", printer.getIpAddress());
        map.put("ipPort", printer.getIpPort());
        map.put("serialPort", printer.getSerialPort());
        map.put("textLength", printer.getTextLength());
    }

    public static void printTicket(Ticket ticket) {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        ReceiptPrintService.printTicket(ticket, ReceiptPrintService.populateTicketProperties(ticket, printProperties, null));
    }

    public static void printTicket(Ticket ticket, String copyType) {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
        map.put(COPY_TYPE, copyType);
        map.put(CARD_PAYMENT, true);
        ReceiptPrintService.printTicket(ticket, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printTicket(Ticket ticket, HashMap<String, Object> map) {
        try {
            boolean printUsingPaymentGateway;
            ticket.setShouldUpdateStock(true);
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            boolean bl = printUsingPaymentGateway = paymentGateway != null && paymentGateway.printUsingThisTerminal();
            if (printUsingPaymentGateway) {
                ReceiptPrintService.updatePrintCount(ticket);
                paymentGateway.printTicket(ticket);
                return;
            }
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            if (receiptPrinters == null) {
                return;
            }
            ReceiptPrintService.updatePrintCount(ticket);
            for (Printer receiptPrinter : receiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                logger.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), deviceName, ticket.getTotalAmount()));
                ReceiptPrintService.setPrintProperty(map, receiptPrinter);
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                ReceiptPrintService.getReceiptPrintServiceProvider(receiptPrinter).printTicket(ticket, map, deviceName);
            }
            ReceiptPrintService.saveJournal(ticket);
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
        finally {
            ticket.setShouldUpdateStock(false);
        }
    }

    public static void printTransaction(PosTransaction transaction, boolean printCustomerCopy) {
        ReceiptPrintService.printTransaction(transaction, false, printCustomerCopy);
    }

    public static void printTransaction(PosTransaction transaction, boolean printStoreCopy, boolean printCustomerCopy) {
        try {
            Ticket ticket = transaction.getTicket();
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            if (paymentGateway != null && paymentGateway.printUsingThisTerminal()) {
                paymentGateway.printTransaction(transaction, printStoreCopy, printCustomerCopy);
                return;
            }
            TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            if (transaction != null && transaction.isCard()) {
                map.put(CARD_PAYMENT, true);
                map.put(COPY_TYPE, Messages.getString("ReceiptPrintService.7"));
                ReceiptPrintService.printTransaction(transaction, map);
                if (printCustomerCopy) {
                    map.put(COPY_TYPE, Messages.getString("ReceiptPrintService.8"));
                    ReceiptPrintService.printTransaction(transaction, map);
                }
            } else {
                ReceiptPrintService.printTransaction(transaction, map);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printTransaction(PosTransaction transaction, HashMap<String, Object> map) {
        try {
            boolean printUsingPaymentGateway;
            Ticket ticket = transaction.getTicket();
            PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
            boolean bl = printUsingPaymentGateway = paymentGateway != null && paymentGateway.printUsingThisTerminal();
            if (printUsingPaymentGateway) {
                paymentGateway.printTransaction(transaction, false, false);
                return;
            }
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer receiptPrinter : receiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                logger.info((Object)String.format("Printing ticket %s payment using printer %s. Total amount %s", ticket.getId(), deviceName, ticket.getTotalAmount()));
                ReceiptPrintService.setPrintProperty(map, receiptPrinter);
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                ReceiptPrintService.getReceiptPrintServiceProvider(receiptPrinter).printTransaction(ticket, map, transaction, deviceName);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printTransaction(PosTransaction transaction) {
        boolean printUsingPaymentGateway;
        Ticket ticket = transaction.getTicket();
        PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
        boolean paymentTypeCash = transaction.getPaymentType().equals((Object)PaymentType.CASH);
        boolean bl = printUsingPaymentGateway = paymentGateway != null && paymentGateway.printUsingThisTerminal();
        if (printUsingPaymentGateway && paymentTypeCash) {
            return;
        }
        if (printUsingPaymentGateway) {
            paymentGateway.printTransaction(transaction, false, false);
            return;
        }
        String receiptPrinter = Application.getPrinters().getReceiptPrinter();
        if (StringUtils.isEmpty((String)receiptPrinter)) {
            return;
        }
        TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.3"), true, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
        if (transaction != null && transaction.isCard()) {
            map.put(CARD_PAYMENT, true);
            map.put(COPY_TYPE, Messages.getString("ReceiptPrintService.4"));
            ReceiptPrintService.printTransaction(transaction, map);
            map.put(COPY_TYPE, Messages.getString("ReceiptPrintService.5"));
            ReceiptPrintService.printTransaction(transaction, map);
        } else {
            ReceiptPrintService.printTransaction(transaction, map);
        }
    }

    public static void printRefundTicket(Ticket ticket, RefundTransaction posTransaction) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties("*** REFUND RECEIPT ***", true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, posTransaction, false, true);
            map.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.1") + CurrencyUtil.getCurrencySymbol());
            map.put(REFUND_AMOUNT, NumberUtil.formatNumber(posTransaction.getAmount()));
            map.put(CASH_REFUND_TEXT, Messages.getString("ReceiptPrintService.2") + CurrencyUtil.getCurrencySymbol());
            map.put(CASH_REFUND, NumberUtil.formatNumber(posTransaction.getAmount()));
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer receiptPrinter : receiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                logger.info((Object)String.format("Printing refund ticket %s using printer %s. Refund amount %s", ticket.getId(), deviceName, posTransaction.getAmount()));
                ReceiptPrintService.setPrintProperty(map, receiptPrinter);
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                ReceiptPrintService.getReceiptPrintServiceProvider(receiptPrinter).printTransaction(ticket, map, posTransaction, deviceName);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static void printVoidTicket(Ticket ticket) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties("*** VOID RECEIPT ***", true, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
            String refundText = "";
            if (ticket.getTransactions() != null) {
                Set<PosTransaction> posTransactions = ticket.getTransactions();
                double refundAmount = 0.0;
                if (posTransactions != null) {
                    for (PosTransaction t : posTransactions) {
                        if (!(t instanceof RefundTransaction) && !t.isVoided().booleanValue()) continue;
                        refundAmount += t.getAmount().doubleValue();
                    }
                }
                refundAmount = NumberUtil.roundToTwoDigit(refundAmount);
            }
            map.put(ADDITIONAL_PROPERTIES, "<html><b>" + refundText + "</b></html>");
            map.put(ADDITIONAL_PAYMENT_PROPERTIES, "");
            List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
            for (Printer receiptPrinter : receiptPrinters) {
                String deviceName = receiptPrinter.getDeviceName();
                if (deviceName == null) continue;
                logger.info((Object)String.format("Printing voided ticket %s using printer %s. Voided amount %s", ticket.getId(), deviceName, refundText));
                ReceiptPrintService.setPrintProperty(map, receiptPrinter);
                ReceiptPrintService.setPaginationProperty(map, deviceName);
                ReceiptPrintService.getReceiptPrintServiceProvider(receiptPrinter).printVoidTicket(ticket, map, deviceName);
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static JasperPrint createPurchaseOrderPrint(PurchaseOrder order) throws Exception {
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        printProperties.setPrintCookingInstructions(false);
        HashMap<String, Object> map = ReceiptPrintService.populatePurchaseOrderProperties(order, printProperties, null);
        map.put(COPY_TYPE, "");
        OrderDataSource dataSource = new OrderDataSource(order);
        String receiptName = "order_receipt";
        map.put(PREVIOUS_DUE_TEXT, "Previous Due  ");
        map.put(PREVIOUS_DUE, "");
        return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(receiptName), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static JasperPrint createPurchaseOrderItemsBarcodePrint(List<LabelItem> orderedItemList) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        LabelPrinterTableModel dataSource = new LabelPrinterTableModel(orderedItemList);
        String receiptName = "barcode_report";
        return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(receiptName), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
    }

    public static JasperPrint printKitchenStickerItems(List<KitchenStickerModel.KitchenSticker> stickerItemList) throws Exception {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            KitchenStickerModel dataSource = new KitchenStickerModel(stickerItemList);
            String receiptName = "kitchenStickerReport";
            KitchenStickerPaperSize kitchenStickerPaperSize = ReceiptPrintService.getKitchenStickerPaperSize("kitchen.sticker.paper_size");
            return ReceiptPrintService.getJasperPrintService().createJasperPrint(ReportUtil.getReport(kitchenStickerPaperSize.getReportNameAccording2Size(receiptName)), map, (JRDataSource)new JRTableModelDataSource((TableModel)dataSource));
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e.getMessage(), e);
            return null;
        }
    }

    public static byte[] createPDFStream(Ticket ticket) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, null);
            map.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, map, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e);
            return null;
        }
    }

    public static byte[] createPDFStream(PosTransaction transaction) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties(Messages.getString("ReceiptPrintService.6"), true, true, true);
            printProperties.setPrintCookingInstructions(false);
            Ticket ticket = transaction.getTicket();
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            map.put("IS_IGNORE_PAGINATION", true);
            JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, map, null);
            jasperPrint.setName("TICKET_RECEIPT" + ticket.getId());
            jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
            return JasperExportManager.exportReportToPdf((JasperPrint)jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e);
            return null;
        }
    }

    public static JasperPrintService getJasperPrintService() {
        return new JasperPrintService();
    }

    public static ReceiptPrintServiceProvider getReceiptPrintService() {
        List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
        if (receiptPrinters == null || receiptPrinters.isEmpty()) {
            return ReceiptPrintService.getJasperPrintService();
        }
        return ReceiptPrintService.getReceiptPrintServiceProvider(receiptPrinters.get(0));
    }

    public static ReceiptPrintServiceProvider getKitchenReceiptPrintPreviewService() {
        String printPreview = DataProvider.get().getCurrentTerminal().getProperty("kitchen.receipt.print_preview_system");
        if (printPreview != null && printPreview.equals("EscPOS")) {
            return new EscPosPrintService();
        }
        return new JasperPrintService();
    }

    public static ReceiptPrintServiceProvider getMainReceiptPrintPreviewService() {
        String printPreview = DataProvider.get().getCurrentTerminal().getProperty("main.receipt.print_preview_system");
        if (printPreview != null && printPreview.equals("EscPOS")) {
            return new EscPosPrintService();
        }
        return new JasperPrintService();
    }

    private static ReceiptPrintServiceProvider getReceiptPrintServiceProvider(Printer receiptPrinter) {
        if (receiptPrinter == null) {
            return new JasperPrintService();
        }
        String printerName = receiptPrinter.getDeviceName();
        if (printerName != null && printerName.equals(OROPOS_PDF_PRINTER)) {
            return new JasperPrintService();
        }
        if (receiptPrinter.getPrintSystem().equals("EscPOS")) {
            return new EscPosPrintService();
        }
        return new JasperPrintService();
    }

    private static String createMemberAccountInfo(Ticket ticket) {
        Customer customer = CustomerDAO.getInstance().findById(ticket.getCustomerId());
        String memberAccInfo = new String();
        memberAccInfo = memberAccInfo + ReceiptPrintService.lineBreak();
        memberAccInfo = memberAccInfo + Messages.getString("ReceiptPrintService.25") + ReceiptPrintService.lineBreak();
        memberAccInfo = memberAccInfo + Messages.getString("ReceiptPrintService.26") + customer.getId() + ReceiptPrintService.lineBreak();
        memberAccInfo = memberAccInfo + Messages.getString("NAME") + ": " + customer.getName() + ReceiptPrintService.lineBreak();
        memberAccInfo = memberAccInfo + Messages.getString("Balance") + ": \\" + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumberAcceptNegative(customer.getBalance());
        return memberAccInfo;
    }

    public static void beginRow(StringBuilder html) {
        html.append("<div>");
    }

    private static String lineBreak() {
        return "<br>";
    }

    public static void endRow(StringBuilder html) {
        html.append("</div>\n");
    }

    public static void addColumn(StringBuilder html, String columnText) {
        html.append("<span>" + columnText + "</span>");
    }

    public static HashMap<String, Object> populateTicketProperties(Ticket ticket, TicketPrintProperties printProperties, PosTransaction transaction) {
        return ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction, false, false);
    }

    public static HashMap<String, Object> populateTicketProperties(Ticket ticket, TicketPrintProperties printProperties, PosTransaction transaction, boolean kitchenReceipt, boolean refundReceipt) {
        StringBuilder taxBreakdown;
        boolean isShowTipsSuggestion;
        ImageIcon storeLogo;
        String barcodeParamName;
        String tableNameDisplay;
        User owner;
        String pickupTime;
        String reciprocalNote;
        Application.getInstance().refreshStore();
        Store store = DataProvider.get().getStore();
        String extraOrderInfo = "";
        OrderType orderType = ticket.getOrderType();
        String orderTypeId = "";
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (orderType != null) {
            orderTypeId = orderType.getId();
        }
        String header = "";
        String footer = "";
        String bottom = "";
        String orderInfo = "";
        if (kitchenReceipt) {
            header = ReceiptUtil.getReceiptSection(store, "kitchen.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(store, "kitchen.order.info", orderTypeId);
            extraOrderInfo = ReceiptUtil.getReceiptSection(store, "kitchen.order.extrainfo1", orderTypeId);
            footer = ReceiptUtil.getReceiptSection(store, "kitchen.footer", orderTypeId);
            bottom = ReceiptUtil.getReceiptSection(store, "kitchen.bottom", orderTypeId);
            ReceiptPrintService.putFontParamsFromStoreParams(store, HEADER_LINE1, "kitchen.header", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, TICKET_HEADER, "kitchen.order.info", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, ADDITIONAL_ORDER_INFO, "kitchen.order.extrainfo1", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, BOTTOM_MESSAGE, "kitchen.footer", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, FOOTER_MESSAGE, "kitchen.bottom", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, ORDER_DETAILS, "kitchen.details", parameters);
        } else {
            header = ReceiptUtil.getReceiptSection(store, "ticket.header", orderTypeId);
            orderInfo = ReceiptUtil.getReceiptSection(store, "ticket.order.info", orderTypeId);
            extraOrderInfo = ReceiptUtil.getReceiptSection(store, "ticket.order.extrainfo1", orderTypeId);
            footer = ReceiptUtil.getReceiptSection(store, "ticket.footer", orderTypeId);
            bottom = ReceiptUtil.getReceiptSection(store, "ticket.bottom", orderTypeId);
            ReceiptPrintService.setPaginationProperty(parameters, DataProvider.get().getPrinters().getReceiptPrinter());
            ReceiptPrintService.putFontParamsFromStoreParams(store, HEADER_LINE1, "ticket.header", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, TICKET_HEADER, "ticket.order.info", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, ADDITIONAL_ORDER_INFO, "ticket.order.extrainfo1", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, BOTTOM_MESSAGE, "ticket.footer", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, FOOTER_MESSAGE, "ticket.bottom", parameters);
            ReceiptPrintService.putFontParamsFromStoreParams(store, ORDER_DETAILS, "ticket.details", parameters);
        }
        if (ReceiptPrintService.getReceiptPrintService() instanceof EscPosPrintService) {
            parameters.put(ReceiptParam.STORE_LOGO.getParamName(), " ");
        }
        boolean showHeaderLogo = Boolean.valueOf(ReceiptUtil.getReceiptSection(store, kitchenReceipt ? "kitchen.header.logo.show" : "ticket.header.logo.show", orderTypeId));
        double totalAmount = ticket.getTotalAmount();
        double tipAmount = 0.0;
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        parameters.put(ReceiptParam.STORE_NAME.getParamName(), store.getName());
        parameters.put(ReceiptParam.STORE_ADDRESS1.getParamName(), store.getAddressLine1());
        parameters.put(ReceiptParam.STORE_ADDRESS2.getParamName(), store.getAddressLine2());
        parameters.put(ReceiptParam.STORE_ADDRESS3.getParamName(), store.getAddressLine3());
        parameters.put(ReceiptParam.STORE_PHONE_NO.getParamName(), store.getTelephone());
        parameters.put(ReceiptParam.CURRENCY_SYMBOL.getParamName(), currencySymbol);
        parameters.put(ReceiptParam.TICKET_ID.getParamName(), ticket.getId());
        parameters.put(ReceiptParam.TICKET_SHORT_ID.getParamName(), ticket.getShortId());
        parameters.put(ReceiptParam.ORDER_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getCreateDate()));
        parameters.put(ReceiptParam.TOKEN_NO.getParamName(), "" + ticket.getTokenNo());
        parameters.put(ReceiptParam.RETURN_DATE.getParamName(), ReceiptPrintService.getReturnDate(ticket));
        if (StringUtils.isNotBlank((String)ticket.getNote())) {
            parameters.put(ReceiptParam.NOTE.getParamName(), ticket.getNote());
        }
        if (StringUtils.isNotBlank((String)(reciprocalNote = ticket.getProperty("reciprocal_member.note")))) {
            parameters.put(ReceiptParam.RECIPROCAL_NOTE.getParamName(), reciprocalNote);
        }
        if (StringUtils.isNotBlank((String)(pickupTime = ticket.getProperty("togo_pickup_time")))) {
            parameters.put(ReceiptParam.PICKUP_TIME.getParamName(), pickupTime);
        }
        if (transaction != null && transaction.getPaymentType() == PaymentType.MEMBER_ACCOUNT) {
            parameters.put(ReceiptParam.MEMBER_ACCOUNT_INFO.getParamName(), ReceiptPrintService.createMemberAccountInfo(ticket));
        }
        if (orderType != null && (orderType.isDelivery().booleanValue() || orderType.isPickup().booleanValue())) {
            String extraDeliveryInfo;
            if (ticket.isCustomerWillPickup().booleanValue()) {
                parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), "PICKUP");
            } else {
                parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), "DELIVERY");
            }
            String deliveryAddress = ticket.getDeliveryAddress() == null ? "" : ticket.getDeliveryAddress();
            String string = extraDeliveryInfo = ticket.getExtraDeliveryInfo() == null ? "" : ticket.getExtraDeliveryInfo();
            if (StringUtils.isNotBlank((String)deliveryAddress) || StringUtils.isNotBlank((String)extraDeliveryInfo)) {
                parameters.put(ReceiptParam.DELIVERY_ADDRESS.getParamName(), deliveryAddress + extraDeliveryInfo);
            }
            if (ticket.getDeliveryDate() != null) {
                parameters.put(ReceiptParam.DELIVERY_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(ticket.getDeliveryDate()));
            }
        } else if (orderType != null && orderType.isHasForHereAndToGo().booleanValue()) {
            SubOrderType subOrderType = ticket.getSubOrderType();
            parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), subOrderType != null ? subOrderType.getDisplayString() : ticket.getOrderType());
        } else {
            parameters.put(ReceiptParam.ORDER_TYPE.getParamName(), ticket.getOrderType());
        }
        Terminal terminal = ticket.getTerminal();
        if (terminal != null) {
            parameters.put(ReceiptParam.TERMINAL_ID.getParamName(), terminal.getId());
            parameters.put(ReceiptParam.TERMINAL_NAME.getParamName(), terminal.getName());
        }
        if ((owner = ticket.getOwner()) != null) {
            parameters.put(ReceiptParam.SERVER_NAME.getParamName(), owner.getFullName());
            parameters.put(ReceiptParam.SERVER_ID.getParamName(), owner.getId());
        }
        parameters.put(ReceiptParam.GUEST_COUNT.getParamName(), ticket.getNumberOfGuests().toString());
        int printCount = POSUtil.parseInteger(ticket.getProperty("printCount"));
        if (printCount > 0) {
            parameters.put(ReceiptParam.PRINT_COUNT.getParamName(), printCount);
        }
        if (StringUtils.isBlank((String)(tableNameDisplay = ticket.getTableNameDisplay()))) {
            tableNameDisplay = ticket.getFreeTextTableNameOrNumberDisplay();
        }
        parameters.put(ReceiptParam.TABLE_NO.getParamName(), tableNameDisplay);
        if (kitchenReceipt && orderType.isBarTab().booleanValue()) {
            parameters.put(ReceiptParam.TABLE_NO.getParamName(), ticket.getBartabName());
        }
        if (ticket.getCustomer() != null) {
            Customer customer = ticket.getCustomer();
            parameters.put(ReceiptParam.CUSTOMER_NAME.getParamName(), customer.getName());
            parameters.put(ReceiptParam.CUSTOMER_ID.getParamName(), customer.getMemberId() != null ? customer.getMemberId() : "");
            parameters.put(ReceiptParam.CUSTOMER_PHONE.getParamName(), customer.getMobileNo());
            parameters.put(ReceiptParam.CUSTOMER_SIGNATURE.getParamName(), customer.getSignatureImageId());
            if (POSUtil.getBoolean(store.getProperty("loyalty.enabled"))) {
                if (transaction != null) {
                    String earnedPoint;
                    String chargedPoint = transaction.getExtraProperty("loyalty.charged_amount");
                    if (StringUtils.isNotBlank((String)chargedPoint)) {
                        parameters.put(ReceiptParam.LOYALTY_REDEEM.getParamName(), chargedPoint);
                    }
                    String loyaltyEarned = (earnedPoint = transaction.getExtraProperty("transaction.loyalty_point_earned")) == null ? String.valueOf(0) : earnedPoint;
                    parameters.put(ReceiptParam.LOYALTY_EARNED.getParamName(), loyaltyEarned);
                }
                parameters.put(ReceiptParam.LOYALTY_TOTAL.getParamName(), customer.getLoyaltyPoint());
            }
        }
        if (ticket.getSalesArea() != null) {
            SalesArea salesArea = ticket.getSalesArea();
            parameters.put(ReceiptParam.SALES_AREA.getParamName(), salesArea.getName());
        }
        if (ticket.getTransactions() != null) {
            String strPaymentType = PosTransactionDAO.getInstance().findLastTxPaymentTypeName(ticket);
            parameters.put(ReceiptParam.PAYMENT_TYPE.getParamName(), strPaymentType);
        }
        if (ticket.getAssignedDriver() != null) {
            User driver = ticket.getAssignedDriver();
            parameters.put(ReceiptParam.DRIVER_NAME.getParamName(), driver.getFullName());
            parameters.put(ReceiptParam.DRIVER_ID.getParamName(), driver.getId());
        }
        if (header.contains(barcodeParamName = ReceiptParam.BARCODE.getParamName()) || orderInfo.contains(barcodeParamName) || extraOrderInfo.contains(barcodeParamName) || footer.contains(barcodeParamName) || bottom.contains(barcodeParamName)) {
            parameters.put(barcodeParamName, String.valueOf(ticket.getId()));
        }
        parameters.put(ReceiptParam.RECEIPT_TYPE.getParamName(), printProperties.getReceiptTypeName());
        String splitTicketId = ticket.getProperty("SPLIT_TICKET");
        if (StringUtils.isNotEmpty((String)splitTicketId)) {
            parameters.put(SPLIT_TICKET_ID, splitTicketId);
        }
        parameters.put(ReceiptParam.PRINT_DATE.getParamName(), DateUtil.formatFullDateAndTimeAsString(new Date()));
        parameters.put(ITEM_TEXT, POSConstants.RECEIPT_REPORT_ITEM_LABEL);
        parameters.put(QUANTITY_TEXT, POSConstants.RECEIPT_REPORT_QUANTITY_LABEL);
        parameters.put(SUB_TOTAL_TEXT, POSConstants.RECEIPT_REPORT_SUBTOTAL_LABEL);
        parameters.put(SHOW_SUBTOTAL, printProperties.isShowSubtotal());
        parameters.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        parameters.put(SHOW_FOOTER, printProperties.isShowFooter());
        String ticketHeaderString = ReceiptPrintService.getReceiptParamValuesAsString(parameters, orderInfo);
        if (ticket.isVoided().booleanValue()) {
            ticketHeaderString = ticketHeaderString + Messages.getString("ReceiptPrintService.16") + "<br>";
        }
        parameters.put(TICKET_HEADER, ticketHeaderString);
        parameters.put(ADDITIONAL_ORDER_INFO, ReceiptPrintService.getReceiptParamValuesAsString(parameters, extraOrderInfo));
        parameters.put(HEADER_LINE1, ReceiptPrintService.getReceiptParamValuesAsString(parameters, header));
        if (printProperties.isShowFooter()) {
            if (ticket.getDiscountAmount() != 0.0) {
                parameters.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(ticket.getDiscountAmount(), true));
            }
            String TAX_STRING = POSConstants.RECEIPT_REPORT_TAX_LABEL + currencySymbol;
            String taxAmount = NumberUtil.formatNumber(ticket.getTaxAmount(), true);
            if (store.getItemPriceIncludesTax().booleanValue()) {
                TAX_STRING = TAX_STRING + Messages.getString("ReceiptPrintService.18");
                taxAmount = " (" + taxAmount + ")";
            }
            if (ticket.getTaxAmount() != 0.0) {
                parameters.put(TAX_AMOUNT, taxAmount);
            }
            if (ticket.getServiceCharge() != 0.0) {
                parameters.put(SERVICE_CHARGE, NumberUtil.formatNumberAcceptNegative(ticket.getServiceCharge()));
            }
            if (ticket.getDeliveryCharge() > 0.0) {
                parameters.put(DELIVERY_CHARGE, NumberUtil.formatNumberAcceptNegative(ticket.getDeliveryCharge()));
            }
            if (ticket.getGratuity() != null) {
                tipAmount = ticket.getGratuity().getAmount();
                parameters.put(TIP_AMOUNT, NumberUtil.formatNumber(tipAmount));
            }
            parameters.put(TOTAL_TEXT, POSConstants.SUBTOTAL + currencySymbol);
            parameters.put(DISCOUNT_TEXT, POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + currencySymbol);
            parameters.put(TAX_TEXT, TAX_STRING);
            parameters.put(SERVICE_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + currencySymbol);
            parameters.put(DELIVERY_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_DELIVERY_CHARGE_LABEL + currencySymbol);
            parameters.put(TIPS_TEXT, POSConstants.RECEIPT_REPORT_TIPS_LABEL + currencySymbol);
            parameters.put(NET_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_TOTAL_LABEL + currencySymbol);
            parameters.put(PAID_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + currencySymbol);
            parameters.put(DUE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + currencySymbol);
            parameters.put(FEE_AMOUNT_TEXT, POSConstants.FEE_AMOUNT + currencySymbol);
            if (ticket.getFeeAmount() > 0.0) {
                parameters.put(FEE_AMOUNT, NumberUtil.formatNumber(ticket.getFeeAmount()));
            }
            parameters.put(NET_AMOUNT, NumberUtil.formatNumber(totalAmount, true));
            parameters.put(PAID_AMOUNT, NumberUtil.formatNumber(ticket.getPaidAmount()));
            Double refundAmount = ticket.getRefundAmount();
            if (transaction != null) {
                Double tenderAmount = transaction.getTenderAmount();
                parameters.put(TENDER_AMOUNT_TEXT, POSConstants.RECEIPT_TENDERED_AMOUNT_LABEL + currencySymbol);
                parameters.put(TENDER_AMOUNT, NumberUtil.formatNumber(tenderAmount, true));
            }
            if (refundAmount > 0.0) {
                parameters.put(REFUND_AMOUNT_TEXT, Messages.getString("ReceiptPrintService.40") + currencySymbol);
                parameters.put(REFUND_AMOUNT, NumberUtil.formatNumber(refundAmount));
            }
            parameters.put(DUE_AMOUNT, NumberUtil.formatNumber(ticket.getDueAmount(), true));
            parameters.put(GRAND_SUBTOTAL, NumberUtil.formatNumber(ticket.getSubtotalAmount(), true));
            parameters.put(FOOTER_MESSAGE, ReceiptPrintService.getReceiptParamValuesAsString(parameters, footer));
            parameters.put(BOTTOM_MESSAGE, ReceiptPrintService.getReceiptParamValuesAsString(parameters, bottom));
            parameters.put(COPY_TYPE, printProperties.getReceiptCopyType());
            if (transaction != null) {
                double changedAmount = transaction.getTenderAmount() - transaction.getAmount();
                if (changedAmount > 0.0) {
                    parameters.put(CHANGE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + currencySymbol);
                    parameters.put(CHANGED_AMOUNT, NumberUtil.formatNumber(changedAmount));
                }
                if (transaction.isCard()) {
                    String cardInformationForReceipt;
                    if (!orderType.isRetailOrder().booleanValue()) {
                        parameters.put(CARD_PAYMENT, true);
                    }
                    if (StringUtils.isEmpty((String)(cardInformationForReceipt = CardConfig.getPaymentGateway().getProcessor().getCardInformationForReceipt(transaction)))) {
                        cardInformationForReceipt = ReceiptPrintService.getCardInformation(transaction);
                    }
                    parameters.put(APPROVAL_CODE, cardInformationForReceipt);
                }
                if (transaction instanceof CustomerAccountTransaction && !orderType.isRetailOrder().booleanValue()) {
                    parameters.put(CARD_PAYMENT, true);
                }
                if (transaction instanceof GiftCertificateTransaction) {
                    parameters.put(CARD_PAYMENT, true);
                    parameters.put(APPROVAL_CODE, ReceiptPrintService.createGiftCertificateInfo(transaction));
                }
            }
            if (Application.getInstance().getTerminal().isEnableMultiCurrency().booleanValue()) {
                StringBuilder multiCurrencyBreakdownCashBack = ReceiptPrintService.buildMultiCurrency(ticket, transaction, printProperties);
                if (multiCurrencyBreakdownCashBack != null) {
                    parameters.put(ADDITIONAL_PROPERTIES, multiCurrencyBreakdownCashBack.toString());
                } else {
                    StringBuilder multiCurrencyTotalAmount = ReceiptPrintService.buildMulticurrencyBreakdown(ticket, printProperties, false);
                    if (multiCurrencyTotalAmount != null && splitTicketId == null) {
                        parameters.put(ADDITIONAL_PROPERTIES, multiCurrencyTotalAmount.toString());
                    }
                }
            }
        }
        if (showHeaderLogo && (storeLogo = store.getStoreLogo()) != null) {
            parameters.put("storeLogoIcon", storeLogo.getImage());
        }
        if (isShowTipsSuggestion = ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tips_suggestion", orderTypeId)) {
            parameters.put(SHOW_TIPS, ReceiptPrintService.tipsCalculation(ticket));
        }
        boolean isShowTipsBlock = ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tips_block", orderTypeId);
        parameters.put(SHOW_TIPS_BLOCK, isShowTipsBlock);
        boolean isShowTaxBreakdown = ReceiptUtil.getReceiptBooleanProp(store, "receipt.show_tax_breakdown", orderTypeId);
        parameters.put(IS_SHOW_TAX_BREAKDOWN, isShowTaxBreakdown);
        if (isShowTaxBreakdown && (taxBreakdown = ReceiptPrintService.getTaxBreakdown(ticket, store)) != null) {
            parameters.put(TAX_BREAKDOWN_TEXT, taxBreakdown.toString());
        }
        return parameters;
    }

    private static void putFontParamsFromStoreParams(Store store, String mapKey, String storeKey, HashMap<String, Object> parameters) {
        parameters.put(mapKey + FONT_WEIGHT, store.getBooleanProperty(storeKey + FONT_WEIGHT, false));
        parameters.put(mapKey + FONT_SIZE, store.getProperty(storeKey + FONT_SIZE));
        parameters.put(mapKey + FONT_TYPE, store.getProperty(storeKey + FONT_TYPE));
    }

    private static String getReturnDate(Ticket ticket) {
        ArrayList<PosTransaction> transactions = new ArrayList<PosTransaction>(ticket.getTransactions());
        PosTransactionService.sortTransactionsByDateDesc(transactions);
        for (PosTransaction posTransaction : transactions) {
            if (!(posTransaction instanceof RefundTransaction)) continue;
            return DateUtil.formatFullDateAndTimeAsString(posTransaction.getTransactionTime());
        }
        return null;
    }

    private static void setPaginationProperty(HashMap<String, Object> parameters, String printerName) {
        if (printerName != null && printerName.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            parameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            parameters.put("IS_IGNORE_PAGINATION", false);
        }
    }

    public static void setPaginationProperty(HashMap<String, Object> parameters, String printerName, boolean ignorePagination) {
        if (printerName != null && printerName.equalsIgnoreCase(OROPOS_PDF_PRINTER)) {
            parameters.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
        } else {
            parameters.put("IS_IGNORE_PAGINATION", ignorePagination);
        }
    }

    private static String getReceiptParamValuesAsString(Map<String, Object> map, String info) {
        ReceiptParam[] receiptParams;
        if (info == null) {
            return "";
        }
        for (ReceiptParam receiptParam : receiptParams = ReceiptParam.values()) {
            String paramName = receiptParam.getParamName();
            Object object = map.get(paramName);
            if (object == null || StringUtils.isEmpty((String)object.toString()) || object.toString().equals("[]")) {
                String text = "<" + receiptParam.getParamName() + ">.*</" + receiptParam.getParamName() + ">";
                info = info.replaceAll("<br>" + text, "");
                info = info.replaceAll(text, "");
                continue;
            }
            String val = object.toString();
            try {
                info = info.replaceAll("\\$" + paramName, val);
            }
            catch (Exception e) {
                info = info.replaceAll("\\$" + paramName, "\\" + val);
            }
        }
        String addSpaces = ReceiptPrintService.replacePatternBySpace(info);
        return addSpaces;
    }

    private static String replacePatternBySpace(String info) {
        Pattern pattern = Pattern.compile("\\{\\{(\\d+)\\}\\}");
        Matcher matcher = pattern.matcher(info);
        StringBuffer buffer = new StringBuffer();
        while (matcher.find()) {
            String group = matcher.group(1);
            try {
                int count = Integer.parseInt(group);
                String space = "";
                for (int i = 0; i < count; ++i) {
                    space = space + " ";
                }
                matcher.appendReplacement(buffer, space);
            }
            catch (Exception exception) {}
        }
        matcher.appendTail(buffer);
        return buffer.toString();
    }

    public static HashMap<String, Object> populatePurchaseOrderProperties(PurchaseOrder order, TicketPrintProperties printProperties, PosTransaction transaction) {
        Store store = StoreDAO.getRestaurant();
        double totalAmount = order.getTotalAmount();
        HashMap<String, Object> map = new HashMap<String, Object>();
        ReceiptPrintService.setPaginationProperty(map, DataProvider.get().getPrinters().getReceiptPrinter());
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        ImageIcon logo = IconFactory.getIcon("/icons/", "header_logo.png");
        if (logo != null) {
            map.put("logo", logo.getImage());
        }
        map.put("currencySymbol", currencySymbol);
        map.put("nameText", "Vendor: ");
        map.put("addressText", "Address: ");
        map.put("slNoText", "Sl. No.");
        map.put(ITEM_TEXT, "Description");
        map.put(QUANTITY_TEXT, "Quantity");
        map.put("priceText", "Unit Cost (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("unitText", "Unit");
        map.put(SUB_TOTAL_TEXT, "Amount (" + CurrencyUtil.getCurrencySymbol() + ")");
        map.put("note", Messages.getString("ReceiptPrintService.75"));
        map.put("shipDateTxt", Messages.getString("ReceiptPrintService.76"));
        String shipmentDate = order.getShipDate() != null ? DateUtil.formatFullDateAndTimeAsString(order.getShipDate()) : null;
        map.put("shipDate", shipmentDate);
        map.put("signature1", "Signature");
        map.put("signature2", "Verified By");
        InventoryVendor vendor = order.getVendor();
        if (vendor != null) {
            String vendorName = vendor.getName();
            String vendorAddress = vendor.getAddress();
            String vendorMobile = vendor.getPhone();
            map.put("customerName", vendorName);
            String address = "";
            if (vendorAddress != null && !vendorAddress.isEmpty()) {
                address = address + vendorAddress;
            }
            if (vendorMobile != null && !vendorMobile.isEmpty()) {
                address = address + ", Cell:" + vendorMobile;
            }
            map.put("customerAddress", StringUtils.isNotEmpty((String)address) ? address : null);
        }
        map.put(RECEIPT_TYPE, printProperties.getReceiptTypeName());
        map.put(SHOW_SUBTOTAL, printProperties.isShowSubtotal());
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(SHOW_FOOTER, printProperties.isShowFooter());
        map.put(REPORT_DATE, POSConstants.RECEIPT_REPORT_DATE_LABEL + DateUtil.formatFullDateAndTimeAsString(new Date()));
        StringBuilder ticketHeaderBuilder2 = ReceiptPrintService.buildOrderInfo(order, printProperties);
        map.put("ticketHeader2", ticketHeaderBuilder2.toString());
        map.put("ticketHeader3", "Purchase Order");
        String invoiceNumber = order.getInvoiceNumber() != null ? Messages.getString("ReceiptPrintService.77") + order.getInvoiceNumber() : null;
        map.put("invoiceNumber", invoiceNumber);
        map.put(HEADER_LINE1, store.getName());
        map.put("headerLine9", store.getTelephone());
        Address address = store.getAddress();
        if (address != null) {
            map.put("headerLine2", address.getAddressLine());
            map.put("headerLine3", address.getAddressLine2());
            map.put("headerLine4", address.getStreet());
            map.put("headerLine5", address.getCity());
            map.put("headerLine6", address.getState());
            map.put("headerLine7", address.getZipCode());
            map.put("headerLine8", address.getCountry());
        } else {
            map.put("headerLine2", store.getAddressLine1());
            map.put("headerLine3", store.getAddressLine2());
            map.put("headerLine4", store.getAddressLine3());
            map.put("headerLine6", store.getZipCode());
        }
        if (printProperties.isShowFooter()) {
            if (order.getDiscountAmount() > 0.0) {
                map.put(DISCOUNT_AMOUNT, NumberUtil.formatNumber(order.getDiscountAmount()));
            }
            if (order.getTaxAmount() > 0.0) {
                map.put(TAX_AMOUNT, NumberUtil.formatNumber(order.getTaxAmount()));
            }
            map.put(TOTAL_TEXT, POSConstants.RECEIPT_REPORT_TOTAL_LABEL + currencySymbol);
            map.put(DISCOUNT_TEXT, POSConstants.RECEIPT_REPORT_DISCOUNT_LABEL + currencySymbol);
            map.put(TAX_TEXT, POSConstants.RECEIPT_REPORT_TAX_LABEL + currencySymbol);
            map.put(SERVICE_CHARGE_TEXT, POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL + currencySymbol);
            map.put(TIPS_TEXT, POSConstants.RECEIPT_REPORT_TIPS_LABEL + currencySymbol);
            map.put(NET_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_NETAMOUNT_LABEL + currencySymbol);
            map.put(PAID_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_PAIDAMOUNT_LABEL + currencySymbol);
            map.put(DUE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_DUEAMOUNT_LABEL + currencySymbol);
            map.put(NET_AMOUNT, NumberUtil.formatNumber(totalAmount));
            map.put(PAID_AMOUNT, NumberUtil.formatNumber(order.getPaidAmount()));
            map.put(DUE_AMOUNT, NumberUtil.formatNumber(order.getDueAmount()));
            map.put(GRAND_SUBTOTAL, NumberUtil.formatNumber(order.getSubtotalAmount()));
            map.put(FOOTER_MESSAGE, store.getTicketFooterMessage());
            map.put(COPY_TYPE, printProperties.getReceiptCopyType());
            if (transaction != null) {
                double changedAmount = transaction.getTenderAmount() - transaction.getAmount();
                if (changedAmount > 0.0) {
                    map.put(CHANGE_AMOUNT_TEXT, POSConstants.RECEIPT_REPORT_CHANGEAMOUNT_LABEL + currencySymbol);
                    map.put(CHANGED_AMOUNT, NumberUtil.formatNumber(changedAmount));
                }
                if (transaction.isCard()) {
                    map.put(CARD_PAYMENT, true);
                    if (StringUtils.isNotEmpty((String)transaction.getCardTrack())) {
                        BankCardMagneticTrack track = BankCardMagneticTrack.from((String)transaction.getCardTrack());
                        String string = transaction.getCardType();
                        string = string + "<br/>APPROVAL: " + transaction.getCardAuthCode();
                        try {
                            string = string + "<br/>ACCT: " + ReceiptPrintService.getCardNumber(track);
                            string = string + "<br/>EXP: " + track.getTrack1().getExpirationDate();
                            string = string + "<br/>CARDHOLDER: " + track.getTrack1().getName();
                        }
                        catch (Exception e) {
                            logger.error((Object)e);
                        }
                        map.put(APPROVAL_CODE, string);
                    } else {
                        String string = "APPROVAL: " + transaction.getCardAuthCode();
                        string = string + "<br/>Card processed in ext. device.";
                        map.put(APPROVAL_CODE, string);
                    }
                }
            }
            String messageString = "<html>";
            messageString = messageString + "</html>";
            map.put(ADDITIONAL_PROPERTIES, messageString);
        }
        return map;
    }

    private static String tipsCalculation(Ticket ticket) {
        StringBuilder buildTips = new StringBuilder();
        buildTips.append("<html>");
        double totalAmount = ticket.getSubtotalAmount();
        String tipsSection = ReceiptUtil.getReceiptSection(DataProvider.get().getStore(), "tips_suggestion", ticket.getOrderType() != null ? ticket.getOrderType().getId() : null);
        if (tipsSection == null) {
            tipsSection = "[{\"percentage\":25,\"sortOrder\":1},{\"percentage\":20,\"sortOrder\":2},{\"percentage\":18,\"sortOrder\":3},{\"percentage\":15,\"sortOrder\":4}]";
        }
        JSONArray arrays = new JSONArray(tipsSection);
        ReceiptPrintService.beginRow(buildTips);
        for (int i = 0; i < arrays.length(); ++i) {
            Object ts = arrays.get(i);
            if (ts == null) continue;
            JSONObject object = new JSONObject(ts.toString());
            double percentage = object.getDouble("percentage");
            ReceiptPrintService.addColumn(buildTips, "<br>" + NumberUtil.trimDecilamIfNotNeeded(percentage) + "% " + Messages.getString("ReceiptPrintService.99") + NumberUtil.formatNumber(totalAmount * percentage / 100.0));
        }
        ReceiptPrintService.endRow(buildTips);
        buildTips.append("</html>");
        return buildTips.toString();
    }

    private static StringBuilder buildOrderInfo(PurchaseOrder order, TicketPrintProperties printProperties) {
        String orderNo = " ";
        if (order.getOrderId() != null) {
            orderNo = order.getOrderId();
        }
        StringBuilder ticketHeaderBuilder = new StringBuilder();
        ticketHeaderBuilder.append("<html>");
        InventoryLocation location = order.getInventoryLocation();
        String inventoryLocation = "";
        String locationAddress = "";
        if (location != null) {
            inventoryLocation = location.getName();
            locationAddress = location.getAddress();
        }
        if (order.getVarificationDate() != null) {
            ReceiptPrintService.beginRow(ticketHeaderBuilder);
            ReceiptPrintService.addColumn(ticketHeaderBuilder, "Date: " + DateUtil.formatFullDateAndTimeAsString(order.getVarificationDate()));
            ReceiptPrintService.endRow(ticketHeaderBuilder);
        }
        ReceiptPrintService.beginRow(ticketHeaderBuilder);
        ReceiptPrintService.addColumn(ticketHeaderBuilder, "Purchase Order #" + orderNo);
        ReceiptPrintService.endRow(ticketHeaderBuilder);
        if (StringUtils.isNotEmpty((String)inventoryLocation)) {
            ReceiptPrintService.beginRow(ticketHeaderBuilder);
            ReceiptPrintService.addColumn(ticketHeaderBuilder, "Inventory Location: " + inventoryLocation);
            ReceiptPrintService.endRow(ticketHeaderBuilder);
        }
        if (StringUtils.isNotEmpty((String)locationAddress)) {
            ReceiptPrintService.beginRow(ticketHeaderBuilder);
            ReceiptPrintService.addColumn(ticketHeaderBuilder, "Inventory Location Address: " + locationAddress);
            ReceiptPrintService.endRow(ticketHeaderBuilder);
        }
        ticketHeaderBuilder.append("</html>");
        return ticketHeaderBuilder;
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket, Store store) {
        return ReceiptPrintService.getTaxBreakdown(ticket, 20, 27, false, store);
    }

    public static StringBuilder getTaxBreakdown(Ticket ticket, int firstColLength, int secondColLegth, boolean ecsPrint, Store store) {
        StringBuilder taxBreakdownBuilder = new StringBuilder();
        Map<String, Double> taxProperties = ReceiptPrintService.populateTaxBreakdownMap(ticket);
        if (taxProperties.isEmpty()) {
            return null;
        }
        String currencySymbol = CurrencyUtil.getCurrencySymbol();
        taxBreakdownBuilder.append("<html><table>");
        Boolean includesTax = store.getItemPriceIncludesTax();
        String taxText = "(" + POSConstants.RECEIPT_REPORT_TAX_LABEL + ") ";
        Iterator<Map.Entry<String, Double>> iterator = taxProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Double> entry = iterator.next();
            String taxValue = NumberUtil.formatNumber(entry.getValue());
            String taxName = entry.getKey();
            if (!ecsPrint && taxName.length() > 15) {
                taxName = taxName.substring(0, 13) + "..";
            }
            taxName = taxName + currencySymbol;
            if (includesTax.booleanValue()) {
                taxName = taxName + Messages.getString("ReceiptPrintService.18");
                taxValue = " (" + taxValue + ")";
            }
            ReceiptPrintService.beginRow(taxBreakdownBuilder);
            ReceiptPrintService.addColumn(taxBreakdownBuilder, ReceiptPrintService.getHtmlText(taxText + taxName, taxName.length(), RIGHT));
            ReceiptPrintService.addColumn(taxBreakdownBuilder, ReceiptPrintService.getHtmlText(taxValue, secondColLegth - (ecsPrint ? 0 : taxValue.length()), RIGHT));
            if (!iterator.hasNext()) continue;
            ReceiptPrintService.endRow(taxBreakdownBuilder);
        }
        taxBreakdownBuilder.append("</div></table></html>");
        return taxBreakdownBuilder;
    }

    public static Map<String, Double> populateTaxBreakdownMap(Ticket ticket) {
        HashMap<String, Double> taxProperties = new HashMap<String, Double>();
        List<TicketItem> ticketItems = ticket.getTicketItems();
        ArrayList<TicketItemTax> taxes = new ArrayList<TicketItemTax>();
        for (TicketItem ticketItem : ticketItems) {
            for (TicketItemTax ticketItemTax : ticketItem.getTaxes()) {
                String key = ticketItemTax.getName();
                Double taxAmount = (Double)taxProperties.get(key);
                if (taxAmount == null) {
                    taxAmount = 0.0;
                }
                taxAmount = taxAmount + ticketItemTax.getTaxAmount();
                taxProperties.put(key, taxAmount);
                taxes.add(ticketItemTax);
            }
        }
        return taxProperties;
    }

    public static StringBuilder buildMulticurrencyBreakdown(Ticket ticket, TicketPrintProperties printProperties, boolean escPrint) {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        StringBuilder currencyAmountBuilder = new StringBuilder();
        currencyAmountBuilder.append("<html><table>");
        String sep = "------------------------------------";
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        String space = " ";
        ReceiptPrintService.addColumn(currencyAmountBuilder, space);
        ReceiptPrintService.addColumn(currencyAmountBuilder, space);
        ReceiptPrintService.addColumn(currencyAmountBuilder, space);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, "<b>Currency breakdown</b>");
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("", 13, RIGHT));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Net Amount", escPrint ? 13 : 11, RIGHT));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Due", escPrint ? 13 : 17, RIGHT));
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        int rowCount = 0;
        List<Currency> allCurrency = CurrencyUtil.getAllCurrency();
        if (allCurrency != null) {
            for (Currency currency : allCurrency) {
                if (currency == null) continue;
                String key = currency.getName();
                double rate = currency.getExchangeRate();
                ReceiptPrintService.beginRow(currencyAmountBuilder);
                ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(key, key.length(), RIGHT));
                String totalAmountText = decimalFormat.format(ticket.getTotalAmountWithTips() * rate);
                String dueAmountText = decimalFormat.format(ticket.getDueAmount() * rate);
                ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(totalAmountText, escPrint ? 13 : 20 - totalAmountText.length(), RIGHT));
                ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(dueAmountText, escPrint ? 13 : 20 - dueAmountText.length(), RIGHT));
                ReceiptPrintService.endRow(currencyAmountBuilder);
                ++rowCount;
            }
        }
        if (rowCount == 0) {
            return null;
        }
        currencyAmountBuilder.append("</table></html>");
        return currencyAmountBuilder;
    }

    private static StringBuilder buildMultiCurrency(Ticket ticket, PosTransaction transaction, TicketPrintProperties printProperties) {
        return ReceiptPrintService.buildMultiCurrency(ticket, transaction, printProperties, false);
    }

    public static StringBuilder buildMultiCurrency(Ticket ticket, PosTransaction transaction, TicketPrintProperties printProperties, boolean escPrint) {
        if (transaction == null) {
            return null;
        }
        DecimalFormat decimalFormat = new DecimalFormat("0.000");
        StringBuilder currencyAmountBuilder = new StringBuilder();
        currencyAmountBuilder.append("<html><table>");
        String sep = "------------------------------------";
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        String space = " ";
        ReceiptPrintService.addColumn(currencyAmountBuilder, space);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        String groupSettleTickets = ticket.getProperty("GROUP_SETTLE_TICKETS");
        if (groupSettleTickets == null) {
            groupSettleTickets = "";
        }
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, groupSettleTickets + "<b>\nCurrency breakdown</b>");
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("", 10, RIGHT));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Paid", escPrint ? 13 : 16, RIGHT));
        ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText("Cashback", escPrint ? 13 : 12, RIGHT));
        ReceiptPrintService.endRow(currencyAmountBuilder);
        ReceiptPrintService.beginRow(currencyAmountBuilder);
        ReceiptPrintService.addColumn(currencyAmountBuilder, sep);
        ReceiptPrintService.endRow(currencyAmountBuilder);
        int rowCount = 0;
        for (Currency currency : CurrencyUtil.getAllCurrency()) {
            if (currency == null) continue;
            String currencyName = currency.getName();
            String tenderedKey = currency.getId() + "_TENDERED";
            String cashBackKey = currency.getId() + "_CASH_BACK";
            String paidAmount = transaction.getProperty(tenderedKey);
            String cashBackAmount = transaction.getProperty(cashBackKey);
            if (paidAmount == null) {
                paidAmount = "0";
            }
            if (cashBackAmount == null) {
                cashBackAmount = "0";
            }
            Double paid = Double.valueOf(paidAmount);
            Double changeDue = Double.valueOf(cashBackAmount);
            if (paid == 0.0 && changeDue == 0.0) continue;
            String paidAmountText = decimalFormat.format(paid);
            String changeAmountText = decimalFormat.format(changeDue);
            ReceiptPrintService.beginRow(currencyAmountBuilder);
            ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(currencyName, currencyName.length(), RIGHT));
            ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(paidAmountText, escPrint ? 13 : 20 - paidAmountText.length(), RIGHT));
            ReceiptPrintService.addColumn(currencyAmountBuilder, ReceiptPrintService.getHtmlText(changeAmountText, escPrint ? 13 : 20 - changeAmountText.length(), RIGHT));
            ReceiptPrintService.endRow(currencyAmountBuilder);
            ++rowCount;
        }
        if (rowCount == 0) {
            return null;
        }
        currencyAmountBuilder.append("</table></html>");
        return currencyAmountBuilder;
    }

    public static String getHtmlText(String txt, int length, String align) {
        block4: {
            String sp;
            block5: {
                block3: {
                    sp = "&nbsp;";
                    if (!align.equals(CENTER)) break block3;
                    int space = (length - txt.length()) / 2;
                    for (int i = 1; i <= space; ++i) {
                        txt = sp + txt + sp;
                    }
                    break block4;
                }
                if (!align.equals(RIGHT)) break block5;
                int space = length - txt.length();
                for (int i = 1; i <= space; ++i) {
                    txt = sp + txt;
                }
                break block4;
            }
            if (!align.equals(LEFT)) break block4;
            int space = length - txt.length();
            for (int i = 1; i <= space; ++i) {
                txt = txt + sp;
            }
        }
        return txt;
    }

    public static void printVoidKitchenTicket(String virtualPrinterName, KitchenTicket kitchenTicket, String deviceName) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(HEADER_LINE1, DataProvider.get().getStore().getName());
        map.put(CARD_PAYMENT, true);
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(SHOW_HEADER_SEPARATOR, Boolean.TRUE);
        map.put(ReceiptParam.TICKET_ID.getParamName(), POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + kitchenTicket.getTicketId());
        if (kitchenTicket.getTableNumbers() != null && kitchenTicket.getTableNumbers().size() > 0) {
            map.put(ReceiptParam.TABLE_NO.getParamName(), POSConstants.RECEIPT_REPORT_TABLE_NO_LABEL + kitchenTicket.getTableNumbers());
        }
        if (StringUtils.isNotEmpty((String)kitchenTicket.getCustomerName())) {
            map.put("customer", Messages.getString("ReceiptPrintService.0") + kitchenTicket.getCustomerName());
        }
        map.put(ReceiptParam.SERVER_NAME.getParamName(), POSConstants.RECEIPT_REPORT_SERVER_LABEL + kitchenTicket.getServerName());
        map.put(REPORT_DATE, Messages.getString("ReceiptPrintService.119") + DateUtil.getReportDate());
        map.put(TICKET_HEADER, Messages.getString("ReceiptPrintService.12"));
        String ticketType = kitchenTicket.getOrderType().toString();
        if (StringUtils.isNotEmpty((String)ticketType)) {
            ticketType = ticketType.replaceAll("_", " ");
        }
        map.put(ReceiptParam.ORDER_TYPE.getParamName(), "** VOID **");
        map.put(PROP_PRINTER_NAME, Messages.getString("ReceiptPrintService.14") + virtualPrinterName);
        ReceiptPrintService.getJasperPrintService().printVoidKitchenTicket(kitchenTicket, map, virtualPrinterName, deviceName);
    }

    public static void printToKitchen(Ticket ticket) {
        ReceiptPrintService.printToKitchen(ticket, true);
    }

    public static void printToKitchen(Ticket ticket, boolean isFilterKitchenPrintedItems) {
        ReceiptPrintService.printToKitchen(ticket, isFilterKitchenPrintedItems, true);
    }

    public static void printToKitchen(Ticket ticket, boolean isFilterKitchenPrintedItems, boolean saveAndUpdateStatus) {
        try {
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, isFilterKitchenPrintedItems);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, kitchenTickets, saveAndUpdateStatus);
            OroMqttClient.getInstance().publishOnThread("MQTT-COMMAND-KIT-DIS-UPDATE", "3");
            CloudDataUploader.get().uploadToCloudIfOnlineOrder(ticket);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public static void printCourseItemsToKitchen(Ticket ticket, List<TicketItem> ticketItems, boolean shouldKdsPrint) {
        try {
            if (ticket == null && ticketItems == null) {
                return;
            }
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, shouldKdsPrint, ticketItems);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, kitchenTickets, shouldKdsPrint);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CourseOrganizeTableView.0") + " " + POSConstants.COURSE + " " + ticketItems.get(0).getCourseName());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static void printItemsToKitchen(Ticket ticket, List<TicketItem> ticketItems) {
        try {
            if (ticket == null && ticketItems == null) {
                return;
            }
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, true, ticketItems);
            ReceiptPrintService.doPrintToKitchenAndSaveStatus(ticket, kitchenTickets, true);
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static void doPrintToKitchenAndSaveStatus(Ticket ticket, List<KitchenTicket> kitchenTickets, boolean saveAndUpdateStatus) throws Exception {
        if (saveAndUpdateStatus) {
            ticket.setShouldUpdateStock(true);
        }
        for (KitchenTicket kitchenTicket : kitchenTickets) {
            kitchenTicket.setParentTicket(ticket);
            Printer printer = kitchenTicket.getPrinter();
            String deviceName = printer.getDeviceName();
            if (printer.getVirtualPrinter().getType() == 2 && deviceName != null) {
                logger.info((Object)("Printing to kitchen using printer: " + deviceName));
                HashMap<String, Object> map = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, deviceName, printer.getVirtualPrinter().getName(), saveAndUpdateStatus);
                ReceiptPrintService.setPrintProperty(map, printer);
                ReceiptPrintService.getReceiptPrintServiceProvider(printer).printKitchenTicket(kitchenTicket, map, ticket, printer.getVirtualPrinter().getName(), deviceName);
                if (!saveAndUpdateStatus || !DataProvider.get().getStore().isKDSenabled()) continue;
                TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
                continue;
            }
            if (printer.getVirtualPrinter().getType() == 6 && deviceName != null) {
                logger.info((Object)("Printing to sticker using printer: " + deviceName));
                ReceiptPrintService.doPrintKitchenStickers(kitchenTicket, deviceName);
                continue;
            }
            if (!saveAndUpdateStatus || printer.getVirtualPrinter().getType() != 4) continue;
            TicketDAO.getInstance().saveKitchenPrintStatus(ticket, kitchenTicket);
        }
        if (saveAndUpdateStatus) {
            ticket.clearDeletedItems();
            ticket.setStatus("Waiting (Kitchen)");
            TicketDAO.getInstance().saveOrUpdate(ticket);
        }
    }

    public static void doPrintKitchenStickers(Ticket ticket) {
        try {
            List<Printer> stickerPrinters = DataProvider.get().getPrinters().getStickerPrinters();
            if (stickerPrinters.isEmpty()) {
                return;
            }
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, true);
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                Printer printer = kitchenTicket.getPrinter();
                String deviceName = printer.getDeviceName();
                kitchenTicket.setParentTicket(ticket);
                if (printer.getVirtualPrinter().getType() != 6 || deviceName == null) continue;
                ReceiptPrintService.doPrintKitchenStickers(kitchenTicket, deviceName);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private static void doPrintKitchenStickers(KitchenTicket kitchenTicket, String deviceName) {
        try {
            List<KitchenTicketItem> ticketItems = kitchenTicket.getTicketItems();
            ArrayList<KitchenStickerModel.KitchenSticker> kitchenStickers = new ArrayList<KitchenStickerModel.KitchenSticker>();
            int count = 0;
            int quantity = ReceiptPrintService.getTotalQty(ticketItems);
            for (KitchenTicketItem kitchenTicketItem : ticketItems) {
                if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
                int i = 0;
                while ((double)i < kitchenTicketItem.getQuantity()) {
                    KitchenStickerModel.KitchenSticker kitchenSticker = new KitchenStickerModel.KitchenSticker();
                    kitchenSticker.setToken(kitchenTicket.getTokenNo());
                    kitchenSticker.setCustomerName(ReceiptPrintService.addCustomerName(kitchenTicket));
                    String menuItemName = kitchenTicketItem.getMenuItemName();
                    if (StringUtils.isNotEmpty((String)menuItemName)) {
                        menuItemName = kitchenTicketItem.getQuantity() > 1.0 ? menuItemName.substring(menuItemName.indexOf(32) + 1) : menuItemName;
                    }
                    kitchenSticker.setItemName(menuItemName);
                    kitchenSticker.setModifiers(kitchenTicket.getModifiersForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setCookingInstructions(kitchenTicket.getCookingInstructionForTicketItem(kitchenTicketItem.getTicketItemId()));
                    kitchenSticker.setTime(Messages.getString("ReceiptPrintService.102") + DateUtil.formatDateWithTime(new Date()));
                    if (kitchenTicket.getOrderType() != null) {
                        kitchenSticker.setOrderType(kitchenTicket.getOrderType().getName());
                    }
                    kitchenSticker.setItemCount(Messages.getString("ReceiptPrintService.103") + (count + 1) + Messages.getString("ReceiptPrintService.104") + quantity);
                    kitchenStickers.add(kitchenSticker);
                    ++count;
                    ++i;
                }
            }
            JasperPrint jasperPrint = ReceiptPrintService.printKitchenStickerItems(kitchenStickers);
            jasperPrint.setName("Kitchen_Sticker_" + kitchenTicket.getTokenNo());
            jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
            JasperPrintService.printQuitely(jasperPrint);
        }
        catch (Exception e) {
            PosLog.error(ReceiptPrintService.class, e.getMessage(), e);
        }
    }

    private static String addCustomerName(KitchenTicket kitchenTicket) {
        Ticket parentTicket = kitchenTicket.getParentTicket();
        if (parentTicket == null) {
            return null;
        }
        Customer customer = parentTicket.getCustomer();
        String note = parentTicket.getNote();
        String customerNameAndNote = "";
        if (customer != null) {
            customerNameAndNote = customer.getName();
        }
        if (StringUtils.isNotBlank((String)note)) {
            customerNameAndNote = StringUtils.isNotBlank((String)customerNameAndNote) ? customerNameAndNote + "/" + note : note;
        }
        return customerNameAndNote;
    }

    private static int getTotalQty(List<KitchenTicketItem> ticketItems) {
        int quantity = 0;
        for (KitchenTicketItem kitchenTicketItem : ticketItems) {
            if (!kitchenTicketItem.isPrintKitchenSticker().booleanValue() || kitchenTicketItem.isModifierItem().booleanValue() || kitchenTicketItem.isCookingInstruction().booleanValue()) continue;
            quantity = (int)((double)quantity + kitchenTicketItem.getQuantity());
        }
        return quantity;
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean isFilterKitchenPrintedItems) {
        return ReceiptPrintService.getKitchenJasperPrint(ticket, isFilterKitchenPrintedItems, false);
    }

    @Deprecated
    public static JasperPrint getKitchenJasperPrint(Ticket ticket, boolean isFilterKitchenPrintedItems, boolean ignorePagination) {
        try {
            List<KitchenTicket> kitchenTickets = KitchenTicket.fromTicket(ticket, isFilterKitchenPrintedItems);
            for (KitchenTicket kitchenTicket : kitchenTickets) {
                kitchenTicket.setParentTicket(ticket);
                Printer printer = kitchenTicket.getPrinter();
                String deviceName = printer.getDeviceName();
                if (deviceName == null) continue;
                HashMap<String, Object> map = ReceiptPrintService.populateKitchenTicketProperties(kitchenTicket, deviceName, printer.getVirtualPrinter().getName(), ignorePagination);
                JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createKitchenPrint(map, printer.getVirtualPrinter().getName(), kitchenTicket, deviceName, ignorePagination);
                jasperPrint.setName("FP_KitchenReceipt_" + ticket.getId() + "_" + kitchenTicket.getSequenceNumber());
                jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                return jasperPrint;
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
        return null;
    }

    public static void printVoidItemsToKitchen(Ticket ticket) {
        try {
            if (!ticket.getOrderType().isShouldPrintToKitchen().booleanValue()) {
                return;
            }
            ArrayList<VoidItem> voidItems = new ArrayList<VoidItem>();
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                VoidItem voidItem = ticketItem.getVoidItem();
                if (voidItem == null) continue;
                if (voidItem.getVoidedModifiers() != null) {
                    voidItems.addAll(voidItem.getVoidedModifiers());
                }
                voidItems.add(voidItem);
            }
            HashMap<Printer, KitchenTicket> itemMap = new HashMap<Printer, KitchenTicket>();
            Date serverTimestamp = StoreDAO.getServerTimestamp();
            for (VoidItem voidItem : voidItems) {
                PrinterGroup printerGroup;
                List<Printer> printers;
                if (voidItem.isCooked() || (printers = ReceiptPrintService.getPrinters(printerGroup = voidItem.getPrinterGroup())) == null) continue;
                for (Printer printer : printers) {
                    KitchenTicket kitchenTicket = (KitchenTicket)itemMap.get(printer);
                    if (kitchenTicket == null) {
                        kitchenTicket = new KitchenTicket();
                        kitchenTicket.setPrinterGroup(printerGroup);
                        kitchenTicket.setTicketId(ticket.getId());
                        kitchenTicket.setTokenNo(ticket.getTokenNo());
                        kitchenTicket.setCreateDate(serverTimestamp);
                        kitchenTicket.setOrderType(ticket.getOrderType());
                        if (ticket.getTableNumbers() != null) {
                            kitchenTicket.setTableNumbers(new ArrayList<Integer>(ticket.getTableNumbers()));
                        }
                        kitchenTicket.setServerName(ticket.getOwner().getFirstName());
                        kitchenTicket.setStatus(KitchenStatus.WAITING.name());
                        if (StringUtils.isNotEmpty((String)ticket.getProperty("CUSTOMER_NAME"))) {
                            kitchenTicket.setCustomerName(ticket.getProperty("CUSTOMER_NAME"));
                        }
                        kitchenTicket.setPrinter(printer);
                        itemMap.put(printer, kitchenTicket);
                    }
                    KitchenTicketItem item = new KitchenTicketItem();
                    item.setTicketItemId(voidItem.getId());
                    item.setMenuItemCode(String.valueOf(voidItem.getMenuItemId()));
                    item.setMenuItemName(voidItem.getMenuItemName());
                    item.setQuantity(voidItem.getQuantity());
                    item.setUnitName("");
                    item.setMenuItemGroupName("VOID");
                    item.setSortOrder(10001);
                    item.setStatus(KitchenStatus.VOID.name());
                    item.setKitchenTicket(kitchenTicket);
                    kitchenTicket.addToticketItems(item);
                }
            }
            for (KitchenTicket kitchenTicket : itemMap.values()) {
                Printer printer = kitchenTicket.getPrinter();
                String deviceName = printer.getDeviceName();
                ReceiptPrintService.printVoidKitchenTicket(printer.getVirtualPrinter().getName(), kitchenTicket, deviceName);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public static List<Printer> getPrinters(PrinterGroup printerGroup) {
        PosPrinters printers = DataProvider.get().getPrinters();
        if (printerGroup == null) {
            printerGroup = PrinterGroupDAO.getInstance().getDefaultPrinterGroup();
        }
        ArrayList<Printer> printerAll = new ArrayList<Printer>();
        if (printerGroup == null) {
            printerAll.addAll(printers.getKitchenPrinters());
            return printerAll;
        }
        List<String> printerNames = printerGroup.getPrinterNames();
        List<Printer> kitchenPrinters = printers.getKitchenPrinters();
        for (Printer printer : kitchenPrinters) {
            if (!printerNames.contains(printer.getVirtualPrinter().getName())) continue;
            printerAll.add(printer);
        }
        if (printerAll.isEmpty() && PrintServiceUtil.getFallBackPrinter() != null) {
            printerAll.add(PrintServiceUtil.getFallBackPrinter());
        }
        return printerAll;
    }

    public static Log getLogger() {
        return logger;
    }

    public static File getPdfPrinterDir() {
        return pdfPrinterDir;
    }

    private static String getCardNumber(BankCardMagneticTrack track) {
        String no = "";
        try {
            if (track.getTrack1().hasPrimaryAccountNumber()) {
                no = track.getTrack1().getPrimaryAccountNumber().getAccountNumber();
                no = "************" + no.substring(12);
            } else if (track.getTrack2().hasPrimaryAccountNumber()) {
                no = track.getTrack2().getPrimaryAccountNumber().getAccountNumber();
                no = "************" + no.substring(12);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return no;
    }

    private static String getCardInformation(PosTransaction transaction) {
        String br = "<br>";
        String string = br + Messages.getString("ReceiptPrintService.15") + " ------------------------";
        try {
            String cardNumber;
            if (transaction.getCardReader() != null) {
                string = string + br + Messages.getString("ReceiptPrintService.17") + transaction.getCardReader();
            }
            if (transaction.getCardType() != null) {
                string = string + br + Messages.getString("ReceiptPrintService.20") + transaction.getCardType();
            }
            if ((cardNumber = transaction.getCardNumber()) != null) {
                string = string + br + Messages.getString("ReceiptPrintService.21") + " **** **** **** " + cardNumber.substring(cardNumber.length() - 4, cardNumber.length());
            }
            if (transaction.getCardHolderName() != null) {
                string = string + br + Messages.getString("ReceiptPrintService.23") + transaction.getCardHolderName();
            }
            if (transaction.getCardTransactionId() != null) {
                string = string + br + Messages.getString("ReceiptPrintService.24") + transaction.getCardTransactionId();
            }
            string = string + br + Messages.getString("ReceiptPrintService.29") + transaction.getCardAuthCode();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return string;
    }

    public static void printCloudTicket(Ticket ticket, Terminal terminal, PosTransaction transaction) {
        try {
            TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
            printProperties.setPrintCookingInstructions(false);
            HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket, printProperties, transaction);
            List<TerminalPrinters> terminalPrinters = TerminalPrintersDAO.getInstance().findTerminalPrinters(terminal);
            ArrayList<Printer> activeReceiptPrinters = new ArrayList<Printer>();
            for (TerminalPrinters terminalPrinters2 : terminalPrinters) {
                int printerType = terminalPrinters2.getVirtualPrinter().getType();
                if (printerType != 1) continue;
                Printer printer = new Printer(terminalPrinters2.getVirtualPrinter(), terminalPrinters2.getPrinterName());
                activeReceiptPrinters.add(printer);
            }
            if (activeReceiptPrinters == null || activeReceiptPrinters.isEmpty()) {
                JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, map, null);
                jasperPrint.setName(ORDER_ + ticket.getId());
                jasperPrint.setProperty(PROP_PRINTER_NAME, DataProvider.get().getPrinters().getReceiptPrinter());
                JasperPrintService.printQuitely(jasperPrint);
            } else {
                for (Printer activeReceiptPrinter : activeReceiptPrinters) {
                    String deviceName = activeReceiptPrinter.getDeviceName();
                    if (deviceName == null) continue;
                    JasperPrint jasperPrint = ReceiptPrintService.getJasperPrintService().createPrint(ticket, map, null);
                    jasperPrint.setName(ORDER_ + ticket.getId() + deviceName);
                    jasperPrint.setProperty(PROP_PRINTER_NAME, deviceName);
                    JasperPrintService.printQuitely(jasperPrint);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)POSConstants.PRINT_ERROR, (Throwable)e);
        }
    }

    public static ReciptPaperSize getReceiptPaperSize(String receiptPropertyName) {
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String receiptProperty = currentTerminal.getProperty(receiptPropertyName);
        ReciptPaperSize paperSize = ReciptPaperSize.Eighty;
        try {
            if (StringUtils.isNotEmpty((String)receiptProperty)) {
                paperSize = ReciptPaperSize.valueOf(receiptProperty);
            }
        }
        catch (Exception e) {
            paperSize = ReciptPaperSize.Eighty;
        }
        return paperSize;
    }

    private static KitchenStickerPaperSize getKitchenStickerPaperSize(String receiptPropertyName) {
        Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
        String receiptProperty = currentTerminal.getProperty(receiptPropertyName);
        KitchenStickerPaperSize paperSize = KitchenStickerPaperSize.FiftyOneMM;
        try {
            if (StringUtils.isNotEmpty((String)receiptProperty)) {
                paperSize = KitchenStickerPaperSize.fromName(receiptProperty);
            }
        }
        catch (Exception e) {
            paperSize = KitchenStickerPaperSize.FiftyOneMM;
        }
        return paperSize;
    }

    public static boolean hasNoReceiptPrinters() {
        boolean isReceiptPrintersNotExist;
        PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
        boolean printUsingPaymentGateway = paymentGateway != null && paymentGateway.printUsingThisTerminal();
        List<Printer> receiptPrinters = DataProvider.get().getPrinters().getReceiptPrinters();
        boolean bl = isReceiptPrintersNotExist = receiptPrinters == null || receiptPrinters.isEmpty() || receiptPrinters.size() == 0;
        return isReceiptPrintersNotExist && !printUsingPaymentGateway;
    }

    public static boolean hasNoKitchenReceiptPrinters() {
        PosPrinters printers = DataProvider.get().getPrinters();
        return printers == null || printers.getKitchenPrinters() == null || printers.getKitchenPrinters().size() == 0 && printers.getStickerPrinters().size() == 0 && !printers.isPrintToKds();
    }

    private static void updatePrintCount(Ticket ticket) {
        int printCountInt = POSUtil.getIntegerOrZero(ticket.getProperty("printCount"));
        ticket.addProperty("printCount", String.valueOf(++printCountInt));
        if (ticket.getTicketItems().size() > 0 && ticket.getTicketItems().get(0) instanceof PreviewTicketUtil.PreviewTicketItem) {
            return;
        }
        OrderController.saveOrder(ticket);
    }

    public static HashMap<String, Object> populateKitchenTicketProperties(KitchenTicket ticket, String deviceName, String virtualPrinterName, boolean ignorePagination) {
        OrderType orderType;
        String ticketType;
        TicketPrintProperties printProperties = new TicketPrintProperties(null, false, true, true);
        HashMap<String, Object> map = ReceiptPrintService.populateTicketProperties(ticket.getParentTicket(), printProperties, null, true, false);
        ReceiptPrintService.setPaginationProperty(map, deviceName, ignorePagination);
        if (ReceiptPrintService.containsVoidItemOnly(ticket)) {
            map.put(HEADER_LINE1, "**");
        }
        if (StringUtils.isNotEmpty((String)(ticketType = ticket.getOrderType().toString()))) {
            ticketType = ticketType.replaceAll("_", " ");
        }
        if ((orderType = ticket.getOrderType()).isDelivery().booleanValue() || orderType.isPickup().booleanValue()) {
            if (ticket.getParentTicket().isCustomerWillPickup().booleanValue()) {
                map.put(ReceiptParam.ORDER_TYPE.getParamName(), "*" + Messages.getString("PICKUP") + "*");
            } else {
                map.put(ReceiptParam.ORDER_TYPE.getParamName(), "*" + Messages.getString("DELIVERY") + "*");
            }
        } else {
            map.put(ReceiptParam.ORDER_TYPE.getParamName(), "* " + ticketType + " *");
        }
        map.put(PROP_PRINTER_NAME, "Printer Name : " + virtualPrinterName);
        return map;
    }

    private static boolean containsVoidItemOnly(KitchenTicket ticket) {
        for (KitchenTicketItem item : ticket.getTicketItems()) {
            if (item.isVoided().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static void printQuitely(JasperPrint jasperPrint) throws JRException {
        JasperPrintService.printQuitely(jasperPrint);
    }

    private static void saveJournal(Ticket ticket) {
        String description = "Ticket is printed at %s. Total: %s";
        description = String.format(description, new Date(), ticket.getTotalAmount());
        ActionHistoryDAO.saveHistory(ticket, "Print receipt", description);
    }

    private static String createGiftCertificateInfo(PosTransaction transaction) {
        GiftCard giftCard = GiftCardDAO.getInstance().get(transaction.getGiftCertNumber());
        if (giftCard == null) {
            return "";
        }
        String cardNo = giftCard.getCardNumber();
        String lastFourDigitsOfGiftCardNo = cardNo.length() > 4 ? "***" + cardNo.substring(cardNo.length() - 4) : cardNo;
        String giftCertificateInfo = new String();
        giftCertificateInfo = giftCertificateInfo + ReceiptPrintService.lineBreak();
        giftCertificateInfo = giftCertificateInfo + Messages.getString("ReceiptPrintService.30") + "------------" + ReceiptPrintService.lineBreak();
        giftCertificateInfo = giftCertificateInfo + Messages.getString("ReceiptPrintService.32") + ": " + lastFourDigitsOfGiftCardNo + ReceiptPrintService.lineBreak();
        giftCertificateInfo = giftCertificateInfo + Messages.getString("ReceiptPrintService.33") + ": " + CurrencyUtil.getCurrencySymbol() + NumberUtil.formatNumber(giftCard.getBalance(), (boolean)Boolean.TRUE);
        return giftCertificateInfo;
    }

    static {
        logger = LogFactory.getLog(ReceiptPrintService.class);
        String homeDir = System.getProperty("user.home");
        pdfPrinterDir = new File(homeDir, "oropos-pdf-print");
        if (!pdfPrinterDir.exists()) {
            pdfPrinterDir.mkdirs();
        }
    }
}

