/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.CurrencyUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.JRViewer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReportUtil {
    private static Log logger = LogFactory.getLog(ReportUtil.class);
    private static final String DEFAULT_REPORT_DIR = "/com/floreantpos/report/template/";

    public static void populateRestaurantProperties(Map map) {
        ReportUtil.populateRestaurantProperties(map, false);
    }

    public static void populateRestaurantProperties(Map map, boolean isPortrait) {
        JasperReport reportHeader = null;
        reportHeader = isPortrait ? ReportUtil.getReport("report_header_portrait") : ReportUtil.getReport(PaperSize.getReportNameAccording2Size("report_header"));
        Store store = StoreDAO.getRestaurant();
        if (store != null) {
            map.put("restaurantName", store.getName());
            map.put("addressLine1", store.getAddressLine1());
            map.put("addressLine2", store.getAddressLine2());
            map.put("addressLine3", store.getAddressLine3());
            map.put("phone", store.getTelephone());
            map.put("reportHeader", reportHeader);
        }
    }

    public static JasperReport getReport(String reportName) {
        return ReportUtil.getDefaultReport(reportName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JasperReport getDefaultReport(String reportName) {
        InputStream resource = null;
        try {
            resource = ReceiptPrintService.class.getResourceAsStream(DEFAULT_REPORT_DIR + reportName + ".jasper");
            JasperReport jasperReport = (JasperReport)JRLoader.loadObject((InputStream)resource);
            IOUtils.closeQuietly((InputStream)resource);
            return jasperReport;
        }
        catch (Exception e) {
            logger.error((Object)e);
            JasperReport jasperReport = null;
            return jasperReport;
        }
        finally {
            IOUtils.closeQuietly(resource);
        }
    }

    public static void populateReportHeader(HashMap map, Terminal terminal, Date fromDate, Date toDate, String userName) {
        String terminalName = terminal == null ? POSConstants.ALL : terminal.getName();
        ReportUtil.populateReportTime(map, fromDate, toDate);
        if (userName != null) {
            map.put("userType", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_TYPE) + " " + userName);
        } else {
            map.put("systemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.SYSTEM_TYPE) + " " + POSConstants.SYSTEM_TOTAL);
        }
        map.put("terminalName", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + " " + terminalName);
        map.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
    }

    private static String createTerminalNameString(List<Terminal> selectedTerminals) {
        if (selectedTerminals == null) {
            return POSConstants.ALL;
        }
        String terminalNames = "";
        Iterator<Terminal> iterator = selectedTerminals.iterator();
        while (iterator.hasNext()) {
            Terminal terminal = iterator.next();
            terminalNames = terminalNames + terminal.getName();
            if (!iterator.hasNext()) continue;
            terminalNames = terminalNames + ", ";
        }
        return terminalNames;
    }

    public static void populateReportHeaderWithTerminals(HashMap map, List<Terminal> terminals, Date fromDate, Date toDate, String userName) {
        String createTerminalNames = ReportUtil.createTerminalNameString(terminals);
        ReportUtil.populateReportTime(map, fromDate, toDate);
        if (userName != null) {
            map.put("userType", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_TYPE) + " " + userName);
        } else {
            map.put("systemTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.SYSTEM_TYPE) + " " + POSConstants.SYSTEM_TOTAL);
        }
        map.put("terminalName", ReportUtil.reportLabelWithBoldTag(POSConstants.TERMINAL) + " " + createTerminalNames);
        map.put("currency", ReportUtil.reportLabelWithBoldTag(POSConstants.CURRENCY) + " " + CurrencyUtil.getCurrencyName() + CurrencyUtil.getCurrencySymbolWithBracket());
    }

    public static void populateReportTime(HashMap map, Date fromDate, Date toDate) {
        map.put("reportTime", ReportUtil.reportLabelWithBoldTag(POSConstants.REPORT_TIME) + DateUtil.formatDateWithTime(new Date()));
        map.put("fromDate", ReportUtil.reportLabelWithBoldTag(POSConstants.FROM_DATE) + DateUtil.formatReportDate(fromDate));
        map.put("toDate", ReportUtil.reportLabelWithBoldTag(POSConstants.TO_DATE) + DateUtil.formatReportDate(toDate));
    }

    public static void populateReportFooter(HashMap properties) {
        properties.put("footerPage", ReportUtil.reportLabelWithBoldTag(POSConstants.PAGE));
    }

    public static String reportLabelWithBoldTag(String tag) {
        String boldTag = "<b>" + tag + "</b>";
        return boldTag;
    }

    public static JRViewer getCustomJRViewer(JasperPrint print) {
        JRViewer viewer = new JRViewer(print);
        JRSaveContributor[] sv = viewer.getSaveContributors();
        ArrayList<JRSaveContributor> reorded = new ArrayList<JRSaveContributor>();
        for (JRSaveContributor s : sv) {
            if (s.getDescription().contains(".pdf")) {
                reorded.add(0, s);
                continue;
            }
            reorded.add(s);
        }
        viewer.setSaveContributors(reorded.toArray(new JRSaveContributor[reorded.size()]));
        return viewer;
    }
}

