/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.service.SalesBalanceReportService;
import com.floreantpos.swing.time.TimeComboBox;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class SalesBalanceReportView
extends JPanel {
    private JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
    private JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
    private JComboBox cbUserType;
    private JButton btnToday;
    private JButton btnGo = new JButton(POSConstants.GO);
    private JPanel reportContainer;
    private JComboBox<Date> jcbStartTime;
    private JComboBox<Date> jcbEndTime;

    public SalesBalanceReportView() throws ParseException {
        super(new BorderLayout());
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout());
        this.btnToday = new JButton(POSConstants.TODAYS_REPORT.toUpperCase());
        this.btnToday.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Date fromDate = new Date();
                    Date toDate = new Date();
                    Date fromTime = (Date)SalesBalanceReportView.this.jcbStartTime.getSelectedItem();
                    Date toTime = (Date)SalesBalanceReportView.this.jcbEndTime.getSelectedItem();
                    fromDate = DateUtil.copyTime(fromDate, fromTime);
                    toDate = DateUtil.copyTime(toDate, toTime);
                    SalesBalanceReportView.this.viewReport(fromDate, toDate);
                }
                catch (Exception ex) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
                }
            }
        });
        this.cbUserType = new JComboBox();
        UserDAO dao = new UserDAO();
        List<User> userTypes = dao.findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.cbUserType.setModel(new DefaultComboBoxModel(list));
        TimeComboBox tcb = new TimeComboBox();
        this.jcbStartTime = tcb.getDefaultTimeComboBox();
        this.jcbStartTime.setSelectedIndex(16);
        this.jcbEndTime = tcb.getDefaultTimeComboBox();
        this.jcbEndTime.setSelectedIndex(44);
        topPanel.add(new JLabel(POSConstants.FROM + ":"));
        topPanel.add((Component)this.fromDatePicker);
        topPanel.add(this.jcbStartTime);
        topPanel.add(new JLabel(POSConstants.TO + ":"));
        topPanel.add((Component)this.toDatePicker);
        topPanel.add(this.jcbEndTime);
        topPanel.add(new JLabel(POSConstants.USER + ":"));
        topPanel.add(this.cbUserType);
        topPanel.add((Component)this.btnGo, "width 60!");
        topPanel.add(this.btnToday);
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportContainer = new JPanel(new BorderLayout());
        centerPanel.add(this.reportContainer);
        this.add(centerPanel);
        this.btnGo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Date fromDate = SalesBalanceReportView.this.fromDatePicker.getDate();
                    Date toDate = SalesBalanceReportView.this.toDatePicker.getDate();
                    Date fromTime = (Date)SalesBalanceReportView.this.jcbStartTime.getSelectedItem();
                    Date toTime = (Date)SalesBalanceReportView.this.jcbEndTime.getSelectedItem();
                    fromDate = DateUtil.copyTime(fromDate, fromTime);
                    toDate = DateUtil.copyTime(toDate, toTime);
                    SalesBalanceReportView.this.viewReport(fromDate, toDate);
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(SalesBalanceReportView.this, POSConstants.ERROR_MESSAGE, e1);
                }
            }
        });
    }

    private void viewReport(Date fromDate, Date toDate) throws Exception {
        if (fromDate.after(toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        User user = null;
        if (!this.cbUserType.getSelectedItem().equals(POSConstants.ALL)) {
            user = (User)this.cbUserType.getSelectedItem();
        }
        JasperPrint jasperPrint = SalesBalanceReportService.createSalesBalanceReport(fromDate, toDate, user);
        JRViewer viewer = ReportUtil.getCustomJRViewer(jasperPrint);
        this.reportContainer.removeAll();
        this.reportContainer.add((Component)viewer);
        this.reportContainer.revalidate();
    }
}

