/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.report.ReportItem;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SalesReportModel
extends AbstractTableModel {
    private static DecimalFormat formatter = new DecimalFormat("#,##0.00");
    private String[] columnNames = new String[]{"barcode", "name", "unit", "qty", "price", "cost", "costPercentage", "grossTotal", "tax", "netTotal", "groupId", "groupName", "discount", "serviceCharge"};
    private List<ReportItem> items;
    private double grandTotal;
    private double totalQuantity;
    private double taxTotal;
    private double netTotal;
    private double discountTotal;

    @Override
    public int getRowCount() {
        if (this.items == null) {
            return 0;
        }
        return this.items.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ReportItem item = this.items.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return item.getId();
            }
            case 1: {
                return item.getName();
            }
            case 2: {
                return item.getUnit();
            }
            case 3: {
                return item.getQuantity();
            }
            case 4: {
                return item.getPrice();
            }
            case 5: {
                return item.getCost();
            }
            case 6: {
                if (item.getAdjustedPrice() > 0.0) {
                    return item.getCost() / item.getAdjustedPrice() * 100.0;
                }
                return 0.0;
            }
            case 7: {
                return item.getGrossTotal();
            }
            case 8: {
                return item.getTaxTotal();
            }
            case 9: {
                return item.getNetTotal();
            }
            case 10: {
                if (item.getGroupId() != null) {
                    return item.getGroupName();
                }
                return "";
            }
            case 11: {
                if (item.getGroupName() != null) {
                    return item.getGroupName();
                }
                return "No group";
            }
            case 12: {
                return item.getDiscount();
            }
            case 13: {
                return item.getServiceCharge();
            }
        }
        return null;
    }

    public List<ReportItem> getItems() {
        return this.items;
    }

    public void setItems(List<ReportItem> items) {
        this.items = items;
    }

    public double getGrandTotal() {
        return this.grandTotal;
    }

    public String getGrandTotalAsString() {
        return formatter.format(this.grandTotal);
    }

    public void setGrandTotal(double grandTotal) {
        this.grandTotal = grandTotal;
    }

    public void calculateGrandTotal() {
        this.grandTotal = 0.0;
        if (this.items == null) {
            return;
        }
        for (ReportItem item : this.items) {
            this.grandTotal += item.getNetTotal();
        }
    }

    public String getTaxTotalAsString() {
        return formatter.format(this.taxTotal);
    }

    public void setTaxTotal(double taxTotal) {
        this.taxTotal = taxTotal;
    }

    public void calculateTaxTotal() {
        this.taxTotal = 0.0;
        if (this.items == null) {
            return;
        }
        for (ReportItem item : this.items) {
            this.taxTotal += item.getTaxTotal();
        }
    }

    public String getNetTotalAsString() {
        return formatter.format(this.netTotal);
    }

    public void setNetTotal(double netTotal) {
        this.netTotal = netTotal;
    }

    public void calculateNetTotal() {
        this.netTotal = 0.0;
        if (this.items == null) {
            return;
        }
        for (ReportItem item : this.items) {
            this.netTotal += item.getGrossTotal();
        }
    }

    public String getTotalQuantityAsString() {
        return String.valueOf(this.totalQuantity);
    }

    public void setTotalQuantity(int totalQuantity) {
        this.totalQuantity = totalQuantity;
    }

    public void calculateTotalQuantity() {
        this.totalQuantity = 0.0;
        if (this.items == null) {
            return;
        }
        for (ReportItem item : this.items) {
            this.totalQuantity += item.getQuantity();
        }
    }

    public String getDiscountTotalAsString() {
        return String.valueOf(this.discountTotal);
    }

    public void setDiscountTotal(int discountTotal) {
        this.discountTotal = discountTotal;
    }

    public void calculateDiscountTotal() {
        this.discountTotal = 0.0;
        if (this.items == null) {
            return;
        }
        for (ReportItem item : this.items) {
            this.discountTotal += item.getDiscount();
        }
    }
}

