/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.SalesSummaryDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesStatistics;
import com.floreantpos.report.ShiftwiseSalesSummaryReportModel;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.io.IOException;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableModel;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.view.JRViewer;
import org.jdesktop.swingx.JXDatePicker;

public class ShiftwiseSalesSummaryReportView
extends JPanel {
    public static final int REPORT_KEY_STATISTICS = 1;
    public static final int REPORT_SALES_ANALYSIS = 2;
    private JButton btnGo;
    private JComboBox cbTerminal;
    private JComboBox cbEmployeeType;
    private JXDatePicker fromDatePicker;
    private JPanel reportPanel;
    private JXDatePicker toDatePicker;
    private Date fromDate;
    private Date toDate;
    private int dateDiff;
    private UserType userType;
    private Terminal terminal;
    private int reportType;
    private MultiSelectionOverflowCombobox<OrderType> cbMultiOrderType;
    private JCheckBox chkSummarize;
    private JLabel lblOrderType;
    private JPanel orderTypePannel;
    private JButton btnHelp;
    private JFrame helpWindow;
    private JPanel employeeTypePannel;
    private JPanel terminalPannel;

    public ShiftwiseSalesSummaryReportView() {
        this.setLayout(new BorderLayout());
        this.initComponents();
        UserTypeDAO dao = new UserTypeDAO();
        List<UserType> userTypes = dao.findAll();
        Vector<Object> list = new Vector<Object>();
        list.add(POSConstants.ALL);
        list.addAll(userTypes);
        this.cbEmployeeType.setModel(new DefaultComboBoxModel(list));
        User user = POSUtil.getBackOfficeWindow().getCurrentUser();
        UserDAO.getInstance().refresh(user);
        List<OrderType> enabledOrderTypeListForUser = user.getPropOrderTypes();
        if (enabledOrderTypeListForUser.isEmpty()) {
            enabledOrderTypeListForUser = OrderTypeDAO.getInstance().findAllForReport(false);
        }
        this.cbMultiOrderType.setItems(enabledOrderTypeListForUser);
        TerminalDAO terminalDAO = new TerminalDAO();
        List<Terminal> terminals = terminalDAO.findAll();
        terminals.add(0, (Terminal)((Object)POSConstants.ALL));
        this.cbTerminal.setModel(new ListComboBoxModel(terminals));
    }

    private void renderUi() {
        boolean isKeyStatisticsReport = this.reportType == 1;
        this.orderTypePannel.setVisible(isKeyStatisticsReport);
        this.lblOrderType.setVisible(isKeyStatisticsReport);
        this.cbMultiOrderType.setVisible(isKeyStatisticsReport);
        this.chkSummarize.setVisible(isKeyStatisticsReport);
        this.btnHelp.setVisible(isKeyStatisticsReport);
        this.employeeTypePannel.setVisible(!isKeyStatisticsReport);
        this.terminalPannel.setVisible(!isKeyStatisticsReport);
    }

    private void initComponents() {
        this.fromDatePicker = UiUtil.getCurrentMonthStart();
        this.toDatePicker = UiUtil.getCurrentMonthEnd();
        this.cbEmployeeType = new JComboBox();
        this.cbTerminal = new JComboBox();
        this.btnGo = new JButton();
        this.btnHelp = new JButton();
        this.lblOrderType = new JLabel(Messages.getString("ReportViewer.1"));
        this.cbMultiOrderType = new MultiSelectionOverflowCombobox();
        this.cbMultiOrderType.setPreferredSize(PosUIManager.getSize(130, 20));
        this.chkSummarize = new JCheckBox(Messages.getString("ShiftwiseSalesSummaryReportView.0"));
        this.btnGo.setText(POSConstants.GO);
        this.btnGo.addActionListener(evt -> this.showReport());
        this.btnHelp.setText(Messages.getString("HELP"));
        this.btnHelp.addActionListener(evt -> this.doOpenHelpWindow());
        TransparentPanel topPanel = new TransparentPanel();
        topPanel.setLayout(new WrapLayout(3, 5, 0));
        topPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel fromDatePannel = new JPanel();
        fromDatePannel.add(new JLabel(POSConstants.FROM + ":"));
        this.fromDatePicker.setFormats(new String[]{"dd MMM yy"});
        fromDatePannel.add((Component)this.fromDatePicker);
        topPanel.add(fromDatePannel);
        JPanel toDatePannel = new JPanel();
        toDatePannel.add(new JLabel(POSConstants.TO + ":"));
        this.toDatePicker.setFormats(new String[]{"dd MMM yy"});
        toDatePannel.add((Component)this.toDatePicker);
        topPanel.add(toDatePannel);
        this.employeeTypePannel = new JPanel();
        this.employeeTypePannel.add(new JLabel(POSConstants.EMPLOYEE_TYPE + ":"));
        this.employeeTypePannel.add(this.cbEmployeeType);
        topPanel.add(this.employeeTypePannel);
        this.terminalPannel = new JPanel();
        this.terminalPannel.add(new JLabel(POSConstants.TERMINAL_LABEL + ":"));
        this.terminalPannel.add(this.cbTerminal);
        topPanel.add(this.terminalPannel);
        this.orderTypePannel = new JPanel();
        this.orderTypePannel.add(this.lblOrderType);
        this.orderTypePannel.add(this.cbMultiOrderType);
        topPanel.add(this.orderTypePannel);
        topPanel.add(this.chkSummarize);
        topPanel.add((Component)this.btnGo, "width 60!");
        topPanel.add((Component)this.btnHelp, "width 90!");
        this.add((Component)topPanel, "North");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBorder(new EmptyBorder(0, 10, 10, 10));
        centerPanel.add((Component)new JSeparator(), "North");
        this.reportPanel = new JPanel(new BorderLayout());
        centerPanel.add(this.reportPanel);
        this.add(centerPanel);
    }

    private void doOpenHelpWindow() {
        if (this.helpWindow != null) {
            this.helpWindow.setVisible(true);
            return;
        }
        this.helpWindow = new JFrame(Messages.getString("HELP"));
        this.helpWindow.setDefaultCloseOperation(2);
        ShiftwiseSalesSummaryReportView.createUI(this.helpWindow);
        this.helpWindow.setSize(PosUIManager.getSize(620, 550));
        this.helpWindow.setLocationRelativeTo(null);
        this.helpWindow.setVisible(true);
        this.helpWindow.setResizable(false);
    }

    private static void createUI(JFrame frame) {
        frame.setIconImage(Application.getApplicationIcon().getImage());
        JPanel panel = new JPanel();
        FlowLayout layout = new FlowLayout();
        panel.setLayout(layout);
        JEditorPane jEditorPane = new JEditorPane();
        jEditorPane.setEditable(false);
        URL url = ShiftwiseSalesSummaryReportView.class.getResource("/help/sales_summary_key_statistics.html");
        try {
            jEditorPane.setPage(url);
        }
        catch (IOException e) {
            jEditorPane.setContentType("text/html");
            jEditorPane.setText("<html>" + Messages.getString("PAGE_NOT_FOUND") + "</html>");
        }
        JScrollPane jScrollPane = new JScrollPane(jEditorPane);
        jScrollPane.setPreferredSize(PosUIManager.getSize(600, 500));
        panel.add(jScrollPane);
        frame.add((Component)panel, "Center");
    }

    private boolean initCriteria() {
        this.fromDate = this.fromDatePicker.getDate();
        this.toDate = this.toDatePicker.getDate();
        if (this.fromDate.after(this.toDate)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return false;
        }
        this.dateDiff = (int)((double)(this.toDate.getTime() - this.fromDate.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1;
        this.userType = null;
        if (this.cbEmployeeType.getSelectedItem() instanceof UserType) {
            this.userType = (UserType)this.cbEmployeeType.getSelectedItem();
        }
        this.terminal = null;
        if (this.cbTerminal.getSelectedItem() instanceof Terminal) {
            this.terminal = (Terminal)this.cbTerminal.getSelectedItem();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.fromDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        this.fromDate = calendar.getTime();
        calendar.clear();
        calendar2.setTime(this.toDate);
        calendar.set(1, calendar2.get(1));
        calendar.set(2, calendar2.get(2));
        calendar.set(5, calendar2.get(5));
        calendar.set(10, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        this.toDate = calendar.getTime();
        return true;
    }

    private void showReport() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (!this.initCriteria()) {
                return;
            }
            if (this.reportType == 1) {
                this.showKeyStatisticsReport();
            } else if (this.reportType == 2) {
                this.showShiftwiseSalesReport();
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void showShiftwiseSalesReport() throws Exception {
        SalesSummaryDAO dao = new SalesSummaryDAO();
        List<ShiftwiseSalesSummaryReportModel.ShiftwiseSalesSummaryData> datas = dao.findSalesAnalysis(this.fromDate, this.toDate, this.userType, this.terminal);
        String userName = this.userType == null ? POSConstants.ALL : this.userType.getName();
        HashMap<String, String> properties = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(properties, true);
        ReportUtil.populateReportHeader(properties, this.terminal, this.fromDate, this.toDate, userName);
        ReportUtil.populateReportFooter(properties);
        properties.put("subtitle", POSConstants.SALES_SUMMARY_REPORT);
        properties.put("colCategory", POSConstants.CATEGORY);
        properties.put("colCount", POSConstants.COUNT);
        properties.put("colGross", Messages.getString("GROSS"));
        properties.put("colDiscount", POSConstants.DISCOUNT);
        properties.put("colTaxAmnt", Messages.getString("TAX_AMOUNT"));
        properties.put("colNSales", POSConstants.NET_SALES);
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("shiftwise_sales_summary_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)new ShiftwiseSalesSummaryReportModel(datas)));
        this.openReport(print);
    }

    private void showKeyStatisticsReport() throws Exception {
        SalesSummaryDAO dao = new SalesSummaryDAO();
        User user = POSUtil.getBackOfficeWindow().getCurrentUser();
        List<OrderType> selectedItems = this.cbMultiOrderType.getSelectedItems() == null ? user.getPropOrderTypes() : this.cbMultiOrderType.getSelectedItems();
        boolean summarize = this.chkSummarize.isSelected();
        SalesStatistics summary = dao.findKeyStatistics(this.fromDate, this.toDate, null, null, selectedItems, summarize);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ReportUtil.populateRestaurantProperties(properties, true);
        ReportUtil.populateReportHeader(properties, null, this.fromDate, this.toDate, null);
        ReportUtil.populateReportFooter(properties);
        this.populateReportParams(properties);
        properties.put("shift", ReportUtil.reportLabelWithBoldTag(POSConstants.SHIFT_WITH_CLONE) + " " + POSConstants.ALL);
        properties.put("days", ReportUtil.reportLabelWithBoldTag(POSConstants.DAYS) + " " + String.valueOf(this.dateDiff));
        properties.put("subtitle", POSConstants.SALES_SUMMARY_KEY_STATISTICS);
        properties.put("Capacity", String.valueOf(summary.getCapacity()));
        properties.put("GuestCount", String.valueOf(summary.getGuestCount()));
        properties.put("GuestPerSeat", NumberUtil.formatNumber(summary.getGuestPerSeat()));
        properties.put("Capacity", String.valueOf(summary.getCapacity()));
        properties.put("GuestCount", String.valueOf(summary.getGuestCount()));
        properties.put("GuestPerChecks", NumberUtil.formatNumber(summary.getGuestPerCheck()));
        properties.put("TableTrnOvr", NumberUtil.formatNumber(summary.getTableTurnOver()));
        properties.put("AVGGuest", NumberUtil.formatNumber(summary.getAvgGuest()));
        properties.put("OpenChecks", String.valueOf(summary.getOpenChecks()));
        properties.put("VOIDChecks", String.valueOf(summary.getVoidChecks()));
        properties.put("Tables", String.valueOf(summary.getTableCount()));
        properties.put("CheckCount", String.valueOf(summary.getCheckCount()));
        properties.put("GuestPerChecks", NumberUtil.formatNumber(summary.getGuestPerCheck()));
        properties.put("AVGChecks", NumberUtil.formatNumber(summary.getAvgCheck()));
        properties.put("OPENAmount", NumberUtil.formatNumber(summary.getOpenAmount()));
        properties.put("VOIDAmount", NumberUtil.formatNumber(summary.getVoidAmount()));
        properties.put("PAIDChecks", NumberUtil.formatNumber(summary.getClosedChecks()));
        properties.put("DiscountAmount", NumberUtil.formatNumber(summary.getDiscount()));
        properties.put("NetSale", NumberUtil.formatNumber(summary.getNetSales()));
        properties.put("LaborHour", NumberUtil.formatNumber(summary.getLaborHour()));
        properties.put("TotlGrossSales", summary.getGrossSales());
        properties.put("Labor", NumberUtil.formatNumber(summary.getLaborCount()));
        properties.put("LaborCost", NumberUtil.formatNumber(summary.getLaborCost()));
        properties.put("summarize", summarize);
        JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("key_statistics_report"));
        JasperPrint print = JasperFillManager.fillReport((JasperReport)report, properties, (JRDataSource)new JRTableModelDataSource((TableModel)new SalesStatistics.ShiftwiseDataTableModel(summary.getSalesTableDataList())));
        this.openReport(print);
    }

    private void populateReportParams(HashMap<String, Object> properties) {
        properties.put("lblKSRT", ReportUtil.reportLabelWithBoldTag(Messages.getString("KeyStatistics")));
        properties.put("lblCapacity", ReportUtil.reportLabelWithBoldTag(POSConstants.CAPACITY));
        properties.put("lblGuestCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestCount")));
        properties.put("lblGuestSeat", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestSeat")));
        properties.put("lblTableTrnOvr", ReportUtil.reportLabelWithBoldTag(Messages.getString("TableTrnOvr")));
        properties.put("lblAVGGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGGuest")));
        properties.put("lblOpenChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("OpenChecks")));
        properties.put("lblVoidChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("VoidChecks")));
        properties.put("lblLaborHour", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborHour")));
        properties.put("lblLaborSales", ReportUtil.reportLabelWithBoldTag(Messages.getString("GrossSales")));
        properties.put("lblTables", ReportUtil.reportLabelWithBoldTag(POSConstants.TABLES));
        properties.put("lblCheckCount", ReportUtil.reportLabelWithBoldTag(Messages.getString("CheckCount")));
        properties.put("lblGuestChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("GuestChecks")));
        properties.put("lblAVGCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGCheck")));
        properties.put("lblOpentAmnt", ReportUtil.reportLabelWithBoldTag(Messages.getString("OpenAmount")));
        properties.put("lblVoidAmntTx", ReportUtil.reportLabelWithBoldTag(Messages.getString("VoidAmntTx")));
        properties.put("lblPaidChecks", ReportUtil.reportLabelWithBoldTag(Messages.getString("CloseChecks")));
        properties.put("lblLabor", ReportUtil.reportLabelWithBoldTag(Messages.getString("Labor")));
        properties.put("lblLaborCost", ReportUtil.reportLabelWithBoldTag(Messages.getString("LaborCost")));
        properties.put("lblDayPart", ReportUtil.reportLabelWithBoldTag(Messages.getString("DayPart")));
        properties.put("lblProfitCenter", ReportUtil.reportLabelWithBoldTag(Messages.getString("ProfitCenter")));
        properties.put("lblCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("CHECK")));
        properties.put("lblGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("GUEST")));
        properties.put("lblSales", ReportUtil.reportLabelWithBoldTag(Messages.getString("ShiftwiseSalesSummaryReportView.1")));
        properties.put("lblAVGCheck", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGCheck")));
        properties.put("lblAVGGuest", ReportUtil.reportLabelWithBoldTag(Messages.getString("AVGGuest")));
        properties.put("lblNetSale", ReportUtil.reportLabelWithBoldTag(Messages.getString("ShiftwiseSalesSummaryReportView.1")));
        properties.put("lblDiscountAmount", ReportUtil.reportLabelWithBoldTag(Messages.getString("DISCOUNT")));
        properties.put("lblGroupTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GROUP_TOTAL));
        properties.put("lblGrandTotal", ReportUtil.reportLabelWithBoldTag(POSConstants.GRAND_TOTAL));
    }

    private void openReport(JasperPrint print) {
        JRViewer viewer = ReportUtil.getCustomJRViewer(print);
        this.reportPanel.removeAll();
        this.reportPanel.add((Component)viewer);
        this.reportPanel.revalidate();
    }

    public int getReportType() {
        return this.reportType;
    }

    public void setReportType(int reportType) {
        this.reportType = reportType;
        this.renderUi();
    }
}

