/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.Ticket;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.List;

public class TaxExemptReport {
    private List<TaxExemptData> taxExemptTickets = new ArrayList<TaxExemptData>();

    public void addTaxExemptTicket(Ticket ticket) {
        TaxExemptData data = new TaxExemptData();
        data.setTicketId(ticket.getId());
        data.setCustomerName(ticket.getCustomerNameByProperty());
        data.setTotalAmount(ticket.getTotalAmountWithTips());
        data.setCreateDate(ticket.getCreateDateFormatted());
        data.setTaxAmount(ticket.getTaxAmountFromProperty());
        this.taxExemptTickets.add(data);
    }

    public TaxExemptTableModel getTaxExemptTableModel() {
        TaxExemptTableModel model = new TaxExemptTableModel();
        model.setRows(this.taxExemptTickets);
        return model;
    }

    public class TaxExemptData {
        private String ticketId;
        private String customerName;
        private double totalAmount;
        private String createDate;
        private double taxAmount;

        public String getTicketId() {
            return this.ticketId;
        }

        public void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        public String getCustomerName() {
            return this.customerName;
        }

        public void setCustomerName(String customerName) {
            this.customerName = customerName;
        }

        public double getTotalAmount() {
            return this.totalAmount;
        }

        public void setTotalAmount(double totalAmount) {
            this.totalAmount = totalAmount;
        }

        public String getCreateDate() {
            return this.createDate;
        }

        public void setCreateDate(String createDate) {
            this.createDate = createDate;
        }

        public double getTaxAmount() {
            return this.taxAmount;
        }

        public void setTaxAmount(double taxAmount) {
            this.taxAmount = taxAmount;
        }
    }

    public class TaxExemptTableModel
    extends ListTableModel {
        public TaxExemptTableModel() {
            this.setColumnNames(new String[]{"ticketId", "customerName", "totalAmount", "createDate", "taxAmount"});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TaxExemptData ticket = (TaxExemptData)this.rows.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ticket.getTicketId();
                }
                case 1: {
                    return ticket.getCustomerName();
                }
                case 2: {
                    return NumberUtil.getCurrencyTwoDigitFormat(ticket.getTotalAmount());
                }
                case 3: {
                    return ticket.getCreateDate();
                }
                case 4: {
                    return NumberUtil.getCurrencyTwoDigitFormat(ticket.getTaxAmount());
                }
            }
            return null;
        }
    }
}

