/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Store;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.AbstractReportDataSource;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import org.apache.commons.lang.StringUtils;

public class TicketDataSource
extends AbstractReportDataSource {
    private Store store = DataProvider.get().getStore();
    private String modifierTextColor;
    private String seatTextColor;

    public TicketDataSource() {
        super(new String[]{"itemName", "itemQty", "itemSubtotal", "colorCode"});
    }

    public TicketDataSource(Ticket ticket) {
        this(ticket, false);
    }

    public TicketDataSource(Ticket ticket, boolean includeSeat) {
        super(new String[]{"itemName", "itemQty", "itemSubtotal", "colorCode"});
        this.setTicket(ticket, includeSeat);
    }

    private void setTicket(Ticket ticket, boolean includeSeat) {
        ArrayList<ITicketItem> rows = new ArrayList<ITicketItem>();
        boolean suppressZerocostModifiers = Boolean.parseBoolean(DataProvider.get().getStore().getProperty("suppress.zerocost.modifiers"));
        LinkedHashMap<String, ITicketItem> tableRows = new LinkedHashMap<String, ITicketItem>();
        TicketItemRowCreator.calculateTicketRows(ticket, tableRows, true, false, true, true, includeSeat, suppressZerocostModifiers);
        rows.addAll(tableRows.values());
        this.setRows(rows);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ITicketItem item = (ITicketItem)this.rows.get(rowIndex);
        if (item instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)item;
            ticketItem.setIncludeVoidQuantity(true);
        }
        switch (columnIndex) {
            case 0: {
                String nameDisplay = "<html>" + item.getNameDisplay() + "</html>";
                nameDisplay = nameDisplay.replaceAll("\n", "&#10;");
                nameDisplay = nameDisplay.replaceAll("\\s", "&nbsp;");
                return nameDisplay;
            }
            case 1: {
                return "";
            }
            case 2: {
                return item.getSubTotalAmountDisplay();
            }
            case 3: {
                return this.getColorCode(this.store, item);
            }
        }
        return null;
    }

    public String getColorCode(Store store, ITicketItem item) {
        if (item instanceof TicketItemModifier) {
            if (this.modifierTextColor != null) {
                return this.modifierTextColor;
            }
            TicketItemModifier ticketItemModifier = (TicketItemModifier)item;
            Ticket ticket = ticketItemModifier.getTicketItem().getTicket();
            String orderTypeId = this.getOrderTypeId(ticket);
            this.modifierTextColor = store.getProperty(orderTypeId + "ticket.modifier.color");
            return this.modifierTextColor;
        }
        if (item instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)item;
            if (!ticketItem.isTreatAsSeat().booleanValue()) {
                return Messages.getString("KitchenTicketDataSource.7");
            }
            if (this.seatTextColor != null) {
                return this.seatTextColor;
            }
            Ticket ticket = ticketItem.getTicket();
            String orderTypeId = this.getOrderTypeId(ticket);
            this.seatTextColor = store.getProperty(orderTypeId + "ticket.seat.color");
            return this.seatTextColor;
        }
        return Messages.getString("KitchenTicketDataSource.7");
    }

    private String getOrderTypeId(Ticket ticket) {
        String orderTypeId = "";
        if (ticket != null && ticket.getOrderType() != null && StringUtils.isNotEmpty((String)(orderTypeId = ticket.getOrderType().getId()))) {
            orderTypeId = orderTypeId + ".";
        }
        return orderTypeId;
    }
}

