/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report.service;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.User;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.SalesBalanceReport;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.util.NumberUtil;
import java.util.Date;
import java.util.HashMap;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;

public class SalesBalanceReportService {
    public static JasperPrint createSalesBalanceReport(Date fromDate, Date toDate, User user) throws JRException {
        ReportService reportService = new ReportService();
        SalesBalanceReport report = reportService.getSalesBalanceReport(fromDate, toDate, user);
        String userName = user == null ? POSConstants.ALL : user.getFullName();
        HashMap<String, String> map = new HashMap<String, String>();
        ReportUtil.populateRestaurantProperties(map, true);
        ReportUtil.populateReportHeader(map, null, fromDate, toDate, null);
        ReportUtil.populateReportFooter(map);
        SalesBalanceReportService.populateReportLabel(map);
        map.put("userName", ReportUtil.reportLabelWithBoldTag(POSConstants.USER_WITH_CLONE) + " " + userName);
        map.put("days", ReportUtil.reportLabelWithBoldTag(POSConstants.DAYS) + " " + String.valueOf((int)((double)(toDate.getTime() - fromDate.getTime()) * (1.15740741 * Math.pow(10.0, -8.0))) + 1));
        map.put("grossTaxableSales", NumberUtil.formatNumber(report.getGrossTaxableSalesAmount()));
        map.put("grossNonTaxableSales", NumberUtil.formatNumber(report.getGrossNonTaxableSalesAmount()));
        map.put("discounts", NumberUtil.formatNumber(report.getDiscountAmount()));
        map.put("netSales", NumberUtil.formatNumber(report.getNetSalesAmount()));
        map.put("salesTaxes", NumberUtil.formatNumber(report.getSalesTaxAmount()));
        map.put("totalRevenues", NumberUtil.formatNumber(report.getTotalRevenueAmount()));
        map.put("giftCertSold", NumberUtil.formatNumber(report.getGiftCertSalesAmount()));
        map.put("payIns", NumberUtil.formatNumber(report.getPayInsAmount()));
        map.put("cashTips", NumberUtil.formatNumber(report.getCashTipsAmount()));
        map.put("chargedTips", NumberUtil.formatNumber(report.getChargedTipsAmount()));
        map.put("grossReceipts", NumberUtil.formatNumber(report.getGrossReceiptsAmount()));
        map.put("cashReceipts", NumberUtil.formatNumber(report.getCashReceiptsAmount()));
        map.put("creditCardReceipts", NumberUtil.formatNumber(report.getCreditCardReceiptsAmount()));
        map.put("debitCardReceipts", NumberUtil.formatNumber(report.getDebitCardReceiptsAmount()));
        map.put("memberPaymentReceipts", NumberUtil.formatNumber(report.getMemberPaymentAmount()));
        map.put("customPayment", NumberUtil.formatNumber(report.getCustomPaymentAmount()));
        map.put("grossTipsPaid", NumberUtil.formatNumber(report.getGrossTipsPaidAmount()));
        map.put("arReceipts", NumberUtil.formatNumber(report.getArReceiptsAmount()));
        map.put("giftCertReceipts", NumberUtil.formatNumber(report.getGiftCertReceipts()));
        map.put("cashBack", NumberUtil.formatNumber(report.getCashBackAmount()));
        map.put("cashRefund", NumberUtil.formatNumber(report.getCashRefundAmount()));
        map.put("receiptDiff", NumberUtil.formatNumber(report.getReceiptDiffAmount()));
        map.put("cashPayout", NumberUtil.formatNumber(report.getCashPayoutAmount()));
        map.put("cashAccountable", NumberUtil.formatNumber(report.getCashAccountableAmount()));
        map.put("drawerPulls", NumberUtil.formatNumber(report.getDrawerPullsAmount()));
        map.put("coCurrent", NumberUtil.formatNumber(report.getCoCurrentAmount()));
        map.put("coPrevious", NumberUtil.formatNumber(report.getCoPreviousAmount()));
        map.put("coOverShort", NumberUtil.formatNumber(report.getOverShortAmount()));
        map.put("serviceCharge", NumberUtil.formatNumber(report.getServiceChargeAmnt()));
        map.put("toleranceAmount", NumberUtil.formatNumber(report.getToleranceAmount(), true));
        map.put("visaCreditCardSum", NumberUtil.formatNumber(report.getVisaCreditCardAmount()));
        map.put("mastercardSum", NumberUtil.formatNumber(report.getMasterCardAmount()));
        map.put("amexSum", NumberUtil.formatNumber(report.getAmexAmount()));
        map.put("discoverySum", NumberUtil.formatNumber(report.getDiscoveryAmount()));
        map.put("visaDebitCardSum", NumberUtil.formatNumber(report.getVisaDebitCardAmount()));
        map.put("masterDebitCardSum", NumberUtil.formatNumber(report.getMasterDebitCardAmount()));
        JasperReport jasperReport = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("sales_balance_report"));
        JasperPrint jasperPrint = JasperFillManager.fillReport((JasperReport)jasperReport, map, (JRDataSource)new JREmptyDataSource());
        return jasperPrint;
    }

    private static void populateReportLabel(HashMap map) {
        map.put("lblRHeader", POSConstants.SALES_BALANCE_REPORT);
        map.put("lblReciptS", Messages.getString("RECEIPTS_SUMMARY"));
        map.put("lblNetSales", POSConstants.NET_SALES);
        map.put("lblDiscount", "-" + POSConstants.DISCOUNT);
        map.put("lblSalesT", "+" + Messages.getString("SALES_TAXES"));
        map.put("lblServiceC", "+" + POSConstants.RECEIPT_REPORT_SERVICE_CHARGE_LABEL);
        map.put("lblTotalRev", "=" + Messages.getString("TOTAL_REVENUES"));
        map.put("lblCashTips", "+" + Messages.getString("TipsCashoutReportTableModel.9"));
        map.put("lblChargedTips", "+" + Messages.getString("chargedTips"));
        map.put("lblGrossReceipts", "=" + Messages.getString("grossReceipts"));
        map.put("lblCReceipts", "-" + Messages.getString("cashReceipts"));
        map.put("lblCCReceipts", "-" + Messages.getString("CreditCardReceipts"));
        map.put("lblDCReceipts", "-" + Messages.getString("DebitCartReceipts"));
        map.put("lblMPReceipts", "-" + Messages.getString("MemberPaymentReceipts"));
        map.put("lblCPReceipts", "-" + Messages.getString("CustomPaymentReceipts"));
        map.put("lblGCertReceipts", "-" + Messages.getString("GiftCertReceipts"));
        map.put("lblRefundPlus", "+" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("lblTolerance", "+" + Messages.getString("CurrencyExplorer.8"));
        map.put("lblReceiptDiff", "=" + Messages.getString("ReceiptDiff"));
        map.put("lblCCS", Messages.getString("CreditCardSummary"));
        map.put("lblTR", Messages.getString("TotalReceipts"));
        map.put("lblVCS", Messages.getString("VisaCardSummary"));
        map.put("lblTT", Messages.getString("TotalTips"));
        map.put("lblMCS", Messages.getString("MasterCardSummary"));
        map.put("lblAmexS", Messages.getString("AmexSummary"));
        map.put("lblDiscoveryS", Messages.getString("DiscoverySummary"));
        map.put("lblCashS", Messages.getString("CashSummary"));
        map.put("lblCashRecipts", Messages.getString("cashReceipts"));
        map.put("lblGTP", "-" + Messages.getString("GrossTipsPaid"));
        map.put("lblCPO", "-" + Messages.getString("CashPayOut"));
        map.put("lblGCChange", "-" + Messages.getString("giftCertChange"));
        map.put("lblRefundMinus", "-" + POSConstants.REFUND_BUTTON_TEXT);
        map.put("lblCashAcc", "=" + Messages.getString("CashAccountable"));
        map.put("lblDrawerPulls", "-" + Messages.getString("DrawerPulls"));
        map.put("lblCOC", "-" + Messages.getString("COCurrent"));
        map.put("lblCOP", "+" + Messages.getString("COPrevious"));
        map.put("lblOS", "=" + Messages.getString("OverShort"));
        map.put("lblDCS", Messages.getString("DebitCardSummaryHeading"));
        map.put("lblDEBITVCS", Messages.getString("VisaCardSummary"));
        map.put("lblDEBITMCS", Messages.getString("MasterCardSummary"));
    }
}

