/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashBreakdown;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.base.BasePosTransaction;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GenericDAO;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.MultiCurrencyTenderDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class PosTransactionService {
    private static PosTransactionService paymentService = new PosTransactionService();

    public void settleTicket(Ticket ticket, PosTransaction transaction, User currentUser) throws Exception {
        this.settleTicket(ticket, transaction, currentUser, null, null);
    }

    public void settleTicket(Ticket ticket, PosTransaction transaction, User currentUser, PostPaymentProcessor postPaymentService, List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencyList) throws Exception {
        if (currentUser == null) {
            currentUser = Application.getCurrentUser();
        }
        Terminal terminal = DataProvider.get().getCurrentTerminal();
        Transaction tx = null;
        boolean newOrder = ticket.getId() == null;
        try (Session session = TerminalDAO.getInstance().createNewSession();){
            Date currentDate = StoreDAO.getServerTimestamp();
            tx = session.beginTransaction();
            CashDrawer cashDrawer = currentUser.getActiveDrawerPullReport();
            if (cashDrawer != null && paymentByCurrencyList != null) {
                this.adjustMulticurrencyBalance(session, terminal, cashDrawer.getId(), paymentByCurrencyList);
            }
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + transaction.getAmount());
            if (ticket.isSourceOnline()) {
                ticket.setDueAmount(ticket.getTotalAmountWithTips() - ticket.getPaidAmount());
            } else {
                ticket.calculatePrice(true, true);
            }
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, currentDate);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(terminal);
            transaction.setUser(currentUser);
            transaction.setServer(ticket.getOwner());
            transaction.setCashDrawer(cashDrawer);
            transaction.setTransactionTime(currentDate);
            transaction.setCustomerId(ticket.getCustomerId());
            StoreSession storeSession = DataProvider.get().getStoreSession();
            if (storeSession != null) {
                transaction.setStoreSessionId(storeSession.getId());
            }
            ticket.setCashier(currentUser);
            if (transaction.getAmount() > 0.0) {
                ticket.addTotransactions(transaction);
            }
            this.updateCustomerLoyaltyPoint(ticket, transaction, session);
            this.calculateToleranceAmount(ticket, transaction);
            this.adjustGratuityIfNeeded(ticket, transaction);
            transaction.calculateTaxAmount();
            transaction.calculateServiceChargeAmount();
            if (ticket.getOrderType() != null && ticket.getOrderType().getName() == "BAR_TAB") {
                ticket.removeProperty("payment_method");
                ticket.removeProperty("card_name");
                ticket.removeProperty("card_transaction_id");
                ticket.removeProperty("card_tracks");
                ticket.removeProperty("card_reader");
                ticket.removeProperty("advance_payment");
                ticket.removeProperty("card_number");
                ticket.removeProperty("card_exp_year");
                ticket.removeProperty("card_exp_month");
                ticket.removeProperty("card_auth_code");
            }
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            this.adjustGiftCardBalance(ticket, transaction, session);
            if (postPaymentService != null) {
                postPaymentService.paymentDone(transaction, session);
            }
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception x) {
                PosLog.error(PosTransactionService.class, x);
            }
            throw e;
        }
        ActionHistoryDAO.getInstance().performActionHistorySaveOperation(ticket, newOrder);
        this.saveJournal(ticket, transaction);
    }

    private void adjustMulticurrencyBalance(Session session, Terminal terminal, String cashDrawerId, List<MultiCurrencyTenderDialog.PaymentByCurrency> paymentByCurrencyList) {
        boolean isMulticurrencyTrans;
        boolean bl = isMulticurrencyTrans = terminal.isEnableMultiCurrency() != false && paymentByCurrencyList != null && !paymentByCurrencyList.isEmpty();
        if (isMulticurrencyTrans) {
            CashDrawer cashDrawer = CashDrawerDAO.getInstance().get(cashDrawerId, session);
            paymentByCurrencyList.forEach(payByCurrency -> {
                Currency currency = payByCurrency.currency;
                CashBreakdown item = cashDrawer.getCurrencyBalance(currency);
                double balance = payByCurrency.tenderedAmount - payByCurrency.cashBackAmount;
                if (item == null) {
                    item = new CashBreakdown();
                    item.setCurrency(currency);
                    item.setBalance(balance);
                    cashDrawer.addTocashBreakdownList(item);
                } else {
                    item.setBalance(item.getBalance() + balance);
                }
            });
            session.saveOrUpdate((Object)cashDrawer);
        }
    }

    private void saveJournal(Ticket ticket, PosTransaction transaction) {
        StringBuilder sb = new StringBuilder();
        sb.append("Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
        sb.append(". Transaction amount: " + NumberUtil.formatNumber(transaction.getAmount()));
        ActionHistoryDAO.saveHistory(Application.getCurrentUser(), ticket, transaction, "Settle check", sb.toString());
    }

    private void updateCustomerLoyaltyPoint(Ticket ticket, PosTransaction transaction, Session session) {
        Store store = DataProvider.get().getStore();
        Boolean loyaltyEnabled = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        if (!loyaltyEnabled.booleanValue()) {
            return;
        }
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            return;
        }
        customer = CustomerDAO.getInstance().get(customer.getId(), session);
        this.chargeCustomerLoyaltyPoint(ticket, customer, transaction);
        this.adjustCustomerLoyaltyPoint(ticket, transaction, store, customer, session);
        ticket.updateCustomer(customer);
    }

    private void chargeCustomerLoyaltyPoint(Ticket ticket, Customer customer, PosTransaction transaction) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (ticket.getDiscounts() == null) {
            return;
        }
        ArrayList applicableDiscounts = new ArrayList();
        ticket.getDiscounts().forEach(discount -> {
            if (!discount.isLoyaltyCharged()) {
                applicableDiscounts.add(discount);
            }
        });
        if (applicableDiscounts.isEmpty()) {
            return;
        }
        if (customer == null) {
            throw new PosException(Messages.getString("PosTransactionService.3"));
        }
        int loyaltyChargedAmt = 0;
        for (TicketDiscount discount2 : applicableDiscounts) {
            int discountLoyalty = discount2.getLoyaltyPoint();
            int customerLogalty = customer.getLoyaltyPoint();
            customer.setLoyaltyPoint(customerLogalty - discountLoyalty);
            discount2.setLoyaltyCharged(Boolean.TRUE);
            loyaltyChargedAmt += discountLoyalty;
        }
        transaction.addExtraProperty("loyalty.charged_amount", String.valueOf(loyaltyChargedAmt));
        ticket.buildDiscounts();
    }

    private void adjustCustomerLoyaltyPoint(Ticket ticket, PosTransaction transaction, Store store, Customer customer, Session session) {
        if (ticket == null) {
            throw new PosException(Messages.getString("PosTransactionService.0"));
        }
        if (transaction == null) {
            throw new PosException(Messages.getString("PosTransactionService.5"));
        }
        if (store == null) {
            throw new PosException(Messages.getString("PosTransactionService.6"));
        }
        if (customer == null) {
            return;
        }
        Integer loyaltyPoint = customer.getLoyaltyPoint();
        int ticketLoyaltyPoint = 0;
        try {
            String ticketLoyaltyProperty = ticket.getProperty("loyalty");
            Boolean addedTicketLoyalty = ticketLoyaltyProperty != null && Boolean.valueOf(ticketLoyaltyProperty) != false;
            if (!addedTicketLoyalty.booleanValue()) {
                int pointForVisit = Integer.parseInt(store.getProperty("loyalty.pointForVisit"));
                if (pointForVisit > 0) {
                    ticketLoyaltyPoint = pointForVisit;
                }
                ticket.addProperty("loyalty", String.valueOf(Boolean.TRUE));
            }
        }
        catch (Exception ticketLoyaltyProperty) {
            // empty catch block
        }
        loyaltyPoint = loyaltyPoint + ticketLoyaltyPoint;
        int purchaseLoyaltyPoint = 0;
        try {
            int loyaltyAmount = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (loyaltyAmount > 0) {
                purchaseLoyaltyPoint = (int)(transaction.getAmount() / (double)loyaltyAmount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        loyaltyPoint = loyaltyPoint + purchaseLoyaltyPoint;
        transaction.addExtraProperty("transaction.loyalty_point_earned", String.valueOf(purchaseLoyaltyPoint));
        customer.setLoyaltyPoint(loyaltyPoint);
        CustomerDAO.getInstance().update(customer, session);
    }

    private void deductCustomerLoyaltyPoint(Customer customer, double refundedAmount) {
        if (customer == null || refundedAmount <= 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        Boolean loyaltyEnabled = Boolean.valueOf(store.getProperty("loyalty.enabled"));
        Boolean loyaltyDeduct = Boolean.valueOf(store.getProperty("loyalty.deductPointOnRefund"));
        if (!loyaltyEnabled.booleanValue() || !loyaltyDeduct.booleanValue()) {
            return;
        }
        Integer loyaltyPoint = customer.getLoyaltyPoint();
        Integer loyaltyPointToDeduct = 0;
        try {
            int loyaltyAmount = Integer.parseInt(store.getProperty("loyalty.pointForPuchases"));
            if (loyaltyAmount > 0) {
                loyaltyPointToDeduct = (int)Math.ceil(refundedAmount / (double)loyaltyAmount);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        loyaltyPoint = loyaltyPoint - loyaltyPointToDeduct;
        customer.setLoyaltyPoint(loyaltyPoint > 0 ? loyaltyPoint : 0);
        CustomerDAO.getInstance().update(customer);
    }

    private void calculateToleranceAmount(Ticket ticket, PosTransaction transaction) {
        double changeAmount;
        double toleranceAmountFactor = 0.0;
        Currency mainCurrency = CurrencyUtil.getMainCurrency();
        if (mainCurrency != null) {
            toleranceAmountFactor = mainCurrency.getTolerance();
        }
        if (ticket.getRoundedDueAmount() == 0.0 || ticket.getRoundedDueAmount() <= toleranceAmountFactor) {
            transaction.setToleranceAmount(ticket.getToleranceAmount());
        }
        if ((changeAmount = NumberUtil.round(transaction.getTenderAmount() - transaction.getAmount())) == 0.0) {
            return;
        }
        Store store = DataProvider.get().getStore();
        double roundedChangeAmount = store.isAllowPenyRounding() ? (double)Math.round(changeAmount * 100.0 / 5.0) * 5.0 / 100.0 : changeAmount;
        double toleranceAmount = changeAmount - roundedChangeAmount;
        if (Math.abs(roundedChangeAmount) <= toleranceAmountFactor) {
            transaction.setToleranceAmount(changeAmount);
            transaction.setChangeAmount(0.0);
        } else {
            transaction.setToleranceAmount(toleranceAmount);
            transaction.setChangeAmount(roundedChangeAmount);
        }
        transaction.setAmount(transaction.getAmount() + transaction.getToleranceAmount());
    }

    public void settleBarTabTicket(Ticket ticket, PosTransaction transaction, boolean closed, User currentUser) throws Exception {
        Application application = Application.getInstance();
        Terminal terminal = application.refreshAndGetTerminal();
        Transaction tx = null;
        GenericDAO dao = new GenericDAO();
        try (Session session = dao.createNewSession();){
            Date currentDate = StoreDAO.getServerTimestamp();
            tx = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.setPaidAmount(ticket.getPaidAmount() + transaction.getAmount());
            ticket.calculatePrice();
            if (closed) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, currentDate);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(terminal);
            transaction.setUser(currentUser);
            transaction.setServer(ticket.getOwner());
            transaction.setCashDrawer(currentUser.getActiveDrawerPullReport());
            transaction.setTransactionTime(currentDate);
            ticket.setCashier(currentUser);
            ticket.addTotransactions(transaction);
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.saveJournal(ticket, transaction);
    }

    public static void closeTicketIfApplicable(Ticket ticket, Date currentDate) {
        OrderType ticketType = ticket.getOrderType();
        if (ticketType != null && (ticketType.isCloseOnPaid().booleanValue() || ticketType.isBarTab().booleanValue())) {
            ticket.setClosed(true);
            ticket.setClosingDate(currentDate);
        }
    }

    private void adjustGratuityIfNeeded(Ticket ticket, PosTransaction transaction) {
        double gratuityAmount = ticket.getGratuityAmount();
        if (gratuityAmount <= 0.0) {
            return;
        }
        double gratuityPaidAmount = 0.0;
        Set<PosTransaction> transactions = ticket.getTransactions();
        if (transactions != null && transactions.size() > 0) {
            for (PosTransaction posTransaction : transactions) {
                if (posTransaction instanceof RefundTransaction || posTransaction.isVoided().booleanValue()) continue;
                gratuityPaidAmount += posTransaction.getTipsAmount().doubleValue();
            }
        }
        double gratuityDueAmount = gratuityAmount - gratuityPaidAmount;
        double payableTipsAmount = gratuityDueAmount + ticket.getPaidAmount() - ticket.getTotalAmountWithTips();
        if (gratuityDueAmount > 0.0) {
            if (ticket.getDueAmount() == 0.0) {
                transaction.setTipsAmount(gratuityDueAmount);
            } else if (payableTipsAmount > 0.0) {
                Double transactionAmount = transaction.getAmount();
                if (payableTipsAmount > transactionAmount) {
                    transaction.setTipsAmount(transactionAmount);
                } else {
                    transaction.setTipsAmount(NumberUtil.roundToTwoDigit(payableTipsAmount));
                }
            }
        }
    }

    public void voidTicket(Ticket ticket, User currentUser) throws Exception {
        Terminal terminal = Application.getInstance().getTerminal();
        ticket.setVoidedBy(currentUser);
        ticket.setTerminal(terminal);
        ticket.calculatePrice();
        TicketDAO.getInstance().voidTicket(ticket);
        try {
            ReceiptPrintService.printVoidTicket(ticket);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private double getRefundableAmount(PosTransaction posTransaction) {
        double refundedAmountForTransaction = 0.0;
        String refundedAmountText = posTransaction.getProperty("REFUNDED_AMOUNT");
        if (StringUtils.isNotEmpty((String)refundedAmountText)) {
            try {
                refundedAmountForTransaction = Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NumberUtil.roundToTwoDigit(posTransaction.getAmount() - refundedAmountForTransaction);
    }

    public double refundTicketByGiftCard(Ticket ticket, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, String giftCardNo) throws Exception {
        boolean refundToCustomerBalance = false;
        RefundTransaction refundTransaction = this.createRefundTransaction(ticket, null, refundTenderedAmount, true);
        refundTransaction.setUser(currentUser);
        refundTransaction.setPaymentType(PaymentType.GIFT_CERTIFICATE);
        this.updateTicket(ticket, currentUser, refundTransaction);
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            GiftCard giftCard;
            transaction = session.beginTransaction();
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (refundToCustomerBalance) {
                CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
            }
            if (StringUtils.isNotEmpty((String)giftCardNo) && (giftCard = GiftCardDAO.getInstance().get(giftCardNo, session)) != null) {
                giftCard.setBalance(giftCard.getBalance() + refundTransaction.getAmount());
                GiftCardDAO.getInstance().update(giftCard, session);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        return refundTenderedAmount;
    }

    public double refundTicketByCash(Ticket ticket, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser) throws Exception {
        boolean refundToCustomerBalance = false;
        RefundTransaction refundTransaction = this.createRefundTransaction(ticket, null, refundTenderedAmount, true);
        refundTransaction.setUser(currentUser);
        refundTransaction.setPaymentType(PaymentType.CASH);
        this.updateTicket(ticket, currentUser, refundTransaction);
        Transaction transaction = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            transaction = session.beginTransaction();
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            if (refundToCustomerBalance) {
                CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
            }
            transaction.commit();
        }
        catch (Exception e) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw e;
        }
        return refundTenderedAmount;
    }

    private void updateTicket(Ticket ticket, User currentUser, RefundTransaction refundTransaction) {
        ticket.addTotransactions(refundTransaction);
        ticket.setRefunded(true);
        ticket.setCashier(currentUser);
        ticket.calculateRefundAmount();
        ticket.calculatePrice(true);
        if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
            ticket.setClosed(true);
        }
    }

    public double refundTicket(Ticket ticket, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, List<PosTransaction> transactions, boolean forceCashRefund) throws Exception {
        return this.refundTicket(ticket, refundTenderedAmount, refundItemTaxAmount, currentUser, transactions, forceCashRefund, null);
    }

    public double refundTicket(Ticket ticket, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, List<PosTransaction> transactions, boolean forceCashRefund, String giftCardNo) throws Exception {
        double refundedAmount;
        double refundTenderedRemaining = refundTenderedAmount;
        boolean refundToCustomerBalance = false;
        if (transactions == null || transactions.isEmpty()) {
            RefundTransaction refundTransaction = this.createRefundTransaction(ticket, null, refundTenderedAmount, true);
            refundTransaction.setUser(currentUser);
            if (StringUtils.isEmpty((String)giftCardNo)) {
                refundTransaction.setPaymentType(PaymentType.CASH);
            } else {
                refundTransaction.setPaymentType(PaymentType.GIFT_CERTIFICATE);
            }
            ticket.addTotransactions(refundTransaction);
            ticket.setRefunded(true);
            ticket.setCashier(currentUser);
            ticket.calculateRefundAmount();
            ticket.calculatePrice(true);
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setClosed(true);
            }
            Transaction transaction = null;
            try (Session session = TicketDAO.getInstance().createNewSession();){
                GiftCard giftCard;
                transaction = session.beginTransaction();
                ticket.setShouldUpdateStock(true);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (refundToCustomerBalance) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                if (StringUtils.isNotEmpty((String)giftCardNo) && (giftCard = GiftCardDAO.getInstance().get(giftCardNo, session)) != null) {
                    giftCard.setBalance(giftCard.getBalance() + refundTransaction.getAmount());
                    GiftCardDAO.getInstance().update(giftCard, session);
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
            return refundTenderedAmount;
        }
        if (transactions.size() > 1) {
            for (PosTransaction posTransaction : transactions) {
                if (this.getRefundableAmount(posTransaction) != refundTenderedAmount) continue;
                transactions = new ArrayList<PosTransaction>();
                transactions.add(posTransaction);
                break;
            }
        }
        for (PosTransaction posTransaction : transactions) {
            double refundAmount = this.getRefundableAmount(posTransaction);
            if (refundAmount > refundTenderedRemaining) {
                refundAmount = refundTenderedRemaining;
            }
            if (!(refundAmount <= refundTenderedRemaining)) continue;
            double refundTaxAmount = refundItemTaxAmount * refundAmount / refundTenderedAmount;
            this.refundTicket(ticket, refundAmount, refundTaxAmount, currentUser, posTransaction, forceCashRefund, giftCardNo);
            if (!posTransaction.isRefunded()) continue;
            refundTenderedRemaining -= refundAmount;
            if (!(posTransaction instanceof CustomerAccountTransaction)) continue;
            refundToCustomerBalance = true;
        }
        if (refundTenderedAmount != refundTenderedRemaining) {
            ticket.setRefunded(true);
            ticket.setCashier(currentUser);
            ticket.calculateRefundAmount();
            ticket.calculatePrice();
            if (NumberUtil.roundToTwoDigit(ticket.getDueAmount()) == 0.0) {
                ticket.setClosed(true);
                ticket.setClosingDate(StoreDAO.getServerTimestamp());
            }
            this.mergeCashRefundTransactions(ticket);
            Transaction transaction = null;
            try (Session session = TicketDAO.getInstance().createNewSession();){
                transaction = session.beginTransaction();
                ticket.setShouldUpdateStock(true);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
                if (refundToCustomerBalance) {
                    CustomerDAO.getInstance().saveOrUpdate(ticket.getCustomer(), session);
                }
                transaction.commit();
            }
            catch (Exception e) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw e;
            }
        }
        if ((refundedAmount = refundTenderedAmount - refundTenderedRemaining) > 0.0) {
            this.deductCustomerLoyaltyPoint(ticket.getCustomer(), refundedAmount);
        }
        return refundedAmount;
    }

    private void mergeCashRefundTransactions(Ticket ticket) {
        BasePosTransaction refundTransaction = null;
        Iterator<PosTransaction> iterator = ticket.getTransactions().iterator();
        while (iterator.hasNext()) {
            PosTransaction posTransaction = iterator.next();
            if (!(posTransaction instanceof RefundTransaction) || posTransaction.getId() != null || posTransaction.getPaymentType() != PaymentType.CASH) continue;
            if (refundTransaction != null) {
                refundTransaction.setAmount(refundTransaction.getAmount() + posTransaction.getAmount());
                refundTransaction.setTipsAmount(refundTransaction.getTipsAmount() + posTransaction.getTipsAmount());
                refundTransaction.setTaxAmount(refundTransaction.getTaxAmount() + posTransaction.getTaxAmount());
                iterator.remove();
                continue;
            }
            if (posTransaction.getId() != null) continue;
            refundTransaction = (RefundTransaction)posTransaction;
        }
    }

    public void refundTicket(Ticket ticket, double refundAmount, double refundTaxAmount, User currentUser, PosTransaction transaction, boolean forceCashRefund) throws Exception {
        this.refundTicket(ticket, refundAmount, refundTaxAmount, currentUser, transaction, forceCashRefund, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refundTicket(Ticket ticket, double refundAmount, double refundTaxAmount, User currentUser, PosTransaction transaction, boolean forceCashRefund, String giftCardNo) throws Exception {
        if (refundAmount <= 0.0) {
            return;
        }
        boolean refundedUsingCard = false;
        boolean voidedUsingCard = false;
        if (StringUtils.isNotEmpty((String)giftCardNo)) {
            GiftCardPaymentPlugin paymentGateway = GiftCardConfig.getPaymentGateway();
            GiftCardProcessor giftCardProcessor = paymentGateway.getProcessor();
            giftCardProcessor.refund(giftCardNo, refundAmount);
        } else if (!forceCashRefund) {
            if (transaction != null) {
                if (transaction instanceof CustomerAccountTransaction) {
                    Customer customer = ticket.getCustomer();
                    if (customer == null) {
                        throw new PosException(Messages.getString("PosTransactionService.1"));
                    }
                    customer.setBalance(customer.getBalance() + refundAmount);
                    transaction.setRefunded(true);
                } else if (transaction instanceof CreditCardTransaction) {
                    double transactionAmount = transaction.getAmount();
                    CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
                    try {
                        transaction.setAmount(refundAmount);
                        cardProcessor.refundTransaction(transaction, refundAmount);
                        refundedUsingCard = transaction.isRefunded();
                    }
                    finally {
                        transaction.setAmount(transactionAmount);
                    }
                }
            }
            if (transaction instanceof CreditCardTransaction && !refundedUsingCard && !voidedUsingCard) {
                throw new PosException(Messages.getString("PosTransactionService.2"));
            }
        }
        PaymentType paymentType = null;
        paymentType = StringUtils.isNotEmpty((String)giftCardNo) ? PaymentType.GIFT_CERTIFICATE : (forceCashRefund ? PaymentType.CASH : transaction.getPaymentType());
        RefundTransaction posTransaction = this.createRefundTransaction(ticket, transaction, refundAmount, true);
        posTransaction.setPaymentType(paymentType);
        posTransaction.setUser(currentUser);
        posTransaction.setServer(ticket.getOwner());
        posTransaction.setTaxAmount(refundTaxAmount);
        if (transaction instanceof CustomerAccountTransaction) {
            posTransaction.setCustomerId(ticket.getCustomerId());
        }
        if (StringUtils.isNotEmpty((String)giftCardNo)) {
            posTransaction.setGiftCertNumber(giftCardNo);
        }
        ticket.addTotransactions(posTransaction);
        transaction.setRefunded(true);
    }

    public RefundTransaction createRefundTransaction(Ticket ticket, PosTransaction transaction, double refundAmount, boolean populateReturnedItems) {
        RefundTransaction posTransaction = new RefundTransaction();
        posTransaction.setAmount(refundAmount);
        posTransaction.setTicket(ticket);
        posTransaction.setTerminal(DataProvider.get().getCurrentTerminal());
        posTransaction.setTransactionType(TransactionType.DEBIT.name());
        posTransaction.setCashDrawer(Application.getCurrentUser().getActiveDrawerPullReport());
        posTransaction.setTransactionTime(StoreDAO.getServerTimestamp());
        posTransaction.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        if (populateReturnedItems) {
            try {
                posTransaction.addReturnTicketItemIds(ticket.getTicketItems());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (transaction == null) {
            return posTransaction;
        }
        posTransaction.setCardExpMonth(transaction.getCardExpMonth());
        posTransaction.setCardHolderName(transaction.getCardHolderName());
        posTransaction.setCardAuthCode(transaction.getCardAuthCode());
        posTransaction.setCardMerchantGateway(transaction.getCardMerchantGateway());
        posTransaction.setCardNumber(transaction.getCardNumber());
        posTransaction.setCardTrack(transaction.getCardTrack());
        posTransaction.setCardTransactionId(transaction.getCardTransactionId());
        posTransaction.setCardReader(transaction.getCardReader());
        posTransaction.setCardType(transaction.getCardType());
        posTransaction.addProperty("REFUNDED_TRANSACTION_ID", transaction.getId());
        String refundedAmountText = transaction.getProperty("REFUNDED_AMOUNT");
        double previousRefundedAmount = 0.0;
        if (StringUtils.isNotEmpty((String)refundedAmountText)) {
            try {
                previousRefundedAmount = Double.parseDouble(refundedAmountText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        transaction.addProperty("REFUNDED_AMOUNT", String.valueOf(refundAmount + previousRefundedAmount));
        if (transaction.getTipsAmount() > 0.0) {
            double transactionAmountWithoutTips;
            double totalRefundedAmount;
            double tipsRefundAmount;
            String refundedTipsAmountText = transaction.getProperty("REFUNDED_TIPS_AMOUNT");
            double previousRefundedTipsAmount = 0.0;
            if (StringUtils.isNotEmpty((String)refundedAmountText)) {
                try {
                    previousRefundedTipsAmount = Double.parseDouble(refundedTipsAmountText);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((tipsRefundAmount = (totalRefundedAmount = previousRefundedAmount + refundAmount) - (transactionAmountWithoutTips = transaction.getAmount() - transaction.getTipsAmount()) - previousRefundedTipsAmount) > 0.0) {
                posTransaction.setTipsAmount(tipsRefundAmount);
                transaction.addProperty("REFUNDED_TIPS_AMOUNT", String.valueOf(tipsRefundAmount + previousRefundedTipsAmount));
                Gratuity gratuity = ticket.getGratuity();
                gratuity.setAmount(gratuity.getAmount() - tipsRefundAmount);
            }
        }
        return posTransaction;
    }

    @Deprecated
    public double refundTicket(Ticket ticket, PosTransaction transaction, double refundTenderedAmount, Double refundItemTaxAmount, User currentUser, Session session) throws Exception {
        ticket.addTotransactions(transaction);
        ticket.setRefunded(true);
        ticket.setClosed(true);
        ticket.setCashier(currentUser);
        ticket.calculateRefundAmount();
        ticket.calculatePrice();
        ticket.setShouldUpdateStock(true);
        TicketDAO.getInstance().saveOrUpdate(ticket, session);
        return refundTenderedAmount;
    }

    public void bookBartabTicket(Ticket ticket, PosTransaction transaction, boolean closed) throws Exception {
        Application application = Application.getInstance();
        User currentUser = Application.getCurrentUser();
        Terminal terminal = application.refreshAndGetTerminal();
        Transaction tx = null;
        GenericDAO dao = new GenericDAO();
        try (Session session = dao.createNewSession();){
            Date currentDate = new Date();
            tx = session.beginTransaction();
            ticket.setVoided(false);
            ticket.setTerminal(terminal);
            ticket.calculatePrice();
            if (closed) {
                ticket.setPaid(true);
                PosTransactionService.closeTicketIfApplicable(ticket, currentDate);
            } else {
                ticket.setPaid(false);
                ticket.setClosed(false);
            }
            transaction.setTransactionType(TransactionType.CREDIT.name());
            transaction.setPaymentType(transaction.getPaymentType());
            transaction.setTerminal(terminal);
            transaction.setUser(currentUser);
            transaction.setTransactionTime(currentDate);
            ticket.addTotransactions(transaction);
            ticket.setShouldUpdateStock(true);
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                tx.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
        this.saveJournal(ticket, transaction);
    }

    private void adjustGiftCardBalance(Ticket ticket, PosTransaction transaction, Session session) {
        if (ticket.hasGiftCard()) {
            List<TicketItem> ticketItems = ticket.getTicketItems();
            for (TicketItem ticketItem : ticketItems) {
                double giftCardPaidAmount;
                if (!ticketItem.isGiftCard()) continue;
                String giftCardNo = ticketItem.getGiftCardNo();
                double balanceToAdd = ticketItem.getUnitPrice();
                if (balanceToAdd == (giftCardPaidAmount = ticketItem.getGiftCardPaidAmount())) {
                    return;
                }
                ticketItem.setGiftCardPaidAmount(balanceToAdd);
                transaction.addGiftCardBalanceAddInfo(ticketItem.getId(), giftCardNo, balanceToAdd);
                GiftCard giftCard = GiftCardDAO.getInstance().findByCardNumber(giftCardNo);
                giftCard.setBalance(giftCard.getBalance() + balanceToAdd);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard, session);
            }
        }
    }

    public static void sortTransactionsByDateDesc(List<PosTransaction> transactions) {
        Collections.sort(transactions, new Comparator<PosTransaction>(){

            @Override
            public int compare(PosTransaction o1, PosTransaction o2) {
                if (o1.getTransactionTime() == null) {
                    return -1;
                }
                if (o2.getTransactionTime() == null) {
                    return 1;
                }
                return o2.getTransactionTime().compareTo(o1.getTransactionTime());
            }
        });
    }

    public static void sortTransactionsByTransactionTypeAndDateDesc(List<PosTransaction> transactions) {
        Comparator<PosTransaction> comparator = Comparator.comparing(PosTransaction::getTransactionType, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(BasePosTransaction::getTransactionTime);
        transactions.sort(comparator);
    }

    public static PosTransactionService getInstance() {
        return paymentService;
    }
}

