/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.dao.ShopSeatDAO;
import com.floreantpos.util.NumberUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public class SplitTicketService {
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;
    public static final int maxSplitQuantity = 100;

    public static List<Ticket> doEquallySplit(Ticket ticket, int splitQuantity) throws Exception {
        int i;
        double ticketTotal = ticket.getTotalAmount();
        double splitAmount = ticketTotal / (double)splitQuantity;
        double roundedSplitAmount = NumberUtil.round(splitAmount);
        double diff = roundedSplitAmount * (double)splitQuantity - splitAmount * (double)splitQuantity;
        int numberOfSplitToAdjust = (int)Math.abs(NumberUtil.round(diff) * 100.0);
        ArrayList<TicketItem> originalTickeItems = new ArrayList<TicketItem>(ticket.getTicketItems());
        ArrayList<Ticket> splittedTickets = new ArrayList<Ticket>();
        ticket.getTicketItems().clear();
        splittedTickets.add(ticket);
        for (i = 1; i < splitQuantity; ++i) {
            Ticket splitTicket = SplitTicketService.createNewTicket(ticket, splitQuantity);
            splittedTickets.add(splitTicket);
        }
        for (i = 0; i < originalTickeItems.size(); ++i) {
            TicketItem ticketItem = (TicketItem)originalTickeItems.get(i);
            for (int splitNo = 0; splitNo < splittedTickets.size(); ++splitNo) {
                Ticket splittedTicket = (Ticket)splittedTickets.get(splitNo);
                double newAmount = roundedSplitAmount;
                if (splitNo < numberOfSplitToAdjust) {
                    if (roundedSplitAmount > splitAmount) {
                        newAmount -= 0.01;
                    } else if (roundedSplitAmount < splitAmount) {
                        newAmount += 0.01;
                    }
                }
                TicketItem splitTicketItem = SplitTicketService.splitTicketItem(splittedTicket, ticketItem, ticketTotal, newAmount, splitQuantity);
                splitTicketItem.setTicket(splittedTicket);
                splittedTicket.addToticketItems(splitTicketItem, false);
                splittedTicket.setSplitOrder(splitNo + 1);
                splittedTicket.addProperty("split", String.valueOf(Boolean.TRUE));
                splittedTicket.addProperty(SPLIT_TYPE, String.valueOf(0));
                splittedTicket.addProperty("split_ticket_id", ticket.getId());
                splittedTicket.calculatePrice();
            }
        }
        return splittedTickets;
    }

    private static TicketItem splitTicketItem(Ticket ticket, TicketItem ticketItem, double originalTicketTotal, double ticketTotalAfterSplit, int splitQuantity) throws Exception {
        TicketItem newTicketItem = ticketItem.cloneAsNew(true);
        newTicketItem.setSplitted(true);
        if (ticket.getId() != null) {
            newTicketItem.setCreateDate(ticketItem.getCreateDate());
        }
        ticketItem.setTicket(ticket);
        TicketItemSeat newTicketItemSeat = ticketItem.getSeat();
        if (newTicketItemSeat != null) {
            newTicketItemSeat.setId(null);
            newTicketItem.setSeat(newTicketItemSeat);
        }
        newTicketItem.setQuantity(ticketTotalAfterSplit * ticketItem.getQuantity() / originalTicketTotal);
        if (newTicketItem.getQuantity() % 1.0 != 0.0) {
            newTicketItem.setFractionalUnit(true);
        }
        List<TicketItemDiscount> newDiscounts = newTicketItem.getDiscounts();
        newTicketItem.calculatePrice();
        SplitTicketService.updateTicketItemDiscounts(newDiscounts, splitQuantity);
        return newTicketItem;
    }

    public static List<Ticket> doSplitBySeatNumber(Ticket originalTicket) throws Exception {
        ArrayList<TicketItem> ticketItems = new ArrayList<TicketItem>(originalTicket.getTicketItems());
        ArrayList<TicketItem> sharedTicketItems = new ArrayList<TicketItem>();
        HashMap<String, Customer> customerMap = new HashMap<String, Customer>();
        HashMap<String, List<TicketItem>> itemMap = new HashMap<String, List<TicketItem>>();
        SplitTicketService.populateTicketItemMap(ticketItems, sharedTicketItems, customerMap, itemMap);
        if (itemMap.size() > 100) {
            throw new PosException(String.format(Messages.getString("SplitTicketService.16"), 100));
        }
        if (itemMap.size() <= 1) {
            return null;
        }
        int totalSplitQuantity = 0;
        if (itemMap.keySet().size() > 1) {
            totalSplitQuantity = itemMap.keySet().size();
        }
        ArrayList<Ticket> splittedTickets = new ArrayList<Ticket>();
        originalTicket.getTicketItems().clear();
        splittedTickets.add(originalTicket);
        for (int i = 1; i < totalSplitQuantity; ++i) {
            Ticket splitTicket = SplitTicketService.createNewTicket(originalTicket, totalSplitQuantity);
            splittedTickets.add(splitTicket);
        }
        int splitNo = 0;
        List<ShopSeat> extraSeats = originalTicket.getExtraSeats();
        for (String seatNo : itemMap.keySet()) {
            Ticket ticket2 = (Ticket)splittedTickets.get(splitNo++);
            List itemList = (List)itemMap.get(seatNo);
            if (itemList == null) continue;
            for (TicketItem ticketItem : itemList) {
                ticketItem.setTicket(ticket2);
                ticketItem.setSeat(null);
                ticket2.addToticketItems(ticketItem, false);
                ticket2.addProperty("split", String.valueOf(Boolean.TRUE));
                ticket2.addProperty(SPLIT_TYPE, String.valueOf(1));
                ShopSeat shopSeat = ShopSeatDAO.getInstance().getShopSeatById(seatNo, ticket2);
                if (shopSeat == null) {
                    shopSeat = SplitTicketService.getExtraSeat(extraSeats, seatNo);
                }
                if (shopSeat != null) {
                    ticket2.addProperty("split_seat_number", shopSeat.getSeatNumberWithTableName());
                }
                ticket2.addProperty("split_ticket_id", originalTicket.getId());
                Customer customer = (Customer)customerMap.get(seatNo);
                if (customer == null) continue;
                ticket2.setCustomer(customer);
            }
        }
        splitNo = 0;
        for (Ticket ticket2 : splittedTickets) {
            for (TicketItem ticketItem : sharedTicketItems) {
                TicketItem splitTicketItem = SplitTicketService.splitTicketItem(ticket2, ticketItem, splitNo, totalSplitQuantity);
                splitTicketItem.setSeat(null);
                splitTicketItem.setTicket(ticket2);
                ticket2.addToticketItems(splitTicketItem, false);
            }
            ++splitNo;
            ticket2.calculatePrice();
        }
        return splittedTickets;
    }

    private static ShopSeat getExtraSeat(List<ShopSeat> extraSeats, String seatId) {
        if (extraSeats.isEmpty() || StringUtils.isBlank((String)seatId)) {
            return null;
        }
        for (ShopSeat shopSeat : extraSeats) {
            if (!shopSeat.getId().equals(seatId)) continue;
            return shopSeat;
        }
        return null;
    }

    private static void populateTicketItemMap(List<TicketItem> ticketItems, List<TicketItem> sharedTicketItems, Map<String, Customer> customerMap, Map<String, List<TicketItem>> itemMap) {
        Iterator<TicketItem> iterator = ticketItems.iterator();
        while (iterator.hasNext()) {
            TicketItem oldItem = iterator.next();
            if (oldItem.isTreatAsSeat().booleanValue()) {
                oldItem.setSeat(null);
                iterator.remove();
                continue;
            }
            TicketItem ticketItem = oldItem.cloneAsNew(true);
            TicketItemSeat seat = oldItem.getSeat();
            Integer seatNumber = oldItem.getSeatNumber();
            String seatId = seat == null ? (seatNumber == null || seatNumber == 0 ? null : seatNumber.toString()) : seat.getSeatId();
            ticketItem.setSeat(null);
            oldItem.setSeat(null);
            if (StringUtils.isBlank((String)seatId)) {
                sharedTicketItems.add(ticketItem);
                continue;
            }
            List<TicketItem> ticketItemList = itemMap.get(seatId);
            if (ticketItemList == null) {
                ticketItemList = new ArrayList<TicketItem>();
                ticketItemList.add(ticketItem);
                if (seat != null) {
                    customerMap.put(seatId, seat.getMember());
                }
                itemMap.put(seatId, ticketItemList);
                continue;
            }
            ticketItemList.add(ticketItem);
        }
    }

    private static List<TicketDiscount> cloneTicketDiscounts(List<TicketDiscount> ticketDiscounts, int splitQuantity) throws Exception {
        ArrayList<TicketDiscount> newTicketDiscounts = new ArrayList<TicketDiscount>();
        if (ticketDiscounts != null && !ticketDiscounts.isEmpty()) {
            for (TicketDiscount ticketDiscount : ticketDiscounts) {
                TicketDiscount newTicketDiscount = new TicketDiscount();
                PropertyUtils.copyProperties((Object)newTicketDiscount, (Object)ticketDiscount);
                newTicketDiscount.setId(null);
                if (ticketDiscount.getType() != 1) {
                    newTicketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)splitQuantity);
                }
                newTicketDiscounts.add(newTicketDiscount);
            }
        }
        return newTicketDiscounts;
    }

    private static Ticket createNewTicket(Ticket ticket, int splitQuantity) throws Exception {
        Ticket splitTicket = new Ticket(true);
        PropertyUtils.copyProperties((Object)splitTicket, (Object)ticket);
        splitTicket.setProperties(null);
        splitTicket.setTransactions(null);
        splitTicket.setId(null);
        splitTicket.setTokenNo(null);
        splitTicket.setShortId(null);
        splitTicket.setTicketItems(null);
        splitTicket.setCreateDate(null);
        splitTicket.setLastUpdateTime(null);
        splitTicket.setLastSyncTime(null);
        splitTicket.setGratuity(null);
        splitTicket.setCloudSynced(false);
        splitTicket.setDiscounts(SplitTicketService.cloneTicketDiscounts(ticket.getDiscounts(), splitQuantity));
        ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
        List<Integer> ticketTableNumbers = ticket.getTableNumbers();
        if (ticketTableNumbers != null) {
            tableNumbers.addAll(ticketTableNumbers);
        }
        splitTicket.setTableNumbers(tableNumbers);
        splitTicket.setCustomer(ticket.getCustomer());
        return splitTicket;
    }

    private static void updateTicketItemDiscounts(List<TicketItemDiscount> ticketItemDiscounts, int splitQuantity) throws Exception {
        if (ticketItemDiscounts != null && !ticketItemDiscounts.isEmpty()) {
            for (TicketItemDiscount discount : ticketItemDiscounts) {
                if (discount.getType() != 1) {
                    discount.setCouponQuantity(discount.getCouponQuantity() / (double)splitQuantity);
                }
                discount.calculateDiscount(discount.getTicketItem().getSubtotalAmount());
            }
        }
    }

    private static TicketItem splitTicketItem(Ticket ticket, TicketItem ticketItem, int splitNo, int splitQuantity) throws Exception {
        double newQuantity;
        TicketItem newTicketItem = ticketItem.cloneAsNew(true);
        newTicketItem.setSplitted(true);
        if (ticket.getId() != null) {
            newTicketItem.setCreateDate(ticketItem.getCreateDate());
        }
        ticketItem.setTicket(ticket);
        TicketItemSeat newTicketItemSeat = ticketItem.getSeat();
        if (newTicketItemSeat != null) {
            newTicketItemSeat.setId(null);
            newTicketItem.setSeat(newTicketItemSeat);
        }
        if ((newQuantity = ticketItem.getQuantity() / (double)splitQuantity) % 1.0 == 0.0) {
            newTicketItem.setQuantity(newQuantity);
        } else {
            double unitPriceWithModifier = ticketItem.getSubtotalAmount() / ticketItem.getQuantity();
            double nonRoundedUnitPrice = unitPriceWithModifier * newQuantity * (double)splitQuantity;
            double roundedUnitPrice = NumberUtil.round(unitPriceWithModifier * newQuantity) * (double)splitQuantity;
            double unitPriceDiff = roundedUnitPrice - nonRoundedUnitPrice;
            int numberOfSplitToAdjust = (int)Math.abs(NumberUtil.round(unitPriceDiff) * 100.0);
            newTicketItem.setQuantity(newQuantity);
            double newPrice1 = newTicketItem.getUnitPrice() * newTicketItem.getQuantity();
            if (splitNo < numberOfSplitToAdjust) {
                newTicketItem.setQuantity(nonRoundedUnitPrice * newQuantity / roundedUnitPrice);
                double newPrice2 = newTicketItem.getUnitPrice() * newTicketItem.getQuantity();
                if (NumberUtil.round(newPrice1) == NumberUtil.round(newPrice2)) {
                    if (roundedUnitPrice < nonRoundedUnitPrice) {
                        newTicketItem.setQuantity((newPrice2 + Math.abs(unitPriceDiff)) * newTicketItem.getQuantity() / newPrice2);
                    } else {
                        newTicketItem.setQuantity((newPrice2 - Math.abs(unitPriceDiff)) * newTicketItem.getQuantity() / newPrice2);
                    }
                }
            } else {
                newTicketItem.setQuantity(newQuantity);
            }
            newTicketItem.setFractionalUnit(true);
        }
        List<TicketItemDiscount> newDiscounts = newTicketItem.getDiscounts();
        newTicketItem.calculatePrice();
        SplitTicketService.updateTicketItemDiscounts(newDiscounts, splitQuantity);
        return newTicketItem;
    }

    public static void splitAndDistributeItem(TicketItem ticketItem, Ticket sourceTicket, List<Ticket> tickets) throws Exception {
        int index = sourceTicket.getTicketItems().indexOf(ticketItem);
        tickets.add(0, sourceTicket);
        int splitQuantity = tickets.size();
        for (int splitNo = 0; splitNo < tickets.size(); ++splitNo) {
            Ticket splittedTicket = tickets.get(splitNo);
            TicketItem splitTicketItem = SplitTicketService.splitTicketItem(splittedTicket, ticketItem, splitNo, splitQuantity);
            splitTicketItem.setTicket(splittedTicket);
            if (splittedTicket == sourceTicket) {
                sourceTicket.getTicketItems().set(index, splitTicketItem);
            } else {
                splittedTicket.addToticketItems(splitTicketItem, false);
            }
            splittedTicket.calculatePrice();
        }
    }

    public static void splitAndDistributeItemForSharedCustom(TicketItem ticketItem, Ticket sourceTicket, List<Ticket> tickets) throws Exception {
        int index = sourceTicket.getTicketItems().indexOf(ticketItem);
        if (!tickets.contains(sourceTicket)) {
            sourceTicket.getTicketItems().remove(index);
        }
        int splitQuantity = tickets.size();
        for (int splitNo = 0; splitNo < tickets.size(); ++splitNo) {
            Ticket splittedTicket = tickets.get(splitNo);
            TicketItem splitTicketItem = SplitTicketService.splitTicketItem(splittedTicket, ticketItem, splitNo, splitQuantity);
            splitTicketItem.setTicket(splittedTicket);
            if (splittedTicket == sourceTicket) {
                sourceTicket.getTicketItems().set(index, splitTicketItem);
            } else {
                splittedTicket.addToticketItems(splitTicketItem, false);
            }
            splittedTicket.calculatePrice();
        }
    }
}

