/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.PosLog;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PaginationSupport;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public class BeanTableModel<M>
extends AbstractTableModel
implements PaginationSupport {
    private int numRows;
    private int currentRowIndex;
    private int pageSize = 100;
    private List<M> rows = new ArrayList<M>();
    private List<BeanColumn> columns = new ArrayList<BeanColumn>();
    private Class<?> beanClass;
    private BeanTableCellEditor numericCellEditor;
    private BeanTableCellEditor defaultCellEditor;
    private String sortBy;
    private boolean ascOrder;

    public BeanTableModel(Class<?> beanClass) {
        this(beanClass, 50);
    }

    public BeanTableModel(Class<?> beanClass, int pageSize) {
        this.beanClass = beanClass;
        this.pageSize = pageSize;
        DoubleTextField numericCellEditorField = new DoubleTextField();
        numericCellEditorField.setHorizontalAlignment(4);
        this.numericCellEditor = new BeanTableCellEditor(numericCellEditorField);
        this.numericCellEditor.setClickCountToStart(1);
        JTextField tf = new JTextField();
        this.defaultCellEditor = new BeanTableCellEditor(tf);
        this.defaultCellEditor.setClickCountToStart(1);
    }

    public void addColumn(String columnGUIName, String beanAttribute, EditMode editable) {
        this.addColumn(columnGUIName, beanAttribute, editable, 10, null);
    }

    public void addColumn(String columnGUIName, String beanAttribute, EditMode editable, int horizontalAlignment, DataType dataType) {
        try {
            PropertyDescriptor descriptor = new PropertyDescriptor(beanAttribute, this.beanClass);
            this.columns.add(new BeanColumn(columnGUIName, beanAttribute, editable, descriptor, horizontalAlignment, dataType));
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    public void addColumn(String columnGUIName, String beanAttribute) {
        this.addColumn(columnGUIName, beanAttribute, EditMode.NON_EDITABLE);
    }

    public void addColumn(String columnGUIName, String beanAttribute, int horizontalAlignment, DataType dataType) {
        this.addColumn(columnGUIName, beanAttribute, EditMode.NON_EDITABLE, horizontalAlignment, dataType);
    }

    public void addRow(M row) {
        this.rows.add(row);
        this.fireTableDataChanged();
    }

    public void removeRow(M row) {
        this.rows.remove(row);
        this.fireTableDataChanged();
    }

    public void removeRow(int index) {
        this.rows.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public void removeAll() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public void addRows(List<M> rows) {
        if (rows == null) {
            return;
        }
        for (M row : rows) {
            this.addRow(row);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void setRows(List rows) {
        this.rows = rows;
        this.fireTableDataChanged();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        BeanColumn column = this.columns.get(columnIndex);
        M row = this.rows.get(rowIndex);
        Object result = null;
        try {
            result = column.descriptor.getReadMethod().invoke(row, new Object[0]);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
        return result;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        M row = this.rows.get(rowIndex);
        BeanColumn column = this.columns.get(columnIndex);
        try {
            column.descriptor.getWriteMethod().invoke(row, value);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        BeanColumn column = this.columns.get(columnIndex);
        Class<?> returnType = column.descriptor.getReadMethod().getReturnType();
        return returnType;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).columnGUIName;
    }

    public String getColumnBeanAttributeName(int column) {
        return this.columns.get(column).columnBeanAttribute;
    }

    public BeanColumn getColumn(int column) {
        return this.columns.get(column);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).editable == EditMode.EDITABLE;
    }

    public void setRow(int index, M row) {
        this.getRows().set(index, row);
        this.fireTableRowsUpdated(index, index);
    }

    public M getRow(int index) {
        return this.getRows().get(index);
    }

    public List<M> getRows() {
        return this.rows;
    }

    @Override
    public int getNumRows() {
        return this.numRows;
    }

    @Override
    public void setNumRows(int numRows) {
        this.numRows = numRows;
    }

    @Override
    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    @Override
    public void setCurrentRowIndex(int currentRowIndex) {
        this.currentRowIndex = currentRowIndex;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Override
    public boolean hasNext() {
        return this.currentRowIndex + this.pageSize < this.numRows;
    }

    @Override
    public boolean hasPrevious() {
        return this.currentRowIndex > 0;
    }

    @Override
    public int getNextRowIndex() {
        if (this.numRows == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    @Override
    public int getPreviousRowIndex() {
        int i = this.getCurrentRowIndex() - this.getPageSize();
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    public void initTableRenderer(JTable table) {
        BeanTableCellRenderer renderer = new BeanTableCellRenderer();
        table.setDefaultRenderer(Object.class, renderer);
        table.setDefaultRenderer(Double.class, renderer);
        table.setDefaultRenderer(Number.class, renderer);
        table.setRowHeight(PosUIManager.getSize(30));
        for (int i = 0; i < this.columns.size(); ++i) {
            BeanColumn beanColumn = this.columns.get(i);
            if (!beanColumn.isEditable()) continue;
            if (beanColumn.getDataType() == DataType.MONEY || beanColumn.getDataType() == DataType.NUMBER) {
                table.setDefaultEditor(table.getColumnClass(i), this.numericCellEditor);
                continue;
            }
            table.setDefaultEditor(table.getColumnClass(i), this.defaultCellEditor);
        }
    }

    public void setSortBy(String propertyName, boolean ascOrder) {
        this.sortBy = propertyName;
        this.ascOrder = ascOrder;
    }

    public boolean isAscOrder() {
        return this.ascOrder;
    }

    public String getSortBy() {
        return this.sortBy;
    }

    class BeanTableCellEditor
    extends DefaultCellEditor {
        public BeanTableCellEditor(JTextField textField) {
            super(textField);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.editorComponent instanceof DoubleTextField) {
                return ((DoubleTextField)this.editorComponent).getDoubleOrZero();
            }
            if (this.editorComponent instanceof IntegerTextField) {
                return ((IntegerTextField)this.editorComponent).getInteger();
            }
            return super.getCellEditorValue();
        }
    }

    public static class BeanTableCellRenderer
    extends DefaultTableCellRenderer {
        private Border unselectedBorder = null;
        private Border selectedBorder = null;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            BeanTableModel model = (BeanTableModel)table.getModel();
            BeanColumn beanColumn = model.getColumn(column);
            this.setHorizontalAlignment(beanColumn.getHorizontalAlignment());
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, table.getSelectionBackground());
            }
            if (this.unselectedBorder == null) {
                this.unselectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, table.getBackground());
            }
            if (value instanceof byte[]) {
                byte[] imageData = (byte[])value;
                ImageIcon image = new ImageIcon(imageData);
                image = ImageResource.getScaledImageIcon(image, 40);
                JLabel l = new JLabel(image);
                if (isSelected) {
                    l.setBorder(this.selectedBorder);
                } else {
                    l.setBorder(this.unselectedBorder);
                }
                l.setHorizontalAlignment(0);
                return l;
            }
            if (value instanceof Color) {
                JLabel l = new JLabel();
                Color newColor = (Color)value;
                l.setOpaque(true);
                l.setBackground(newColor);
                if (isSelected) {
                    l.setBorder(this.selectedBorder);
                } else {
                    l.setBorder(this.unselectedBorder);
                }
                return l;
            }
            if (value instanceof Date) {
                String valueStr = DateUtil.formatFullDateAndTimeWithoutYearAsString((Date)value);
                return super.getTableCellRendererComponent(table, valueStr, isSelected, hasFocus, row, column);
            }
            DataType dataType = beanColumn.getDataType();
            if (dataType == null) {
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            switch (dataType) {
                case MONEY: {
                    try {
                        value = NumberUtil.getCurrencyFormat(value);
                    }
                    catch (Exception exception) {}
                    break;
                }
                case NUMBER: {
                    try {
                        value = NumberUtil.format6DigitNumber((Double)value);
                    }
                    catch (Exception exception) {}
                    break;
                }
                default: {
                    value = "<html>" + value + "</html>";
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    public static class BeanColumn {
        private String columnGUIName;
        private String columnBeanAttribute;
        private EditMode editable;
        private PropertyDescriptor descriptor;
        private int horizontalAlignment = 10;
        private DataType dataType;

        public BeanColumn(String columnGUIName, String beanAttribute, EditMode editable, PropertyDescriptor descriptor, int horizontalAlignment, DataType dataType) {
            this.columnGUIName = columnGUIName;
            this.columnBeanAttribute = beanAttribute;
            this.editable = editable;
            this.descriptor = descriptor;
            this.horizontalAlignment = horizontalAlignment;
            this.dataType = dataType;
        }

        public boolean isEditable() {
            if (this.editable == null) {
                return false;
            }
            return this.editable == EditMode.EDITABLE;
        }

        public int getHorizontalAlignment() {
            return this.horizontalAlignment;
        }

        public void setHorizontalAlignment(int horizontalAlignment) {
            this.horizontalAlignment = horizontalAlignment;
        }

        public DataType getDataType() {
            return this.dataType;
        }
    }

    public static enum EditMode {
        NON_EDITABLE,
        EDITABLE;

    }

    public static enum DataType {
        MONEY,
        NUMBER,
        DATE;

    }
}

