/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.ITicketList;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicScrollBarUI;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class CustomerTicketListView
extends JPanel
implements DataChangeListener,
ITicketList {
    private JXTable ticketListTable = new JXTable();
    private PosButton btnPrevious;
    private PosButton btnNext;
    private PosBlinkButton btnRefresh;
    private BeanTableModel<Ticket> tableModel;
    private JScrollBar verticalScrollBar;
    private String customerId;

    public CustomerTicketListView(String customerId) {
        this.customerId = customerId;
        this.setLayout(new BorderLayout());
        this.createTicketTable();
    }

    private void createTicketTable() {
        this.ticketListTable.setSortable(true);
        this.ticketListTable.setSelectionMode(0);
        this.ticketListTable.setColumnControlVisible(true);
        this.tableModel = new BeanTableModel(Ticket.class);
        this.tableModel.addColumn(POSConstants.ID, Ticket.PROP_ID);
        this.tableModel.addColumn(POSConstants.SERVER, "owner");
        this.tableModel.addColumn(POSConstants.CREATED, Ticket.PROP_CREATE_DATE, 10, BeanTableModel.DataType.DATE);
        this.tableModel.addColumn(POSConstants.CUSTOMER, "customer");
        this.tableModel.addColumn(POSConstants.TOTAL, Ticket.PROP_TOTAL_AMOUNT, 4, BeanTableModel.DataType.MONEY);
        this.ticketListTable.setModel(this.tableModel);
        this.tableModel.setPageSize(50);
        this.ticketListTable.setAutoResizeMode(3);
        this.ticketListTable.setGridColor(Color.LIGHT_GRAY);
        this.ticketListTable.getTableHeader().setPreferredSize(new Dimension(100, PosUIManager.getSize(40)));
        this.tableModel.initTableRenderer((JTable)this.ticketListTable);
        this.ticketListTable.setRowHeight(PosUIManager.getSize(60));
        this.createScrollPane();
    }

    private void createScrollPane() {
        this.btnRefresh = new PosBlinkButton(IconFactory.getIcon("/ui_icons/", "refresh-16.png"));
        this.btnPrevious = new PosButton(IconFactory.getIcon("/ui_icons/", "previous-24.png"));
        this.btnNext = new PosButton(IconFactory.getIcon("/ui_icons/", "next-24.png"));
        this.createActionHandlers();
        PosScrollPane scrollPane = new PosScrollPane((Component)this.ticketListTable, 20, 31);
        scrollPane.getVerticalScrollBar().setUI(new CustomScrollbarUI());
        int height = PosUIManager.getSize(40);
        JPanel topButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        topButtonPanel.add((Component)this.btnRefresh, "h " + height + "!, grow, wrap");
        topButtonPanel.add((Component)this.btnPrevious, "h " + height + "!, grow, wrap");
        JPanel downButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "grow", ""));
        downButtonPanel.add((Component)this.btnNext, "h " + height + "!, grow,gaptop 5, wrap");
        JPanel tableButtonPanel = new JPanel(new BorderLayout());
        tableButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        tableButtonPanel.setPreferredSize(PosUIManager.getSize(48, 0));
        tableButtonPanel.add((Component)topButtonPanel, "North");
        tableButtonPanel.add((Component)downButtonPanel, "South");
        this.verticalScrollBar = scrollPane.getVerticalScrollBar();
        scrollPane.getViewport().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                CustomerTicketListView.this.verticalScrollBar.repaint();
            }
        });
        tableButtonPanel.add(this.verticalScrollBar);
        this.add(scrollPane);
        this.add((Component)tableButtonPanel, "East");
    }

    public void createActionHandlers() {
        this.btnPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomerTicketListView.this.tableModel.hasPrevious()) {
                    CustomerTicketListView.this.tableModel.setCurrentRowIndex(CustomerTicketListView.this.tableModel.getPreviousRowIndex());
                    CustomerTicketListView.this.updateTicketList();
                }
                CustomerTicketListView.this.updateButtonStatus();
            }
        });
        this.btnNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CustomerTicketListView.this.tableModel.hasNext()) {
                    CustomerTicketListView.this.tableModel.setCurrentRowIndex(CustomerTicketListView.this.tableModel.getNextRowIndex());
                    CustomerTicketListView.this.updateTicketList();
                }
                CustomerTicketListView.this.updateButtonStatus();
            }
        });
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CustomerTicketListView.this.tableModel.setCurrentRowIndex(0);
                CustomerTicketListView.this.updateTicketList();
            }
        });
    }

    public void updateButtonStatus() {
        this.btnNext.setEnabled(this.tableModel.hasNext());
        this.btnPrevious.setEnabled(this.tableModel.hasPrevious());
    }

    @Override
    public synchronized void updateTicketList() {
        try {
            List<Ticket> customerTickets = TicketDAO.getInstance().findCustomerTickets(this.customerId, this.tableModel);
            this.tableModel.setRows(customerTickets);
            this.btnRefresh.setBlinking(false);
            this.updateButtonStatus();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("SwitchboardView.19"), e);
        }
    }

    @Override
    public Ticket getSelectedTicket() {
        int selectedRow = this.ticketListTable.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        return this.tableModel.getRow(this.ticketListTable.convertRowIndexToModel(selectedRow));
    }

    public List<Ticket> getSelectedTickets() {
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        Ticket selectedTicket = this.getSelectedTicket();
        if (selectedTicket == null) {
            return null;
        }
        tickets.add(selectedTicket);
        return tickets;
    }

    public Ticket getFirstSelectedTicket() {
        List<Ticket> selectedTickets = this.getSelectedTickets();
        if (selectedTickets == null || selectedTickets.size() == 0) {
            return null;
        }
        Ticket ticket = selectedTickets.get(0);
        return ticket;
    }

    public String getFirstSelectedTicketId() {
        Ticket ticket = this.getFirstSelectedTicket();
        if (ticket == null) {
            return null;
        }
        return ticket.getId();
    }

    public JXTable getTable() {
        return this.ticketListTable;
    }

    public void setCurrentRowIndexZero() {
        this.tableModel.setCurrentRowIndex(0);
    }

    @Override
    public Object getSelectedData() {
        Ticket ticket = this.getSelectedTicket();
        if (ticket == null) {
            GlobalInputDialog inputDialog = new GlobalInputDialog(Application.getPosWindow());
            inputDialog.setCaption(Messages.getString("TicketListView.20"));
            inputDialog.open();
            if (inputDialog.isCanceled()) {
                return null;
            }
            String ticketId = inputDialog.getInput();
            ticket = TicketService.getTicket(ticketId);
        }
        return ticket;
    }

    @Override
    public void dataSetUpdated() {
        this.updateTicketList();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket updatedTicket = (Ticket)object;
        if (updatedTicket.getId() == null) {
            return;
        }
        updatedTicket = TicketDAO.getInstance().get(updatedTicket.getId());
        this.dataChanged(updatedTicket);
    }

    @Override
    public void dataAdded(Object object) {
    }

    @Override
    public void dataChanged(Object object) {
    }

    @Override
    public void dataRemoved(Object object) {
    }

    class CustomScrollbarUI
    extends BasicScrollBarUI {
        private ImageIcon downArrow;
        private ImageIcon upArrow = IconFactory.getIcon("/ui_icons/", "up.png");

        public CustomScrollbarUI() {
            this.downArrow = IconFactory.getIcon("/ui_icons/", "down.png");
        }

        @Override
        protected JButton createDecreaseButton(int orientation) {
            PosButton decreaseButton = new PosButton(this.getAppropriateIcon(orientation)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }

                @Override
                public boolean isVisible() {
                    this.setEnabled(CustomScrollbarUI.this.thumbRect.getY() > 0.0);
                    return super.isVisible();
                }
            };
            return decreaseButton;
        }

        @Override
        protected JButton createIncreaseButton(int orientation) {
            PosButton increaseButton = new PosButton(this.getAppropriateIcon(orientation)){

                @Override
                public Dimension getPreferredSize() {
                    return PosUIManager.getSize(40, 40);
                }

                @Override
                public boolean isVisible() {
                    this.setEnabled(CustomScrollbarUI.this.thumbRect.getY() > 0.0);
                    return super.isVisible();
                }
            };
            return increaseButton;
        }

        private ImageIcon getAppropriateIcon(int orientation) {
            switch (orientation) {
                case 5: {
                    return this.downArrow;
                }
                case 1: {
                    return this.upArrow;
                }
            }
            return this.upArrow;
        }
    }
}

