/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.PosUIManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.ComboPopup;

public class POSComboBox
extends JComboBox
implements PopupMenuListener {
    public POSComboBox() {
        this.setHeight(60);
        this.setFont(this.getFont().deriveFont(14.0f));
        this.addPopupMenuListener(this);
    }

    public POSComboBox(Object[] items) {
        super(items);
        this.setHeight(60);
        this.setFont(this.getFont().deriveFont(18.0f));
        this.addPopupMenuListener(this);
    }

    public void setHeight(int height) {
        this.setMinimumSize(PosUIManager.getSize(60, 40));
        Accessible popup = this.getUI().getAccessibleChild(this, 0);
        if (popup instanceof ComboPopup) {
            JList<Object> jlist = ((ComboPopup)((Object)popup)).getList();
            jlist.setFixedCellHeight(PosUIManager.getSize(height));
        }
    }

    public POSComboBox(Vector items) {
        super(items);
        this.setHeight(60);
        this.setFont(this.getFont().deriveFont(18.0f));
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        JComboBox comboBox = (JComboBox)e.getSource();
        Accessible popup = comboBox.getUI().getAccessibleChild(comboBox, 0);
        Component c = ((Container)((Object)popup)).getComponent(0);
        JComponent popupComponent = (JComponent)((Object)popup);
        if (popupComponent.isPreferredSizeSet()) {
            return;
        }
        if (c instanceof JScrollPane) {
            JScrollPane scrollpane = (JScrollPane)c;
            JScrollBar scrollBar = scrollpane.getVerticalScrollBar();
            scrollBar.setPreferredSize(PosUIManager.getSize(50, scrollBar.getPreferredSize().height));
        }
        if (popup instanceof ComboPopup) {
            Dimension comboboxSize = this.getSize();
            popupComponent.setPreferredSize(PosUIManager.getSize(comboboxSize.width, 300));
            popupComponent.setLayout(new GridLayout(1, 1));
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e) {
    }
}

