/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.swing.PosUIManager;
import java.awt.Color;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;
import javax.swing.event.ChangeListener;
import net.miginfocom.swing.MigLayout;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.Interval;

public class TimerWatch
extends JPanel
implements ActionListener {
    private Timer updateTimer = new Timer(1000, this);
    private JLabel timerLabel = new JLabel("");
    private final Date date;
    private final Color initialBgColor;
    private final Color initialFgColor;
    private final Color warningBgColor;
    private final Color warningFgColor;
    private final Color overBgColor;
    private final Color overFgColor;
    public Color backColor;
    public Color textColor;
    private ChangeListener colorChangeListener;

    public TimerWatch(Date date) {
        this(date, null);
    }

    public TimerWatch(Date date, ChangeListener colorChangeListener) {
        this.date = date;
        this.colorChangeListener = colorChangeListener;
        this.setOpaque(false);
        this.setLayout((LayoutManager)new MigLayout("right,ins 0"));
        this.initialBgColor = TerminalConfig.getColor("kds.initial.bg", new Color(0, 135, 67));
        this.initialFgColor = TerminalConfig.getColor("kds.initial.fg", Color.white);
        this.warningBgColor = TerminalConfig.getColor("kds.warning.bg", new Color(247, 177, 55));
        this.warningFgColor = TerminalConfig.getColor("kds.warning.fg", Color.white);
        this.overBgColor = TerminalConfig.getColor("kds.over.bd", new Color(204, 0, 0));
        this.overFgColor = TerminalConfig.getColor("kds.over.fg", Color.white);
        this.backColor = this.initialBgColor;
        this.textColor = this.initialFgColor;
        this.timerLabel.setFont(this.timerLabel.getFont().deriveFont(1, PosUIManager.getDefaultFontSize() + 2));
        this.timerLabel.setHorizontalAlignment(4);
        this.timerLabel.setOpaque(false);
        this.timerLabel.setForeground(Color.black);
        this.actionPerformed(null);
        this.add(this.timerLabel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean colorChanged;
        int oldColorCode;
        long currentTimeMillis = new Instant().getMillis();
        long createTimeMillis = this.date.getTime();
        long diff = createTimeMillis - currentTimeMillis;
        Interval interval = null;
        interval = diff > 0L ? new Interval(currentTimeMillis, this.date.getTime()) : new Interval(this.date.getTime(), currentTimeMillis);
        Duration duration = interval.toDuration();
        int timeOutValueYellow = 300;
        int timeOutValueRed = 600;
        if (AppConfig.getString("YellowTimeOut") != null) {
            timeOutValueYellow = Integer.parseInt(AppConfig.getString("YellowTimeOut"));
        }
        if (AppConfig.getString("RedTimeOut") != null) {
            timeOutValueRed = Integer.parseInt(AppConfig.getString("RedTimeOut"));
        }
        int n = oldColorCode = this.backColor != null ? this.backColor.getRGB() : -1;
        if ((long)timeOutValueYellow < duration.getStandardSeconds() && (long)timeOutValueRed > duration.getStandardSeconds()) {
            this.backColor = this.warningBgColor;
            this.textColor = this.warningFgColor;
        } else if ((long)timeOutValueRed < duration.getStandardSeconds()) {
            this.backColor = this.overBgColor;
            this.textColor = this.overFgColor;
        } else {
            this.backColor = this.initialBgColor;
            this.textColor = this.initialFgColor;
        }
        this.timerLabel.setForeground(this.textColor);
        this.timerLabel.setText(this.format(duration.getStandardHours()) + ":" + this.format(duration.getStandardMinutes() % 60L) + ":" + this.format(duration.getStandardSeconds() % 60L));
        boolean bl = colorChanged = this.backColor != null && this.backColor.getRGB() != oldColorCode;
        if (this.colorChangeListener != null && colorChanged) {
            this.colorChangeListener.stateChanged(null);
        }
    }

    private String format(long value) {
        String stringValue = String.valueOf(value);
        return stringValue.length() == 2 ? stringValue : "0" + value;
    }

    public void start() {
        this.updateTimer.start();
    }

    public void stop() {
        this.updateTimer.stop();
    }
}

