/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.DrawerAssignmentAction;
import com.floreantpos.actions.StaffBankCloseAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.DrawerType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TipsCashoutReport;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CashDropTransactionDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.report.CashDrawerTransactionReportModel;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.DetailReportDialog;
import com.floreantpos.ui.dialog.GratuityDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PayoutDialog;
import com.floreantpos.ui.dialog.TipsCashoutReportDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.TicketReceiptView;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import org.jdesktop.swingx.JXDatePicker;

public class CashDrawerReportDialog
extends POSDialog
implements ActionListener {
    private TitlePanel titlePanel;
    private CashDrawer cashDrawer;
    private PosButton btnCloseDrawer;
    private PosButton btnDrawerBleed;
    private PosButton btnNoSale;
    private PosButton btnPayout;
    private PosButton btnCloseStaffBank;
    private PosButton btnEncashTips;
    private PosButton btnDeclareTips;
    private User currentUser;
    private Terminal drawerTerminal;
    private PosButton btnPrint;
    private PosButton btnTransactionDetails;
    private PosButton btnTransferUser;
    private List<CashDrawer> drawerReports;
    private JPanel reportViewPanel;
    private JPanel serverLeftActionPanel;
    private JPanel buttonPanel;
    private PosButton btnFinish;
    private boolean showInfoOnly;
    private JasperPrint terminalSummryDetailsJasperPrint;
    private JasperPrint jasperPrint;

    public CashDrawerReportDialog(CashDrawer report) {
        this(null, report);
    }

    public CashDrawerReportDialog(User currentUser, CashDrawer report) {
        super(POSUtil.getFocusedWindow());
        this.setModal(true);
        this.currentUser = currentUser;
        this.cashDrawer = report;
        this.drawerTerminal = report.getTerminal();
        this.initComponents();
        this.setSize(PosUIManager.getSize(800, 670));
    }

    private void updateView() {
        boolean staffBank;
        if (this.showInfoOnly) {
            return;
        }
        if (this.cashDrawer.getId() == null || this.cashDrawer.isClosed()) {
            this.setEnableFields(false);
            return;
        }
        boolean thisTerminalDrawer = this.cashDrawer.getTerminal().getId().intValue() == Application.getInstance().getTerminal().getId().intValue();
        boolean bl = staffBank = this.cashDrawer.getDrawerType() == DrawerType.STAFF_BANK;
        if (staffBank) {
            this.btnCloseDrawer.setText(Messages.getString("CloseStaffBank"));
        }
        this.btnCloseDrawer.setEnabled(this.cashDrawer.getId() != null && this.cashDrawer.isOpen());
        this.btnCloseStaffBank.setEnabled(this.cashDrawer.getId() != null && this.cashDrawer.isOpen());
        this.btnDeclareTips.setVisible(staffBank);
        this.btnEncashTips.setVisible(staffBank);
        this.btnCloseStaffBank.setVisible(staffBank);
        this.btnDrawerBleed.setVisible(!staffBank);
        this.btnNoSale.setVisible(!staffBank && thisTerminalDrawer);
        this.btnPayout.setVisible(thisTerminalDrawer);
        this.btnCloseDrawer.setVisible(!staffBank);
        this.btnTransferUser.setVisible(!staffBank);
    }

    private void setEnableFields(boolean b) {
        this.btnCloseDrawer.setEnabled(b);
        this.btnCloseStaffBank.setVisible(b);
        this.btnDeclareTips.setEnabled(b);
        this.btnEncashTips.setEnabled(b);
        this.btnCloseStaffBank.setEnabled(b);
        this.btnDrawerBleed.setEnabled(b);
        this.btnPayout.setEnabled(b);
        this.btnCloseDrawer.setVisible(b);
        this.btnTransferUser.setVisible(b);
    }

    public void showInfoOnly(boolean b) {
        this.showInfoOnly = b;
        this.serverLeftActionPanel.setVisible(!b);
        if (this.currentUser == null) {
            return;
        }
        if (this.showInfoOnly) {
            this.buttonPanel.removeAll();
            this.buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
            this.buttonPanel.add((Component)this.btnTransactionDetails, "grow");
            this.buttonPanel.add((Component)this.btnPrint, "grow");
            this.buttonPanel.add((Component)this.btnFinish, "grow");
            this.btnCloseStaffBank.setVisible(!this.showInfoOnly);
            this.btnCloseDrawer.setVisible(!this.showInfoOnly);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.titlePanel = new TitlePanel();
        this.add((Component)this.titlePanel, "North");
        this.reportViewPanel = new JPanel(new BorderLayout());
        this.add(new PosScrollPane(this.reportViewPanel));
        this.buttonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 5 5 5 5,wrap 5", "[grow]", ""));
        this.btnPrint = new PosButton(POSConstants.PRINT);
        this.btnFinish = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
        this.btnDrawerBleed = new PosButton(POSConstants.DRAWER_BLEED);
        this.btnNoSale = new PosButton(Messages.getString("ManagerDialog.1"));
        this.btnPayout = new PosButton(POSConstants.PAYOUT_BUTTON_TEXT);
        this.btnCloseDrawer = new PosButton(Messages.getString("CashDrawerReportDialog.6"));
        this.btnDrawerBleed.addActionListener(this);
        this.btnNoSale.addActionListener(this);
        this.btnPayout.addActionListener(this);
        this.btnCloseDrawer.addActionListener(e -> this.doCloseCashDrawer());
        this.btnCloseStaffBank = new PosButton(Messages.getString("CloseStaffBank"));
        this.btnCloseStaffBank.addActionListener(e -> this.doCloseStaffBank());
        this.btnDeclareTips = new PosButton(Messages.getString("DeclareTips"));
        this.btnDeclareTips.addActionListener(e -> this.doAddTips());
        this.btnEncashTips = new PosButton(Messages.getString("CashDrawerReportDialog.9"));
        this.btnEncashTips.addActionListener(e -> this.doAddEncashTips());
        this.serverLeftActionPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,ins 0 20 0 20,wrap 1", "[120px,grow]", ""));
        this.buttonPanel.add((Component)new JSeparator(), "grow,span,wrap");
        this.buttonPanel.add((Component)this.btnPrint, "gapleft 160,grow");
        this.btnTransactionDetails = new PosButton(POSConstants.DETAILS);
        this.btnTransactionDetails.addActionListener(e -> this.showTransactionDetails());
        this.btnTransferUser = new PosButton(Messages.getString("CashDrawerReportDialog.0"));
        this.btnTransferUser.addActionListener(e -> this.showTransferUserDialog());
        this.serverLeftActionPanel.add((Component)this.btnDrawerBleed, "grow");
        this.serverLeftActionPanel.add((Component)this.btnNoSale, "grow");
        this.serverLeftActionPanel.add((Component)this.btnPayout, "grow");
        this.buttonPanel.add((Component)this.btnTransactionDetails, "grow");
        this.buttonPanel.add((Component)this.btnTransferUser, "grow");
        this.buttonPanel.add((Component)this.btnCloseDrawer, "grow");
        this.buttonPanel.add((Component)this.btnCloseStaffBank, "grow");
        this.serverLeftActionPanel.add((Component)this.btnEncashTips, "grow");
        this.buttonPanel.add((Component)this.btnFinish, "grow");
        this.add((Component)this.buttonPanel, "South");
        this.add((Component)this.serverLeftActionPanel, "West");
        this.btnFinish.addActionListener(e -> this.doCloseDialog());
        this.btnPrint.addActionListener(e -> this.doPrintReport());
    }

    public void refreshReport() throws Exception {
        this.createReport(!this.showInfoOnly);
        this.updateView();
    }

    private void showTransferUserDialog() {
        try {
            UserListDialog dialog = new UserListDialog();
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            User assignToUser = dialog.getSelectedUser();
            if (!assignToUser.isClockedIn().booleanValue()) {
                POSMessageDialog.showError(Messages.getString("DrawerAssignmentAction.16"));
                return;
            }
            CashDrawerDAO instance = CashDrawerDAO.getInstance();
            instance.refresh(this.cashDrawer);
            String assignedOldUserId = this.cashDrawer.getAssignedUserId();
            if (assignedOldUserId.equals(assignToUser.getId())) {
                POSMessageDialog.showError(Messages.getString("CashDrawerReportDialog.1"));
                return;
            }
            instance.transferUser(this.cashDrawer, assignToUser);
            POSMessageDialog.showMessage(Messages.getString("DrawerAssignmentAction.8") + " " + assignToUser.getFullName());
            this.refreshReport();
            this.logTransferUserJournal(this.cashDrawer, assignedOldUserId);
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }

    private void logTransferUserJournal(CashDrawer currentCashDrawer, String oldUserId) {
        try {
            String actionMessage = String.format("Drawer id : %s is transfered from user %s to user %s", currentCashDrawer.getId(), oldUserId, currentCashDrawer.getAssignedUserId());
            ActionHistoryDAO.saveHistory(this.currentUser, "Cash drawer assignment change", actionMessage);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void showTransactionDetails() {
        try {
            if (this.cashDrawer == null) {
                return;
            }
            this.doShowTransactionInfoReport();
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private void doShowTransactionInfoReport() throws Exception {
        this.buildTerminalDetailsTransationReport();
        DetailReportDialog dialog = new DetailReportDialog(this.terminalSummryDetailsJasperPrint);
        dialog.setTitle(this.cashDrawer.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? Messages.getString("CashDrawerReportDialog.13") : Messages.getString("CashDrawerReportDialog.14"));
        dialog.updateView();
        dialog.open();
    }

    private void buildTerminalDetailsTransationReport() throws JRException {
        ArrayList<PosTransaction> allTransactionsList = new ArrayList<PosTransaction>();
        if (this.drawerReports != null && this.drawerReports.size() > 0) {
            for (CashDrawer cashDrawer : this.drawerReports) {
                List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(cashDrawer.getId(), false);
                allTransactionsList.addAll(transactions);
            }
        } else {
            List<PosTransaction> transactions = PosTransactionDAO.getInstance().findTransactionsForCashDrawer(this.cashDrawer.getId(), false);
            allTransactionsList.addAll(transactions);
        }
        CashDrawerTransactionReportModel reportModel = new CashDrawerTransactionReportModel();
        reportModel.setItems(allTransactionsList);
        HashMap<String, String> map = new HashMap<String, String>();
        Store store = DataProvider.get().getStore();
        map.put("headerLine1", store.getName());
        map.put("headerLine2", store.getAddressLine1());
        map.put("receiptType", this.cashDrawer.getType().intValue() == DrawerType.DRAWER.getTypeNumber() ? Messages.getString("CashDrawerReportDialog.13") : Messages.getString("CashDrawerReportDialog.14"));
        if (this.cashDrawer.getAssignedUser() != null) {
            map.put("serverName", Messages.getString("CashDrawerReportDialog.17") + this.cashDrawer.getAssignedUser());
        }
        map.put("startDate", Messages.getString("CashDrawerReportDialog.18") + DateUtil.formatFullDateAndTimeAsString(this.cashDrawer.getStartTime()));
        map.put("status", allTransactionsList == null || allTransactionsList.isEmpty() ? Messages.getString("NoTransactionFound") : null);
        JasperReport masterReport = ReportUtil.getReport("transaction_report_receipt");
        this.terminalSummryDetailsJasperPrint = JasperFillManager.fillReport((JasperReport)masterReport, map, (JRDataSource)new JRTableModelDataSource((TableModel)reportModel));
    }

    private void doAddTips() {
        try {
            if (this.cashDrawer == null) {
                return;
            }
            Double declaredTipsAmount = NumberSelectionDialog2.takeDoubleInput(Messages.getString("EnterTipsAmount"), Messages.getString("CashDrawerReportDialog.21"), this.cashDrawer.getTipsPaid());
            if (Double.isNaN(declaredTipsAmount)) {
                return;
            }
            this.cashDrawer.setDeclaredTips(declaredTipsAmount);
            TerminalDAO.getInstance().performBatchSave(this.cashDrawer);
            this.refreshReport();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }

    private void doAddEncashTips() {
        this.doManageGratuity();
    }

    private void doCloseDialog() {
        this.dispose();
    }

    @Override
    public void setTitle(String title) {
        this.titlePanel.setTitle(title);
        super.setTitle(VersionInfo.getAppName());
    }

    private void doPrintReport() {
        try {
            PosPrintService.printReportByJasperPrint(this.jasperPrint);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
        catch (Exception ex) {
            POSMessageDialog.showError(this, Messages.getString("DrawerPullReportDialog.122") + ex.getMessage(), ex);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            PosButton sourceBtn = (PosButton)e.getSource();
            if (sourceBtn == this.btnDrawerBleed) {
                this.doDrawerBleed();
                this.refreshReport();
            } else if (sourceBtn == this.btnNoSale) {
                this.doDrawerKick();
            } else if (sourceBtn == this.btnPayout) {
                this.doPayout();
                this.refreshReport();
            }
        }
        catch (Exception e2) {
            POSMessageDialog.showError(e2.getMessage(), e2);
        }
    }

    private void doManageGratuity() {
        GratuityDialog dialog = new GratuityDialog((Window)this, this.currentUser);
        dialog.setCaption(Messages.getString("TipsManagement"));
        dialog.setOkButtonText(Messages.getString("PAY"));
        dialog.setSize(PosUIManager.getSize(780, 550));
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        try {
            this.refreshReport();
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage(), e);
        }
    }

    private void doDrawerBleed() {
        try {
            DrawerUtil.kickDrawer();
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
            dialog.setTitle(Messages.getString("CashDropDialog.17"));
            dialog.setFloatingPoint(true);
            dialog.pack();
            dialog.open();
            if (!dialog.isCanceled()) {
                double amount = dialog.getValue();
                CashDropTransaction transaction = new CashDropTransaction();
                StoreSession storeSession = DataProvider.get().getStoreSession();
                transaction.setDrawerResetted(false);
                transaction.setTerminal(this.drawerTerminal);
                if (this.currentUser.isStaffBankStarted().booleanValue()) {
                    transaction.setCashDrawer(this.currentUser.getActiveDrawerPullReport());
                } else {
                    transaction.setCashDrawer(this.drawerTerminal.getCurrentCashDrawer());
                }
                transaction.setPaymentType(PaymentType.CASH);
                transaction.setUser(this.currentUser);
                transaction.setServer(this.currentUser);
                transaction.setTransactionTime(new Date());
                transaction.setAmount(amount);
                transaction.setStoreSessionId(storeSession.getId());
                CashDropTransactionDAO dao = new CashDropTransactionDAO();
                dao.saveNewCashDrop(transaction, this.drawerTerminal);
                this.logJournal(amount);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("CashDropDialog.18"), e);
        }
    }

    private void logJournal(double amount) {
        try {
            Terminal currentTerminal = DataProvider.get().getCurrentTerminal();
            CashDrawer currentCashDrawer = currentTerminal.getCurrentCashDrawer();
            String actionMessage = String.format("Terminal id : %s, Cash drawer id : %s, Total : %s", currentTerminal.getId(), currentCashDrawer.getId(), NumberUtil.formatNumber(amount));
            ActionHistoryDAO.saveHistory(this.currentUser, "Cash drawer bleed", actionMessage);
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
        }
    }

    private void doDrawerKick() {
        try {
            DrawerUtil.kickDrawer();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void doPayout() {
        try {
            TerminalDAO.getInstance().refresh(this.drawerTerminal);
            if (!POSUtil.checkDrawerAssignment(this.drawerTerminal, this.currentUser)) {
                return;
            }
            DrawerUtil.kickDrawer();
            PayoutDialog dialog = new PayoutDialog((Dialog)this, this.currentUser, this.drawerTerminal);
            dialog.open();
            this.refreshReport();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void doManageServerTips() {
        try {
            JPanel panel = new JPanel((LayoutManager)new MigLayout());
            List<User> users = UserDAO.getInstance().findAll();
            JXDatePicker fromDatePicker = UiUtil.getCurrentMonthStart();
            JXDatePicker toDatePicker = UiUtil.getCurrentMonthEnd();
            panel.add((Component)new JLabel(POSConstants.SELECT_USER + ":"), "grow");
            JComboBox userCombo = new JComboBox(new ListComboBoxModel(users));
            panel.add(userCombo, "grow, wrap");
            panel.add((Component)new JLabel(POSConstants.FROM + ":"), "grow");
            panel.add((Component)fromDatePicker, "wrap");
            panel.add((Component)new JLabel(POSConstants.TO_), "grow");
            panel.add((Component)toDatePicker);
            int option = JOptionPane.showOptionDialog(Application.getPosWindow(), panel, POSConstants.SELECT_CRIETERIA, 2, 3, null, null, null);
            if (option != 0) {
                return;
            }
            GratuityDAO gratuityDAO = new GratuityDAO();
            TipsCashoutReport report = gratuityDAO.createReport(fromDatePicker.getDate(), toDatePicker.getDate(), (User)userCombo.getSelectedItem());
            TipsCashoutReportDialog dialog = new TipsCashoutReportDialog(report);
            dialog.setSize(400, 600);
            dialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    private void doCloseCashDrawer() {
        try {
            DrawerUtil.kickDrawer();
            DrawerAssignmentAction drawerAction = new DrawerAssignmentAction(this.drawerTerminal, this.currentUser);
            drawerAction.execute();
            this.cashDrawer = CashDrawerDAO.getInstance().get(this.cashDrawer.getId());
            this.refreshReport();
            ActionHistoryDAO.saveHistory(this.currentUser, "Cash drawer close", "Drawer id: " + this.cashDrawer.getId());
        }
        catch (Exception ex) {
            POSMessageDialog.showError(ex.getMessage(), ex);
        }
    }

    private void doCloseStaffBank() {
        try {
            if (!this.currentUser.isClockedIn().booleanValue()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CashDrawerReportDialog.25"));
                return;
            }
            StaffBankCloseAction drawerAction = new StaffBankCloseAction(this.cashDrawer, this.currentUser);
            drawerAction.execute();
            this.cashDrawer = CashDrawerDAO.getInstance().get(this.cashDrawer.getId());
            this.refreshReport();
        }
        catch (Exception ex) {
            POSMessageDialog.showError(ex.getMessage(), ex);
        }
    }

    public void createReport(boolean calculate) throws Exception {
        this.reportViewPanel.removeAll();
        if (calculate || this.cashDrawer.getReportTime() == null) {
            CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.cashDrawer);
            cashDrawerReportService.populateReport();
        }
        this.jasperPrint = PosPrintService.populateTerminalStatusReport(this.cashDrawer);
        TicketReceiptView receiptView = new TicketReceiptView(this.jasperPrint);
        receiptView.setZoom(1.25f);
        this.reportViewPanel.add(receiptView.getReportPanel());
        this.reportViewPanel.revalidate();
        this.reportViewPanel.repaint();
    }
}

