/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;

public class DetailsInfoDialog
extends POSDialog {
    private String message;
    private String details;
    private boolean isDetailsView = false;
    private JPanel detailsPanel;

    public DetailsInfoDialog(String message, String details) {
        this.message = message;
        this.details = details;
        this.setTitle(VersionInfo.getAppName());
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3, fillx"));
        JPanel infoPanel = new JPanel((LayoutManager)new MigLayout("ins 5 5 5 50"));
        JLabel lblIcon = new JLabel(IconFactory.getIcon("/ui_icons/", "info-color.png"));
        JLabel lblMsg = new JLabel(this.message);
        PosButton btnDetails = new PosButton(Messages.getString("DetailsInfoDialog.0"));
        JTextArea txtDetails = new JTextArea(this.details);
        txtDetails.setBackground(Color.WHITE);
        txtDetails.setEditable(false);
        final JScrollPane scrollDetails = new JScrollPane(txtDetails);
        this.detailsPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 5 5 5 30"));
        this.detailsPanel.setVisible(false);
        this.detailsPanel.add((Component)scrollDetails, "grow");
        btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                DetailsInfoDialog.this.doShowDetails(scrollDetails);
            }
        });
        PosButton btnOk = new PosButton(Messages.getString("DetailsInfoDialog.7"));
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DetailsInfoDialog.this.dispose();
            }
        });
        infoPanel.add((Component)lblIcon, "grow");
        infoPanel.add((Component)lblMsg, "grow, wrap");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 5 5 5 30"));
        buttonPanel.add((Component)btnOk, "right, split 2");
        buttonPanel.add(btnDetails);
        mainPanel.add((Component)infoPanel, "grow, wrap");
        mainPanel.add((Component)buttonPanel, "grow, wrap");
        mainPanel.add((Component)this.detailsPanel, "grow");
        this.getContentPane().add((Component)mainPanel, "Center");
    }

    private void doShowDetails(JScrollPane scrollDetails) {
        try {
            if (!this.isDetailsView) {
                this.isDetailsView = true;
                this.detailsPanel.setVisible(this.isDetailsView);
            } else {
                this.isDetailsView = false;
                this.detailsPanel.setVisible(this.isDetailsView);
            }
            this.pack();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
    }
}

