/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class TaxSelectionDialog
extends POSDialog {
    private JXTable table;
    private BeanTableModel<Tax> tableModel;
    private List<Tax> selectedTaxes;
    private TaxGroup taxGroup;

    public TaxSelectionDialog(TaxGroup taxGroup) {
        super(POSUtil.getFocusedWindow(), "");
        this.taxGroup = taxGroup;
        this.init();
        List<Tax> taxList = TaxDAO.getInstance().findAll();
        List<Tax> existingTaxs = null;
        if (taxGroup != null) {
            existingTaxs = taxGroup.getTaxes();
        }
        if (existingTaxs != null) {
            for (Tax tax : taxList) {
                if (!existingTaxs.contains(tax)) continue;
                tax.setEnable(true);
            }
        }
        this.tableModel.setRows(taxList);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle(Messages.getString("TaxSelectionDialog.1"));
        TitlePanel titelpanel = new TitlePanel();
        titelpanel.setTitle(Messages.getString("TaxSelectionDialog.2") + this.taxGroup.getName());
        this.add((Component)titelpanel, "North");
        this.tableModel = new BeanTableModel<Tax>(Tax.class){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                Tax tax;
                if (columnIndex == 2 && (tax = (Tax)TaxSelectionDialog.this.tableModel.getRow(rowIndex)) != null) {
                    return NumberUtil.format6DigitNumber(tax.getRate()) + "%";
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        };
        this.tableModel.addColumn("", "enable");
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.addColumn(Messages.getString("TaxSelectionDialog.0"), "rate");
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setTableHeader(null);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setShowGrid(true, false);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    TaxSelectionDialog.this.editSelectedRow();
                } else {
                    TaxSelectionDialog.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        JScrollPane scroll = new JScrollPane((Component)this.table);
        contentPanel.add(scroll);
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        this.add((Component)this.createButtonPanel(), "South");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        JButton btnOk = new JButton(Messages.getString("DONE"));
        btnOk.setHorizontalTextPosition(4);
        btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxSelectionDialog.this.doOk();
            }
        });
        JButton btnCancel = new JButton(POSConstants.CANCEL);
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxSelectionDialog.this.setCanceled(true);
                TaxSelectionDialog.this.dispose();
            }
        });
        btnAdd.setText(Messages.getString("TaxSelectionDialog.7"));
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaxSelectionDialog.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Tax tax = new Tax();
                    TaxForm editor = new TaxForm(tax);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Tax item = (Tax)editor.getBean();
                    TaxSelectionDialog.this.tableModel.addRow(item);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        btnOk.setBackground(Color.GREEN);
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0 0 5 0", "sg,fill", ""));
        int h = PosUIManager.getSize(40);
        panel.add((Component)btnAdd, "h " + h);
        panel.add((Component)btnOk, "h " + h);
        panel.add((Component)btnCancel, "h " + h);
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(50);
        columnWidth.add(250);
        columnWidth.add(50);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Tax tax = this.tableModel.getRow(index);
            this.tableModel.setRow(index, tax);
            TaxForm editor = new TaxForm(tax);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doOk() {
        try {
            this.selectedTaxes = new ArrayList<Tax>();
            List<Tax> items = this.tableModel.getRows();
            for (Tax tax : items) {
                if (!tax.isEnable().booleanValue()) continue;
                this.selectedTaxes.add(tax);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<Tax> getSelectedTaxList() {
        return this.selectedTaxes;
    }

    private void selectItem() {
        Tax tax;
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        tax.setEnable((tax = this.tableModel.getRow(selectedRow = this.table.convertRowIndexToModel(selectedRow))).isEnable() == false);
        this.table.repaint();
    }
}

