/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.TipSuggestion;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import liquibase.util.StringUtils;
import net.miginfocom.swing.MigLayout;

public class TipsSuggestionDialog
extends OkCancelOptionDialog {
    private JLabel lblTipsPercentage;
    private JLabel lblTipsSortOrder;
    private DoubleTextField tfTipsPercentage;
    private IntegerTextField tfTipsSortOrder;
    private TipSuggestion tipSuggestion;

    public TipsSuggestionDialog(String title) {
        this.setModal(true);
        this.setTitle(title);
        this.setCaption(title);
        this.initComponents();
    }

    private void initComponents() {
        JPanel mainPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.lblTipsPercentage = new JLabel(Messages.getString("TipsPercenage"));
        this.tfTipsPercentage = new DoubleTextField();
        this.lblTipsSortOrder = new JLabel(POSConstants.SORT_ORDER + ":");
        this.tfTipsSortOrder = new IntegerTextField();
        mainPanel.add((Component)this.lblTipsPercentage, "split 2");
        mainPanel.add((Component)this.tfTipsPercentage, "growx,wrap");
        mainPanel.add((Component)this.lblTipsSortOrder, "split 2");
        mainPanel.add((Component)this.tfTipsSortOrder, "growx,wrap");
        this.add(mainPanel);
    }

    @Override
    public void doOk() {
        double tipsPercentage = this.tfTipsPercentage.getDouble();
        int tipsSortOrder = this.tfTipsSortOrder.getInteger();
        if (StringUtils.isEmpty((String)String.valueOf(tipsPercentage))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("TipsCantNotEmpty"));
            return;
        }
        this.tipSuggestion = new TipSuggestion();
        this.tipSuggestion.setPercentage(tipsPercentage);
        this.tipSuggestion.setSortOrder(tipsSortOrder);
        this.setCanceled(false);
        this.dispose();
    }

    public TipSuggestion getTipSuggestion() {
        return this.tipSuggestion;
    }

    public void setTipsPercentage(double percentage) {
        this.tfTipsPercentage.setText(String.valueOf(percentage));
    }

    public void setTipsSortOrder(int sortOrder) {
        this.tfTipsSortOrder.setText(String.valueOf(sortOrder));
    }
}

