/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.UploadPaymentSyncableAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.clubmember.ClubMemberSelectionPane;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.GratuityDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.MultiSelectionOverflowCombobox;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TitledView;
import com.floreantpos.ui.dialog.DateSelectionDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.foretees.salesforce.sync.PaymentSyncable;
import com.foretees.salesforce.sync.SFResetAction;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SyncDialog;
import com.foretees.salesforce.sync.SyncErrorInfoDialogNew;
import com.foretees.salesforce.sync.SyncErrorItemsInfoDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class UploadSfTicketsDialog
extends POSDialog {
    public static SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
    JTabbedPane tabbedPane;
    private JLabel lblNumberOfItem;
    private List<Object> items;
    private PosButton btnUploadAll = new PosButton(Messages.getString("UploadPaymentDialog.0"));
    private PosButton btnUploadTen = new PosButton(Messages.getString("UploadSfTicketsDialog.5"));
    private String gratuityItemId;
    private User currentUser;
    private JTextField tfSearchField;
    private MultiSelectComboBox<OrderType> cbOrderTypes;
    private TreeMap<Date, List<Object>> ticketMap;
    private Map<TicketListPanel, Date> ticketMapKeys;

    public UploadSfTicketsDialog(User currentUser, List<Object> items) {
        super(POSUtil.getFocusedWindow(), Messages.getString("UploadSfTicketsDialog.0"), true);
        this.currentUser = currentUser;
        this.items = items;
        this.initComponents();
        this.updateData();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        TitledView titledView = new TitledView(Messages.getString("UploadPaymentDialog.1"));
        JPanel titleContentPane = titledView.getContentPane();
        titleContentPane.setLayout((LayoutManager)new MigLayout());
        this.tfSearchField = new JTextField(30);
        this.tfSearchField.addActionListener(event -> this.doSearch(this.tfSearchField.getText()));
        JButton btnSearch = new JButton(Messages.getString("UploadSfTicketsDialog.1"));
        btnSearch.addActionListener(event -> this.doSearch(this.tfSearchField.getText()));
        JButton btnClearSearch = new JButton(Messages.getString("UploadSfTicketsDialog.2"));
        btnClearSearch.addActionListener(event -> this.doClearSearch());
        this.cbOrderTypes = new MultiSelectionOverflowCombobox<OrderType>();
        this.cbOrderTypes.setItems(OrderTypeDAO.getInstance().findAll());
        titleContentPane.add((Component)new JLabel(Messages.getString("UploadSfTicketsDialog.3")), "grow");
        titleContentPane.add((Component)this.tfSearchField, "grow");
        titleContentPane.add(this.cbOrderTypes, "grow");
        titleContentPane.add((Component)btnSearch, "grow");
        titleContentPane.add((Component)btnClearSearch, "grow, wrap");
        this.add((Component)titledView, "North");
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setTabLayoutPolicy(1);
        JPanel centerLayout = new JPanel((LayoutManager)new MigLayout("fill, ins 10"));
        centerLayout.add((Component)this.tabbedPane, "grow, wrap");
        this.lblNumberOfItem = new JLabel();
        centerLayout.add((Component)this.lblNumberOfItem, "right, split 3");
        this.add((Component)centerLayout, "Center");
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3"));
        PosButton btnSetSynced = new PosButton(Messages.getString("UploadPaymentDialog.6"));
        PosButton btnSetMenuItem = new PosButton(Messages.getString("UploadPaymentDialog.7"));
        PosButton btnSetMember = new PosButton(Messages.getString("UploadPaymentDialog.8"));
        PosButton btnSetGratuity = new PosButton(Messages.getString("UploadPaymentDialog.9"));
        PosButton btnSetGratuityAmount = new PosButton(Messages.getString("UploadPaymentDialog.56"));
        PosButton btnSetEmployee = new PosButton(Messages.getString("UploadPaymentDialog.10"));
        btnSetSynced.addActionListener(ev -> this.doMarkAsSynced());
        btnSetMenuItem.addActionListener(ev -> this.doSetMenuItem());
        btnSetMember.addActionListener(ev -> this.doSetMember());
        btnSetGratuity.addActionListener(ev -> this.doSetGratuity());
        btnSetGratuityAmount.addActionListener(ev -> this.doSetGratuityAmount());
        btnSetEmployee.addActionListener(ev -> this.doSetEmployee());
        PosButton cancelButton = new PosButton(POSConstants.CLOSE);
        PosButton btnSyncErrLog = new PosButton(Messages.getString("UploadPaymentDialog.12"));
        PosButton btnSetDate = new PosButton(Messages.getString("UploadPaymentDialog.13"));
        PosButton btnReset = new PosButton(Messages.getString("UploadPaymentDialog.23"));
        PosButton btnSyncErrorNew = new PosButton("Sync error (New)");
        cancelButton.addActionListener(e -> this.doClose());
        btnSyncErrLog.addActionListener(ev -> this.doShowSyncErrLog());
        this.btnUploadAll.addActionListener(ev -> this.doUploadAll());
        this.btnUploadTen.addActionListener(ev -> this.doUploadMultipleItems());
        btnSetDate.addActionListener(ev -> this.doUpdateDateOfSelectedItem());
        btnReset.addActionListener(e -> this.doReset(e));
        btnSyncErrorNew.addActionListener(e -> this.showNewSyncErrorLog());
        bottomPanel.add((Component)btnSyncErrorNew, "left");
        bottomPanel.add((Component)btnSyncErrLog, "left");
        bottomPanel.add((Component)btnSetSynced, "center, split 7");
        bottomPanel.add(btnSetMenuItem);
        bottomPanel.add(btnSetMember);
        bottomPanel.add(btnSetGratuity);
        bottomPanel.add(btnSetGratuityAmount);
        bottomPanel.add(btnSetEmployee);
        bottomPanel.add(btnSetDate);
        bottomPanel.add((Component)btnReset, "right, split 5");
        if (DataProvider.get().getStore().isEnableMultiUploadButton()) {
            bottomPanel.add(this.btnUploadTen);
        }
        bottomPanel.add(cancelButton);
        this.add((Component)bottomPanel, "South");
    }

    private void showNewSyncErrorLog() {
        SyncErrorInfoDialogNew dialogNew = new SyncErrorInfoDialogNew();
        dialogNew.openFullScreen();
    }

    public void updateData() {
        try {
            this.tabbedPane.removeAll();
            this.ticketMap = new TreeMap(new Comparator<Date>(){

                @Override
                public int compare(Date o1, Date o2) {
                    return o2.compareTo(o1);
                }
            });
            try {
                Collections.sort(this.items, new Comparator<Object>(){

                    @Override
                    public int compare(Object o1, Object o2) {
                        Ticket ticket = UploadSfTicketsDialog.this.getTicket(o1);
                        Ticket ticket2 = UploadSfTicketsDialog.this.getTicket(o2);
                        if (ticket == null || ticket2 == null) {
                            return 0;
                        }
                        if (ticket.getId() != null && ticket2.getId() != null) {
                            return ticket.getId().compareTo(ticket2.getId());
                        }
                        return 0;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (Object object : this.items) {
                Ticket ticket = this.getTicket(object);
                if (ticket == null || ticket.isVoided().booleanValue()) continue;
                Date createDate = ticket.getCreateDate();
                if (object instanceof RefundTransaction) {
                    createDate = ((RefundTransaction)object).getTransactionTime();
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(createDate);
                calendar.set(14, 0);
                calendar.set(13, 0);
                calendar.set(12, 0);
                calendar.set(10, 0);
                calendar.set(9, 0);
                createDate = calendar.getTime();
                List<Object> list = this.ticketMap.get(createDate);
                if (list == null) {
                    list = new ArrayList<Object>();
                    this.ticketMap.put(createDate, list);
                }
                if (object instanceof Gratuity) {
                    Gratuity gratuity = (Gratuity)object;
                    this.updateGratuityItem(gratuity);
                }
                list.add(object);
            }
            Set<Date> keySet = this.ticketMap.keySet();
            this.ticketMapKeys = new HashMap<TicketListPanel, Date>();
            for (Date key : keySet) {
                List<Object> list = this.ticketMap.get(key);
                TicketListPanel ticketListPanel = new TicketListPanel(key, list);
                this.tabbedPane.add(dateFormat.format(key), ticketListPanel);
                this.ticketMapKeys.put(ticketListPanel, key);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage());
        }
    }

    private void updateGratuityItem(Gratuity gratuity) {
        if (StringUtils.isEmpty((String)this.gratuityItemId)) {
            MenuItem gratuityItem = MenuItemDAO.getInstance().findByName("Gratuity");
            if (gratuityItem == null) {
                return;
            }
            this.gratuityItemId = gratuityItem.getId();
        }
        gratuity.getTicket().addExtraProperty("salesforce.gratuity.item.id", this.gratuityItemId);
    }

    private Ticket getTicket(Object object) {
        Ticket ticket = null;
        if (object instanceof TicketItem) {
            ticket = ((TicketItem)object).getTicket();
        } else if (object instanceof Gratuity) {
            ticket = ((Gratuity)object).getTicket();
        }
        if (object instanceof PosTransaction) {
            ticket = ((PosTransaction)object).getTicket();
        }
        return ticket;
    }

    private void doSearch(String searchKey) {
        TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
        if (ticketListPanel == null) {
            return;
        }
        List<String> orderTypesIds = this.getSelectedOrderTypesIds();
        Date key = this.ticketMapKeys.get(ticketListPanel);
        ArrayList<Object> objects = new ArrayList<Object>((Collection)this.ticketMap.get(key));
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            String customerName;
            OrderType orderType;
            Object object = iterator.next();
            Ticket ticket = this.getTicket(object);
            OrderType orderType2 = orderType = ticket == null ? null : ticket.getOrderType();
            if (orderType != null && !orderTypesIds.isEmpty() && !orderTypesIds.contains(orderType.getId())) {
                iterator.remove();
                continue;
            }
            if (ticket != null && ticket.getId() != null && ticket.getId().contains(searchKey) || (customerName = ticket.getCustomerName()) != null && customerName.toUpperCase().contains(searchKey.toUpperCase())) continue;
            iterator.remove();
        }
        ticketListPanel.objects = objects;
        ticketListPanel.tableModel.setRows(ticketListPanel.objects);
        this.updateTableModel();
    }

    private void doClearSearch() {
        this.tfSearchField.setText(null);
        this.cbOrderTypes.unselectAllItems();
        this.cbOrderTypes.repaint();
        this.doSearch("");
    }

    private List<String> getSelectedOrderTypesIds() {
        ComboBoxModel m = (ComboBoxModel)this.cbOrderTypes.getModel();
        List items = m.getDataList();
        ArrayList<String> selectedItems = new ArrayList<String>();
        for (Object item : items) {
            MultiSelectComboBox.CheckableItem obj2 = (MultiSelectComboBox.CheckableItem)item;
            if (obj2.item instanceof String || !obj2.isSelected()) continue;
            OrderType orderType = (OrderType)obj2.getItem();
            selectedItems.add(orderType.getId());
        }
        return selectedItems;
    }

    public void doUploadSelectedItem() {
        try {
            TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
            if (ticketListPanel == null) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.40"));
                return;
            }
            int row = ticketListPanel.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            List<Object> objectList = ticketListPanel.objects;
            Object object = objectList.get(row);
            ArrayList<Object> objects = new ArrayList<Object>();
            objects.add(object);
            PaymentSyncable paymentSyncable = new PaymentSyncable(objects);
            SyncDialog dialog = new SyncDialog(paymentSyncable);
            paymentSyncable.setSyncView(dialog);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            if (!paymentSyncable.hasSyncError) {
                ticketListPanel.tableModel.deleteItem(object);
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.41"));
            } else {
                Map<String, String> errorMap = paymentSyncable.getErrorMap();
                if (object instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)object;
                    ticketItem.setSyncEdited(true);
                    String error = errorMap.get(ticketItem.getId());
                    POSMessageDialog.showError(this, error);
                } else if (object instanceof Gratuity) {
                    Gratuity gratuity = (Gratuity)object;
                    gratuity.setSyncEdited(true);
                    String error = errorMap.get(gratuity.getId());
                    POSMessageDialog.showError(this, error);
                } else if (object instanceof PosTransaction) {
                    PosTransaction posTransaction = (PosTransaction)object;
                    posTransaction.setSyncEdited(true);
                    String error = errorMap.get(posTransaction.getId());
                    POSMessageDialog.showError(this, error);
                }
            }
            if (ticketListPanel.objects.size() == 0) {
                this.tabbedPane.remove(ticketListPanel);
            }
            ticketListPanel.tableModel.fireTableDataChanged();
            ticketListPanel.table.repaint();
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void doUpdateDateOfSelectedItem() {
        try {
            TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
            if (ticketListPanel == null) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.40"));
                return;
            }
            int row = ticketListPanel.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            List<Object> objectList = ticketListPanel.objects;
            Object object = objectList.get(row);
            if (object == null) {
                return;
            }
            Ticket ticket = this.getTicket(object);
            this.doSetDateFromDialog(ticket);
            this.updateTableModel();
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSetDateFromDialog(Ticket ticket) {
        DateSelectionDialog dateSelectionDialog = new DateSelectionDialog(ticket.getCreateDate());
        dateSelectionDialog.setTitle(VersionInfo.getAppName());
        dateSelectionDialog.setCaption(Messages.getString("UploadPaymentDialog.13"));
        dateSelectionDialog.setSize(PosUIManager.getSize(350, 250));
        dateSelectionDialog.open();
        if (dateSelectionDialog.isCanceled()) {
            return;
        }
        Date selectedDate = dateSelectionDialog.getSelectedDate();
        if (selectedDate == null) {
            return;
        }
        Date oldcreateDate = ticket.getCreateDate();
        ticket.setCreateDate(selectedDate);
        this.updateTicketDate(ticket, selectedDate);
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm:ss Z");
        sb.append("Ticket: " + ticket.getId());
        sb.append(". Prev date: " + dateFormat.format(oldcreateDate));
        sb.append(". New date: " + dateFormat.format(selectedDate));
        ActionHistoryDAO.saveHistory(this.currentUser, ticket, "Sf sync date change", sb.toString());
        this.doSetDateForAllItems(ticket, selectedDate);
    }

    private void updateTicketDate(Ticket ticket, Date selectedDate) {
        Ticket fullTicket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        fullTicket.setCreateDate(selectedDate);
        List<TicketItem> ticketItems = fullTicket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            ticketItem.setCreateDate(selectedDate);
            if (!ticketItem.isVoided().booleanValue() || ticketItem.getVoidDate() == null) continue;
            ticketItem.setVoidDate(selectedDate);
        }
        Set<PosTransaction> transactions = fullTicket.getTransactions();
        for (PosTransaction posTransaction : transactions) {
            posTransaction.setTransactionTime(selectedDate);
        }
        TicketDAO.getInstance().update(fullTicket);
    }

    private void doSetDateForAllItems(Ticket ticket, Date selectedDate) {
        TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
        if (ticketListPanel == null) {
            POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.40"));
            return;
        }
        for (Object obj : ticketListPanel.tableModel.getRows()) {
            Gratuity gratuity;
            if (obj instanceof PosTransaction) {
                PosTransaction transaction = (PosTransaction)obj;
                if (transaction.getTicketId().equals(ticket.getId())) {
                    transaction.setTransactionTime(selectedDate);
                    transaction.getTicket().setCreateDate(selectedDate);
                    transaction.setSyncEdited(true);
                }
            } else if (obj instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)obj;
                if (ticketItem.getTicket().getId().equals(ticket.getId())) {
                    ticketItem.getTicket().setCreateDate(selectedDate);
                    if (ticketItem.isVoided().booleanValue() && ticketItem.getVoidDate() != null) {
                        ticketItem.setVoidDate(selectedDate);
                    }
                    ticketItem.setSyncEdited(true);
                }
            } else if (obj instanceof Gratuity && (gratuity = (Gratuity)obj).getTicket().getId().equals(ticket.getId())) {
                gratuity.getTicket().setCreateDate(selectedDate);
                gratuity.setSyncEdited(true);
            }
            this.updateTableModel();
        }
    }

    private void doShowSyncErrLog() {
        try {
            SyncErrorItemsInfoDialog paymentDialog = new SyncErrorItemsInfoDialog();
            paymentDialog.openFullScreen();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doUploadAll() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("UploadSfTicketsDialog.7"));
            if (option != 0) {
                return;
            }
            TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
            if (ticketListPanel == null) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.40"));
                return;
            }
            ArrayList<Object> objectsToUpload = new ArrayList<Object>(ticketListPanel.objects);
            UploadPaymentSyncableAction action = new UploadPaymentSyncableAction(ticketListPanel.objects);
            action.execute();
            ticketListPanel.tableModel.fireTableDataChanged();
            if (ticketListPanel.objects.size() == 0) {
                List<Object> list = this.ticketMap.get(ticketListPanel.date);
                list.removeAll(objectsToUpload);
                if (list.size() == 0) {
                    this.tabbedPane.remove(ticketListPanel);
                }
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doUploadMultipleItems() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("UploadSfTicketsDialog.7"));
            if (option != 0) {
                return;
            }
            TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
            if (ticketListPanel == null) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.40"));
                return;
            }
            int numItemsToUpload = 100;
            if (Application.getInstance().isDevelopmentMode()) {
                numItemsToUpload = (int)NumberSelectionDialog2.takeIntInput(Messages.getString("UploadSfTicketsDialog.6"), numItemsToUpload);
                if (numItemsToUpload < 0) {
                    return;
                }
                if (numItemsToUpload == 0) {
                    POSMessageDialog.showError(Messages.getString("UploadSfTicketsDialog.10"));
                    return;
                }
            }
            UploadPaymentSyncableAction action = new UploadPaymentSyncableAction(ticketListPanel.objects, numItemsToUpload);
            action.execute();
            List<Object> lists = this.ticketMap.get(ticketListPanel.date);
            Iterator<Object> iterator = lists.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!this.isCloudSyncedOrHasSyncError(object)) continue;
                iterator.remove();
            }
            ticketListPanel.tableModel.fireTableDataChanged();
            if (lists.size() == 0) {
                this.tabbedPane.remove(ticketListPanel);
            }
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private boolean isCloudSyncedOrHasSyncError(Object object) {
        boolean cloudSynced = false;
        if (object instanceof TicketItem) {
            cloudSynced = ((TicketItem)object).isCloudSynced() != false || ((TicketItem)object).isHasSyncError() != false;
        } else if (object instanceof Gratuity) {
            boolean bl = cloudSynced = ((Gratuity)object).isCloudSynced() != false || ((Gratuity)object).isHasSyncError() != false;
        }
        if (object instanceof PosTransaction) {
            cloudSynced = ((PosTransaction)object).isCloudSynced() != false || ((PosTransaction)object).isHasSyncError() != false;
        }
        return cloudSynced;
    }

    private void doReset(ActionEvent e) {
        int option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("UploadSfTicketsDialog.8"), Messages.getString("UploadSfTicketsDialog.9"));
        if (option != 0) {
            return;
        }
        new SFResetAction().actionPerformed(e);
    }

    private void doUploadSeperately() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(Messages.getString("UploadSfTicketsDialog.7"));
            if (option != 0) {
                return;
            }
            TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
            if (ticketListPanel == null) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.40"));
                return;
            }
            ArrayList<Object> objectsToUpload = new ArrayList<Object>(ticketListPanel.objects);
            UploadPaymentSyncableAction action = new UploadPaymentSyncableAction(ticketListPanel.objects, true);
            action.execute();
            ticketListPanel.tableModel.fireTableDataChanged();
            if (ticketListPanel.objects.size() == 0) {
                List<Object> list = this.ticketMap.get(ticketListPanel.date);
                list.removeAll(objectsToUpload);
                if (list.size() == 0) {
                    this.tabbedPane.remove(ticketListPanel);
                }
            }
            SFUtil.postFJLAmountSfService();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private Object getRowFromTable() {
        TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
        if (ticketListPanel == null) {
            POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.46"));
            return null;
        }
        int index = ticketListPanel.table.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.47"));
            return null;
        }
        List<Object> objectList = ticketListPanel.objects;
        Object object = objectList.get(index);
        if (object == null) {
            return null;
        }
        return object;
    }

    private void doMarkAsSynced() {
        try {
            TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
            if (ticketListPanel == null) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.48"));
                return;
            }
            int row = ticketListPanel.table.getSelectedRow();
            if (row < 0) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("UploadPaymentDialog.49"), Messages.getString("UploadPaymentDialog.50"));
            if (option != 0) {
                return;
            }
            List<Object> objectList = ticketListPanel.objects;
            Object object = objectList.get(row);
            Ticket ticket = this.getTicket(object);
            StringBuilder des = new StringBuilder();
            des.append("Ticket: " + ticket.getId());
            if (object instanceof TicketItem) {
                TicketItem ticketItem = (TicketItem)object;
                ticketItem.setCloudSynced(true);
                TicketItem ticketItem2 = TicketItemDAO.getInstance().get(ticketItem.getId());
                ticketItem2.setCloudSynced(true);
                TicketItemDAO.getInstance().update(ticketItem2);
                des.append(". Item: " + ticketItem.getId());
            } else if (object instanceof Gratuity) {
                Gratuity gratuity = (Gratuity)object;
                gratuity.setCloudSynced(true);
                Gratuity gratuity2 = GratuityDAO.getInstance().get(gratuity.getId());
                gratuity2.setCloudSynced(true);
                GratuityDAO.getInstance().update(gratuity2);
                des.append(". Gratuity: " + gratuity.getId());
            } else if (object instanceof PosTransaction) {
                PosTransaction posTransaction = (PosTransaction)object;
                posTransaction.setCloudSynced(true);
                PosTransaction posTransaction2 = PosTransactionDAO.getInstance().get(posTransaction.getId());
                posTransaction2.setCloudSynced(true);
                posTransaction2.setHasSyncError(false);
                PosTransactionDAO.getInstance().update(posTransaction2);
                des.append(". Transaction: " + posTransaction.getId());
            }
            ticketListPanel.tableModel.deleteItem(object);
            POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.51"));
            ticketListPanel.tableModel.fireTableDataChanged();
            ticketListPanel.table.repaint();
            ActionHistoryDAO.saveHistory(this.currentUser, "Sf sync marked as sync", des.toString());
        }
        catch (Exception x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSetMenuItem() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            if (object instanceof PosTransaction) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.52"));
                return;
            }
            if (object instanceof Gratuity) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.53"));
                return;
            }
            TicketItem ticketItem = (TicketItem)object;
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            dialog.setSelectionMode(0);
            dialog.setHideEditButton(true);
            dialog.setSize(PosUIManager.getSize(600, 515));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem menuItem = dialog.getSelectedRowData();
            ticketItem.setMenuItemId(menuItem.getId());
            ticketItem.setName(menuItem.getName());
            ticketItem.setSyncEdited(true);
            Ticket ticket = ticketItem.getTicket();
            Ticket fullTicket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            TicketItem ticketItem2 = this.getTicketItem(ticketItem.getId(), fullTicket);
            ticketItem2.setMenuItemId(menuItem.getId());
            ticketItem2.setName(menuItem.getName());
            ticketItem2.setSyncEdited(true);
            TicketDAO.getInstance().update(fullTicket);
            String description = String.format("Ticket: %s, ticket item: %s", ticketItem.getTicket().getId(), ticketItem.getId());
            ActionHistoryDAO.saveHistory(this.currentUser, "Sf sync menu item change", description);
            this.updateTableModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doSetMember() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            Ticket ticket = this.getTicket(object);
            if (ticket == null) {
                return;
            }
            String oldMemberId = ticket.getCustomerId();
            CustomerSelectorDialog dialog = new CustomerSelectorDialog(new ClubMemberSelectionPane(null));
            dialog.setCreateNewTicket(false);
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            Customer customer = dialog.getSelectedCustomer();
            String customerId = customer.getId();
            ticket.setCustomer(null);
            this.setCustomer(customer, ticket);
            ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            this.setCustomer(customer, ticket);
            for (Object obj : this.items) {
                Gratuity gratuity;
                Ticket ticket2;
                if (obj instanceof PosTransaction) {
                    PosTransaction transaction = (PosTransaction)obj;
                    if (!transaction.getTicketId().equals(ticket.getId())) continue;
                    transaction.setCustomerId(customerId);
                    transaction.setSyncEdited(true);
                    PosTransaction ticketTransaction = this.getTicketTransaction(transaction.getId(), ticket);
                    ticketTransaction.setCustomerId(customerId);
                    ticketTransaction.setSyncEdited(true);
                    continue;
                }
                if (obj instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)obj;
                    if (ticket == null || ticketItem.getTicket() == null || !ticketItem.getTicket().getId().equals(ticket.getId())) continue;
                    ticket2 = ticketItem.getTicket();
                    this.setCustomer(customer, ticket2);
                    ticketItem.setSyncEdited(true);
                    this.getTicketItem(ticketItem.getId(), ticket).setSyncEdited(true);
                    continue;
                }
                if (!(obj instanceof Gratuity) || !(gratuity = (Gratuity)obj).getTicket().getId().equals(ticket.getId())) continue;
                ticket2 = gratuity.getTicket();
                this.setCustomer(customer, ticket2);
                gratuity.setSyncEdited(true);
                ticket.getGratuity().setSyncEdited(true);
            }
            TicketDAO.getInstance().update(ticket);
            String description = String.format("Ticket: %s, old member: %s, new member: %s", ticket.getId(), oldMemberId, customerId);
            ActionHistoryDAO.saveHistory(this.currentUser, ticket, "Sf sync member change", description);
            this.updateTableModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void setCustomer(Customer customer, Ticket ticket) {
        ticket.setCustomerId(customer.getId());
        ticket.addProperty("CUSTOMER_ID", String.valueOf(customer.getId()));
        ticket.addProperty("CUSTOMER_NAME", customer.getFirstName());
        ticket.addProperty("CUSTOMER_LAST_NAME", customer.getLastName());
        ticket.addProperty("CUSTOMER_MOBILE", customer.getMobileNo());
        ticket.addProperty("CUSTOMER_ZIP_CODE", customer.getZipCode());
        ticket.addProperty("customer.taxExempt", customer.isTaxExempt().toString());
    }

    private void doSetGratuity() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            if (object instanceof PosTransaction) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.54"));
                return;
            }
            if (object instanceof TicketItem) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.55"));
                return;
            }
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            dialog.setSelectionMode(0);
            dialog.setSize(PosUIManager.getSize(600, 515));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem menuItem = dialog.getSelectedRowData();
            if (menuItem == null) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.21"));
                return;
            }
            Gratuity gratuity = (Gratuity)object;
            gratuity.getTicket().addExtraProperty("salesforce.gratuity.item.id", menuItem.getId());
            this.updateTableModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void doSetGratuityAmount() {
        Transaction tx = null;
        try (Session session = TicketDAO.getInstance().createNewSession();){
            Double oldGratuityAmount;
            tx = session.beginTransaction();
            Object selectedObject = this.getRowFromTable();
            if (selectedObject == null) {
                return;
            }
            if (!(selectedObject instanceof Gratuity)) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.57"));
                return;
            }
            Gratuity gratuity = (Gratuity)selectedObject;
            Ticket ticket = this.getTicket(gratuity);
            TicketDAO.getInstance().loadFullTicket(ticket);
            PosTransaction transaction = this.getCustomerAccountTransaction(ticket.getTransactions());
            if (transaction == null) {
                POSMessageDialog.showMessage(this, Messages.getString("UploadPaymentDialog.58"));
                return;
            }
            String title = Messages.getString("UploadPaymentDialog.59");
            double newGratuityAmount = NumberSelectionDialog2.takeDoubleInput(title, oldGratuityAmount = gratuity.getAmount());
            if (newGratuityAmount < 0.0) {
                POSMessageDialog.showError(this, Messages.getString("UploadPaymentDialog.60"));
                return;
            }
            ticket.setGratuityAmount(newGratuityAmount);
            double adjustedGratuityAmount = newGratuityAmount - oldGratuityAmount;
            ticket.setPaidAmount(ticket.getPaidAmount() + adjustedGratuityAmount);
            ticket.calculatePrice();
            gratuity.setAmount(newGratuityAmount);
            transaction.setTipsAmount(newGratuityAmount);
            transaction.setAmount(transaction.getAmount() + adjustedGratuityAmount);
            Customer customer = ticket.getCustomer();
            if (customer != null) {
                customer.setBalance(customer.getBalance() - adjustedGratuityAmount);
                CustomerDAO.getInstance().saveOrUpdate(customer, session);
            }
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            tx.commit();
            this.updateTableModel();
            this.saveJournal(ticket, transaction, customer, oldGratuityAmount, newGratuityAmount);
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void saveJournal(Ticket ticket, PosTransaction transaction, Customer customer, double oldGratuityAmount, double newGratuityAmount) {
        String description = String.format("Ticket id : %s, old amount : %s, new amount: %s, member id: %s", ticket.getId(), oldGratuityAmount, newGratuityAmount, customer.getId());
        ActionHistoryDAO.saveHistory(this.currentUser, ticket, transaction, "Sf sync gratuity amount change", description);
    }

    private PosTransaction getCustomerAccountTransaction(Set<PosTransaction> transactions) {
        if (transactions == null || transactions.isEmpty()) {
            return null;
        }
        for (PosTransaction transaction : transactions) {
            if (!(transaction instanceof CustomerAccountTransaction)) continue;
            return transaction;
        }
        return null;
    }

    private void doClose() {
        this.setCanceled(true);
        this.dispose();
    }

    private void doSetEmployee() {
        try {
            Object object = this.getRowFromTable();
            if (object == null) {
                return;
            }
            Ticket ticket = this.getTicket(object);
            if (ticket == null) {
                return;
            }
            UserListDialog dialog = new UserListDialog();
            dialog.setUsers(UserDAO.getInstance().findAllActive());
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            User oldOwner = ticket.getOwner();
            User user = dialog.getSelectedUser();
            ticket.setOwner(user);
            ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            ticket.setOwner(user);
            for (Object obj : this.items) {
                Gratuity gratuity;
                Ticket ticket2;
                if (obj instanceof PosTransaction) {
                    PosTransaction transaction = (PosTransaction)obj;
                    if (!transaction.getTicketId().equals(ticket.getId())) continue;
                    transaction.setUser(user);
                    transaction.setSyncEdited(true);
                    ticket2 = transaction.getTicket();
                    ticket2.setOwner(user);
                    continue;
                }
                if (obj instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)obj;
                    if (!ticketItem.getTicket().getId().equals(ticket.getId())) continue;
                    ticket2 = ticketItem.getTicket();
                    ticket2.setOwner(user);
                    ticketItem.setSyncEdited(true);
                    continue;
                }
                if (!(obj instanceof Gratuity) || !(gratuity = (Gratuity)obj).getTicket().getId().equals(ticket.getId())) continue;
                ticket2 = gratuity.getTicket();
                ticket2.setOwner(user);
                gratuity.setSyncEdited(true);
            }
            TicketDAO.getInstance().update(ticket);
            String description = String.format("Ticket: %s, old owner: %s, new owner: %s", ticket.getId(), oldOwner.getId(), user.getId());
            ActionHistoryDAO.saveHistory(this.currentUser, ticket, "Sf sync ticket owner change", description);
            this.updateTableModel();
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    private void updateTableModel() {
        TicketListPanel ticketListPanel = (TicketListPanel)this.tabbedPane.getSelectedComponent();
        ticketListPanel.tableModel.fireTableDataChanged();
    }

    private TicketItem getTicketItem(String ticketItemId, Ticket ticket) {
        List<TicketItem> ticketItems = ticket.getTicketItems();
        for (TicketItem ticketItem : ticketItems) {
            if (!ticketItem.getId().equals(ticketItemId)) continue;
            return ticketItem;
        }
        return null;
    }

    private PosTransaction getTicketTransaction(String transactionId, Ticket ticket) {
        Set<PosTransaction> transactions = ticket.getTransactions();
        for (PosTransaction posTransaction : transactions) {
            if (!transactionId.equals(posTransaction.getId())) continue;
            return posTransaction;
        }
        return null;
    }

    public static SimpleDateFormat getDateFormat() {
        return dateFormat;
    }

    public class SyncItemsCellRenderer
    extends CustomCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableModel tableModel;
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            this.setHorizontalAlignment(10);
            label.setBackground(table.getBackground());
            if (value instanceof Double) {
                label.setHorizontalAlignment(4);
                label.setText(String.valueOf(NumberUtil.roundToTwoDigit((Double)value)));
            }
            if ((tableModel = table.getModel()) instanceof ItemModel) {
                PosTransaction transaction;
                ItemModel itemModel = (ItemModel)tableModel;
                Object rowData = itemModel.getRowData(row);
                if (rowData instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)rowData;
                    if (ticketItem.isSyncEdited()) {
                        label.setBackground(Color.GREEN.darker());
                        return label;
                    }
                } else if (rowData instanceof Gratuity) {
                    Gratuity gratuity = (Gratuity)rowData;
                    if (gratuity.isSyncEdited()) {
                        label.setBackground(Color.GREEN.darker());
                        return label;
                    }
                } else if (rowData instanceof PosTransaction && (transaction = (PosTransaction)rowData).isSyncEdited()) {
                    label.setBackground(Color.GREEN.darker());
                    return label;
                }
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class TicketListPanel
    extends JPanel {
        List<Object> objects;
        JTable table;
        ItemModel tableModel;
        Date date;

        public TicketListPanel(Date date, List<Object> objects) {
            this.date = date;
            this.objects = objects;
            this.setLayout(new BorderLayout());
            this.tableModel = new ItemModel();
            this.tableModel.setRows(objects);
            this.table = new JTable(this.tableModel);
            this.table.setDefaultRenderer(Object.class, new SyncItemsCellRenderer());
            this.table.setSelectionMode(0);
            this.table.setRowHeight(45);
            AbstractAction action = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UploadSfTicketsDialog.this.doUploadSelectedItem();
                }
            };
            ButtonColumn buttonColumn = new ButtonColumn(this.table, action, 10);
            MatteBorder selectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.table.getBackground());
            MatteBorder unselectedBorder = BorderFactory.createMatteBorder(2, 10, 2, 10, this.table.getBackground());
            CompoundBorder border1 = new CompoundBorder(selectedBorder, UploadSfTicketsDialog.this.btnUploadAll.getBorder());
            CompoundBorder border2 = new CompoundBorder(unselectedBorder, UploadSfTicketsDialog.this.btnUploadAll.getBorder());
            buttonColumn.setUnselectedBorder(border1);
            buttonColumn.setFocusBorder(border2);
            JScrollPane jScrollPane = new JScrollPane(this.table);
            this.add(jScrollPane);
        }
    }

    public class ItemModel
    extends ListTableModel<Object> {
        private final String TICKET_NUMBER = Messages.getString("UploadPaymentDialog.4");
        private final String DATE = Messages.getString("UploadPaymentDialog.5");
        private final String ITEM_ID = Messages.getString("UploadPaymentDialog.14");
        private final String ITEM_NAME = Messages.getString("UploadPaymentDialog.15");
        private final String MEMBER_ID = Messages.getString("UploadPaymentDialog.16");
        private final String MEMBER_NAME = Messages.getString("UploadPaymentDialog.17");
        private final String CHARGES_ITEM_ID = Messages.getString("UploadPaymentDialog.18");
        private final String TERMINAL = Messages.getString("UploadPaymentDialog.19");
        private final String ORDER_TYPE = Messages.getString("UploadSfTicketsDialog.4");
        private final String AMOUNT = Messages.getString("UploadPaymentDialog.20");
        private String[] columnNames = new String[]{this.TICKET_NUMBER, this.DATE, this.ITEM_ID, this.ITEM_NAME, this.MEMBER_ID, this.MEMBER_NAME, this.CHARGES_ITEM_ID, this.TERMINAL, this.ORDER_TYPE, this.AMOUNT, "-"};

        public ItemModel(List<Object> rows) {
            this.setColumnNames(this.columnNames);
            this.setRows(rows);
        }

        public ItemModel() {
            this.setColumnNames(this.columnNames);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 10;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object object = this.getRows().get(rowIndex);
            Ticket ticket = UploadSfTicketsDialog.this.getTicket(object);
            switch (columnIndex) {
                case 0: {
                    if (ticket != null) {
                        return ticket.getId();
                    }
                    return "";
                }
                case 1: {
                    if (ticket != null) {
                        return DateUtil.formatDateWithTime(ticket.getCreateDate());
                    }
                    return "";
                }
                case 2: {
                    if (object instanceof TicketItem) {
                        return ((TicketItem)object).getId();
                    }
                    if (object instanceof Gratuity) {
                        return ((Gratuity)object).getId();
                    }
                    if (object instanceof PosTransaction) {
                        return ((PosTransaction)object).getId();
                    }
                    return "";
                }
                case 3: {
                    if (object instanceof TicketItem) {
                        return ((TicketItem)object).getName();
                    }
                    if (object instanceof Gratuity) {
                        return Messages.getString("UploadPaymentDialog.2");
                    }
                    if (object instanceof PosTransaction) {
                        return Messages.getString("UploadPaymentDialog.3");
                    }
                    return "";
                }
                case 4: {
                    Customer customer;
                    if (ticket != null && (customer = ticket.getCustomer()) != null) {
                        return customer.getId();
                    }
                    return "";
                }
                case 5: {
                    Customer customer;
                    if (ticket != null && (customer = ticket.getCustomer()) != null) {
                        return customer.getName();
                    }
                    return "";
                }
                case 6: {
                    String gratuityItemId;
                    if (object instanceof TicketItem) {
                        return ((TicketItem)object).getMenuItemId();
                    }
                    if (object instanceof Gratuity && StringUtils.isNotEmpty((String)(gratuityItemId = ticket.getExtraProperty("salesforce.gratuity.item.id")))) {
                        return gratuityItemId;
                    }
                    return "";
                }
                case 7: {
                    Terminal terminal;
                    if (ticket != null && (terminal = ticket.getTerminal()) != null) {
                        return terminal;
                    }
                    return "";
                }
                case 8: {
                    if (ticket != null) {
                        String orderTypeName;
                        OrderType orderType = ticket.getOrderType();
                        String string = orderTypeName = orderType == null ? "" : orderType.getName();
                        if (StringUtils.isNotBlank((String)orderTypeName)) {
                            return orderTypeName;
                        }
                    }
                    return "";
                }
                case 9: {
                    if (object instanceof TicketItem) {
                        return NumberUtil.roundToTwoDigit(((TicketItem)object).getTotalAmount());
                    }
                    if (object instanceof Gratuity) {
                        return NumberUtil.roundToTwoDigit(((Gratuity)object).getAmount());
                    }
                    if (object instanceof PosTransaction) {
                        if (object instanceof RefundTransaction) {
                            return NumberUtil.roundToTwoDigit(((PosTransaction)object).getAmount() * -1.0);
                        }
                        return NumberUtil.roundToTwoDigit(((PosTransaction)object).getAmount());
                    }
                    return "";
                }
                case 10: {
                    return Messages.getString("UploadPaymentDialog.39");
                }
            }
            return null;
        }
    }
}

