/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.main.Application;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Frame;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class UserListDialog
extends OkCancelOptionDialog {
    BeanTableModel<User> tableModel;
    JTable userListTable;

    public UserListDialog() {
        super((Frame)Application.getPosWindow(), true);
        this.setTitle(Messages.getString("UserListDialog.0"));
        this.setCaption(Messages.getString("UserListDialog.0"));
        JPanel contentPane = this.getContentPanel();
        contentPane.setLayout(new BorderLayout(5, 5));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.tableModel = new BeanTableModel(User.class);
        this.tableModel.addColumn("Name", "fullName");
        this.userListTable = new JTable(this.tableModel);
        this.userListTable.setRowHeight(PosUIManager.getSize(60));
        this.userListTable.getSelectionModel().setSelectionMode(0);
        contentPane.add(new JScrollPane(this.userListTable));
        this.userListTable.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 40));
        List<User> users = UserDAO.getInstance().findClockedInUsers();
        this.tableModel.addRows(users);
        if (users != null && !users.isEmpty()) {
            this.userListTable.getSelectionModel().setSelectionInterval(0, 0);
        }
    }

    public void setUsers(List<User> users) {
        this.tableModel.removeAll();
        this.tableModel.addRows(users);
    }

    public void hideUser(User user) {
        this.tableModel.removeRow(user);
    }

    public User getSelectedUser() {
        return this.tableModel.getRows().get(this.userListTable.getSelectedRow());
    }

    @Override
    public void doOk() {
        int selectedRow = this.userListTable.getSelectedRow();
        if (selectedRow == -1) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("UserListDialog.4"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }
}

