/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.SystemProperties;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloorLayoutPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopSeat;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShopSeatDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.ShopTableTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.CheckBoxList;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.floorplan.ShopSeatForm;
import com.floreantpos.ui.floorplan.ShopTableStyledButton;
import com.floreantpos.ui.model.SalesAreaEntryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class ShopTableForm
extends BeanEditor<ShopTable>
implements RefreshableView {
    private static final String EMPTY_SPACE = " ";
    private static final Integer SEAT_CAPACITY_MIN = 1;
    private static final Integer SEAT_CAPACITY_MAX = 100;
    private static final Integer BUTTON_AXIS_LENGTH_MIN = 40;
    private static final Integer BUTTON_AXIS_LENGTH_MAX = 250;
    private FixedLengthTextField tfTableDescription;
    private IntegerTextField tfMinTableCapacity;
    private IntegerTextField tfTableCapacity;
    private IntegerTextField tfTableNo;
    private FixedLengthTextField tfTableName;
    private JCheckBox chkReservable;
    private CheckBoxList tableTypeCBoxList;
    private JPanel statusPanel;
    private JRadioButton rbFree;
    private JRadioButton rbDisable;
    private JButton btnCreateType;
    private int newTable;
    private String dupName;
    private Integer dupCapacity;
    private Integer dupMinCapacity;
    private String dupDescription;
    private List<ShopTableType> dupCheckValues;
    private int selectedTable;
    private boolean duplicate;
    private boolean seatRearrangeMode;
    private JLayeredPane tablePanel = new JLayeredPane();
    private JScrollPane tablePanelContainerPane;
    private JPanel tableMapPanel;
    private IntegerTextField tfButtonWidth;
    private IntegerTextField tfButtonHeight;
    private Integer selectedShape = 0;
    private ShapeButton btnRound;
    private ShapeButton btnRectangle;
    private ShapeButton btnRoundedRectangle;
    private ShapeButton btnPolygon;
    private JComboBox cbSalesArea;
    private JPanel capacitySelectionPanel;
    private JButton btnNewSalesArea;

    public ShopTableForm() {
        this.setLayout((LayoutManager)new MigLayout("fill,ins 0", "[35%][65%]", ""));
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout((LayoutManager)new MigLayout("inset 0 5 5 5 5", "[][grow]", "[][][][][][][][]"));
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.19")));
        this.tableTypeCBoxList = new CheckBoxList();
        this.tableTypeCBoxList.setModel(ShopTableTypeDAO.getInstance().findAll());
        JScrollPane tableTypeCheckBoxList = new JScrollPane(this.tableTypeCBoxList);
        tableTypeCheckBoxList.setPreferredSize(new Dimension(0, 350));
        JLabel lblName = new JLabel(Messages.getString("ShopTableForm.0"));
        leftPanel.add((Component)lblName, "cell 0 0,alignx trailing,aligny center");
        this.cbSalesArea = new JComboBox();
        this.tfTableNo = new IntegerTextField(6);
        FocusListener listener = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                ShopTableForm.this.doGenerateDefaultSeats();
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.btnNewSalesArea = new JButton("...");
        this.btnNewSalesArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableForm.this.addNewSalesArea();
            }
        });
        leftPanel.add((Component)this.tfTableNo, "cell 1 0,growx,aligny top");
        JLabel lblTableName = new JLabel(Messages.getString("ShopTableForm.33"));
        leftPanel.add((Component)lblTableName, "cell 0 1,alignx trailing, wrap");
        this.tfTableName = new FixedLengthTextField(20);
        leftPanel.add((Component)this.tfTableName, "cell 1 1,growx, wrap");
        JLabel lblAddress = new JLabel(Messages.getString("ShopTableForm.2"));
        leftPanel.add((Component)lblAddress, "cell 0 2,alignx trailing");
        this.tfTableDescription = new FixedLengthTextField();
        leftPanel.add((Component)this.tfTableDescription, "cell 1 2,growx");
        JLabel lblMinCapcity = new JLabel("Min Capacity");
        leftPanel.add((Component)lblMinCapcity, "cell 0 3,alignx trailing");
        this.tfMinTableCapacity = new IntegerTextField(6);
        leftPanel.add((Component)this.tfMinTableCapacity, "flowx,grow,cell 1 3");
        this.capacitySelectionPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 5,wrap 5"));
        this.capacitySelectionPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.3")));
        this.tfTableCapacity = new IntegerTextField(6);
        this.tfTableCapacity.addFocusListener(listener);
        this.capacitySelectionPanel.add((Component)this.tfTableCapacity, "flowx,grow,span 5");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShopTableForm.this.tfTableCapacity.setText(e.getActionCommand());
                try {
                    ShopTableForm.this.generateDefaultSeats();
                    ShopTableForm.this.renderTable();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e1.getMessage(), e1);
                }
            }
        };
        Dimension size = PosUIManager.getSize(40, 40);
        Font f = new Font(null, 0, 16);
        for (int i = 1; i < 11; ++i) {
            PosButton btnCapacity = new PosButton("" + i);
            btnCapacity.setPreferredSize(size);
            btnCapacity.addActionListener(action);
            btnCapacity.setFont(f);
            this.capacitySelectionPanel.add((Component)btnCapacity, "gap 0,grow");
        }
        leftPanel.add((Component)this.capacitySelectionPanel, "cell 1 5,growx");
        this.chkReservable = new JCheckBox(Messages.getString("ShopTableForm.32"));
        if (this.isFloorplanActive()) {
            leftPanel.add((Component)this.chkReservable, "cell 1 6, grow");
        }
        this.statusPanel = new JPanel();
        this.statusPanel.setBorder(new TitledBorder(null, Messages.getString("ShopTableForm.4"), 4, 2, null, null));
        leftPanel.add((Component)this.statusPanel, "cell 1 7,grow");
        this.statusPanel.setLayout(new FlowLayout(0, 5, 5));
        this.rbFree = new JRadioButton(Messages.getString("ShopTableForm.5"));
        this.statusPanel.add(this.rbFree);
        this.rbDisable = new JRadioButton(Messages.getString("ShopTableForm.9"));
        this.statusPanel.add(this.rbDisable);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbFree);
        buttonGroup.add(this.rbDisable);
        leftPanel.add((Component)new JLabel(), "grow,span");
        if (this.isFloorplanActive()) {
            this.btnCreateType = new JButton(Messages.getString("ShopTableForm.40"));
            leftPanel.add((Component)new JLabel(Messages.getString("ShopTableForm.10")), "cell 0 8");
            leftPanel.add((Component)tableTypeCheckBoxList, "cell 1 8,wrap,grow");
            leftPanel.add((Component)this.btnCreateType, "cell 1 9");
            this.btnCreateType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FloorLayoutPlugin tableLayoutPlugin = (FloorLayoutPlugin)ExtensionManager.getPlugin(FloorLayoutPlugin.class);
                    BeanEditorDialog dialog = new BeanEditorDialog(tableLayoutPlugin.getBeanEditor());
                    dialog.open();
                    ShopTableForm.this.tableTypeCBoxList.setModel(ShopTableTypeDAO.getInstance().findAll());
                }
            });
        }
        if (SystemProperties.isForeTees()) {
            leftPanel.add((Component)new JLabel(Messages.getString("ShopTableForm.37")), "cell 0 10");
            leftPanel.add((Component)this.cbSalesArea, "cell 1 10,split 2,growx");
            leftPanel.add((Component)this.btnNewSalesArea, "");
        }
        this.add((Component)leftPanel, "growx,aligny top");
        this.createLayoutPanel();
        this.cbSalesArea.setModel(new ComboBoxModel(SalesAreaDAO.getInstance().findAll()));
        this.cbSalesArea.setSelectedItem(null);
    }

    protected void doGenerateDefaultSeats() {
        try {
            ShopTable shopTable = (ShopTable)this.getBean();
            shopTable.setId(this.tfTableNo.getInteger());
            shopTable.setSeats(null);
            this.generateDefaultSeats();
            this.renderTable();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage());
        }
    }

    private void addNewSalesArea() {
        SalesArea item = new SalesArea();
        SalesAreaEntryForm editor = new SalesAreaEntryForm(item);
        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        SalesArea salesArea = (SalesArea)editor.getBean();
        this.cbSalesArea.addItem(salesArea);
        this.cbSalesArea.setSelectedItem(salesArea);
    }

    private void createLayoutPanel() {
        this.tableMapPanel = new JPanel(new BorderLayout());
        this.createTopRearragePanel();
        this.tablePanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ShopTableForm.this.insertSeat(e);
            }
        });
        JPanel tablePanelContainer = new JPanel();
        tablePanelContainer.add(this.tablePanel);
        this.tablePanelContainerPane = new JScrollPane(tablePanelContainer);
        this.tablePanelContainerPane.setBorder(BorderFactory.createBevelBorder(1));
        this.tablePanel.setBackground(Color.white);
        this.tablePanel.setOpaque(true);
        this.tableMapPanel.add((Component)this.tablePanelContainerPane, "Center");
        if (this.isFloorplanActive()) {
            this.add((Component)this.tableMapPanel, "grow");
        }
    }

    private void createTopRearragePanel() {
        JPanel inputPanel = new JPanel((LayoutManager)new MigLayout("inset 0 0 5 0"));
        this.btnRound = new ShapeButton(2);
        this.btnRectangle = new ShapeButton(0);
        this.btnRoundedRectangle = new ShapeButton(1);
        this.btnPolygon = new ShapeButton(3);
        ActionListener shapeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ShopTable table = (ShopTable)ShopTableForm.this.getBean();
                    if (table == null) {
                        return;
                    }
                    ShopTableForm.this.selectedShape = Integer.valueOf(e.getActionCommand());
                    if (ShopTableForm.this.selectedShape == 3) {
                        table.setHeight(ShopTableForm.this.tfButtonWidth.getInteger() - 30);
                        ShopTableForm.this.tfButtonHeight.setText(String.valueOf(ShopTableForm.this.tfButtonWidth.getInteger() - 30));
                        ShopTableForm.this.tfButtonHeight.setEditable(false);
                    } else {
                        ShopTableForm.this.tfButtonHeight.setEditable(true);
                    }
                    table.setStateTableType(ShopTableForm.this.selectedShape);
                    ShopTableForm.this.renderTable();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e1.getMessage(), e1);
                }
            }
        };
        this.btnRound.addActionListener(shapeAction);
        this.btnRectangle.addActionListener(shapeAction);
        this.btnRoundedRectangle.addActionListener(shapeAction);
        this.btnPolygon.addActionListener(shapeAction);
        this.tfButtonWidth = new IntegerTextField(3);
        this.tfButtonHeight = new IntegerTextField(3);
        FocusListener sizeAction = new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                try {
                    ShopTable table = (ShopTable)ShopTableForm.this.getBean();
                    if (table == null) {
                        return;
                    }
                    if (ShopTableForm.this.selectedShape == 3) {
                        Integer effectiveWidth = ShopTableForm.this.tfButtonWidth.getInteger() - 30;
                        ShopTableForm.this.tfButtonHeight.setText(effectiveWidth.toString());
                        table.setHeight(effectiveWidth);
                    }
                    ShopTableForm.this.tfButtonHeight.setEditable(ShopTableForm.this.selectedShape != 3);
                    table.setWidth(ShopTableForm.this.tfButtonWidth.getInteger());
                    table.setHeight(ShopTableForm.this.tfButtonHeight.getInteger());
                    ShopTableForm.this.renderTable();
                }
                catch (Exception e0) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e0.getMessage(), e0);
                }
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        };
        this.tfButtonWidth.addFocusListener(sizeAction);
        this.tfButtonHeight.addFocusListener(sizeAction);
        inputPanel.add(this.btnRectangle);
        inputPanel.add(this.btnRoundedRectangle);
        inputPanel.add(this.btnRound);
        inputPanel.add(this.btnPolygon);
        inputPanel.add(new JLabel("Width"));
        inputPanel.add((Component)this.tfButtonWidth, "width 40!");
        inputPanel.add(new JLabel("Height"));
        inputPanel.add((Component)this.tfButtonHeight, "width 40!");
        this.tableMapPanel.add((Component)inputPanel, "North");
    }

    private void renderTable() throws Exception {
        this.tablePanel.removeAll();
        ShopTable table = (ShopTable)this.getBean();
        if (table == null) {
            return;
        }
        this.tablePanel.setPreferredSize(new Dimension(400, 390));
        ShopTableStyledButton tableButton = new ShopTableStyledButton(this.tablePanel, table);
        tableButton.drawShape(table.getStateTableType());
        this.tablePanel.add((Component)tableButton, Float.valueOf(0.5f));
        ShopTableDAO.getInstance().initializeSeats(table);
        Set<ShopSeat> seats = table.getSeats();
        if (seats != null) {
            for (ShopSeat shopSeat : seats) {
                SeatButton button = new SeatButton(shopSeat);
                button.setEnabled(this.seatRearrangeMode);
                this.tablePanel.add(button);
            }
        }
        this.tablePanel.moveToBack(tableButton);
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
    }

    private void insertSeat(MouseEvent e) {
        try {
            ShopTable table = (ShopTable)this.getBean();
            if (!this.seatRearrangeMode) {
                return;
            }
            if (table == null) {
                return;
            }
            if (table.getSeats() != null && table.getCapacity() <= table.getSeats().size()) {
                POSMessageDialog.showMessage(this, Messages.getString("ShopTableForm.52"));
                return;
            }
            ShopSeatForm shopSeatForm = new ShopSeatForm(table);
            shopSeatForm.setFieldsEditable(true);
            shopSeatForm.createNew();
            BeanEditorDialog shopSeatDialog = new BeanEditorDialog(shopSeatForm);
            shopSeatDialog.setTitle("Enter seat number");
            shopSeatDialog.pack();
            shopSeatDialog.open();
            if (shopSeatDialog.isCanceled()) {
                return;
            }
            ShopSeat selectedSeat = shopSeatForm.getSeat();
            selectedSeat.setTableId(table.getId());
            selectedSeat.setPosX(e.getX() - 20);
            selectedSeat.setPosY(e.getY() - 20);
            table.addToseats(selectedSeat);
            SeatButton button = new SeatButton(selectedSeat);
            this.tablePanel.add(button);
            this.tablePanel.moveToFront(button);
            this.tablePanel.revalidate();
            this.tablePanel.repaint();
        }
        catch (PosException e2) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), e2.getMessage());
        }
        catch (Exception e2) {
            POSMessageDialog.showError(SwingUtilities.getWindowAncestor(this), e2.getMessage(), e2);
        }
    }

    public ShopTable getTable() {
        return (ShopTable)this.getBean();
    }

    @Override
    public void createNew() {
        try {
            ShopTable oldTable = (ShopTable)this.getBean();
            ShopTable newTable = new ShopTable();
            this.setBean(newTable);
            int nxtTableNumber = ShopTableDAO.getInstance().getNextTableNumber() + 1;
            this.tfTableNo.setEditable(true);
            this.tfTableNo.setText(String.valueOf(nxtTableNumber));
            this.tfTableCapacity.setText(this.isDuplicateOn() ? String.valueOf(oldTable.getCapacity()) : "4");
            this.tfMinTableCapacity.setText(this.isDuplicateOn() ? oldTable.getMinCapacity().toString() : SEAT_CAPACITY_MIN.toString());
            this.tfTableDescription.setText("");
            this.tfTableName.setText("");
            this.tfButtonWidth.setText(this.isDuplicateOn() ? String.valueOf(oldTable.getWidth()) : "230");
            this.tfButtonHeight.setText(this.isDuplicateOn() ? String.valueOf(oldTable.getHeight()) : "130");
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.18")));
            newTable.setId(this.tfTableNo.getInteger());
            newTable.setCapacity(this.isDuplicateOn() ? oldTable.getCapacity() : 4);
            newTable.setStateTableType(this.selectedShape);
            newTable.setWidth(this.isDuplicateOn() ? oldTable.getWidth() : 230);
            newTable.setHeight(this.isDuplicateOn() ? oldTable.getHeight() : 130);
            this.seatRearrangeMode = true;
            if (this.isDuplicateOn()) {
                this.replicateSeats(oldTable, newTable);
                newTable.setSalesAreaId(oldTable.getSalesAreaId());
            } else {
                this.generateDefaultSeats();
            }
            this.renderTable();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
    }

    private void replicateSeats(ShopTable oldTable, ShopTable newTable) {
        Set<ShopSeat> seats = oldTable.getSeats();
        if (seats == null) {
            return;
        }
        if (newTable.getSeats() == null) {
            newTable.setSeats(new HashSet<ShopSeat>());
        }
        newTable.getSeats().clear();
        for (ShopSeat oldSeat : seats) {
            ShopSeat newSeat = new ShopSeat();
            Date date = new Date();
            newSeat.setLastSyncTime(date);
            newSeat.setLastUpdateTime(date);
            newSeat.setSeatNumber(oldSeat.getSeatNumber());
            newSeat.setPosX(oldSeat.getPosX());
            newSeat.setPosY(oldSeat.getPosY());
            newSeat.setDisable(oldSeat.isDisable());
            newSeat.setTableId(newTable.getId());
            newSeat.setProperties(oldSeat.getProperties());
            newTable.getSeats().add(newSeat);
        }
        newTable.setStateTableType(oldTable.getStateTableType());
    }

    @Override
    public void cancel() {
        ShopTable table = (ShopTable)this.getBean();
        if (table != null) {
            this.setBean(ShopTableDAO.getInstance().get(table.getId()));
        }
        this.seatRearrangeMode = false;
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.46")));
    }

    @Override
    public void clearFields() {
        this.tfTableNo.setText("");
        this.tfTableCapacity.setText("");
        this.tfTableDescription.setText("");
        this.tfTableName.setText("");
        this.tableTypeCBoxList.unCheckAll();
        this.rbFree.setSelected(false);
        this.rbDisable.setSelected(false);
    }

    @Override
    public boolean delete() {
        try {
            ShopTable bean2 = (ShopTable)this.getBean();
            if (bean2 == null) {
                return false;
            }
            bean2 = ShopTableDAO.getInstance().get(bean2.getId());
            TableStatus tableStatus = bean2.getShopTableStatus().getTableStatus();
            if (tableStatus.equals((Object)TableStatus.Booked) || tableStatus.equals((Object)TableStatus.Serving)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ShopTableForm.100"));
                return false;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.14"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return false;
            }
            List<BookingInfo> bookingList = BookingInfoDAO.getInstance().findAll();
            block2: for (BookingInfo info : bookingList) {
                List<ShopTable> tableList = info.getTables();
                for (ShopTable shopTable : tableList) {
                    if (!shopTable.getId().equals(bean2.getId())) continue;
                    tableList.remove(shopTable);
                    info.setTables(tableList);
                    BookingInfoDAO.getInstance().saveOrUpdate(info);
                    continue block2;
                }
            }
            bean2.setFloor(null);
            ShopTableDAO.getInstance().delete(bean2);
            this.tfTableCapacity.setText("");
            this.tfTableDescription.setText("");
            this.tfTableName.setText("");
            this.tfTableNo.setText("");
            this.tableTypeCBoxList.unCheckAll();
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
            return false;
        }
    }

    public boolean deleteAllTables() {
        try {
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.20"), Messages.getString("CONFIRM"));
            if (option != 0) {
                return false;
            }
            boolean isDeleted = ShopTableDAO.getInstance().deleteAllTables();
            if (isDeleted) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.19"));
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ShopTableBrowser.20"));
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
        this.tfTableNo.setText("");
        this.tfTableCapacity.setText("");
        this.tfTableDescription.setText("");
        this.tfTableName.setText("");
        this.tableTypeCBoxList.unCheckAll();
        return true;
    }

    public void setFieldsEditable(boolean editable) {
        this.tfTableName.setEditable(editable);
        this.tfTableDescription.setEditable(editable);
        this.tfTableCapacity.setEditable(editable);
        this.chkReservable.setEnabled(editable);
    }

    @Override
    public void setFieldsEnable(boolean enable) {
        try {
            this.tableTypeCBoxList.setEnabled(enable);
            this.tableTypeCBoxList.clearSelection();
            this.tfTableNo.setEnabled(enable);
            this.tfTableName.setEnabled(enable);
            this.tfTableDescription.setEnabled(enable);
            this.tfTableCapacity.setEnabled(enable);
            this.tfMinTableCapacity.setEnabled(enable);
            this.cbSalesArea.setEnabled(enable);
            this.btnNewSalesArea.setEnabled(enable);
            this.chkReservable.setEnabled(enable);
            for (Component c : this.capacitySelectionPanel.getComponents()) {
                c.setEnabled(enable);
            }
            if (this.btnCreateType != null) {
                this.btnCreateType.setEnabled(enable);
            }
            this.rbFree.setEnabled(enable);
            this.rbDisable.setEnabled(enable);
            this.seatRearrangeMode = enable;
            this.tfButtonWidth.setEnabled(enable);
            this.tfButtonHeight.setEnabled(enable);
            this.btnRectangle.setEnabled(enable);
            this.btnRound.setEnabled(enable);
            this.btnRoundedRectangle.setEnabled(enable);
            this.btnPolygon.setEnabled(enable);
            this.renderTable();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage(), e1);
        }
    }

    public void setOnlyStatusEnable() {
        this.tfTableNo.setEditable(false);
        this.tfTableName.setEditable(false);
        this.tfTableDescription.setEditable(false);
        this.tfTableCapacity.setEditable(false);
        this.tableMapPanel.setVisible(false);
        this.tableTypeCBoxList.setEnabled(false);
        if (this.btnCreateType != null) {
            this.btnCreateType.setVisible(false);
        }
        this.rbFree.setEnabled(true);
        this.rbDisable.setEnabled(true);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            ShopTable table = (ShopTable)this.getBean();
            ShopTableDAO.getInstance().saveOrUpdate(table);
            ShopTableStatus shopTableStatus = table.getShopTableStatus();
            ShopTableStatusDAO.getInstance().saveOrUpdate(shopTableStatus);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException | StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
        return false;
    }

    @Override
    protected void updateView() {
        try {
            ShopTable table = (ShopTable)this.getBean();
            if (table == null) {
                return;
            }
            ShopTableDAO.getInstance().initializeTypes(table);
            Integer tableWidth = table.getWidth();
            Integer tableHeight = table.getHeight();
            if (tableWidth == null || tableWidth == 0) {
                tableWidth = TerminalConfig.getFloorButtonWidth();
            }
            if (tableHeight == null || tableHeight == 0) {
                tableHeight = TerminalConfig.getFloorButtonHeight();
            }
            this.tfButtonWidth.setText(String.valueOf(tableWidth));
            this.tfButtonHeight.setText(String.valueOf(tableHeight));
            this.selectedShape = table.getStateTableType();
            this.tableTypeCBoxList.setModel(ShopTableTypeDAO.getInstance().findAll());
            this.tableTypeCBoxList.selectItems(table.getTypes());
            this.tfTableNo.setText(String.valueOf(table.getTableNumber()));
            this.tfTableName.setText(table.getName());
            this.tfTableDescription.setText(table.getDescription());
            this.tfTableCapacity.setText(String.valueOf(table.getCapacity()));
            this.tfMinTableCapacity.setText(String.valueOf(table.getMinCapacity()));
            this.chkReservable.setSelected(table.isReservable());
            this.rbFree.setSelected(true);
            TableStatus tableStatus = table.getTableStatus();
            if (tableStatus == TableStatus.Disable) {
                this.rbDisable.setSelected(true);
            }
            this.cbSalesArea.setSelectedItem(table.getSalesArea());
            this.selectedTable = table.getTableNumber() != null ? table.getTableNumber() : 0;
            if (!this.isDuplicateOn()) {
                List checkValues = this.tableTypeCBoxList.getCheckedValues();
                this.dupCheckValues = checkValues;
                this.dupMinCapacity = table.getMinCapacity();
                this.dupCapacity = table.getCapacity();
                this.dupDescription = table.getDescription();
                this.dupName = table.getName();
            }
            this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.46")));
            this.renderTable();
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage(), e1);
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        ShopTable table = (ShopTable)this.getBean();
        if (table == null) {
            table = new ShopTable();
            this.setBean(table, false);
        }
        if (!this.isDuplicateOn() && this.tfTableNo.getInteger() == 0) {
            POSMessageDialog.showError(null, Messages.getString("ShopTableForm.57"));
            return false;
        }
        Set<ShopSeat> seats = table.getSeats();
        ShopTable tableTocheck = ShopTableDAO.getInstance().get(this.tfTableNo.getInteger());
        if (tableTocheck != null && this.selectedTable != tableTocheck.getId()) {
            if (tableTocheck.isDeleted().booleanValue()) {
                if (seats != null && seats.size() > 0) {
                    for (ShopSeat shopSeat : seats) {
                        shopSeat.setServing(Boolean.FALSE);
                        shopSeat.setBooked(Boolean.FALSE);
                        shopSeat.setStatus(null);
                        shopSeat.setTableId(tableTocheck.getId());
                    }
                }
                if (this.isDuplicateOn()) {
                    tableTocheck.setSalesAreaId(table.getSalesAreaId());
                }
                table = tableTocheck;
                table.setTableStatus(TableStatus.Available);
                this.setBean(table, false);
                table.setDeleted(false);
                table.setSeats(seats);
            } else {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.58"));
                return false;
            }
        }
        this.validateTableButtonSize();
        table.setWidth(this.tfButtonWidth.getInteger());
        table.setHeight(this.tfButtonHeight.getInteger());
        this.validateSeatCapacity();
        if (this.isDuplicateOn()) {
            if (table.getId() == null) {
                int nxtTableNumber = ShopTableDAO.getInstance().getNextTableNumber() + 1;
                table.setId(nxtTableNumber);
            }
            table.setTypes(this.dupCheckValues);
            table.setCapacity(this.dupCapacity);
            table.setMinCapacity(this.dupMinCapacity);
            table.setDescription(this.dupDescription);
            table.setName(this.dupName);
            this.setDuplicate(false);
        } else {
            table.setId(this.tfTableNo.getInteger());
            table.setStateTableType(this.selectedShape);
            table.setName(this.tfTableName.getText());
            table.setDescription(this.tfTableDescription.getText());
            table.setCapacity(this.tfTableCapacity.getInteger());
            table.setMinCapacity(this.tfMinTableCapacity.getInteger());
            table.setReservable(this.chkReservable.isSelected());
            if (seats != null && seats.size() > 0) {
                for (ShopSeat shopSeat : seats) {
                    shopSeat.setTableId(table.getId());
                }
            }
            List<ShopTableType> checkValues = this.tableTypeCBoxList.getCheckedValues();
            table.setTypes(checkValues);
            TableStatus tableStatus = table.getShopTableStatus().getTableStatus();
            if (tableStatus != null) {
                ShopTableStatus shopTableStatus = table.getShopTableStatus();
                if (this.rbDisable.isSelected()) {
                    if (tableStatus.equals((Object)TableStatus.Booked) || tableStatus.equals((Object)TableStatus.Serving)) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), (Object)((Object)tableStatus) + Messages.getString("ShopTableForm.29"));
                        return false;
                    }
                    shopTableStatus.setTableStatus(TableStatus.Disable);
                } else if (tableStatus.equals((Object)TableStatus.Disable)) {
                    table.setTableStatus(TableStatus.Available);
                } else {
                    table.setTableStatus(tableStatus);
                }
                table.setShopTableStatus(shopTableStatus);
            }
            SalesArea salesArea = (SalesArea)this.cbSalesArea.getSelectedItem();
            table.setSalesArea(salesArea);
        }
        this.setNewTable(table.getId());
        return true;
    }

    private void validateSeatCapacity() {
        int minTableCapacity = this.tfMinTableCapacity.getInteger();
        if (minTableCapacity < SEAT_CAPACITY_MIN) {
            String message = Messages.getString("ShopTableForm.35") + EMPTY_SPACE + SEAT_CAPACITY_MIN;
            throw new PosException(message);
        }
        if (minTableCapacity > SEAT_CAPACITY_MAX) {
            String message = Messages.getString("ShopTableForm.36") + EMPTY_SPACE + SEAT_CAPACITY_MAX;
            throw new PosException(message);
        }
        int tableCapacity = this.tfTableCapacity.getInteger();
        if (tableCapacity < SEAT_CAPACITY_MIN) {
            String message = Messages.getString("ShopTableForm.38") + EMPTY_SPACE + SEAT_CAPACITY_MIN;
            throw new PosException(message);
        }
        if (tableCapacity > SEAT_CAPACITY_MAX) {
            String message = Messages.getString("ShopTableForm.39") + EMPTY_SPACE + SEAT_CAPACITY_MAX;
            throw new PosException(message);
        }
        if (minTableCapacity > tableCapacity) {
            String message = Messages.getString("ShopTableForm.41");
            throw new PosException(message);
        }
    }

    private void validateTableButtonSize() {
        int buttonWidth = this.tfButtonWidth.getInteger();
        if (buttonWidth < BUTTON_AXIS_LENGTH_MIN) {
            String message = Messages.getString("ShopTableForm.42") + EMPTY_SPACE + BUTTON_AXIS_LENGTH_MIN;
            throw new PosException(message);
        }
        if (buttonWidth > BUTTON_AXIS_LENGTH_MAX) {
            String message = Messages.getString("ShopTableForm.43") + EMPTY_SPACE + BUTTON_AXIS_LENGTH_MAX;
            throw new PosException(message);
        }
        int modifiedMinLength = this.selectedShape == 3 ? BUTTON_AXIS_LENGTH_MIN - 30 : BUTTON_AXIS_LENGTH_MIN;
        int buttonHeight = this.tfButtonHeight.getInteger();
        if (buttonHeight < modifiedMinLength) {
            String message = Messages.getString("ShopTableForm.44") + EMPTY_SPACE + modifiedMinLength;
            throw new PosException(message);
        }
        if (buttonHeight > BUTTON_AXIS_LENGTH_MAX) {
            String message = Messages.getString("ShopTableForm.45") + EMPTY_SPACE + BUTTON_AXIS_LENGTH_MAX;
            throw new PosException(message);
        }
    }

    private void generateDefaultSeats() {
        ShopTable table = (ShopTable)this.getBean();
        int existingSeatQuantity = 0;
        int selectedCapacity = this.tfTableCapacity.getInteger();
        if (table.getSeats() != null) {
            ArrayList<ShopSeat> seats = new ArrayList<ShopSeat>(table.getSeats());
            Collections.sort(seats, new Comparator<ShopSeat>(){

                @Override
                public int compare(ShopSeat o1, ShopSeat o2) {
                    return o1.getSeatNumber() - o2.getSeatNumber();
                }
            });
            existingSeatQuantity = seats.size();
            if (selectedCapacity < existingSeatQuantity) {
                int countSeat = 1;
                for (ShopSeat seat : seats) {
                    if (countSeat > selectedCapacity) {
                        table.getSeats().remove(seat);
                    }
                    ++countSeat;
                }
                return;
            }
        }
        for (int i = existingSeatQuantity; i < selectedCapacity; ++i) {
            ShopSeat shopSeat = new ShopSeat(table, i + 1, this.getPositionX().get(i), this.getPositionY().get(i));
            table.addToseats(shopSeat);
            if (i == 9) break;
        }
    }

    @Override
    public void edit() {
        ShopTable shopTable = (ShopTable)this.getBean();
        ShopTableDAO.getInstance().refresh(shopTable);
        this.setBean(shopTable);
        this.seatRearrangeMode = true;
        this.tfTableNo.setEditable(false);
        this.setBorder(BorderFactory.createTitledBorder(Messages.getString("ShopTableForm.17")));
    }

    @Override
    public String getDisplayText() {
        return Messages.getString("ShopTableForm.18");
    }

    public void setTableTypeCBoxListEnable(boolean enable) {
        this.tableTypeCBoxList.setEnabled(enable);
    }

    public boolean isDuplicateOn() {
        return this.duplicate;
    }

    public void setDuplicate(boolean duplicate) {
        this.duplicate = duplicate;
    }

    public int getNewTable() {
        return this.newTable;
    }

    public void setNewTable(int newTable) {
        this.newTable = newTable;
    }

    private List<Integer> getPositionX() {
        ArrayList<Integer> positionX = new ArrayList<Integer>();
        positionX.add(89);
        positionX.add(163);
        positionX.add(237);
        positionX.add(319);
        positionX.add(319);
        positionX.add(239);
        positionX.add(166);
        positionX.add(93);
        positionX.add(12);
        positionX.add(11);
        return positionX;
    }

    private List<Integer> getPositionY() {
        ArrayList<Integer> positionY = new ArrayList<Integer>();
        positionY.add(52);
        positionY.add(52);
        positionY.add(52);
        positionY.add(122);
        positionY.add(194);
        positionY.add(268);
        positionY.add(268);
        positionY.add(268);
        positionY.add(196);
        positionY.add(124);
        return positionY;
    }

    @Override
    public void refresh() {
        ShopTableDAO.getInstance().refresh(this.getBean());
        this.updateView();
    }

    private boolean isFloorplanActive() {
        return true;
    }

    class ShapeButton
    extends PosButton {
        int shape;

        public ShapeButton(int shape) {
            this.shape = shape;
            this.setActionCommand(String.valueOf(shape));
            this.setPreferredSize(new Dimension(30, 30));
            this.setOpaque(true);
            this.setBackground(Color.white);
        }

        @Override
        protected void paintBorder(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(this.getForeground());
            g2d.setStroke(new BasicStroke(2.0f));
            if (this.shape == 2) {
                g2d.drawOval(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            } else if (this.shape == 1) {
                g2d.drawRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 5, 5);
            } else if (this.shape == 3) {
                g2d.rotate(Math.toRadians(45.0));
                g2d.drawRect(10, -10, this.getSize().width - 10, this.getSize().height - 10);
            } else {
                g2d.drawRect(2, 2, this.getSize().width - 4, this.getSize().height - 4);
            }
        }
    }

    class SeatButton
    extends PosButton
    implements MouseListener,
    MouseMotionListener {
        ShopSeat seat;
        int pressedX;
        int pressedY;

        public SeatButton(ShopSeat seat) {
            this.seat = seat;
            this.setText(seat.getSeatNumber() + "");
            this.setBounds(seat.getPosX(), seat.getPosY(), 70, 70);
            this.setFont(new Font(this.getFont().getName(), this.getFont().getStyle(), TerminalConfig.getFloorButtonFontSize()));
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public ShopSeat getSeat() {
            return this.seat;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!ShopTableForm.this.seatRearrangeMode) {
                return;
            }
            try {
                int x = e.getX() - this.pressedX + this.getLocation().x;
                int y = e.getY() - this.pressedY + this.getLocation().y;
                int floorWidth = ((ShopTableForm)ShopTableForm.this).tablePanel.getBounds().width - 40;
                int floorHeight = ((ShopTableForm)ShopTableForm.this).tablePanel.getBounds().height - 40;
                if (x < 0 || x > floorWidth) {
                    return;
                }
                if (y < 0 || y > floorHeight) {
                    return;
                }
                this.seat.setPosX(x);
                this.seat.setPosY(y);
                this.setLocation(x, y);
            }
            catch (Exception e2) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("FloorView.24"));
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                if (!ShopTableForm.this.seatRearrangeMode) {
                    return;
                }
                ShopSeatForm form = new ShopSeatForm((ShopTable)ShopTableForm.this.getBean());
                form.setBean(this.seat);
                final BeanEditorDialog dialog = new BeanEditorDialog(form);
                dialog.setTitle(Messages.getString("ShopTableForm.30"));
                PosSmallButton btnDelete = new PosSmallButton(POSConstants.DELETE);
                btnDelete.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            String seatId;
                            String string = seatId = SeatButton.this.seat == null ? null : SeatButton.this.seat.getId();
                            if (ShopSeatDAO.getInstance().isShopSeatServing(seatId)) {
                                String message = Messages.getString("ShopTableForm.34");
                                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message);
                                return;
                            }
                            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("ShopTableForm.31"), POSConstants.CONFIRM);
                            if (option != 0) {
                                return;
                            }
                            ((ShopTable)ShopTableForm.this.getBean()).getSeats().remove(SeatButton.this.seat);
                            dialog.dispose();
                            ShopTableForm.this.renderTable();
                        }
                        catch (Exception e2) {
                            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                        }
                    }
                });
                TransparentPanel buttonPanel = dialog.getButtonPanel();
                Component[] components = buttonPanel.getComponents();
                buttonPanel.removeAll();
                buttonPanel.add(btnDelete);
                for (Component component : components) {
                    buttonPanel.add(component);
                }
                dialog.pack();
                dialog.open();
                if (!dialog.isCanceled()) {
                    ShopTableForm.this.renderTable();
                }
            }
            catch (Exception e1) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), e1.getMessage(), e1);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.pressedX = e.getX();
            this.pressedY = e.getY();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

