/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.floorplan;

import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.ShopTable;
import com.floreantpos.swing.PosButton;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.JLayeredPane;

public class ShopTableStyledButton
extends PosButton {
    private JLayeredPane parent;
    private ShopTable table;
    private int type;

    public ShopTableStyledButton(JLayeredPane tablePanel, ShopTable table) {
        this.parent = tablePanel;
        this.table = table;
        String tableID = table.getId() != null ? table.getId() + "" : "";
        this.setText(tableID);
        Integer tableWidth = table.getWidth();
        Integer tableHeight = table.getHeight();
        if (tableWidth == null || tableWidth == 0) {
            tableWidth = TerminalConfig.getFloorButtonWidth();
        }
        if (tableHeight == null || tableHeight == 0) {
            tableHeight = TerminalConfig.getFloorButtonHeight();
        }
        this.setHorizontalAlignment(0);
        this.setVerticalAlignment(0);
        this.setBackground(this.parent.getBackground());
        this.setOpaque(false);
        this.setBounds(this.parent.getPreferredSize().width / 2 - tableWidth / 2, this.parent.getPreferredSize().height / 2 - tableHeight / 2, tableWidth, tableHeight);
    }

    public void drawShape(int type) {
        this.type = type;
        this.repaint();
    }

    @Override
    public void paintAll(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getBackground());
        if (this.type == 2) {
            g2d.fillOval(10, 10, this.getSize().width - 20, this.getSize().height - 20);
        } else if (this.type == 1) {
            g2d.fillRoundRect(2, 2, this.getSize().width - 4, this.getSize().height - 4, 20, 20);
        } else if (this.type != 3) {
            g2d.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    @Override
    protected void paintBorder(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setColor(this.getForeground());
        g2d.setStroke(new BasicStroke(6.0f));
        int w = this.getSize().width;
        int h = this.getSize().height;
        if (this.type == 2) {
            g2d.drawOval(10, 10, w - 20, h - 20);
        } else if (this.type == 1) {
            g2d.drawRoundRect(2, 2, w - 4, h - 4, 20, 20);
        } else if (this.type == 3) {
            int x = w / 2;
            int y = w / 2;
            int d = (int)Math.sqrt(w * w + w * w);
            int dX = d - w;
            int dY = d - w;
            g2d.rotate(Math.toRadians(45.0), x, 0.0);
            g2d.drawRoundRect(x + 2, 4, w - dX, w - dY, 20, 20);
        } else {
            g2d.drawRect(0, 0, w, h);
        }
    }

    public ShopTable getTable() {
        return this.table;
    }
}

