/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.menuitem;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.InventoryVendorItems;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.InventoryVendorDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class VendorSelectionDialog
extends POSDialog {
    private BeanTableModel<InventoryVendor> tableModel;
    private List<InventoryVendorItems> vendorItems = new ArrayList<InventoryVendorItems>();
    private JXTable table;
    private MenuItem menuItem;

    public VendorSelectionDialog() {
        super(POSUtil.getFocusedWindow(), Dialog.ModalityType.APPLICATION_MODAL);
        this.initComponents();
        this.initData();
    }

    private void initData() {
        List<InventoryVendor> vendors = InventoryVendorDAO.getInstance().findAll();
        this.tableModel.setRows(vendors);
    }

    private void initComponents() {
        this.setTitle(AppProperties.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(InventoryVendor.class);
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.setPageSize(10);
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(40));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center"));
        PosButton btnSelect = new PosButton(Messages.getString("SELECT"));
        btnSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VendorSelectionDialog.this.doAddVendorItems();
            }
        });
        PosButton btnCancel = new PosButton(Messages.getString("Cancel"));
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VendorSelectionDialog.this.setCanceled(true);
                VendorSelectionDialog.this.dispose();
            }
        });
        bottomPanel.add(btnSelect);
        bottomPanel.add(btnCancel);
        contentPanel.add((Component)bottomPanel, "South");
        this.add(contentPanel);
    }

    public MenuItem getMenuItem() {
        return this.menuItem;
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
    }

    public List<InventoryVendorItems> getVendorItems() {
        return this.vendorItems;
    }

    public void setVendorItems(List<InventoryVendorItems> vendorItems) {
        this.vendorItems = vendorItems;
    }

    private void doAddVendorItems() {
        try {
            int[] selectedRows = this.table.getSelectedRows();
            if (selectedRows.length < 1) {
                return;
            }
            for (int i : selectedRows) {
                int index = this.table.convertRowIndexToModel(i);
                InventoryVendor inventoryVendor = this.tableModel.getRow(index);
                boolean hasVendorItems = InventoryVendorItemsDAO.getInstance().vendorHasItem(inventoryVendor, this.menuItem, null);
                if (hasVendorItems) continue;
                InventoryVendorItems inventoryVendorItems = new InventoryVendorItems();
                inventoryVendorItems.setItem(this.menuItem);
                inventoryVendorItems.setVendor(inventoryVendor);
                this.vendorItems.add(inventoryVendorItems);
            }
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            PosLog.error(VendorSelectionDialog.class, e.getMessage(), e);
        }
    }
}

