/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.ComboItemExplorer;
import com.floreantpos.bo.ui.explorer.MenuItemVariantExplorer;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageDesigner;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.InventoryPlugin;
import com.floreantpos.model.Course;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryVendorItemsDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IUpdatebleView;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.OverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.menuitem.InventoryPanel;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuItemModifierSpecForm;
import com.floreantpos.ui.model.ReportGroupForm;
import com.floreantpos.util.DateTimePicker;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.StaleStateException;
import org.hibernate.Transaction;

public class MenuItemForm
extends BeanEditor<MenuItem>
implements ActionListener,
ChangeListener,
RefreshableView {
    private MenuItem menuItem;
    private JButton btnDeleteModifierGroup = new JButton();
    private JButton btnEditModifierGroup = new JButton();
    private JButton btnNewModifierGroup = new JButton();
    private JComboBox cbReportGroup = new JComboBox();
    private JCheckBox chkVisible = new JCheckBox();
    private JLabel lfname = new JLabel();
    private JLabel lblMemberPrice = new JLabel();
    private JLabel lblRetailPrice = new JLabel();
    private JLabel lblButtonColor = new JLabel(Messages.getString("BUTTON_COLOR"));
    private JPanel tabGeneral = new JPanel();
    private JPanel tabModifier = new JPanel();
    private JPanel tabButtonStyle = new JPanel();
    private JScrollPane modifiertabScrollpane = new JScrollPane();
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTable modifierSpecTable = new JTable();
    private DoubleTextField tfDiscountRate = new DoubleTextField(18);
    private JLabel lblSalesforceID = new JLabel();
    private FixedLengthTextField tfSalseForceID = new FixedLengthTextField(20, 255);
    private FixedLengthTextField tfName = new FixedLengthTextField(20, 255);
    private FixedLengthTextField tfCmsItemCodeField = new FixedLengthTextField(20, 32);
    private FixedLengthTextField tfTranslatedName = new FixedLengthTextField(20, 255);
    private DoubleTextField tfMemberPrice = new DoubleTextField(10);
    private DoubleTextField tfRetailPrice = new DoubleTextField(10);
    private DoubleTextField tfCost = new DoubleTextField(10);
    private JTextArea tfDescription = new JTextArea(new FixedLengthDocument(512));
    private List<MenuItemModifierSpec> menuItemModifierSpecList;
    private MenuItemMGListModel menuItemMGListModel = new MenuItemMGListModel();
    private JLabel lblImagePreview = new JLabel("");
    private JButton btnClearImage = new JButton(Messages.getString("MenuItemForm.34"));
    private JCheckBox cbShowTextWithImage = new JCheckBox(Messages.getString("MenuItemForm.40"));
    private JLabel lblKitchenPrinter = new JLabel(Messages.getString("MenuItemForm.27"));
    private OverflowCombobox cbPrinterGroup = new OverflowCombobox();
    private JLabel lblBarcode = new JLabel(Messages.getString("MenuItemForm.lblBarcode.text"));
    private FixedLengthTextField tfBarcode = new FixedLengthTextField(20, 128);
    private JLabel lblTextColor = new JLabel(Messages.getString("MenuItemForm.lblTextColor.text"));
    private JLabel lblUnitName = new JLabel(Messages.getString("MenuItemForm.23"));
    private JButton btnButtonColor = new JButton();
    private JButton btnTextColor = new JButton(Messages.getString("MenuItemForm.SAMPLE_TEXT"));
    private JLabel lblTranslatedName = new JLabel(Messages.getString("MenuItemForm.lblTranslatedName.text"));
    private FixedLengthTextField tfUnitName = new FixedLengthTextField(10, 20);
    private IntegerTextField tfSortOrder = new IntegerTextField(10);
    private JCheckBox cbFractionalUnit = new JCheckBox(Messages.getString("MenuItemForm.24"));
    private JCheckBox cbRawMaterial = new JCheckBox(Messages.getString("MenuItemForm.31"));
    private JCheckBox cbIsInventory = new JCheckBox(Messages.getString("MenuItemForm.44"));
    private InventoryPanel inventoryPanel;
    private JLabel lblReportGroup = new JLabel();
    private JButton btnNewReportGroup = new JButton();
    private JButton btnNewMenuGroup = new JButton("+");
    private boolean inventoryItemMode = false;
    private JLabel lblSortOrder = new JLabel(Messages.getString("MenuItemForm.lblSortOrder.text"));
    private ImageResource imageResource;
    private ModifierPageDesigner modifierDesigner;
    private JCheckBox chkComboItem;
    private JCheckBox chkHasVariant = new JCheckBox(Messages.getString("MenuItemForm.57"));
    private MenuItemVariantExplorer variantTab;
    private ComboItemExplorer tabComboItems;
    private JComboBox cbUnits = new JComboBox();
    private JComboBox<MenuGroup> cbMenuGroup = new JComboBox();
    private FixedLengthTextField tfCmsTypeName = new FixedLengthTextField(20, 32);
    private FixedLengthTextField tfCmsSubTypeName = new FixedLengthTextField(20, 32);
    private JComboBox<Course> cbCourse = new JComboBox();
    private JCheckBox chkPrintToKitchen;
    private JCheckBox chkPrintKitchenSticker;
    private JCheckBox chkEditablePrice;
    private IntegerTextField tfSalesCountdown = new IntegerTextField(10);
    private DateTimePicker lastSetDatePicker = new DateTimePicker();

    public MenuItemForm() throws Exception {
        this(new MenuItem());
    }

    public MenuItemForm(MenuItem menuItem) throws Exception {
        this.menuItem = menuItem;
        this.initComponents();
        this.initData();
        this.setBean(menuItem);
    }

    public MenuItemForm(MenuItem menuItem, boolean inventoryMode) throws Exception {
        this.menuItem = menuItem;
        this.inventoryItemMode = inventoryMode;
        this.initComponents();
        this.initData();
        this.setBean(menuItem);
    }

    public void initData() {
        MenuGroupDAO foodGroupDAO = new MenuGroupDAO();
        List<MenuGroup> foodGroups = foodGroupDAO.findAll();
        ComboBoxModel foodGroupModel = new ComboBoxModel();
        foodGroupModel.addElement((Object)null);
        for (MenuGroup menuGroup : foodGroups) {
            foodGroupModel.addElement(menuGroup);
        }
        this.cbMenuGroup.setModel(foodGroupModel);
        List<PrinterGroup> printerGroups = PrinterGroupDAO.getInstance().findAll();
        ComboBoxModel printerGroupModel = new ComboBoxModel();
        printerGroupModel.addElement((Object)null);
        for (PrinterGroup printerGroup : printerGroups) {
            printerGroupModel.addElement(printerGroup);
        }
        this.cbPrinterGroup.setModel(printerGroupModel);
        ReportGroupDAO reportGroupDao = new ReportGroupDAO();
        List<ReportGroup> reportGroups = reportGroupDao.findAll();
        ComboBoxModel reportGroupModel = new ComboBoxModel();
        reportGroupModel.addElement((Object)null);
        for (ReportGroup menuGroup : reportGroups) {
            reportGroupModel.addElement(menuGroup);
        }
        this.cbReportGroup.setModel(reportGroupModel);
        TaxGroupDAO taxDAO = new TaxGroupDAO();
        List<TaxGroup> taxeGroups = taxDAO.findAll();
        ComboBoxModel taxGroupModel = new ComboBoxModel();
        taxGroupModel.addElement((Object)null);
        for (TaxGroup taxGroup : taxeGroups) {
            taxGroupModel.addElement(taxGroup);
        }
        CourseDAO courseDAO = new CourseDAO();
        ArrayList<Course> courses = new ArrayList<Course>();
        courses.add(null);
        List<Course> courseList = courseDAO.findAll();
        if (courseList != null && courseList.size() > 0) {
            courses.addAll(courseList);
        }
        ComboBoxModel aModel = new ComboBoxModel(courses);
        this.cbCourse.setModel(aModel);
        this.cbCourse.setSelectedItem(null);
        this.menuItemModifierSpecList = this.menuItem.getMenuItemModiferSpecs();
        this.tabComboItems.setMenuItem(this.menuItem);
        this.variantTab.setParentMenuItem(this.menuItem);
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog dialog = ImageGalleryDialog.getInstance();
        dialog.setTitle(Messages.getString("MenuItemForm.58"));
        dialog.setSelectBtnVisible(true);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.imageResource = dialog.getImageResource();
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(200, 200));
        }
    }

    protected void doClearImage() {
        this.lblImagePreview.setIcon(null);
        this.imageResource = null;
    }

    public void addRecipeExtension() {
        InventoryPlugin plugin = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
        if (plugin == null) {
            return;
        }
        plugin.addRecepieView(this.tabbedPane);
        if (this.cbUnits.isVisible()) {
            plugin.addStockUnitView(this.tabbedPane, this.menuItem);
            this.cbUnits.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MenuItemForm.this.menuItem.setUnit((InventoryUnit)MenuItemForm.this.cbUnits.getSelectedItem());
                }
            });
        }
    }

    private Component getUnitField() {
        InventoryPlugin plugin = (InventoryPlugin)ExtensionManager.getPlugin(InventoryPlugin.class);
        if (plugin == null) {
            this.cbUnits.setVisible(false);
            return this.tfUnitName;
        }
        this.lblUnitName.setText(Messages.getString("MenuItemForm.63"));
        this.cbUnits.setModel(new ComboBoxModel(InventoryUnitDAO.getInstance().findAll()));
        return this.cbUnits;
    }

    private void initComponents() {
        this.tfSalseForceID.setEditable(false);
        this.setLayout(new BorderLayout());
        this.initGeneralTab();
        this.initModifierGroupTab();
        this.addRecipeExtension();
        this.initComboTab();
        this.initAttributeTab();
        this.initBtnstyleTab();
        this.initInverntoryTab();
    }

    private void initComboTab() {
        this.tabComboItems = new ComboItemExplorer();
    }

    private void initAttributeTab() {
        this.variantTab = new MenuItemVariantExplorer();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(50);
        columnWidth.add(50);
        return columnWidth;
    }

    private void btnNewModifierGroupActionPerformed(ActionEvent evt) {
    }

    private void addMenuItemModifierGroup() {
        try {
            MenuItemModifierSpecForm form = new MenuItemModifierSpecForm(new MenuItemModifierSpec(), this.menuItem, false);
            BeanEditorDialog dialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)form);
            dialog.getButtonPanel().add((Component)form.getAutoBuildButton(), 0);
            dialog.openWithScale(500, 500);
            if (dialog.isCanceled()) {
                return;
            }
            this.menuItemMGListModel.add(form.getBean());
            this.modifierSpecTable.getSelectionModel().setSelectionInterval(this.menuItemMGListModel.getRowCount() - 1, this.menuItemMGListModel.getRowCount() - 1);
            if (form.isAutoBuildSelected()) {
                this.modifierDesigner.doGenenateMenuItemModifierPageItems();
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editMenuItemModifierGroup() {
        this.editSelectedRow();
    }

    private void editSelectedRow() {
        try {
            int index = this.modifierSpecTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            MenuItemModifierSpec menuItemModifierSpec = this.menuItemMGListModel.get(index);
            MenuItemModifierSpecForm form = new MenuItemModifierSpecForm(menuItemModifierSpec, this.menuItem, true);
            BeanEditorDialog dialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)form);
            dialog.openWithScale(500, 500);
            if (!dialog.isCanceled()) {
                this.menuItemMGListModel.fireTableRowsUpdated(index, index);
            }
            this.modifierDesigner.setDataModel();
            this.modifierDesigner.disableAllButton(!form.getBean().isEnableModifierGroupSettings());
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteMenuItemModifierGroup() {
        try {
            int index = this.modifierSpecTable.getSelectedRow();
            if (index < 0) {
                return;
            }
            if (ConfirmDeleteDialog.showMessage(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.CONFIRM) == 0) {
                this.menuItemMGListModel.remove(index);
                if (this.menuItemMGListModel.getRowCount() > 0) {
                    this.modifierSpecTable.getSelectionModel().setSelectionInterval(this.menuItemMGListModel.getRowCount() - 1, this.menuItemMGListModel.getRowCount() - 1);
                } else {
                    this.modifierDesigner.reset();
                }
            }
        }
        catch (Exception x) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean save() {
        Transaction transaction = null;
        try (Session session = MenuItemDAO.getInstance().createNewSession();){
            if (!this.updateModel()) {
                boolean bl = false;
                return bl;
            }
            MenuItem menuItem = (MenuItem)this.getBean();
            transaction = session.beginTransaction();
            MenuItemDAO.getInstance().saveOrUpdate(menuItem, session);
            InventoryVendorItemsDAO.getInstance().saveAll(this.inventoryPanel.getVendorItems(), session);
            transaction.commit();
            return true;
        }
        catch (StaleStateException e) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
            return false;
        }
        catch (Exception e) {
            if (transaction == null) throw new RuntimeException(e);
            transaction.rollback();
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void updateView() {
        Color buttonColor;
        MenuItem menuItem = (MenuItem)this.getBean();
        if (menuItem.getId() != null && !Hibernate.isInitialized(menuItem.getMenuItemModiferSpecs())) {
            try (Session session = MenuItemDAO.getInstance().createNewSession();){
                menuItem = (MenuItem)session.merge((Object)menuItem);
                Hibernate.initialize(menuItem.getMenuItemModiferSpecs());
            }
        }
        if (menuItem.getId() != null) {
            this.tfSalseForceID.setText(menuItem.getId().toString());
        } else {
            this.tfSalseForceID.setText("");
        }
        this.tfName.setText(menuItem.getName());
        this.tfDescription.setText(menuItem.getDescription());
        this.tfTranslatedName.setText(menuItem.getTranslatedName());
        this.tfBarcode.setText(menuItem.getBarcode());
        this.tfCost.setText(String.valueOf(menuItem.getCost()));
        this.tfMemberPrice.setText(String.valueOf(menuItem.getPrice()));
        this.tfRetailPrice.setText(String.valueOf(menuItem.getRetailPrice()));
        this.cbUnits.setSelectedItem(menuItem.getUnit());
        this.tfUnitName.setText(menuItem.getUnitName());
        this.tfDiscountRate.setText(String.valueOf(menuItem.getDiscountRate()));
        this.chkVisible.setSelected(menuItem.isVisible());
        this.cbShowTextWithImage.setSelected(menuItem.isShowImageOnly());
        this.cbRawMaterial.setSelected(menuItem.isRawMaterial());
        this.cbIsInventory.setSelected(menuItem.isInventoryItem());
        if (menuItem.getReportGroupId() != null) {
            this.cbReportGroup.setSelectedItem(ReportGroupDAO.getInstance().get(menuItem.getReportGroupId()));
        }
        if (!menuItem.isInventoryItem().booleanValue()) {
            this.tabbedPane.remove(this.inventoryPanel);
        }
        this.tabbedPane.addChangeListener(this);
        this.imageResource = IconFactory.getImageResource(menuItem.getImageId());
        if (this.imageResource != null) {
            this.lblImagePreview.setIcon(this.imageResource.getScaledImage(200, 200));
        }
        if (menuItem.getCourseId() != null) {
            PosGuiUtil.selectComboItemById(this.cbCourse, menuItem.getCourseId());
        }
        this.cbMenuGroup.setSelectedItem(menuItem.getParent());
        if (menuItem.getPrinterGroupId() != null) {
            this.cbPrinterGroup.setSelectedItem(PrinterGroupDAO.getInstance().get(menuItem.getPrinterGroupId()));
        }
        this.tfCmsItemCodeField.setText(menuItem.getCmsItemCode());
        this.tfCmsTypeName.setText(menuItem.getCmsTypeName());
        this.tfCmsSubTypeName.setText(menuItem.getCmsSubTypeName());
        if (menuItem.getSortOrder() != null) {
            this.tfSortOrder.setText(menuItem.getSortOrder().toString());
        }
        if ((buttonColor = menuItem.getButtonColor()) != null) {
            this.btnButtonColor.setBackground(buttonColor);
            this.btnTextColor.setBackground(buttonColor);
        }
        if (menuItem.getTextColor() != null) {
            this.btnTextColor.setForeground(menuItem.getTextColor());
        }
        this.cbFractionalUnit.setSelected(menuItem.isFractionalUnit());
        this.chkComboItem.setSelected(menuItem.isComboItem());
        this.chkHasVariant.setSelected(menuItem.isHasVariant());
        this.chkPrintToKitchen.setSelected(menuItem.isShouldPrintToKitchen());
        this.chkPrintKitchenSticker.setSelected(menuItem.isPrintKitchenSticker());
        this.chkEditablePrice.setSelected(menuItem.isEditablePrice());
        this.menuItemModifierSpecList = menuItem.getMenuItemModiferSpecs();
        if (menuItem.isAuto86Enabled()) {
            this.tfSalesCountdown.setText(String.valueOf(menuItem.get86Countdown()));
            this.lastSetDatePicker.setDate(menuItem.get86CountdownSetTime());
        }
        if (menuItem.isVariant().booleanValue()) {
            this.chkComboItem.setVisible(false);
            this.chkHasVariant.setVisible(false);
            this.tfMemberPrice.setEnabled(false);
            this.tfRetailPrice.setEnabled(false);
            this.cbMenuGroup.setEnabled(false);
        } else if (menuItem.isHasVariant().booleanValue()) {
            this.tfMemberPrice.setEnabled(false);
            this.tfRetailPrice.setEnabled(false);
            this.tfCost.setEnabled(false);
        }
    }

    @Override
    protected boolean updateModel() {
        String itemName = this.tfName.getText();
        if (POSUtil.isBlankOrNull(itemName)) {
            MessageDialog.showError(POSConstants.NAME_REQUIRED);
            return false;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.setName(itemName);
        menuItem.setDescription(this.tfDescription.getText());
        menuItem.setBarcode(this.tfBarcode.getText());
        menuItem.setCost(this.tfCost.getDoubleOrZero());
        menuItem.setPrice(Double.valueOf(this.tfMemberPrice.getText()));
        menuItem.setRetailPrice(Double.valueOf(this.tfRetailPrice.getText()));
        if (this.cbUnits.isVisible()) {
            Iterator<MenuItemModifierSpec> unit = (InventoryUnit)this.cbUnits.getSelectedItem();
            menuItem.setUnit((InventoryUnit)((Object)unit));
        } else {
            menuItem.setUnitName(this.tfUnitName.getText());
        }
        menuItem.setVisible(this.chkVisible.isSelected());
        menuItem.setShowImageOnly(this.cbShowTextWithImage.isSelected());
        menuItem.setFractionalUnit(this.cbFractionalUnit.isSelected());
        menuItem.setRawMaterial(this.cbRawMaterial.isSelected());
        menuItem.setInventoryItem(this.cbIsInventory.isSelected());
        menuItem.setTranslatedName(this.tfTranslatedName.getText());
        menuItem.setSortOrder(this.tfSortOrder.getInteger());
        menuItem.setCmsItemCode(this.tfCmsItemCodeField.getText());
        menuItem.setReportGroup((ReportGroup)this.cbReportGroup.getSelectedItem());
        menuItem.setButtonColorCode(this.btnButtonColor.getBackground().getRGB());
        menuItem.setTextColorCode(this.btnTextColor.getForeground().getRGB());
        try {
            menuItem.setDiscountRate(Double.parseDouble(this.tfDiscountRate.getText()));
        }
        catch (Exception unit) {
            // empty catch block
        }
        if (this.menuItemModifierSpecList != null && this.menuItemModifierSpecList.size() > 0) {
            for (MenuItemModifierSpec menuItemModifierSpec : this.menuItemModifierSpecList) {
                int minQuantity = menuItemModifierSpec.getMinQuantity();
                int itemCount = 0;
                for (MenuItemModifierPage itemModifierPage : menuItemModifierSpec.getModifierPages()) {
                    List<MenuItemModifierPageItem> pageItems;
                    if (StringUtils.isNotBlank((String)menuItemModifierSpec.getId())) {
                        itemModifierPage.setModifierSpecId(menuItemModifierSpec.getId());
                    }
                    if (StringUtils.isNotBlank((String)menuItem.getId())) {
                        menuItemModifierSpec.setMenuItemId(menuItem.getId());
                    }
                    if ((pageItems = itemModifierPage.getPageItems()) == null) continue;
                    itemCount += pageItems.size();
                    for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                        if (!StringUtils.isNotBlank((String)itemModifierPage.getId())) continue;
                        menuItemModifierPageItem.setParentPage(itemModifierPage);
                    }
                }
                if (itemCount >= minQuantity) continue;
                Component componentAt = this.tabbedPane.getSelectedComponent();
                if (componentAt != this.tabModifier) {
                    this.tabbedPane.setSelectedComponent(this.tabModifier);
                }
                int quaDiff = minQuantity - itemCount;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.68") + quaDiff + Messages.getString("MenuItemForm.69") + (quaDiff > 1 ? Messages.getString("MenuItemForm.70") : Messages.getString("MenuItemForm.71")) + Messages.getString("MenuItemForm.72") + menuItemModifierSpec.getName() + Messages.getString("MenuItemForm.73") + minQuantity + ".");
                return false;
            }
        }
        menuItem.setMenuItemModiferSpecs(this.menuItemModifierSpecList);
        menuItem.setHasModifiers(this.menuItemModifierSpecList != null && !this.menuItemModifierSpecList.isEmpty());
        menuItem.setHasMandatoryModifiers(false);
        if (menuItem.hasModifiers()) {
            for (MenuItemModifierSpec menuItemModifierGroup : this.menuItemModifierSpecList) {
                if (menuItemModifierGroup.getMinQuantity() <= 0 && !menuItemModifierGroup.isAutoShow().booleanValue()) continue;
                menuItem.setHasMandatoryModifiers(true);
                break;
            }
        }
        menuItem.setCourse((Course)this.cbCourse.getSelectedItem());
        int tabCount = this.tabbedPane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            IUpdatebleView view;
            Component componentAt = this.tabbedPane.getComponent(i);
            if (!(componentAt instanceof IUpdatebleView) || (view = (IUpdatebleView)((Object)componentAt)).updateModel(menuItem)) continue;
            return false;
        }
        menuItem.setParent((MenuGroup)this.cbMenuGroup.getSelectedItem());
        menuItem.setPrinterGroup((PrinterGroup)this.cbPrinterGroup.getSelectedItem());
        menuItem.setComboItem(this.chkComboItem.isSelected());
        menuItem.setHasVariant(this.chkHasVariant.isSelected());
        menuItem.setEditablePrice(this.chkEditablePrice.isSelected());
        menuItem.setShouldPrintToKitchen(this.chkPrintToKitchen.isSelected());
        menuItem.setPrintKitchenSticker(this.chkPrintKitchenSticker.isSelected());
        if (menuItem.isComboItem().booleanValue()) {
            menuItem.setComboItems(this.tabComboItems.getSelectedComboItems());
            menuItem.setComboGroups(this.tabComboItems.getSelectedComboGroups());
        }
        if (menuItem.isHasVariant().booleanValue()) {
            List<MenuItem> newVariants = this.variantTab.getVariants();
            if (newVariants != null) {
                for (MenuItem menuItem2 : newVariants) {
                    menuItem2.setInventoryItem(this.cbIsInventory.isSelected());
                }
            }
            menuItem.setVariants(POSUtil.copySelectedValues(menuItem.getVariants(), newVariants));
        }
        menuItem.setImageId(null);
        if (this.imageResource != null) {
            menuItem.setImageId(this.imageResource.getId());
        }
        menuItem.setSku(this.inventoryPanel.getSku());
        menuItem.setReorderLevel(this.inventoryPanel.getReOrderLevel());
        menuItem.setReplenishLevel(this.inventoryPanel.getReplenishLevel());
        menuItem.setDisableWhenStockAmountIsZero(this.inventoryPanel.isCbDisableStockCount());
        menuItem.setDisableWhenStockAmountIsZero(this.inventoryPanel.isCbDisableStockCount());
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuItem foodItem = (MenuItem)this.getBean();
        if (foodItem.getId() == null) {
            return POSConstants.NEW_MENU_ITEM;
        }
        return POSConstants.EDIT_MENU_ITEM;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (actionCommand.equals("AddModifierGroup")) {
            this.addMenuItemModifierGroup();
        } else if (actionCommand.equals("EditModifierGroup")) {
            this.editMenuItemModifierGroup();
        } else if (actionCommand.equals("DeleteModifierGroup")) {
            this.deleteMenuItemModifierGroup();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Component selectedComponent = this.tabbedPane.getSelectedComponent();
        if (!(selectedComponent instanceof IUpdatebleView)) {
            return;
        }
        IUpdatebleView view = (IUpdatebleView)((Object)selectedComponent);
        MenuItem menuItem = (MenuItem)this.getBean();
        view.initView(menuItem);
    }

    private void doCreateNewGroup() {
        MenuGroupForm editor = new MenuGroupForm();
        BeanEditorDialog dialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)editor);
        dialog.open();
        if (!dialog.isCanceled()) {
            MenuGroup foodGroup = (MenuGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbMenuGroup.getModel();
            model.addElement(foodGroup);
            model.setSelectedItem(foodGroup);
        }
    }

    private void doCreateReportGroup(ActionEvent evt) {
        ReportGroupForm editor = new ReportGroupForm();
        BeanEditorDialog dialog = new BeanEditorDialog(POSUtil.getFocusedWindow(), (BeanEditor)editor);
        dialog.open();
        if (!dialog.isCanceled()) {
            ReportGroup reportGroup = (ReportGroup)editor.getBean();
            ComboBoxModel model = (ComboBoxModel)this.cbReportGroup.getModel();
            model.addElement(reportGroup);
            model.setSelectedItem(reportGroup);
        }
    }

    public void initModifierGroupTab() {
        this.modifierDesigner = new ModifierPageDesigner(this.menuItem);
        this.btnDeleteModifierGroup.setText(POSConstants.DELETE);
        this.btnEditModifierGroup.setText(POSConstants.EDIT);
        this.btnNewModifierGroup.setText(POSConstants.ADD);
        this.btnDeleteModifierGroup.setActionCommand("DeleteModifierGroup");
        this.btnEditModifierGroup.setActionCommand("EditModifierGroup");
        this.modifierSpecTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int index = MenuItemForm.this.modifierSpecTable.getSelectedRow();
                if (index < 0) {
                    return;
                }
                MenuItemModifierSpec menuItemModifierSpec = MenuItemForm.this.menuItemMGListModel.get(index);
                MenuItemForm.this.modifierDesigner.setMenuItemModifierSpec(menuItemModifierSpec);
            }
        });
        this.modifierSpecTable.setModel(this.menuItemMGListModel);
        this.modifierSpecTable.setRowHeight(PosUIManager.getSize(30));
        this.modifierSpecTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuItemForm.this.editSelectedRow();
                }
            }
        });
        this.btnNewModifierGroup.addActionListener(this);
        this.btnEditModifierGroup.addActionListener(this);
        this.btnDeleteModifierGroup.addActionListener(this);
        this.btnNewModifierGroup.setActionCommand("AddModifierGroup");
        this.btnNewModifierGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuItemForm.this.btnNewModifierGroupActionPerformed(evt);
            }
        });
        this.tabModifier.setLayout(new BorderLayout(10, 10));
        JPanel groupsPanel = new JPanel(new BorderLayout());
        TitledBorder groupsPanelBorder = BorderFactory.createTitledBorder(new EmptyBorder(5, 5, 0, 5), Messages.getString("MenuItemForm.74"), 2, 2);
        groupsPanelBorder.setTitleJustification(2);
        groupsPanel.setBorder(groupsPanelBorder);
        groupsPanel.add(this.modifiertabScrollpane);
        JPanel btmpanel = new JPanel();
        btmpanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        groupsPanel.add((Component)btmpanel, "South");
        btmpanel.add(this.btnNewModifierGroup);
        btmpanel.add(this.btnEditModifierGroup);
        btmpanel.add(this.btnDeleteModifierGroup);
        this.tabModifier.add((Component)groupsPanel, "West");
        this.tabModifier.add(this.modifierDesigner);
        this.tabbedPane.addTab(POSConstants.MODIFIER_GROUPS, this.tabModifier);
        this.modifiertabScrollpane.setViewportView(this.modifierSpecTable);
        this.modifierSpecTable.getColumnModel().getColumn(0).setPreferredWidth(200);
        this.modifierSpecTable.getColumnModel().getColumn(1).setPreferredWidth(45);
        this.modifierSpecTable.getColumnModel().getColumn(2).setPreferredWidth(45);
        this.modifierSpecTable.setAutoResizeMode(3);
    }

    public void initGeneralTab() {
        int comboWidth = PosUIManager.getSize(150);
        this.chkComboItem = new JCheckBox(Messages.getString("MenuItemForm.79"));
        this.lblSalesforceID.setText(POSConstants.ID.toUpperCase());
        this.lblSalesforceID.setHorizontalAlignment(11);
        this.lfname.setText(Messages.getString("LABEL_NAME"));
        this.lfname.setHorizontalAlignment(11);
        this.lblMemberPrice.setHorizontalAlignment(11);
        this.lblMemberPrice.setText(Messages.getString("MenuItemForm.80"));
        this.lblRetailPrice.setHorizontalAlignment(11);
        this.lblRetailPrice.setText(Messages.getString("MenuItemForm.82"));
        this.tfMemberPrice.setHorizontalAlignment(4);
        this.tfRetailPrice.setHorizontalAlignment(4);
        this.tfCost.setHorizontalAlignment(4);
        this.tfSortOrder.setText("");
        this.lblReportGroup.setHorizontalAlignment(11);
        this.lblReportGroup.setText(Messages.getString("MenuItemForm.45"));
        this.btnNewReportGroup.setText("+");
        JPanel column1 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[][grow]", ""));
        JPanel column2 = new JPanel((LayoutManager)new MigLayout("fillx, hidemode 3", "[][grow]", ""));
        Dimension preferredSize = PosUIManager.getSize(300, 620);
        column1.setPreferredSize(preferredSize);
        column2.setPreferredSize(preferredSize);
        this.tfCmsTypeName.setEnabled(false);
        this.tfCmsSubTypeName.setEnabled(false);
        this.tfCmsItemCodeField.setEnabled(false);
        this.tabGeneral.setLayout(new GridLayout(1, 2, 40, 5));
        this.chkEditablePrice = new JCheckBox(Messages.getString("MenuItemForm.83"));
        this.chkPrintToKitchen = new JCheckBox(Messages.getString("MenuItemForm.84"));
        this.chkPrintKitchenSticker = new JCheckBox(Messages.getString("MenuItemForm.85"));
        column1.add((Component)this.lblSalesforceID, "right");
        column1.add((Component)this.tfSalseForceID, "wrap,grow");
        column1.add((Component)this.lfname, "right");
        column1.add((Component)this.tfName, "grow, wrap");
        column1.add((Component)this.lblTranslatedName, "right");
        column1.add((Component)this.tfTranslatedName, "grow, wrap");
        column1.add((Component)this.lblUnitName, "right");
        column1.add(this.getUnitField(), "wrap");
        column1.add((Component)this.lblMemberPrice, "right");
        column1.add((Component)this.tfMemberPrice, "wrap");
        column1.add((Component)this.lblRetailPrice, "right");
        column1.add((Component)this.tfRetailPrice, "wrap");
        column1.add((Component)new JLabel("Cost"), "right");
        column1.add((Component)this.tfCost, "wrap");
        column1.add((Component)new JLabel(Messages.getString("MenuItemForm.86")), "right");
        column1.add(this.cbMenuGroup, "split 2, w " + comboWidth + "!");
        column1.add((Component)this.btnNewMenuGroup, "wrap");
        column1.add((Component)this.lblReportGroup, "right");
        column1.add((Component)this.cbReportGroup, "split 2, w " + comboWidth + "!");
        column1.add((Component)this.btnNewReportGroup, "wrap");
        column1.add((Component)new JLabel(Messages.getString("MenuItemForm.87")), "right");
        column1.add((Component)this.tfCmsTypeName, "wrap");
        column1.add((Component)new JLabel(Messages.getString("MenuItemForm.88")), "right");
        column1.add((Component)this.tfCmsSubTypeName, "wrap");
        column1.add((Component)new JLabel(Messages.getString("MenuItemForm.92")), "right");
        column1.add((Component)this.tfCmsItemCodeField, "wrap");
        column1.add((Component)this.lblBarcode, "right");
        column1.add((Component)this.tfBarcode, "wrap");
        column1.add((Component)this.lblSortOrder, "right");
        column1.add((Component)this.tfSortOrder, "wrap");
        column1.add((Component)this.chkVisible, "skip 1,wrap");
        column1.add((Component)this.cbFractionalUnit, "skip 1,wrap");
        column1.add((Component)this.cbRawMaterial, "skip 1,wrap");
        column1.add((Component)this.cbIsInventory, "skip 1,wrap");
        column1.add((Component)this.chkComboItem, "skip 1,wrap");
        column1.add((Component)this.chkHasVariant, "skip 1,wrap");
        column1.add((Component)this.chkEditablePrice, "skip 1,wrap");
        column1.add((Component)this.chkPrintToKitchen, "skip 1,wrap");
        column1.add((Component)this.chkPrintKitchenSticker, "skip 1,wrap");
        this.chkVisible.setText(POSConstants.VISIBLE);
        this.chkVisible.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkVisible.setMargin(new Insets(0, 0, 0, 0));
        column2.add((Component)this.lblKitchenPrinter, "right");
        column2.add((Component)this.cbPrinterGroup, "wrap, w " + comboWidth + "!");
        column2.add((Component)new JLabel(POSConstants.COURSE), "right");
        column2.add(this.cbCourse, "wrap, w " + comboWidth + "!");
        JLabel descLabel = new JLabel(Messages.getString("MenuItemForm.93"));
        descLabel.setVerticalAlignment(1);
        descLabel.setHorizontalAlignment(11);
        this.tfDescription.setLineWrap(true);
        JScrollPane scrlDescription = new JScrollPane(this.tfDescription, 20, 30);
        column2.add((Component)descLabel, "align right, grow");
        column2.add((Component)scrlDescription, "h 50%,grow,wrap");
        JButton salesCountdownSet = new JButton(Messages.getString("MenuItemForm.142"));
        salesCountdownSet.addActionListener(e -> this.doSetSalesCountdown());
        JButton salesCountdownClear = new JButton(POSConstants.CLEAR);
        salesCountdownClear.addActionListener(e -> this.doClearSalesCountdown());
        column2.add((Component)new JLabel(Messages.getString("MenuItemForm.143")), "align right");
        column2.add((Component)this.tfSalesCountdown, "split 3");
        column2.add(salesCountdownSet);
        column2.add((Component)salesCountdownClear, "wrap");
        this.lastSetDatePicker.setFormats(new String[]{"dd-MM-yyyy HH:mm:ss"});
        this.lastSetDatePicker.setEditable(false);
        column2.add((Component)new JLabel(Messages.getString("MenuItemForm.145")), "align right");
        column2.add((Component)((Object)this.lastSetDatePicker), "wrap");
        this.tabGeneral.add((Component)column1, "grow,wrap");
        this.tabGeneral.add((Component)column2, "grow,wrap");
        JScrollPane scrlMainPanel = new JScrollPane(this.tabGeneral, 20, 30);
        scrlMainPanel.setBorder(null);
        this.tabbedPane.addTab(POSConstants.GENERAL, scrlMainPanel);
        Dimension mainPanelSize = PosUIManager.getSize(700, 460);
        this.tabbedPane.setPreferredSize(mainPanelSize);
        this.add(this.tabbedPane);
        this.chkComboItem.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkComboItem.setMargin(new Insets(0, 0, 0, 0));
        this.chkComboItem.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MenuItemForm.this.tabbedPane.addTab(Messages.getString("MenuItemForm.94"), (Component)MenuItemForm.this.tabComboItems);
                } else {
                    MenuItemForm.this.tabbedPane.remove((Component)MenuItemForm.this.tabComboItems);
                }
            }
        });
        this.chkHasVariant.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.chkHasVariant.setMargin(new Insets(0, 0, 0, 0));
        this.chkHasVariant.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    if (MenuItemForm.this.tfName.getText().isEmpty()) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.96"));
                        MenuItemForm.this.chkHasVariant.setSelected(false);
                        return;
                    }
                    if (MenuItemForm.this.cbMenuGroup.getSelectedItem() == null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.97"));
                        MenuItemForm.this.chkHasVariant.setSelected(false);
                        return;
                    }
                    MenuItemForm.this.tabbedPane.addTab(Messages.getString("MenuItemForm.98"), MenuItemForm.this.variantTab);
                } else {
                    MenuItemForm.this.tabbedPane.remove(MenuItemForm.this.variantTab);
                }
            }
        });
        this.btnNewMenuGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuItemForm.this.doCreateNewGroup();
            }
        });
        this.btnNewReportGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MenuItemForm.this.doCreateReportGroup(evt);
            }
        });
        this.tfName.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                MenuItemForm.this.menuItem.setName(MenuItemForm.this.tfName.getText());
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.cbFractionalUnit.addItemListener(e -> this.fractionalUnitCheckboxValueChanged());
    }

    private void fractionalUnitCheckboxValueChanged() {
        this.tfSalesCountdown.setEnabled(!this.cbFractionalUnit.isSelected());
        this.lastSetDatePicker.setEnabled(!this.cbFractionalUnit.isSelected());
    }

    public void initBtnstyleTab() {
        this.tabButtonStyle.setLayout((LayoutManager)new MigLayout("insets 10", "[][]100[][][][]", "[][][center][][][]"));
        JLabel lblImage = new JLabel(Messages.getString("MenuItemForm.28"));
        lblImage.setHorizontalAlignment(11);
        this.tabButtonStyle.add((Component)lblImage, "cell 0 0,right");
        this.cbShowTextWithImage.setActionCommand(Messages.getString("MenuItemForm.41"));
        this.lblImagePreview.setHorizontalAlignment(0);
        this.lblImagePreview.setBorder(new EtchedBorder(1, null, null));
        this.lblImagePreview.setPreferredSize(PosUIManager.getSize(200, 200));
        this.tabButtonStyle.add((Component)this.lblImagePreview, "cell 1 0");
        this.btnButtonColor.setPreferredSize(new Dimension(228, 40));
        JButton btnSelectImage = new JButton("...");
        this.tabButtonStyle.add((Component)this.btnClearImage, "cell  1 0");
        this.tabButtonStyle.add((Component)btnSelectImage, "cell 1 0");
        this.tabButtonStyle.add((Component)this.lblButtonColor, "cell 0 2,right");
        this.tabButtonStyle.add((Component)this.btnButtonColor, "cell 1 2,grow");
        this.tabButtonStyle.add((Component)this.lblTextColor, "cell 0 3,right");
        this.tabButtonStyle.add((Component)this.btnTextColor, "cell 1 3");
        this.tabButtonStyle.add((Component)this.cbShowTextWithImage, "cell 1 4");
        this.btnTextColor.setPreferredSize(new Dimension(228, 50));
        btnSelectImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemForm.this.doSelectImageFile();
            }
        });
        this.btnClearImage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemForm.this.doClearImage();
            }
        });
        this.btnButtonColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.42"), MenuItemForm.this.btnButtonColor.getBackground());
                if (color != null) {
                    MenuItemForm.this.btnButtonColor.setBackground(color);
                    MenuItemForm.this.btnTextColor.setBackground(color);
                }
            }
        });
        this.btnTextColor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color color = JColorChooser.showDialog(POSUtil.getFocusedWindow(), Messages.getString("MenuItemForm.43"), MenuItemForm.this.btnTextColor.getForeground());
                if (color != null) {
                    MenuItemForm.this.btnTextColor.setForeground(color);
                }
            }
        });
        this.tabbedPane.addTab(Messages.getString("MenuItemForm.26"), this.tabButtonStyle);
    }

    public void initInverntoryTab() {
        this.inventoryPanel = new InventoryPanel(this.menuItem);
        this.tabbedPane.addTab(Messages.getString("MenuItemForm.64"), this.inventoryPanel);
        if (this.inventoryItemMode) {
            this.cbIsInventory.setVisible(false);
            this.inventoryPanel.setVisible(true);
        }
    }

    @Override
    public void refresh() {
        MenuItem item = (MenuItem)this.getBean();
        if (item == null || StringUtils.isBlank((String)item.getId())) {
            return;
        }
        item = MenuItemDAO.getInstance().getInitialized(item.getId());
        this.setBean(item, Boolean.TRUE);
    }

    private void doSetSalesCountdown() {
        if (this.cbFractionalUnit.isSelected()) {
            return;
        }
        int salesCountdown = this.tfSalesCountdown.getInteger();
        if (salesCountdown <= 0) {
            POSMessageDialog.showError(Messages.getString("MenuItemForm.156"));
            return;
        }
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.set86Countdown(salesCountdown);
        menuItem.setAuto86Enabled(true);
        Date date = new Date();
        menuItem.set86CountdownSetTime(date);
        this.lastSetDatePicker.setDate(date);
    }

    private void doClearSalesCountdown() {
        if (this.cbFractionalUnit.isSelected()) {
            return;
        }
        this.tfSalesCountdown.setText("");
        this.lastSetDatePicker.setDate(null);
        MenuItem menuItem = (MenuItem)this.getBean();
        menuItem.clearAuto86Settings();
    }

    class ShiftTableModel
    extends AbstractTableModel {
        List<MenuItemShift> shifts;
        String[] cn = new String[]{POSConstants.START_TIME, POSConstants.END_TIME, POSConstants.PRICE};
        Calendar calendar = Calendar.getInstance();

        ShiftTableModel(List<MenuItemShift> shifts) {
            this.shifts = shifts == null ? new ArrayList<MenuItemShift>() : new ArrayList<MenuItemShift>(shifts);
        }

        public MenuItemShift get(int index) {
            return this.shifts.get(index);
        }

        public void add(MenuItemShift group) {
            if (this.shifts == null) {
                this.shifts = new ArrayList<MenuItemShift>();
            }
            this.shifts.add(group);
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (this.shifts == null) {
                return;
            }
            this.shifts.remove(index);
            this.fireTableDataChanged();
        }

        public void remove(MenuItemShift group) {
            if (this.shifts == null) {
                return;
            }
            this.shifts.remove(group);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (this.shifts == null) {
                return 0;
            }
            return this.shifts.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        public List<MenuItemShift> getShifts() {
            return this.shifts;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItemShift shift = this.shifts.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getShift().getStartTime());
                }
                case 1: {
                    return ShiftUtil.buildShiftTimeRepresentation(shift.getShift().getEndTime());
                }
                case 2: {
                    return String.valueOf(shift.getShiftPrice());
                }
            }
            return null;
        }
    }

    class MenuItemMGListModel
    extends AbstractTableModel {
        String[] cn = new String[]{POSConstants.GROUP_NAME, "MIN", "MAX"};

        MenuItemMGListModel() {
        }

        public MenuItemModifierSpec get(int index) {
            return (MenuItemModifierSpec)MenuItemForm.this.menuItemModifierSpecList.get(index);
        }

        public void add(MenuItemModifierSpec group) {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                MenuItemForm.this.menuItemModifierSpecList = new ArrayList();
            }
            MenuItemForm.this.menuItemModifierSpecList.add(group);
            this.fireTableDataChanged();
        }

        public void remove(int index) {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                return;
            }
            MenuItemForm.this.menuItemModifierSpecList.remove(index);
            this.fireTableDataChanged();
        }

        public List<MenuItemModifierSpec> getItems() {
            return MenuItemForm.this.menuItemModifierSpecList;
        }

        public void remove(MenuItemModifierSpec group) {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                return;
            }
            MenuItemForm.this.menuItemModifierSpecList.remove(group);
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (MenuItemForm.this.menuItemModifierSpecList == null) {
                return 0;
            }
            return MenuItemForm.this.menuItemModifierSpecList.size();
        }

        @Override
        public int getColumnCount() {
            return this.cn.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.cn[column];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            MenuItemModifierSpec menuItemModifierGroup = (MenuItemModifierSpec)MenuItemForm.this.menuItemModifierSpecList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return menuItemModifierGroup.getName();
                }
                case 1: {
                    return (int)menuItemModifierGroup.getMinQuantity();
                }
                case 2: {
                    return (int)menuItemModifierGroup.getMaxQuantity();
                }
            }
            return null;
        }
    }
}

