/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosSmallButton;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.ui.model.ModifierPricingRule;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jidesoft.range.IntegerRange;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class MenuItemModifierSpecForm
extends BeanEditor
implements ItemListener {
    private JLabel lblMin;
    private JLabel lblMax;
    private JLabel lblSortOrder;
    private IntegerTextField tfSortOrder = new IntegerTextField();
    private FixedLengthTextField tfName = new FixedLengthTextField(60);
    private JTextArea taInstruction = new JTextArea(new FixedLengthDocument(220));
    private IntegerTextField tfMaxQuantity = new IntegerTextField();
    private IntegerTextField tfMinQuantity = new IntegerTextField();
    private JCheckBox chkVisible;
    private JComboBox cbMenuModifierGroup;
    private JCheckBox chkAutoShow;
    private JCheckBox chkJumbToNextGroup;
    private PosSmallButton btnSaveAndAutoBuild;
    private boolean autoBuildSelected;
    private MenuItem menuItem;
    private MenuItemModifierSpec modifierSpec;
    private boolean editMode;
    private JPanel groupPricingPanel;
    private JXTable groupPricingTable;
    private BeanTableModel<ModifierPricingRule> groupPricingTableModel;
    private JCheckBox chkEnableGroupWisePricing;
    private JPanel priceInputPanel;
    private IntegerTextField tfFromQty;
    private IntegerTextField tfToQty;
    private DoubleTextField tfPrice;
    private JRadioButton rbModifierGroupSettings;
    private JRadioButton rbOverrideModifierGroupSettings;
    private JButton btnAdd;
    private JButton btnEdit;
    private JButton btnDelete;

    public MenuItemModifierSpecForm(MenuItemModifierSpec modifierSpec, MenuItem menuItem, boolean editMode) {
        this.menuItem = menuItem;
        this.modifierSpec = modifierSpec;
        this.editMode = editMode;
        this.initComponents();
        this.initHandler();
        this.initList();
        this.setBean(modifierSpec);
    }

    private void initHandler() {
        this.rbModifierGroupSettings.addItemListener(this);
        this.rbOverrideModifierGroupSettings.addItemListener(this);
    }

    private void initList() {
        List<ModifierGroup> modifierGroups = null;
        modifierGroups = this.menuItem.isPizzaType() != false ? ModifierGroupDAO.getInstance().findPizzaModifierGroups() : ModifierGroupDAO.getInstance().findNormalModifierGroups();
        ComboBoxModel model = new ComboBoxModel(modifierGroups);
        this.cbMenuModifierGroup.setModel(model);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("fillx,inset 5 0 0 0", "[][grow]", ""));
        ButtonGroup btnGrpDrvrSet = new ButtonGroup();
        this.rbModifierGroupSettings = new JRadioButton(Messages.getString("MenuItemModifierSpecForm.5"));
        this.rbOverrideModifierGroupSettings = new JRadioButton(Messages.getString("MenuItemModifierSpecForm.7"));
        this.rbModifierGroupSettings.setSelected(true);
        btnGrpDrvrSet.add(this.rbModifierGroupSettings);
        btnGrpDrvrSet.add(this.rbOverrideModifierGroupSettings);
        this.lblMin = new JLabel(Messages.getString("MenuItemModifierGroupForm.6"));
        this.lblMax = new JLabel(Messages.getString("MenuItemModifierGroupForm.7"));
        this.lblSortOrder = new JLabel(Messages.getString("MenuItemModifierSpecForm.0"));
        this.chkVisible = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.1"));
        this.chkAutoShow = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.2"));
        this.chkJumbToNextGroup = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.3"));
        this.chkEnableGroupWisePricing = new JCheckBox(Messages.getString("MenuItemModifierSpecForm.4"));
        this.cbMenuModifierGroup = new JComboBox();
        this.cbMenuModifierGroup.setEnabled(!this.editMode);
        this.tfName.setColumns(20);
        this.tfMinQuantity.setColumns(10);
        this.tfMaxQuantity.setColumns(10);
        this.tfSortOrder.setColumns(10);
        this.taInstruction.setLineWrap(true);
        this.taInstruction.setRows(4);
        this.tfMinQuantity.setText("1");
        this.tfMaxQuantity.setText("1");
        this.chkVisible.setSelected(true);
        this.btnSaveAndAutoBuild = new PosSmallButton(Messages.getString("MenuItemModifierSpecForm.6"));
        this.btnSaveAndAutoBuild.addActionListener(e -> {
            if (!this.save()) {
                return;
            }
            this.autoBuildSelected = true;
            this.editorDialog.disposeWithNotCancelled();
        });
        JButton btnAddNewGroup = new JButton("...");
        btnAddNewGroup.addActionListener(e -> this.doAddNewModifierGroup());
        this.cbMenuModifierGroup.addActionListener(arg0 -> this.doSelectModifierGroup());
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        JPanel topPanel = new JPanel((LayoutManager)new MigLayout("fillx,inset 0", "[]22px[grow]", ""));
        topPanel.add(new JLabel(Messages.getString("MenuItemModifierSpecForm.8")));
        topPanel.add((Component)this.cbMenuModifierGroup, "grow");
        topPanel.add((Component)new JLabel(Messages.getString("MenuItemModifierSpecForm.10")), "newline,aligny top");
        topPanel.add((Component)new JScrollPane(this.taInstruction), "grow");
        contentPanel.add((Component)this.rbModifierGroupSettings, "span 2,newline");
        contentPanel.add((Component)this.rbOverrideModifierGroupSettings, "span 2,newline");
        contentPanel.add((Component)this.lblMin, "newline");
        contentPanel.add(this.tfMinQuantity);
        contentPanel.add((Component)this.lblMax, "newline");
        contentPanel.add(this.tfMaxQuantity);
        contentPanel.add((Component)this.lblSortOrder, "newline");
        contentPanel.add(this.tfSortOrder);
        contentPanel.add((Component)this.chkJumbToNextGroup, "skip 1,newline");
        contentPanel.add((Component)this.chkAutoShow, "skip 1,newline");
        contentPanel.add((Component)this.chkEnableGroupWisePricing, "skip 1,newline");
        contentPanel.add((Component)this.chkVisible, "skip 1,newline");
        this.add((Component)topPanel, "North");
        this.add(this.createModifierGroupPricingPanel());
        this.add((Component)contentPanel, "West");
        this.createPriceInputPanel();
    }

    private void doSelectModifierGroup() {
        try {
            List<MenuItemModifierPage> menuItemModifierPages;
            if (this.rbOverrideModifierGroupSettings.isSelected()) {
                return;
            }
            ModifierGroup selectedModifierGroup = (ModifierGroup)this.cbMenuModifierGroup.getSelectedItem();
            if (selectedModifierGroup == null) {
                return;
            }
            this.tfMinQuantity.setText(String.valueOf(selectedModifierGroup.getMinQuantity()));
            Integer maxQuantity = selectedModifierGroup.getMaxQuantity();
            this.tfMaxQuantity.setText(String.valueOf(maxQuantity == 0 ? 1 : maxQuantity));
            this.tfSortOrder.setText(String.valueOf(selectedModifierGroup.getSortOrder()));
            this.chkVisible.setSelected(selectedModifierGroup.isEnable());
            this.chkJumbToNextGroup.setSelected(selectedModifierGroup.isJumpGroup());
            this.chkAutoShow.setSelected(selectedModifierGroup.isAutoShow());
            this.chkEnableGroupWisePricing.setSelected(selectedModifierGroup.isEnableGroupPricing());
            ArrayList<ModifierPricingRule> priceRules = selectedModifierGroup.getPriceRules();
            if (priceRules == null) {
                priceRules = new ArrayList<ModifierPricingRule>();
            }
            this.groupPricingTableModel.setRows(priceRules);
            this.setVisibleGroupWisePricePanel(this.chkEnableGroupWisePricing.isSelected());
            if (this.modifierSpec.getId() == null && this.modifierSpec.getModifierPages() != null) {
                this.modifierSpec.getModifierPages().clear();
            }
            if ((menuItemModifierPages = selectedModifierGroup.getModifierGroupPages()) != null) {
                for (MenuItemModifierPage menuItemModifierPage : menuItemModifierPages) {
                    if (this.modifierSpec.getId() != null && menuItemModifierPage.getModifierGroupId().equals(selectedModifierGroup.getId())) continue;
                    this.modifierSpec.addTomodifierPages(menuItemModifierPage.deepClone());
                }
            }
            this.doCreatePricingRule(this.getBean(), priceRules);
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    private JPanel createModifierGroupPricingPanel() {
        this.chkEnableGroupWisePricing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuItemModifierSpecForm.this.setVisibleGroupWisePricePanel(MenuItemModifierSpecForm.this.chkEnableGroupWisePricing.isSelected());
            }
        });
        this.groupPricingTableModel = new BeanTableModel(ModifierPricingRule.class){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 2) {
                    ModifierPricingRule selectedPriceRule = (ModifierPricingRule)MenuItemModifierSpecForm.this.groupPricingTableModel.getRow(rowIndex);
                    return NumberUtil.formatNumber(selectedPriceRule.getPrice());
                }
                return super.getValueAt(rowIndex, columnIndex);
            }

            @Override
            public void setValueAt(Object value, int rowIndex, int columnIndex) {
                if (value == null) {
                    value = 0.0;
                }
                if (columnIndex == 0) {
                    int selectedRow = MenuItemModifierSpecForm.this.groupPricingTable.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    ModifierPricingRule selectedPriceRule = (ModifierPricingRule)MenuItemModifierSpecForm.this.groupPricingTableModel.getRow(MenuItemModifierSpecForm.this.groupPricingTable.convertRowIndexToModel(selectedRow));
                    if (!MenuItemModifierSpecForm.this.isValidQtyRange(selectedPriceRule, POSUtil.parseInteger(value.toString()), selectedPriceRule.getToQty())) {
                        MenuItemModifierSpecForm.this.groupPricingTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        return;
                    }
                    value = POSUtil.parseInteger(value.toString());
                } else if (columnIndex == 1) {
                    int selectedRow = MenuItemModifierSpecForm.this.groupPricingTable.getSelectedRow();
                    if (selectedRow == -1) {
                        return;
                    }
                    ModifierPricingRule selectedPriceRule = (ModifierPricingRule)MenuItemModifierSpecForm.this.groupPricingTableModel.getRow(MenuItemModifierSpecForm.this.groupPricingTable.convertRowIndexToModel(selectedRow));
                    if (!MenuItemModifierSpecForm.this.isValidQtyRange(selectedPriceRule, selectedPriceRule.getFromQty(), POSUtil.parseInteger(value.toString()))) {
                        MenuItemModifierSpecForm.this.groupPricingTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                        return;
                    }
                    value = POSUtil.parseInteger(value.toString());
                } else if (columnIndex == 2) {
                    value = POSUtil.parseDouble(value.toString());
                }
                super.setValueAt(value, rowIndex, columnIndex);
            }
        };
        this.groupPricingTableModel.addColumn(POSConstants.FROM, "fromQty", BeanTableModel.EditMode.EDITABLE);
        this.groupPricingTableModel.addColumn(POSConstants.TO, "toQty", BeanTableModel.EditMode.EDITABLE);
        this.groupPricingTableModel.addColumn(POSConstants.PRICE, "price", BeanTableModel.EditMode.EDITABLE, 4, BeanTableModel.DataType.MONEY);
        this.groupPricingTable = new JXTable(this.groupPricingTableModel){

            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                this.editCellAt(row, column);
                DefaultCellEditor editor = (DefaultCellEditor)this.getCellEditor(row, column);
                JTextField textField = (JTextField)editor.getComponent();
                textField.requestFocus();
                textField.selectAll();
            }
        };
        IntegerTextField tfFromQty = new IntegerTextField();
        IntegerTextField tfToQty = new IntegerTextField();
        DoubleTextField tfGroupPrice = new DoubleTextField();
        tfFromQty.setHorizontalAlignment(4);
        tfToQty.setHorizontalAlignment(4);
        tfGroupPrice.setHorizontalAlignment(4);
        this.groupPricingTable.getColumnModel().getColumn(0).setCellEditor(new DefaultCellEditor(tfFromQty));
        this.groupPricingTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(tfToQty));
        this.groupPricingTable.getColumnModel().getColumn(2).setCellEditor(new DefaultCellEditor(tfGroupPrice));
        this.groupPricingPanel = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 0 0", "[grow]", "[grow][]"));
        JScrollPane groupPricingScrollPane = new JScrollPane((Component)this.groupPricingTable);
        groupPricingScrollPane.setBorder(BorderFactory.createTitledBorder(null, Messages.getString("PriceExplorer.0"), 2, 2));
        this.btnAdd = new JButton(Messages.getString("MenuItemForm.9"));
        this.btnEdit = new JButton(POSConstants.EDIT);
        this.btnDelete = new JButton(POSConstants.DELETE);
        this.btnDelete.setFocusable(true);
        this.btnAdd.addActionListener(e -> this.doAddPriceRule());
        this.btnEdit.addActionListener(e -> this.doEditPriceRule());
        this.btnDelete.addActionListener(e -> this.doDeletePriceRule());
        this.groupPricingPanel.add((Component)groupPricingScrollPane, "grow,span");
        this.groupPricingPanel.add((Component)this.btnAdd, "newline,split 3,right");
        this.groupPricingPanel.add(this.btnEdit);
        this.groupPricingPanel.add(this.btnDelete);
        return this.groupPricingPanel;
    }

    private void setVisibleGroupWisePricePanel(boolean selected) {
        this.groupPricingPanel.setVisible(selected);
    }

    private void createPriceInputPanel() {
        this.priceInputPanel = new JPanel((LayoutManager)new MigLayout("fill,wrap 2", "[][grow]", ""));
        this.tfFromQty = new IntegerTextField(5);
        this.tfToQty = new IntegerTextField(5);
        this.tfPrice = new DoubleTextField(5);
        this.priceInputPanel.add(new JLabel(POSConstants.FROM));
        this.priceInputPanel.add((Component)this.tfFromQty, "growx");
        this.priceInputPanel.add(new JLabel(POSConstants.TO));
        this.priceInputPanel.add((Component)this.tfToQty, "growx");
        this.priceInputPanel.add(new JLabel(POSConstants.PRICE));
        this.priceInputPanel.add((Component)this.tfPrice, "growx");
    }

    private void doAddPriceRule() {
        this.openPriceRuleInputDialog(new ModifierPricingRule(), false);
    }

    private void doEditPriceRule() {
        ModifierPricingRule selectedPriceRule = this.getSelectedPriceRule();
        if (selectedPriceRule == null) {
            return;
        }
        this.openPriceRuleInputDialog(selectedPriceRule, true);
    }

    private void doDeletePriceRule() {
        if (this.groupPricingTable.isEditing()) {
            return;
        }
        ModifierPricingRule selectedPriceRule = this.getSelectedPriceRule();
        if (selectedPriceRule == null) {
            return;
        }
        this.groupPricingTableModel.removeRow(selectedPriceRule);
    }

    private void openPriceRuleInputDialog(final ModifierPricingRule pricing, final boolean editMode) {
        if (!editMode) {
            pricing.setFromQty(this.getNextQty());
            pricing.setToQty(POSUtil.parseInteger(this.tfMaxQuantity.getText()));
            pricing.setPrice(this.getFirstModifierPrice());
        }
        this.tfFromQty.setText(String.valueOf(pricing.getFromQty()));
        this.tfToQty.setText(String.valueOf(pricing.getToQty()));
        this.tfPrice.setText(NumberUtil.formatAmount(pricing.getPrice()));
        this.tfFromQty.requestFocus();
        this.tfFromQty.selectAll();
        OkCancelOptionDialog dialog = new OkCancelOptionDialog(){

            @Override
            public void doOk() {
                int toQty;
                double price = MenuItemModifierSpecForm.this.tfPrice.getDoubleOrZero();
                int fromQty = MenuItemModifierSpecForm.this.tfFromQty.getInteger();
                if (!MenuItemModifierSpecForm.this.isValidQtyRange(pricing, fromQty, toQty = MenuItemModifierSpecForm.this.tfToQty.getInteger())) {
                    return;
                }
                pricing.setFromQty(fromQty);
                pricing.setToQty(toQty);
                pricing.setPrice(price);
                if (!editMode) {
                    MenuItemModifierSpecForm.this.groupPricingTableModel.addRow(pricing);
                } else {
                    MenuItemModifierSpecForm.this.groupPricingTable.repaint();
                }
                super.doCancel();
            }
        };
        String caption = editMode ? Messages.getString("MenuItemModifierSpecForm.29") : Messages.getString("MenuItemModifierSpecForm.30");
        dialog.setTitle(caption);
        dialog.setCaption(caption);
        dialog.getContentPanel().add(this.priceInputPanel);
        dialog.pack();
        dialog.open();
    }

    private void showQuantityExceedMessage() {
        POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.31"));
        this.tfMaxQuantity.requestFocus();
        this.tfMaxQuantity.selectAll();
    }

    private Double getFirstModifierPrice() {
        return 0.0;
    }

    private Integer getNextQty() {
        if (this.groupPricingTableModel.getRowCount() == 0) {
            return 1;
        }
        int nextQty = 1;
        for (ModifierPricingRule pricingRule : this.groupPricingTableModel.getRows()) {
            if (pricingRule.getToQty() <= nextQty) continue;
            nextQty = pricingRule.getToQty();
        }
        if ((double)(nextQty + 1) > POSUtil.parseDouble(this.tfMaxQuantity.getText())) {
            return 1;
        }
        return nextQty + 1;
    }

    protected boolean isValidQtyRange(ModifierPricingRule pricing, int fromQty, int toQty) {
        if (toQty < fromQty) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.32"));
            this.tfFromQty.requestFocus();
            this.tfFromQty.selectAll();
            return false;
        }
        if (fromQty <= 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.33"));
            this.tfFromQty.requestFocus();
            this.tfFromQty.selectAll();
            return false;
        }
        if (toQty <= 0) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.33"));
            this.tfToQty.requestFocus();
            this.tfToQty.selectAll();
            return false;
        }
        if ((double)toQty > POSUtil.parseDouble(this.tfMaxQuantity.getText())) {
            this.showQuantityExceedMessage();
            this.tfToQty.requestFocus();
            this.tfToQty.selectAll();
            return false;
        }
        if (this.groupPricingTableModel.getRowCount() > 0) {
            for (ModifierPricingRule price : this.groupPricingTableModel.getRows()) {
                IntegerRange range;
                if (price == pricing || !(range = new IntegerRange(price.getFromQty().intValue(), price.getToQty().intValue())).contains(Integer.valueOf(fromQty)) && !range.contains(Integer.valueOf(toQty))) continue;
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.35"));
                return false;
            }
        }
        return true;
    }

    private ModifierPricingRule getSelectedPriceRule() {
        int selectedRow = this.groupPricingTable.getSelectedRow();
        if (selectedRow == -1) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("MenuItemModifierSpecForm.36"));
            return null;
        }
        return this.groupPricingTableModel.getRow(this.groupPricingTable.convertRowIndexToModel(selectedRow));
    }

    private void doAddNewModifierGroup() {
        try {
            ModifierGroupForm form = new ModifierGroupForm(new ModifierGroup());
            BeanEditorDialog dialog = new BeanEditorDialog(form);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ComboBoxModel model = (ComboBoxModel)this.cbMenuModifierGroup.getModel();
            Object modifierGroup = form.getBean();
            model.addElement(modifierGroup);
            this.cbMenuModifierGroup.setSelectedItem(modifierGroup);
        }
        catch (Exception e2) {
            BOMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
        }
    }

    public PosButton getAutoBuildButton() {
        return this.btnSaveAndAutoBuild;
    }

    @Override
    public boolean save() {
        return this.updateModel();
    }

    @Override
    protected void updateView() {
        MenuItemModifierSpec menuItemModifierSpec = this.getBean();
        if (menuItemModifierSpec == null) {
            return;
        }
        this.tfName.setText(menuItemModifierSpec.getName());
        this.tfMinQuantity.setText(String.valueOf(menuItemModifierSpec.getMinQuantity()));
        Integer maxQuantity = menuItemModifierSpec.getMaxQuantity();
        this.tfMaxQuantity.setText(String.valueOf(maxQuantity == 0 ? 1 : maxQuantity));
        this.tfSortOrder.setText(String.valueOf(menuItemModifierSpec.getSortOrder()));
        this.chkVisible.setSelected(menuItemModifierSpec.isEnable());
        this.taInstruction.setText(menuItemModifierSpec.getInstruction());
        this.chkJumbToNextGroup.setSelected(menuItemModifierSpec.isJumpGroup());
        this.chkAutoShow.setSelected(menuItemModifierSpec.isAutoShow());
        this.chkEnableGroupWisePricing.setSelected(menuItemModifierSpec.isEnableGroupPricing());
        ArrayList priceRules = menuItemModifierSpec.getPriceRules();
        if (priceRules == null) {
            priceRules = new ArrayList();
        }
        this.groupPricingTableModel.setRows(priceRules);
        this.setVisibleGroupWisePricePanel(this.chkEnableGroupWisePricing.isSelected());
        if (!this.editMode) {
            ComboBoxModel model = (ComboBoxModel)this.cbMenuModifierGroup.getModel();
            if (model.getSize() > 0) {
                for (ModifierGroup modifierGroup : model.getDataList()) {
                    if (this.hasSimilerGroupSpec(modifierGroup)) continue;
                    this.cbMenuModifierGroup.setSelectedItem(modifierGroup);
                    break;
                }
            }
            this.rbModifierGroupSettings.setSelected(true);
        } else if (menuItemModifierSpec.isEnableModifierGroupSettings()) {
            this.rbModifierGroupSettings.setSelected(menuItemModifierSpec.isEnableModifierGroupSettings());
        } else {
            this.rbOverrideModifierGroupSettings.setSelected(true);
        }
        this.cbMenuModifierGroup.setSelectedItem(menuItemModifierSpec.getModifierGroup());
        this.doUpdateComponantsState();
    }

    @Override
    protected boolean updateModel() {
        MenuItemModifierSpec menuItemModifierSpec = this.getBean();
        ModifierGroup selectedGroup = (ModifierGroup)this.cbMenuModifierGroup.getSelectedItem();
        if (selectedGroup == null) {
            return false;
        }
        if (this.hasSimilerGroupSpec(selectedGroup)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuItemModifierSpecForm.17"));
            return false;
        }
        int maxQty = this.tfMaxQuantity.getInteger();
        int minQty = this.tfMinQuantity.getInteger();
        if (maxQty < 1) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("MenuItemModifierSpecForm.111"));
            return false;
        }
        if (minQty > maxQty) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("ComboGroupItemSelectionDialog.15"));
            return false;
        }
        menuItemModifierSpec.setModifierGroup(selectedGroup);
        menuItemModifierSpec.setName(selectedGroup.getName());
        menuItemModifierSpec.setMinQuantity(minQty);
        menuItemModifierSpec.setMaxQuantity(maxQty);
        menuItemModifierSpec.setSortOrder(this.tfSortOrder.getInteger());
        menuItemModifierSpec.setEnable(this.chkVisible.isSelected());
        menuItemModifierSpec.setInstruction(this.taInstruction.getText());
        menuItemModifierSpec.setJumpGroup(this.chkJumbToNextGroup.isSelected());
        menuItemModifierSpec.setAutoShow(this.chkAutoShow.isSelected());
        menuItemModifierSpec.addProperty("enableGroupPricing", String.valueOf(this.chkEnableGroupWisePricing.isSelected()));
        if (!this.rbModifierGroupSettings.isSelected()) {
            POSMessageDialog.showMessage(Messages.getString("MenuItemModifierSpecForm.9"));
        } else if (menuItemModifierSpec.getModifierPages() != null) {
            menuItemModifierSpec.getModifierPages().clear();
            List<MenuItemModifierPage> modifierGroupPages = selectedGroup.getModifierGroupPages();
            for (MenuItemModifierPage menuItemModifierPage : modifierGroupPages) {
                menuItemModifierSpec.addTomodifierPages(menuItemModifierPage);
            }
        }
        menuItemModifierSpec.setModifierGroupSettings(this.rbModifierGroupSettings.isSelected());
        List<ModifierPricingRule> pricingRules = this.groupPricingTableModel.getRows();
        if (pricingRules == null || pricingRules.isEmpty()) {
            menuItemModifierSpec.removeProperty("priceRules");
        } else {
            this.doCreatePricingRule(menuItemModifierSpec, pricingRules);
        }
        return true;
    }

    private void doCreatePricingRule(MenuItemModifierSpec menuItemModifierSpec, List<ModifierPricingRule> pricingRules) {
        JsonArray groupPricingRulesJsonArray = new JsonArray();
        for (ModifierPricingRule priceRule : pricingRules) {
            JsonObject orderTypeObject = new JsonObject();
            orderTypeObject.addProperty("fromQty", (Number)priceRule.getFromQty());
            orderTypeObject.addProperty("toQty", (Number)priceRule.getToQty());
            orderTypeObject.addProperty("price", (Number)priceRule.getPrice());
            groupPricingRulesJsonArray.add((JsonElement)orderTypeObject);
        }
        menuItemModifierSpec.getPropertyStore().add("priceRules", (JsonElement)groupPricingRulesJsonArray);
    }

    private boolean hasSimilerGroupSpec(ModifierGroup selectedGroup) {
        if (this.editMode && selectedGroup.getName().equals(this.modifierSpec.getModifierGroup().getName())) {
            return false;
        }
        List<MenuItemModifierSpec> menuItemModiferSpecs = this.menuItem.getMenuItemModiferSpecs();
        if (menuItemModiferSpecs == null || menuItemModiferSpecs.isEmpty()) {
            return false;
        }
        for (MenuItemModifierSpec menuItemModifierSpec : menuItemModiferSpecs) {
            if (!menuItemModifierSpec.getModifierGroup().getName().equals(selectedGroup.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDisplayText() {
        MenuItemModifierSpec modifierGroup = this.getBean();
        if (modifierGroup.getId() == null) {
            return Messages.getString("MenuItemModifierSpecForm.18");
        }
        return Messages.getString("MenuItemModifierSpecForm.19");
    }

    public MenuItemModifierSpec getBean() {
        MenuItemModifierSpec menuItemModifierSpec = (MenuItemModifierSpec)super.getBean();
        if (menuItemModifierSpec == null) {
            menuItemModifierSpec = new MenuItemModifierSpec();
            this.setBean(menuItemModifierSpec);
        }
        return menuItemModifierSpec;
    }

    public Dimension getDefaultSize() {
        return new Dimension(600, 500);
    }

    public boolean isAutoBuildSelected() {
        return this.autoBuildSelected;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.doUpdateComponantsState();
    }

    private void doUpdateComponantsState() {
        boolean selected = this.rbModifierGroupSettings.isSelected();
        if (selected) {
            this.doSelectModifierGroup();
        }
        this.tfMinQuantity.setEditable(!selected);
        this.tfMaxQuantity.setEditable(!selected);
        this.tfSortOrder.setEditable(!selected);
        this.chkJumbToNextGroup.setEnabled(!selected);
        this.chkAutoShow.setEnabled(!selected);
        this.chkEnableGroupWisePricing.setEnabled(!selected);
        this.chkVisible.setEnabled(!selected);
        this.setVisibleGroupWisePricePanel(this.chkEnableGroupWisePricing.isSelected());
        this.groupPricingTable.setEditable(!selected);
        this.btnAdd.setEnabled(!selected);
        this.btnEdit.setEnabled(!selected);
        this.btnDelete.setEnabled(!selected);
        this.btnSaveAndAutoBuild.setVisible(!selected);
    }
}

