/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class PriceTableForm
extends BeanEditor<PriceTable>
implements ActionListener {
    private JTable priceTableItemTable;
    private PriceTableItemExplorerTableModel priceTableItemModel;
    private FixedLengthTextField tfName = new FixedLengthTextField();
    private JTextArea tfDescription = new JTextArea();
    private JButton addButton;
    private JButton deleteButton;
    private boolean viewMode;
    private JLabel lblNumberOfItem = new JLabel();
    private PosButton btnNext;
    private PosButton btnPrev;
    protected PaginatedListModel dataModel = new PaginatedListModel();
    private boolean edit = false;

    public PriceTableForm(PriceTable priceTable) {
        this.initComponents();
        this.priceTableItemModel = new PriceTableItemExplorerTableModel();
        this.priceTableItemTable.setModel(this.priceTableItemModel);
        this.setBean(priceTable);
        this.resizeTableColumns();
        this.priceTableItemTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        DoubleTextField tfPrice = new DoubleTextField();
        tfPrice.setAllowNegativeValue(true);
        tfPrice.setHorizontalAlignment(4);
        DefaultCellEditor editorPrice = new DefaultCellEditor(tfPrice);
        editorPrice.setClickCountToStart(1);
        this.priceTableItemTable.setDefaultEditor(this.priceTableItemTable.getColumnClass(4), editorPrice);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill", "[][grow]", ""));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.priceTableItemTable = new JTable(){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                if (column != 4) {
                    return;
                }
                PriceTableForm.this.priceTableItemTable.editCellAt(row, column);
                PriceTableForm.this.priceTableItemTable.transferFocus();
                DefaultCellEditor editor = (DefaultCellEditor)PriceTableForm.this.priceTableItemTable.getCellEditor(row, column);
                if (column == 4) {
                    DoubleTextField textField = (DoubleTextField)editor.getComponent();
                    textField.requestFocus();
                    textField.selectAll();
                    PriceTableForm.this.edit = true;
                }
            }
        };
        this.priceTableItemTable.setRowHeight(PosUIManager.getSize(30));
        this.tfName.setLength(30);
        this.add(new JLabel(Messages.getString("NAME")));
        this.add((Component)this.tfName, "growx,wrap");
        this.tfDescription.setLineWrap(true);
        this.tfDescription.setDocument(new FixedLengthDocument(255));
        this.add((Component)new JLabel(Messages.getString("PriceTableForm.6")), "growx,aligny top");
        JScrollPane scrollPane = new JScrollPane(this.tfDescription);
        this.add((Component)scrollPane, "growx,h 70!,top,wrap");
        this.add((Component)new JScrollPane(this.priceTableItemTable), "span,grow");
        this.addButtonPanel();
    }

    private void scrollDown() {
        PriceTable priceTable = (PriceTable)this.getBean();
        if (this.edit) {
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, this.dataModel.getDataList());
            this.edit = false;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.updateData();
    }

    private void updateData() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.dataModel.setNumRows(PriceTableItemDAO.getInstance().rowCount(priceTable));
        PriceTableItemDAO.getInstance().loadItems(priceTable, this.dataModel);
        this.priceTableItemModel.setItems(this.dataModel.getDataList());
        this.updateButton();
        this.priceTableItemTable.revalidate();
        this.priceTableItemTable.repaint();
    }

    private void scrollUp() {
        PriceTable priceTable = (PriceTable)this.getBean();
        if (this.edit) {
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, this.dataModel.getDataList());
            this.edit = false;
        }
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.updateData();
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.dataModel.getCurrentRowIndex() + 1;
        int endNumber = this.dataModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.dataModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("PriceTableForm.10"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.dataModel.hasPrevious());
        this.btnNext.setEnabled(this.dataModel.hasNext());
    }

    private void addButtonPanel() {
        this.addButton = new JButton(Messages.getString("PriceTableForm.11"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    if (!PriceTableForm.this.updateModel()) {
                        return;
                    }
                    MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
                    dialog.setSelectionMode(1);
                    dialog.setSize(PosUIManager.getSize(600, 515));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    ArrayList<PriceTableItem> priceTableItems = new ArrayList<PriceTableItem>();
                    PriceTable priceTable = (PriceTable)PriceTableForm.this.getBean();
                    List<MenuItem> menuItemList = dialog.getSelectedItems();
                    for (MenuItem menuItem : menuItemList) {
                        PriceTableItem existingItem = null;
                        if (priceTable.getId() != null) {
                            existingItem = PriceTableItemDAO.getInstance().getItem(priceTable, menuItem);
                        }
                        if (existingItem != null) continue;
                        PriceTableItem item = new PriceTableItem();
                        item.setMenuItem(menuItem);
                        item.setMenuItemId(menuItem.getId());
                        item.setItemBarcode(menuItem.getBarcode());
                        item.setPrice(menuItem.getPrice());
                        priceTableItems.add(item);
                    }
                    PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, priceTableItems);
                    PriceTableForm.this.dataModel.setNumRows(PriceTableItemDAO.getInstance().rowCount(priceTable));
                    PriceTableForm.this.dataModel.setCurrentRowIndex(0);
                    PriceTableItemDAO.getInstance().loadItems(priceTable, PriceTableForm.this.dataModel);
                    PriceTableForm.this.updateButton();
                    PriceTableForm.this.priceTableItemModel.setItems(PriceTableForm.this.dataModel.getDataList());
                    PriceTableForm.this.priceTableItemTable.revalidate();
                    PriceTableForm.this.priceTableItemTable.repaint();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.deleteButton = new JButton(POSConstants.DELETE);
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = PriceTableForm.this.priceTableItemTable.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = PriceTableForm.this.priceTableItemTable.convertRowIndexToModel(index);
                    PriceTableItem priceTableItem = PriceTableForm.this.priceTableItemModel.getPriceTableItem(index);
                    PriceTableItemDAO.getInstance().delete(priceTableItem);
                    PriceTableForm.this.dataModel.setNumRows(PriceTableForm.this.dataModel.getNumRows() - 1);
                    PriceTableForm.this.dataModel.removeElement(priceTableItem);
                    PriceTableForm.this.priceTableItemModel.deleteItem(priceTableItem, index);
                    PriceTableForm.this.updateButton();
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.dataModel.setPageSize(20);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][]", ""));
        paginationButtonPanel.add((Component)this.addButton, "split 2,top");
        paginationButtonPanel.add((Component)this.deleteButton, "top");
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,span");
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        paginationButtonPanel.add(this.btnNext);
        this.add((Component)paginationButtonPanel, "growx,span 2");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == PriceTableForm.this.btnPrev) {
                        PriceTableForm.this.scrollUp();
                    } else if (source == PriceTableForm.this.btnNext) {
                        PriceTableForm.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private void resizeTableColumns() {
        this.priceTableItemTable.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(100));
        this.setColumnWidth(1, PosUIManager.getSize(100));
        this.setColumnWidth(3, PosUIManager.getSize(100));
        this.setColumnWidth(4, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.priceTableItemTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.DELETE.equals(actionCommand)) {
            int index = this.priceTableItemTable.getSelectedRow();
            if (index < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            PriceTableItem menuItem = this.priceTableItemModel.getPriceTableItem(index);
            this.deletePriceTableItem(index, menuItem);
        }
    }

    private void deletePriceTableItem(int index, PriceTableItem priceTableItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.priceTableItemModel.deleteItem(priceTableItem, index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            PriceTable priceTable = (PriceTable)this.getBean();
            PriceTableItemDAO.getInstance().saveOrUpdateItems(priceTable, this.dataModel.getDataList());
            return true;
        }
        catch (IllegalModelStateException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected void updateView() {
        PriceTable priceTable = (PriceTable)this.getBean();
        this.tfName.setText(priceTable.getName());
        this.tfDescription.setText(priceTable.getDescription());
        if (priceTable.getId() == null) {
            return;
        }
        this.dataModel.setCurrentRowIndex(0);
        this.updateData();
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        PriceTable priceTable = (PriceTable)this.getBean();
        String name = this.tfName.getText();
        if (StringUtils.isBlank((String)name)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PriceTableForm.28"));
            return false;
        }
        priceTable.setName(name.trim());
        priceTable.setDescription(this.tfDescription.getText());
        priceTable.setLastUpdateTime(new Date());
        priceTable.setLastUpdatedBy(Application.getCurrentUser().getId());
        return true;
    }

    @Override
    public String getDisplayText() {
        if (this.viewMode) {
            return Messages.getString("PriceTableForm.29");
        }
        if (((PriceTable)this.getBean()).getId() == null) {
            return Messages.getString("PriceTableForm.30");
        }
        return Messages.getString("PriceTableForm.31");
    }

    public void setEditable(boolean b) {
        boolean bl = this.viewMode = !b;
        if (this.viewMode) {
            this.addButton.setVisible(false);
            this.deleteButton.setVisible(false);
            this.tfDescription.setEnabled(false);
            this.tfName.setEnabled(false);
            this.priceTableItemTable.setEnabled(false);
        }
    }

    private class PriceTableItemExplorerTableModel
    extends ListTableModel<PriceTableItem> {
        String[] columnNames = new String[]{Messages.getString("PriceTableForm.22"), Messages.getString("PriceTableForm.23"), Messages.getString("PriceTableForm.24"), Messages.getString("PriceTableForm.25"), Messages.getString("PriceTableForm.26")};
        List<PriceTableItem> priceTableItemList = new ArrayList<PriceTableItem>();

        public void setItems(List<PriceTableItem> priceTableItems) {
            if (priceTableItems == null) {
                return;
            }
            this.priceTableItemList.clear();
            this.priceTableItemList.addAll(priceTableItems);
        }

        public List<PriceTableItem> getItems() {
            return this.priceTableItemList;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 4;
        }

        @Override
        public int getRowCount() {
            if (this.priceTableItemList == null) {
                return 0;
            }
            return this.priceTableItemList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4 || columnIndex == 3) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.priceTableItemList == null) {
                return "";
            }
            PriceTableItem priceTableItem = this.priceTableItemList.get(row);
            if (priceTableItem == null) {
                return "";
            }
            switch (column) {
                case 0: {
                    return priceTableItem.getMenuItem().getId();
                }
                case 1: {
                    return priceTableItem.getMenuItem().getBarcode();
                }
                case 2: {
                    return priceTableItem.getMenuItem().getDisplayName();
                }
                case 3: {
                    return priceTableItem.getMenuItem().getPrice();
                }
                case 4: {
                    return priceTableItem.getPrice();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            PriceTableItem priceTableItem = this.priceTableItemList.get(rowIndex);
            if (priceTableItem == null) {
                return;
            }
            if (columnIndex == 4) {
                String priceString = (String)aValue;
                if (priceString.isEmpty()) {
                    return;
                }
                double price = Double.parseDouble(priceString);
                priceTableItem.setPrice(price);
            } else {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }

        public void deleteItem(PriceTableItem priceTableItem, int index) {
            Iterator<PriceTableItem> iterator = this.priceTableItemList.iterator();
            while (iterator.hasNext()) {
                PriceTableItem item = iterator.next();
                if (priceTableItem != item) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(index, index);
        }

        public PriceTableItem getPriceTableItem(int index) {
            return this.priceTableItemList.get(index);
        }
    }
}

