/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.actions.ItemReorderAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.BarTabButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.VerticalSimpleScrollPane;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.floorplan.UiRenderer;
import com.floreantpos.ui.tableselection.TableSelectionView;
import com.floreantpos.ui.views.TableLayoutView;
import com.floreantpos.util.CurrencyUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;

public class BarTabSelectionView
extends JPanel
implements UiRenderer {
    private Map<Ticket, BarTabButton> tableButtonMap = new HashMap<Ticket, BarTabButton>();
    private JPanel buttonsPanel;
    private OrderType orderType;
    private TableSelectionView tableSelectionView;

    public BarTabSelectionView() {
        this((TableSelectionView)null);
    }

    public BarTabSelectionView(TableSelectionView tableSelectionView) {
        this.tableSelectionView = tableSelectionView;
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.buttonsPanel = new JPanel(new WrapLayout());
        TitledBorder titledBorder1 = BorderFactory.createTitledBorder(null, Messages.getString("BarTabSelectionView.0"), 2, 0);
        JPanel rootPanel = new JPanel(new BorderLayout(5, 5));
        rootPanel.setBorder(new CompoundBorder(titledBorder1, new EmptyBorder(2, 2, 2, 2)));
        VerticalSimpleScrollPane scrollPane = new VerticalSimpleScrollPane(this.buttonsPanel);
        rootPanel.add((Component)((Object)scrollPane), "Center");
        this.add((Component)rootPanel, "Center");
    }

    private void rendererBarTickets() {
        List<Ticket> openTickets = TicketDAO.getInstance().findBarTabOpenTickets(this.orderType);
        if (openTickets != null && openTickets.size() > 0) {
            for (Ticket ticket : openTickets) {
                BarTabButton barTabButton = new BarTabButton(ticket);
                barTabButton.setPreferredSize(PosUIManager.getSize(157, 138));
                barTabButton.setFont(new Font(barTabButton.getFont().getName(), 1, 24));
                barTabButton.setText(barTabButton.getText());
                barTabButton.addActionListener(e -> this.bartabSelected((BarTabButton)e.getSource()));
                barTabButton.update();
                this.buttonsPanel.add(barTabButton);
                this.tableButtonMap.put(ticket, barTabButton);
                String customerName = barTabButton.getTicket().getProperty("CUSTOMER_NAME");
                if (customerName == null) {
                    customerName = Messages.getString("GUEST");
                }
                barTabButton.setText("<html><center>" + customerName + "<br><h4 style='margin:0px;'>" + ticket.getOwner().getFirstName() + "<br>Chk#" + ticket.getId() + "</h4>" + CurrencyUtil.getCurrencySymbol() + ticket.getTotalAmountWithTips() + "<br><small style='margin:0px;'>Due: " + CurrencyUtil.getCurrencySymbol() + ticket.getDueAmount() + "</small></center></html>");
                if (!ticket.getOwner().getId().equals(Application.getCurrentUser().getId())) {
                    barTabButton.setBackground(new Color(139, 0, 139));
                    barTabButton.setForeground(Color.WHITE);
                }
                barTabButton.setTicket(ticket);
                barTabButton.setUser(ticket.getOwner());
            }
        }
    }

    private boolean shouldReorder() {
        return this.tableSelectionView != null && this.tableSelectionView.shouldReorder();
    }

    private void bartabSelected(BarTabButton barTabButton) {
        if (!barTabButton.hasUserAccess()) {
            return;
        }
        this.closeDialog(false);
        TableLayoutView tableLayoutView = TableLayoutView.getInstance();
        Ticket ticket = barTabButton.getTicket();
        if (tableLayoutView.shouldGuestCheck()) {
            new ShowOrderInfoAction(ticket).actionPerformed(null);
            tableLayoutView.clearSelection();
            return;
        }
        if (tableLayoutView.shouldSettle()) {
            new SettleTicketAction(ticket).actionPerformed(null);
            tableLayoutView.clearSelection();
            return;
        }
        if (this.shouldReorder()) {
            ItemReorderAction itemReorderAction = new ItemReorderAction(ticket);
            itemReorderAction.execute();
            this.tableSelectionView.clearSelection();
        } else {
            new TicketEditAction(ticket).actionPerformed(null);
            tableLayoutView.clearSelection();
        }
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(false);
            windowAncestor.dispose();
        }
    }

    public void updateView(OrderType orderType) {
        this.orderType = orderType;
        this.buttonsPanel.removeAll();
        this.tableButtonMap.clear();
        this.rendererBarTickets();
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
    }

    @Override
    public void render() {
        this.updateView(this.orderType);
    }

    public void setOrderType(OrderType orderType) {
        this.orderType = orderType;
    }
}

