/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.model.GiftCard;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.QwertyKeyPad;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.NumberUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class GiftCardActivateView
extends POSDialog {
    private POSTextField txtCardNumber;
    private POSTextField txtHolder;
    private GiftCard giftCard;
    private GiftCardProcessor giftCardProcessor;
    private JLabel lblValidity;
    private IntegerTextField txtValidity;
    private JComboBox<String> cbDuration;

    public GiftCardActivateView(GiftCardProcessor giftCardProcessor) {
        this.giftCardProcessor = giftCardProcessor;
        this.init();
    }

    public GiftCardActivateView(GiftCardProcessor giftCardProcessor, GiftCard giftCard) {
        this.giftCardProcessor = giftCardProcessor;
        this.giftCard = giftCard;
        this.init();
        this.updateView();
    }

    private void updateView() {
        if (this.giftCard != null) {
            this.updateVisiblityOfValidityUi(this.giftCard.isExpried());
            this.txtCardNumber.setText(this.giftCard.getCardNumber());
            this.txtCardNumber.setEditable(false);
            this.txtHolder.setText(this.giftCard.getOwnerName());
            this.txtValidity.setText(String.valueOf(this.giftCard.getDuration()));
            this.cbDuration.setSelectedItem(this.giftCard.getDurationType());
        }
    }

    public GiftCardActivateView(JFrame parent) {
        this.init();
    }

    private void init() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("GiftCardActivateView.0"));
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3,fillx,aligny", "[][]", ""));
        JLabel lblNumberOfCard = new JLabel(Messages.getString("GiftCardActivateView.3"));
        this.txtCardNumber = new POSTextField(20);
        JLabel lblHolder = new JLabel(Messages.getString("GiftCardActivateView.4"));
        this.txtHolder = new POSTextField(20);
        this.lblValidity = new JLabel(Messages.getString("GiftCardGeneratorView.6"));
        this.txtValidity = new IntegerTextField(20, 3);
        this.cbDuration = new JComboBox();
        this.cbDuration.addItem("DAY");
        this.cbDuration.addItem("MONTH");
        this.cbDuration.addItem("YEAR");
        this.cbDuration.setSelectedItem("YEAR");
        this.updateVisiblityOfValidityUi(Boolean.FALSE);
        QwertyKeyPad keyPad = new QwertyKeyPad();
        centerPanel.add((Component)lblNumberOfCard, "cell 0 0, alignx right");
        centerPanel.add((Component)this.txtCardNumber, "cell 1 0");
        centerPanel.add((Component)lblHolder, "cell 0 1,alignx right");
        centerPanel.add((Component)this.txtHolder, "cell 1 1");
        centerPanel.add((Component)this.lblValidity, "cell 0 2,alignx right");
        centerPanel.add((Component)this.txtValidity, "cell 1 2,split 2");
        centerPanel.add(this.cbDuration, "cell 1 3");
        centerPanel.add((Component)((Object)keyPad), "newline,span 2,gaptop 10,growx");
        this.add((Component)centerPanel, "Center");
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnGenerate = new PosButton(Messages.getString("OK"));
        buttonPanel.add((Component)btnGenerate, "grow");
        btnGenerate.addActionListener(e -> this.doGenerate());
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("CANCEL"))));
        this.add((Component)buttonPanel, "South");
    }

    private void updateVisiblityOfValidityUi(boolean isVisible) {
        this.lblValidity.setVisible(isVisible);
        this.txtValidity.setVisible(isVisible);
        this.cbDuration.setVisible(isVisible);
    }

    public void doGenerate() {
        if (this.save()) {
            this.giftCardProcessor.activate(this.giftCard);
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.22"));
            this.dispose();
        }
    }

    private boolean save() {
        String cardNo = this.txtCardNumber.getText();
        String holder = this.txtHolder.getText();
        int duration = this.txtValidity.getInteger();
        String durationType = (String)this.cbDuration.getSelectedItem();
        if (StringUtils.isEmpty((String)cardNo)) {
            MessageDialog.showError(Messages.getString("GiftCardNotFound"));
            return false;
        }
        if (StringUtils.isEmpty((String)holder)) {
            MessageDialog.showError(Messages.getString("GiftCardActivateView.26"));
            return false;
        }
        if (this.txtValidity.isVisible() && NumberUtil.isZero(duration)) {
            POSMessageDialog.showError(this, Messages.getString("GiftCardGeneratorView.32"));
            return false;
        }
        this.giftCard = this.giftCardProcessor.getCard(cardNo);
        if (this.giftCard == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardNotFound"));
            return false;
        }
        if (this.giftCard.isActive().booleanValue() && !this.giftCard.isExpried()) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardActivateView.25"));
            return false;
        }
        Calendar c = Calendar.getInstance();
        Date activationDate = c.getTime();
        this.giftCard.setOwnerName(holder);
        this.giftCard.setActivationDate(activationDate);
        this.giftCard.setDuration(duration);
        this.giftCard.setDurationType(durationType);
        this.giftCard.setDeActivationDate(null);
        this.giftCard.setExpiryDate(this.giftCard.prepareExpireDate(activationDate));
        this.giftCard.setActive(true);
        this.giftCard.setDisable(false);
        return true;
    }

    public GiftCard getGiftCard() {
        return this.giftCard;
    }
}

