/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.GiftCertificateTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.ext.PaperSize;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.report.ReportUtil;
import com.floreantpos.report.model.GiftCardTransactionsReportModel;
import com.floreantpos.services.report.ReportService;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOptionPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardTransactionInfoDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRTableModelDataSource;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class GiftCardTransactionInfoView
extends POSDialog {
    private JXTable table;
    private BeanTableModel<PosTransaction> tableModel;
    private Pattern pattern;
    private Matcher matcher;
    private static final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private GiftCardProcessor giftCardProcessor;
    private GiftCard giftCard;
    private JXDatePicker fromDatePicker;
    private JXDatePicker toDatePicker;
    private List<PosTransaction> transactionList;

    public GiftCardTransactionInfoView(GiftCard giftCard, GiftCardProcessor giftCardProcessor) {
        this.giftCardProcessor = giftCardProcessor;
        this.giftCard = giftCard;
        this.init();
    }

    private void init() {
        JPanel searchPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("TransactionInfo"));
        searchPanel.add((Component)titlePanel, "grow,span");
        JLabel lblFromDate = new JLabel(Messages.getString("GiftCardTransactionInfoView.3"));
        this.fromDatePicker = new JXDatePicker(new Date());
        JLabel lblToDate = new JLabel(Messages.getString("GiftCardTransactionInfoView.4"));
        this.toDatePicker = new JXDatePicker(new Date());
        JButton btnSearch = new JButton(Messages.getString("Search"));
        searchPanel.add((Component)lblFromDate, "split 5");
        searchPanel.add((Component)this.fromDatePicker, "gapright 10");
        searchPanel.add(lblToDate);
        searchPanel.add((Component)this.toDatePicker, "gapright 10");
        searchPanel.add(btnSearch);
        btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardTransactionInfoView.this.doShowTransactions();
            }
        });
        this.add((Component)searchPanel, "North");
        this.pattern = Pattern.compile(EMAIL_PATTERN);
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        this.tableModel = new BeanTableModel(PosTransaction.class);
        this.tableModel.addColumn(Messages.getString("TRANSACTION_TIME"), "transactionTime");
        this.tableModel.addColumn(Messages.getString("AMOUNT"), "amount");
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(30);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Date) {
                    return super.getTableCellRendererComponent(table, DateUtil.formatReportDateAsString((Date)value), isSelected, hasFocus, row, column);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.table.getColumnModel().getColumn(1).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                PosTransaction transaction;
                if (value instanceof Double && (transaction = (PosTransaction)GiftCardTransactionInfoView.this.tableModel.getRow(row)) instanceof GiftCertificateTransaction) {
                    double amount = (Double)value;
                    return super.getTableCellRendererComponent(table, NumberUtil.formatNumberAcceptNegative(amount * -1.0), isSelected, hasFocus, row, column);
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        centerPanel.add((Component)new JScrollPane((Component)this.table), "grow");
        this.add((Component)centerPanel, "Center");
        this.resizeColumnWidth((JTable)this.table);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        PosButton btnPrint = new PosButton(Messages.getString("Print"));
        buttonPanel.add((Component)btnPrint, "grow");
        btnPrint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardTransactionInfoView.this.doPrint();
            }
        });
        PosButton btnEmail = new PosButton(Messages.getString("Email"));
        buttonPanel.add((Component)btnEmail, "grow");
        btnEmail.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GiftCardTransactionInfoView.this.doEmail();
            }
        });
        buttonPanel.add(new PosButton(new CloseDialogAction(this, Messages.getString("Cancel"))));
        this.add((Component)buttonPanel, "South");
    }

    private void doShowTransactions() {
        Date toDate;
        Date fromDate = this.fromDatePicker.getDate();
        if (fromDate.after(toDate = this.toDatePicker.getDate())) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        this.transactionList = this.giftCardProcessor.getTransactionList(this.giftCard.getCardNumber(), fromDate, toDate);
        if (this.transactionList == null || this.transactionList.isEmpty()) {
            this.tableModel.removeAll();
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionDialog.15"));
            return;
        }
        this.tableModel.setRows(this.transactionList);
    }

    public void doPrint() {
        JasperPrint reportCreation = this.reportCreation();
        if (reportCreation == null) {
            return;
        }
        GiftCardTransactionInfoDialog reportDialog = new GiftCardTransactionInfoDialog(reportCreation);
        reportDialog.setTitle(Messages.getString("GiftCardTransactionInfoView.14"));
        reportDialog.setDefaultCloseOperation(2);
        reportDialog.setSize(PosUIManager.getSize(900, 600));
        reportDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        reportDialog.setVisible(true);
    }

    public void doEmail() {
        String email = PosOptionPane.showInputDialog(Messages.getString("GiftCardTransactionInfoView.15"));
        if (email == null) {
            return;
        }
        this.matcher = this.pattern.matcher(email);
        if (this.matcher.matches()) {
            JasperPrint reportCreation = this.reportCreation();
            if (reportCreation == null) {
                return;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            JRPdfExporter exporter = new JRPdfExporter();
            exporter.setParameter(JRPdfExporterParameter.JASPER_PRINT, (Object)reportCreation);
            exporter.setParameter(JRPdfExporterParameter.OUTPUT_STREAM, (Object)byteArrayOutputStream);
            try {
                exporter.exportReport();
            }
            catch (JRException e) {
                PosLog.error(this.getClass(), (Exception)((Object)e));
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            MailService.sendMail(email, Messages.getString("GiftCardTransactionInfoView.0"), Messages.getString("GiftCardTransactionInfoView.18"), Messages.getString("GiftCardTransactionInfoView.18"), "GiftCardTransactionReport.pdf", bytes);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.20"));
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.21"));
            this.doEmail();
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(100);
        columnWidth.add(150);
        columnWidth.add(180);
        columnWidth.add(200);
        columnWidth.add(300);
        return columnWidth;
    }

    public JasperPrint reportCreation() {
        JasperPrint print = null;
        try {
            if (this.transactionList == null || this.transactionList.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardTransactionInfoView.10"));
                return null;
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            ReportUtil.populateRestaurantProperties(parameters);
            parameters.put("reportTitle", Messages.getString("GiftCardTransactionsReport"));
            parameters.put("cardNo", this.giftCard.getCardNumber() != null ? this.giftCard.getCardNumber() : "");
            parameters.put("cardOwner", this.giftCard.getOwnerName() != null ? this.giftCard.getOwnerName() : "");
            parameters.put("endBalance", this.giftCard.getBalance() != null ? NumberUtil.formatNumber(this.giftCard.getBalance()) : "");
            parameters.put("reportTime", ReportService.formatFullDate(new Date()));
            parameters.put("terminalName", String.valueOf(TerminalConfig.getTerminalId()));
            parameters.put("currency", CurrencyUtil.getCurrencySymbol());
            parameters.put("activeDate", ReportService.formatFullDate(this.giftCard.getActivationDate()));
            JasperReport report = ReportUtil.getReport(PaperSize.getReportNameAccording2Size("gift_card_transaction_report"));
            print = JasperFillManager.fillReport((JasperReport)report, parameters, (JRDataSource)new JRTableModelDataSource((TableModel)new GiftCardTransactionsReportModel(this.transactionList)));
        }
        catch (Exception e) {
            PosLog.info(this.getClass(), "" + e.getMessage());
        }
        return print;
    }
}

