/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class MenuCategorySelectionView
extends JPanel {
    private JComboBox cbOrderTypes;
    private JXTable table;
    private BeanTableModel<MenuCategory> tableModel;
    private JTextField tfName;
    private MenuCategory parentMenuCategory;
    private PosButton btnNext;
    private PosButton btnPrev;
    private OrderType orderType;
    private JLabel lblNumberOfItem = new JLabel();
    private JLabel lblName;
    private JButton btnSearch;
    private JPanel searchPanel;
    private Map<String, MenuCategory> addedMenuCategoryMap = new HashMap<String, MenuCategory>();
    private JCheckBox chkShowSelected;
    private JCheckBox chkSelectAll;
    private JLabel lblOrderType;
    public static final int SINGLE_SELECTION = 0;
    public static final int MULTIPLE_SELECTION = 1;

    public MenuCategorySelectionView(List<MenuCategory> addedMenuCategories) {
        this.initComponents();
        this.tableModel.setCurrentRowIndex(0);
        this.cbOrderTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuCategorySelectionView.this.chkSelectAll.setEnabled(true);
                MenuCategorySelectionView.this.tableModel.setCurrentRowIndex(0);
                MenuCategorySelectionView.this.setSelectedOrderTypes(MenuCategorySelectionView.this.cbOrderTypes.getSelectedItem());
            }
        });
        this.setMenuCategories(addedMenuCategories);
        this.searchItem();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new BeanTableModel(MenuCategory.class);
        this.tableModel.addColumn("", "visible");
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.tableModel.setPageSize(10);
        this.table = new JXTable(this.tableModel);
        this.table.setSelectionMode(2);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(40));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    MenuCategorySelectionView.this.editSelectedRow();
                } else {
                    MenuCategorySelectionView.this.selectItem();
                }
            }
        });
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(10, 5, 10, 5));
        JScrollPane scroll = new JScrollPane((Component)this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        contentPanel.add(scroll);
        contentPanel.add((Component)this.buildSearchForm(), "North");
        this.add(contentPanel);
        this.resizeColumnWidth((JTable)this.table);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 5 0 0 0,fillx", "[left,grow][][][]", ""));
        paginationButtonPanel.add((Component)this.createButtonPanel(), "left,split 2");
        this.chkShowSelected = new JCheckBox(Messages.getString("MenuCategorySelectionView.5"));
        this.chkShowSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategorySelectionView.this.updateView();
            }
        });
        paginationButtonPanel.add(this.chkShowSelected);
        paginationButtonPanel.add((Component)this.lblNumberOfItem, "split 3,center");
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png"));
        paginationButtonPanel.add((Component)this.btnPrev, "center");
        PosButton btnDot = new PosButton();
        btnDot.setBorder(null);
        btnDot.setOpaque(false);
        btnDot.setContentAreaFilled(false);
        btnDot.setIcon(IconFactory.getIcon("/ui_icons/", "dot.png"));
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png"));
        paginationButtonPanel.add(this.btnNext);
        paginationButtonPanel.add((Component)new JSeparator(), "newline,span,grow");
        contentPanel.add((Component)paginationButtonPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == MenuCategorySelectionView.this.btnPrev) {
                        MenuCategorySelectionView.this.scrollUp();
                    } else if (source == MenuCategorySelectionView.this.btnNext) {
                        MenuCategorySelectionView.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
    }

    private void updateView() {
        if (this.chkShowSelected.isSelected()) {
            this.tableModel.setRows(new ArrayList<MenuCategory>(this.addedMenuCategoryMap.values()));
            this.updateMenuCategorySelection();
            String string = String.format(Messages.getString("ShowSelected"), this.addedMenuCategoryMap.values().size());
            this.chkShowSelected.setText(string);
            this.lblNumberOfItem.setText("");
            this.btnPrev.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.cbOrderTypes.setEnabled(false);
            this.table.repaint();
        } else {
            if (this.cbOrderTypes.getSelectedItem() != null) {
                this.searchItem();
            }
            this.cbOrderTypes.setEnabled(true);
        }
    }

    private JPanel buildSearchForm() {
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout((LayoutManager)new MigLayout("inset 0,fillx,hidemode 3", "", "[]10[]"));
        this.lblName = new JLabel(POSConstants.NAME + ":");
        this.tfName = new JTextField(15);
        this.btnSearch = new JButton(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
        this.searchPanel.add((Component)this.lblName, "align label,split 5");
        this.searchPanel.add((Component)this.tfName, "growx");
        this.chkSelectAll = new JCheckBox(Messages.getString("MenuCategorySelectionView.18"));
        this.chkSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategorySelectionView.this.selectOrderTypes();
            }
        });
        this.cbOrderTypes = new JComboBox();
        ArrayList<Object> groups = new ArrayList<Object>();
        groups.add(Messages.getString("MenuCategorySelectionView.19"));
        List<OrderType> orderTypeList = OrderTypeDAO.getInstance().findAll();
        groups.addAll(orderTypeList);
        ComboBoxModel model = new ComboBoxModel(groups);
        this.cbOrderTypes.setModel(model);
        this.cbOrderTypes.setSelectedItem(Messages.getString("MenuCategorySelectionView.20"));
        this.cbOrderTypes.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MenuCategorySelectionView.this.searchItem();
            }
        });
        this.searchPanel.add(this.btnSearch);
        this.lblOrderType = new JLabel(Messages.getString("MenuCategorySelectionView.21"));
        this.searchPanel.add((Component)this.lblOrderType, "split 2,right");
        this.searchPanel.add((Component)this.cbOrderTypes, "wrap");
        this.searchPanel.add((Component)this.chkSelectAll, "left");
        this.btnSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategorySelectionView.this.searchItem();
            }
        });
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategorySelectionView.this.searchItem();
            }
        });
        return this.searchPanel;
    }

    private void searchItem() {
        this.orderType = this.cbOrderTypes.getSelectedItem() instanceof OrderType ? (OrderType)this.cbOrderTypes.getSelectedItem() : null;
        this.tableModel.setCurrentRowIndex(0);
        MenuCategoryDAO.getInstance().findCategories(this.tableModel, true, null);
        this.doSetVisibleCheckAll();
        this.updateButton();
        this.updateMenuCategorySelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void selectOrderTypes() {
        Object selectedOrderType = this.cbOrderTypes.getSelectedItem();
        if (selectedOrderType instanceof OrderType) {
            List<MenuCategory> categories = this.tableModel.getRows();
            if (categories != null && categories.size() > 0) {
                for (MenuCategory item : categories) {
                    if (this.parentMenuCategory != null && this.parentMenuCategory.getId() != null && this.parentMenuCategory.getId().equals(item.getId())) continue;
                    item.setVisible(this.chkSelectAll.isSelected());
                    if (item.isVisible().booleanValue()) {
                        this.addedMenuCategoryMap.put(item.getId(), item);
                        continue;
                    }
                    this.addedMenuCategoryMap.remove(item.getId());
                }
            } else {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuCategorySelectionView.25"));
                this.chkSelectAll.setSelected(false);
            }
        } else {
            List<MenuCategory> menuItems = this.tableModel.getRows();
            if (menuItems == null) {
                return;
            }
            for (MenuCategory item : menuItems) {
                if (this.parentMenuCategory != null && this.parentMenuCategory.getId() != null && this.parentMenuCategory.getId().equals(item.getId())) continue;
                item.setVisible(this.chkSelectAll.isSelected());
                if (item.isVisible().booleanValue()) {
                    this.addedMenuCategoryMap.put(item.getId(), item);
                } else {
                    this.addedMenuCategoryMap.remove(item.getId());
                }
                this.chkShowSelected.setText(Messages.getString("MenuCategorySelectionView.35") + "(" + this.addedMenuCategoryMap.values().size() + ")");
                this.table.repaint();
            }
        }
        this.table.repaint();
    }

    private void updateMenuCategorySelection() {
        List<MenuCategory> menuCategories = this.tableModel.getRows();
        if (menuCategories == null) {
            return;
        }
        Iterator<MenuCategory> iterator = menuCategories.iterator();
        while (iterator.hasNext()) {
            MenuCategory category;
            MenuCategory item = this.addedMenuCategoryMap.get((category = iterator.next()).getId());
            category.setVisible(item != null);
        }
    }

    private void updateButton() {
        int totalNumber;
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        if (endNumber > (totalNumber = this.tableModel.getNumRows())) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format(Messages.getString("MenuCategorySelectionView.28"), startNumber, endNumber, totalNumber));
        this.btnPrev.setEnabled(this.tableModel.hasPrevious());
        this.btnNext.setEnabled(this.tableModel.hasNext());
        if (this.tableModel.getRowCount() > 0) {
            this.table.setRowSelectionInterval(0, 0);
        }
        String string = String.format(Messages.getString("ShowSelected"), this.addedMenuCategoryMap.values().size());
        this.chkShowSelected.setText(string);
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton btnEdit = explorerButton.getEditButton();
        JButton btnAdd = explorerButton.getAddButton();
        btnAdd.setText(POSConstants.ADD);
        btnEdit.setText(POSConstants.EDIT);
        btnEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MenuCategorySelectionView.this.editSelectedRow();
            }
        });
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuCategory menuCategory = new MenuCategory();
                    MenuCategoryForm editor = new MenuCategoryForm(menuCategory);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuCategory category = (MenuCategory)editor.getBean();
                    MenuCategorySelectionView.this.tableModel.addRow(category);
                    MenuCategorySelectionView.this.tableModel.setNumRows(MenuCategorySelectionView.this.tableModel.getNumRows() + 1);
                    MenuCategorySelectionView.this.updateButton();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel((LayoutManager)new MigLayout("center,ins 0", "sg,fill", ""));
        return panel;
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(70);
        columnWidth.add(250);
        columnWidth.add(70);
        return columnWidth;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuCategory category = this.tableModel.getRow(index);
            MenuCategoryDAO.getInstance().initialize(category);
            this.tableModel.setRow(index, category);
            MenuCategoryForm editor = new MenuCategoryForm(category);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuCategory> getSelectedMenuCategoryList() {
        return new ArrayList<MenuCategory>(this.addedMenuCategoryMap.values());
    }

    public void setMenuCategories(List<MenuCategory> menuCategories) {
        if (menuCategories != null) {
            for (MenuCategory item : menuCategories) {
                this.addedMenuCategoryMap.put(item.getId(), item);
                this.tableModel.addRow(item);
            }
        }
    }

    public void setParentMenuItem(MenuCategory selectedMenuItem, boolean editMode) {
        this.parentMenuCategory = selectedMenuItem;
        if (editMode) {
            this.chkShowSelected.setSelected(true);
            this.updateView();
        } else {
            this.searchItem();
        }
    }

    private void scrollDown() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getNextRowIndex());
        MenuCategoryDAO.getInstance().findCategories(this.tableModel, true, null);
        this.doSetVisibleCheckAll();
        this.updateButton();
        this.updateMenuCategorySelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    private void scrollUp() {
        this.tableModel.setCurrentRowIndex(this.tableModel.getPreviousRowIndex());
        MenuCategoryDAO.getInstance().findCategories(this.tableModel, true, null);
        this.doSetVisibleCheckAll();
        this.updateButton();
        this.updateMenuCategorySelection();
        this.table.repaint();
        this.chkShowSelected.setSelected(false);
    }

    public void setSelectedOrderTypes(Object selectedItem) {
        this.orderType = selectedItem instanceof OrderType ? (OrderType)selectedItem : null;
        this.searchItem();
    }

    private void selectItem() {
        if (this.table.getSelectedRow() < 0) {
            return;
        }
        int selectedRow = this.table.getSelectedRow();
        selectedRow = this.table.convertRowIndexToModel(selectedRow);
        MenuCategory item = this.tableModel.getRow(selectedRow);
        if (this.parentMenuCategory != null && this.parentMenuCategory.getId() != null && this.parentMenuCategory.getId().equals(item.getId())) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("MenuCategorySelectionView.34"));
            return;
        }
        item.setVisible(item.isVisible() == false);
        if (item.isVisible().booleanValue()) {
            this.addedMenuCategoryMap.put(item.getId(), item);
        } else {
            this.addedMenuCategoryMap.remove(item.getId());
        }
        String string = String.format(Messages.getString("ShowSelected"), this.addedMenuCategoryMap.values().size());
        this.chkShowSelected.setText(string);
        this.table.repaint();
    }

    private void doSetVisibleCheckAll() {
        ArrayList<Boolean> checkVisibilities = new ArrayList<Boolean>();
        List<MenuCategory> menuItems = this.tableModel.getRows();
        for (MenuCategory menuItem : menuItems) {
            if (!this.addedMenuCategoryMap.containsKey(menuItem.getId())) continue;
            checkVisibilities.add(menuItem.isVisible());
        }
        if (checkVisibilities.size() != 0 && !checkVisibilities.contains(false)) {
            this.chkSelectAll.setSelected(true);
        } else {
            this.chkSelectAll.setSelected(false);
        }
    }

    public BeanTableModel<MenuCategory> getModel() {
        return this.tableModel;
    }

    public int getSelectedRow() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            return -1;
        }
        return this.table.convertRowIndexToModel(index);
    }

    public void repaintTable() {
        this.table.repaint();
    }

    public void setSelectionMode(int selectionMode) {
        this.chkShowSelected.setVisible(selectionMode == 1);
        this.chkSelectAll.setVisible(selectionMode == 1);
        TableColumnModelExt columnModel = (TableColumnModelExt)this.table.getColumnModel();
        columnModel.getColumnExt(0).setVisible(selectionMode == 1);
        this.searchItem();
    }

    public void setSelectedOrdertype(OrderType orderType) {
        if (orderType != null && orderType.getId().equals(orderType.getId())) {
            return;
        }
        this.orderType = orderType;
        this.cbOrderTypes.setSelectedItem(orderType);
        this.searchItem();
    }

    public void setEnableSearch(boolean enableSearch) {
        this.tfName.setVisible(enableSearch);
        this.lblName.setVisible(enableSearch);
        this.btnSearch.setVisible(enableSearch);
    }
}

