/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.MultiSelectComboBox;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.WrapLayout;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketInfoButton;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class StyledTicketSelectionDialog
extends OkCancelOptionDialog
implements MouseListener {
    private JPanel buttonsPanel;
    private JTextField tfMember;
    private Map<String, Ticket> addedTicketListModel = new HashMap<String, Ticket>();
    private PosButton btnSelectAll;
    private boolean isMerge;
    private boolean allowPartialPayment;
    private Integer requiredNumber;
    public static Dimension tokenSize = PosUIManager.getSize(180, 160);
    private POSToggleButton btnMyTickets;
    private JLabel lblTicketCount;
    private MultiSelectComboBox<OrderType> cbMultiOrderType;

    public StyledTicketSelectionDialog() {
        this(false);
    }

    public StyledTicketSelectionDialog(boolean allowPartialPayment) {
        super((Window)Application.getPosWindow());
        this.allowPartialPayment = allowPartialPayment;
        this.initComponent();
        this.initData();
    }

    public StyledTicketSelectionDialog(List<Ticket> tickets) {
        this.initComponent();
        this.initData(tickets);
        this.setResizable(true);
    }

    private void initComponent() {
        this.setOkButtonText(Messages.getString("DONE"));
        this.buttonsPanel = new JPanel(new WrapLayout(3));
        this.btnSelectAll = new PosButton(Messages.getString("StyledTicketSelectionDialog.0"));
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyledTicketSelectionDialog.this.addedTicketListModel.clear();
                for (Component c : StyledTicketSelectionDialog.this.buttonsPanel.getComponents()) {
                    TicketInfoButton button = (TicketInfoButton)c;
                    if (button.isVisible()) {
                        button.setSelected(true);
                        StyledTicketSelectionDialog.this.addedTicketListModel.put(button.getTicket().getId(), button.getTicket());
                        continue;
                    }
                    button.setSelected(false);
                }
                StyledTicketSelectionDialog.this.setTicketCount();
            }
        });
        this.getButtonPanel().add((Component)this.btnSelectAll, 0);
        PosButton btnClearSelection = new PosButton(Messages.getString("StyledTicketSelectionDialog.7"));
        btnClearSelection.addActionListener(e -> {
            this.addedTicketListModel.clear();
            for (Component c : this.buttonsPanel.getComponents()) {
                TicketInfoButton button = (TicketInfoButton)c;
                button.setSelected(false);
            }
            this.setTicketCount();
        });
        this.getButtonPanel().add((Component)btnClearSelection, 0);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(40, 0));
        this.getContentPanel().add((Component)this.buildSearchForm(), "North");
        this.getContentPanel().add((Component)scrollPane, "Center");
        this.lblTicketCount = new JLabel();
        this.lblTicketCount.setHorizontalAlignment(4);
        this.lblTicketCount.setBorder(new EmptyBorder(5, 0, 0, 0));
        this.lblTicketCount.setFont(this.lblTicketCount.getFont().deriveFont(1, this.lblTicketCount.getFont().getSize()));
        this.getContentPanel().add((Component)this.lblTicketCount, "South");
        this.setSize(1024, 600);
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        try {
            panel.setLayout((LayoutManager)new MigLayout("ins 5", "[grow][]", ""));
            List<OrderType> orderTypeList = DataProvider.get().getOrderTypes();
            JLabel lblOrderType = new JLabel(Messages.getString("StyledTicketSelectionDialog.8"));
            this.cbMultiOrderType = new MultiSelectComboBox();
            this.cbMultiOrderType.setPreferredSize(PosUIManager.getSize(130, 50));
            this.cbMultiOrderType.setItems(orderTypeList);
            JLabel lblMember = new JLabel(POSConstants.CUSTOMER);
            this.tfMember = new JTextField(20);
            this.tfMember.setFont(this.tfMember.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
            PosButton btnSearch = new PosButton(Messages.getString("Search"));
            btnSearch.setPreferredSize(PosUIManager.getSize(50, 50));
            PosButton btnClear = new PosButton(Messages.getString("MenuItemForm.34"));
            btnClear.setPreferredSize(PosUIManager.getSize(50, 50));
            this.btnMyTickets = new POSToggleButton(POSConstants.MY_TICKETS);
            this.btnMyTickets.setSelected(true);
            this.btnMyTickets.addItemListener(e -> this.findAllTickets());
            panel.add((Component)lblOrderType, "align label,split 6");
            panel.add(this.cbMultiOrderType);
            panel.add(lblMember);
            panel.add((Component)this.tfMember, "growy");
            panel.add(btnSearch);
            panel.add(btnClear);
            panel.add((Component)this.btnMyTickets, "right");
            btnSearch.addActionListener(e -> this.searchTicket());
            btnClear.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StyledTicketSelectionDialog.this.tfMember.setText("");
                    StyledTicketSelectionDialog.this.cbMultiOrderType.unselectAllItems();
                    StyledTicketSelectionDialog.this.cbMultiOrderType.setSelectedIndex(0);
                    StyledTicketSelectionDialog.this.searchTicket();
                }
            });
            KeyListener keyListener = new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    if (StyledTicketSelectionDialog.this.tfMember.getText().length() > 3) {
                        StyledTicketSelectionDialog.this.searchTicket();
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                    int key = e.getKeyCode();
                    if (key == 10) {
                        StyledTicketSelectionDialog.this.searchTicket();
                    }
                }
            };
            this.tfMember.addKeyListener(keyListener);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void initData() {
        this.setCaption(Messages.getString("StyledTicketSelectionDialog.1"));
        this.initData(null);
    }

    protected void findAllTickets() {
        this.buttonsPanel.removeAll();
        this.addedTicketListModel.clear();
        if (this.btnMyTickets.isSelected()) {
            User user = Application.getCurrentUser();
            List<Ticket> tickets = TicketDAO.getInstance().findOpenTicketsForUser(user);
            this.initData(tickets);
        } else {
            List<Ticket> tickets = TicketDAO.getInstance().findOpenTickets();
            this.initData(tickets);
        }
        this.buttonsPanel.revalidate();
        this.buttonsPanel.repaint();
        this.searchTicket();
    }

    private void initData(List<Ticket> tickets) {
        try {
            if (tickets == null || tickets.size() <= 0) {
                User user = Application.getCurrentUser();
                List<String> orderTypeIds = POSUtil.getStringIds(DataProvider.get().getOrderTypes(), OrderType.class);
                tickets = TicketDAO.getInstance().findOpenTicketsForUser(user, orderTypeIds);
            }
            for (Ticket ticket : tickets) {
                OrderType orderType;
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                if ((ticket.getDueAmount() <= 0.0 || !this.allowPartialPayment) && !ticket.getDueAmount().equals(ticket.getTotalAmountWithTips()) || (orderType = ticket.getOrderType()) != null && orderType.isBarTab().booleanValue()) continue;
                TicketInfoButton btnTicket = new TicketInfoButton(ticket);
                btnTicket.addMouseListener(this);
                this.buttonsPanel.add(btnTicket);
                btnTicket.setPreferredSize(tokenSize);
                this.setTicketCount();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    private void setTicketCount() {
        this.lblTicketCount.setText(Messages.getString("StyledTicketSelectionDialog.12") + this.addedTicketListModel.size());
    }

    @Override
    public void doOk() {
        if (this.addedTicketListModel.isEmpty() && this.requiredNumber == null) {
            POSMessageDialog.showMessage(Messages.getString("TicketSelectionDialog.5"));
            return;
        }
        if (this.requiredNumber != null && this.addedTicketListModel.size() < this.requiredNumber) {
            POSMessageDialog.showMessage(Messages.getString("StyledTicketSelectionDialog.2") + this.requiredNumber + Messages.getString("StyledTicketSelectionDialog.3"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.addedTicketListModel.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public List<Ticket> getSelectedTickets() {
        return new ArrayList<Ticket>(this.addedTicketListModel.values());
    }

    public Ticket getMainTicket() {
        return this.addedTicketListModel.get("root");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TicketInfoButton button = (TicketInfoButton)e.getSource();
        if (this.isMerge) {
            this.setSelectedSectionForMerge(button);
        } else {
            this.setSelectedSection(button);
        }
        this.setTicketCount();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    protected void searchTicket() {
        this.addedTicketListModel.clear();
        List<OrderType> orderTypes = this.cbMultiOrderType.getSelectedItems();
        if (orderTypes == null) {
            orderTypes = DataProvider.get().getOrderTypes();
        }
        List<String> orderTypeIds = POSUtil.getStringIds(orderTypes, OrderType.class);
        String memberName = this.tfMember.getText();
        memberName = memberName != null ? memberName.trim() : "";
        if (this.buttonsPanel.getComponents() != null) {
            System.out.println("Size: " + this.buttonsPanel.getComponents().length);
        }
        for (Component c : this.buttonsPanel.getComponents()) {
            TicketInfoButton sec = (TicketInfoButton)c;
            Ticket ticket = sec.getTicket();
            boolean visible = true;
            if (orderTypeIds.size() > 0 && StringUtils.isNotBlank((String)memberName)) {
                visible = orderTypeIds.contains(ticket.getOrderTypeId()) && ticket.getCustomerName().toLowerCase().contains(memberName.toLowerCase());
            } else {
                if (orderTypeIds.size() > 0) {
                    visible = orderTypeIds.contains(ticket.getOrderTypeId());
                }
                if (StringUtils.isNotBlank((String)memberName)) {
                    visible = ticket.getCustomerName().toLowerCase().contains(memberName.toLowerCase());
                }
            }
            sec.setVisible(visible);
            if (visible) continue;
            sec.setSelected(false);
        }
    }

    public void setSelectedSectionForMerge(TicketInfoButton section) {
        for (Component c : this.buttonsPanel.getComponents()) {
            TicketInfoButton sec = (TicketInfoButton)c;
            if (sec != section) continue;
            if (sec.isSelected()) {
                if (this.addedTicketListModel.get("root") == sec.getTicket() && this.addedTicketListModel.values().size() > 1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("StyledTicketSelectionDialog.9"));
                    continue;
                }
                if (this.addedTicketListModel.get("root") == sec.getTicket()) {
                    this.addedTicketListModel.remove("root");
                } else {
                    this.addedTicketListModel.remove(sec.getTicket().getId());
                }
                sec.setSelected(false);
                continue;
            }
            sec.setSelected(true);
            if (this.addedTicketListModel.isEmpty()) {
                sec.setBorder(BorderFactory.createLineBorder(Color.GREEN, 4));
                this.addedTicketListModel.put("root", sec.getTicket());
                continue;
            }
            this.addedTicketListModel.put(sec.getTicket().getId(), sec.getTicket());
        }
    }

    public void setSelectedSection(TicketInfoButton btn) {
        for (Component c : this.buttonsPanel.getComponents()) {
            TicketInfoButton button = (TicketInfoButton)c;
            if (button != btn) continue;
            this.setColorOfBtn(button);
        }
    }

    private void setColorOfBtn(TicketInfoButton button) {
        if (button.isSelected()) {
            button.setSelected(false);
            this.addedTicketListModel.remove(button.getTicket().getId());
        } else {
            button.setSelected(true);
            this.addedTicketListModel.put(button.getTicket().getId(), button.getTicket());
        }
    }

    public TicketInfoButton getSelectedSection() {
        for (Component c : this.buttonsPanel.getComponents()) {
            TicketInfoButton button = (TicketInfoButton)c;
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    public void setMerge(boolean isMerge) {
        this.isMerge = isMerge;
        if (isMerge) {
            this.setCaption(Messages.getString("StyledTicketSelectionDialog.13"));
            this.btnSelectAll.setVisible(false);
        }
    }

    public int getRequiredNumber() {
        return this.requiredNumber;
    }

    public void setRequiredNumber(int requiredNumber) {
        this.requiredNumber = requiredNumber;
    }
}

