/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.modifier;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionDialog;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import net.miginfocom.swing.MigLayout;

public class ModifierView
extends SelectionView {
    private Vector<ModifierSelectionListener> listenerList = new Vector();
    private ModifierSelectionModel modifierSelectionModel;
    private MenuItemModifierSpec modifierGroup;
    private PosButton btnClear = new PosButton(POSConstants.CLEAR);
    private PosButton btnDone = new PosButton();
    private PosButton btnCancel = new PosButton(POSConstants.CANCEL);
    private Multiplier selectedMultiplier;
    private MultiplierButton defaultMultiplierButton;
    private ButtonGroup multiplierButtonGroup;

    public ModifierView(ModifierSelectionModel modifierSelectionModel) {
        super(POSConstants.MODIFIERS, new FlowLayout(), PosUIManager.getSize(120), PosUIManager.getSize(80));
        this.modifierSelectionModel = modifierSelectionModel;
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.addMultiplierButtons();
        this.addActionButtons();
    }

    private void addMultiplierButtons() {
        JPanel multiplierPanel = new JPanel((LayoutManager)new MigLayout("fillx,center, gap 0, ins 0"));
        LineBorder lineBorder = new LineBorder(Color.lightGray, 1, true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 5, 0), lineBorder);
        multiplierPanel.setBorder(compoundBorder);
        multiplierPanel.setOpaque(true);
        List<Multiplier> multiplierList = DataProvider.get().getMultiplierList();
        this.multiplierButtonGroup = new ButtonGroup();
        if (multiplierList != null) {
            for (Multiplier multiplier : multiplierList) {
                MultiplierButton btnMultiplier = new MultiplierButton(multiplier);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.selectedMultiplier = multiplier;
                    this.defaultMultiplierButton = btnMultiplier;
                    btnMultiplier.setSelected(true);
                }
                multiplierPanel.add((Component)btnMultiplier, "grow");
                this.multiplierButtonGroup.add(btnMultiplier);
            }
        }
        this.actionButtonPanel.add((Component)multiplierPanel, "newline,span");
    }

    private void addActionButtons() {
        this.actionButtonPanel.add((Component)this.btnClear, "newline,grow");
        this.actionButtonPanel.add((Component)this.btnDone, "grow");
        this.actionButtonPanel.add((Component)this.btnCancel, "grow");
        AbstractAction groupDoneAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ModifierSelectionListener listener : ModifierView.this.listenerList) {
                    listener.finishModifierSelection();
                }
            }
        };
        this.btnDone.setAction(groupDoneAction);
        this.btnDone.getInputMap(2).put(KeyStroke.getKeyStroke(10, 0), POSConstants.DONE);
        this.btnDone.getActionMap().put(POSConstants.DONE, groupDoneAction);
        this.btnDone.setText(Messages.getString("ModifierView.0"));
        this.btnClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ModifierSelectionListener listener : ModifierView.this.listenerList) {
                    listener.clearModifiers(ModifierView.this.modifierGroup);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierView.this.closeDialog(true);
            }
        });
    }

    private void closeDialog(boolean canceled) {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(canceled);
            windowAncestor.dispose();
        }
    }

    public void setModifierGroup(MenuItemModifierSpec modifierGroup) {
        this.modifierGroup = modifierGroup;
        if (modifierGroup == null) {
            return;
        }
        this.renderTitle();
        this.renderMultiplierButtons();
        try {
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(modifierGroup.getModifierPages().size());
            this.dataModel.setData(new ArrayList<MenuItemModifierPage>(modifierGroup.getModifierPages()));
            this.setDataModel(this.dataModel);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void renderMultiplierButtons() {
        if (this.multiplierButtonGroup.getButtonCount() < 1) {
            return;
        }
        boolean enable = !this.modifierGroup.isEnableGroupPricing();
        Enumeration<AbstractButton> elements = this.multiplierButtonGroup.getElements();
        while (elements.hasMoreElements()) {
            AbstractButton multiplier = elements.nextElement();
            multiplier.setEnabled(enable);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel items) {
        this.populateItems();
        super.setDataModel(items);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.updateView();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        MenuItemModifierPage modifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setButtonSize(new Dimension(modifierPage.getButtonWidth(), modifierPage.getButtonHeight()));
        Integer cols = modifierPage.getCols();
        MigLayout migLayout = new MigLayout("center,wrap " + cols);
        if (modifierPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int row = 0; row < modifierPage.getRows(); ++row) {
            for (int col = 0; col < modifierPage.getCols(); ++col) {
                MenuItemModifierPageItem itemForCell;
                String constraint = String.format("cell %s %s", col, row);
                if (!modifierPage.isFlixibleButtonSize().booleanValue()) {
                    constraint = constraint + String.format(", w %s!, h %s!", modifierPage.getButtonWidth(), modifierPage.getButtonHeight());
                }
                if ((itemForCell = modifierPage.getItemForCell(col, row)) == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), constraint);
                    continue;
                }
                AbstractButton itemButton = this.createItemButton(itemForCell);
                if (itemButton == null) continue;
                this.selectionButtonsPanel.add((Component)itemButton, constraint);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    private void renderTitle() {
        String displayName = this.modifierGroup.getName();
        String instruction = this.modifierGroup.getInstruction();
        int minQuantity = this.modifierGroup.getMinQuantity();
        int maxQuantity = this.modifierGroup.getMaxQuantity();
        this.setTitle(displayName + Messages.getString("ModifierView.2") + minQuantity + Messages.getString("ModifierView.3") + maxQuantity + (instruction == null ? "" : " " + instruction));
    }

    @Override
    protected AbstractButton createItemButton(Object item) {
        MenuItemModifierPageItem menuItemModifierPageItem = (MenuItemModifierPageItem)item;
        ModifierButton modifierButton = new ModifierButton(menuItemModifierPageItem);
        return modifierButton;
    }

    public void addModifierSelectionListener(ModifierSelectionListener listener) {
        this.listenerList.add(listener);
    }

    public void removeModifierSelectionListener(ModifierSelectionListener listener) {
        this.listenerList.remove(listener);
    }

    public void updateView() {
        Component[] components = this.selectionButtonsPanel.getComponents();
        if (components == null || components.length == 0) {
            return;
        }
        TicketItem ticketItem = this.modifierSelectionModel.getTicketItem();
        HashMap<String, TicketItemModifier> ticketItemModifierMap = new HashMap<String, TicketItemModifier>();
        if (ticketItem.getTicketItemModifiers() != null && ticketItem.getTicketItemModifiers().size() > 0) {
            for (TicketItemModifier ticketItemModifier : ticketItem.getTicketItemModifiers()) {
                ticketItemModifierMap.put(ticketItemModifier.getItemId(), ticketItemModifier);
            }
        }
        for (Component component : components) {
            if (component instanceof JLabel) continue;
            ModifierButton modifierButton = (ModifierButton)component;
            MenuItemModifierPageItem modifierPageItem = modifierButton.menuItemModifierPageItem;
            TicketItemModifier ticketItemModifier = (TicketItemModifier)ticketItemModifierMap.get(modifierPageItem.getMenuModifierId());
            if (ticketItemModifier != null) {
                MenuModifier modifier = MenuModifierDAO.getInstance().get(modifierPageItem.getMenuModifierId());
                MenuModifierDAO.getInstance().initialize(modifier);
                double quantity = ticketItem.findTicketItemModifierByMenuModifier(modifier);
                StringBuilder builder = new StringBuilder();
                builder.append("<html><center>");
                builder.append(modifierPageItem.getMenuModifierName());
                builder.append("<br/><span style='color:green;'>(");
                builder.append(quantity);
                builder.append(")</span></center></html>");
                modifierButton.setText(builder.toString());
            } else {
                StringBuilder builder = new StringBuilder();
                builder.append("<html><center>");
                builder.append(modifierPageItem.getMenuModifierName());
                builder.append("</center></html>");
                modifierButton.setText(builder.toString());
            }
            if (ModifierSelectionDialog.isRequiredModifiersAdded(ticketItem, this.modifierGroup)) {
                this.btnDone.setBackground(Color.green);
                continue;
            }
            this.btnDone.setBackground(UIManager.getColor("Control"));
        }
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.setDataModel(this.dataModel);
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier multiplier;

        public MultiplierButton(Multiplier multiplier) {
            Integer textColor;
            this.multiplier = multiplier;
            this.setText(multiplier.getTicketPrefix());
            Integer buttonColor = multiplier.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(new Color(buttonColor));
            }
            if ((textColor = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(textColor));
            }
            this.setBorder(null);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModifierView.this.selectedMultiplier = this.multiplier;
        }

        public Multiplier getMultiplier() {
            return this.multiplier;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private int BUTTON_SIZE = 100;
        private MenuItemModifierPageItem menuItemModifierPageItem;

        public ModifierButton(MenuItemModifierPageItem menuItemModifierPageItem) {
            this.menuItemModifierPageItem = menuItemModifierPageItem;
            this.setFocusable(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.BUTTON_SIZE = PosUIManager.getSize(100);
            this.setText("<html><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></html>");
            if (menuItemModifierPageItem.getImage() != null) {
                int w = this.BUTTON_SIZE - PosUIManager.getSize(0);
                int h = this.BUTTON_SIZE - PosUIManager.getSize(0);
                if (menuItemModifierPageItem.isShowImageOnly().booleanValue()) {
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(w, h, 0)));
                } else {
                    w = PosUIManager.getSize(80);
                    h = PosUIManager.getSize(40);
                    this.setIcon(new ImageIcon(menuItemModifierPageItem.getImage().getImage().getScaledInstance(w, h, 0)));
                    this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
            }
            if (menuItemModifierPageItem.getTextColor() != null) {
                this.setForeground(menuItemModifierPageItem.getTextColor());
            }
            if (menuItemModifierPageItem.getButtonColor() != null) {
                this.setBackground(menuItemModifierPageItem.getButtonColor());
            }
            this.setPreferredSize(new Dimension(this.BUTTON_SIZE, this.BUTTON_SIZE));
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                for (ModifierSelectionListener listener : ModifierView.this.listenerList) {
                    String menuModifierId = this.menuItemModifierPageItem.getMenuModifierId();
                    MenuModifier modifier = MenuModifierDAO.getInstance().get(menuModifierId);
                    MenuModifierDAO.getInstance().initialize(modifier);
                    modifier.setMenuItemModifierGroup(ModifierView.this.modifierGroup);
                    listener.modifierSelected(modifier, ModifierView.this.selectedMultiplier);
                }
                if (ModifierView.this.defaultMultiplierButton != null) {
                    ModifierView.this.defaultMultiplierButton.setSelected(true);
                    ModifierView.this.selectedMultiplier = ModifierView.this.defaultMultiplierButton.getMultiplier();
                }
            }
            catch (Exception ex) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
            }
        }
    }
}

