/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.CardConfig;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.BusyDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Window;
import java.util.Iterator;
import javax.swing.SwingWorker;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class CreditCardInputListener
implements CardInputListener {
    private SettleTicketProcessor settleTicketProcessor;

    public CreditCardInputListener(SettleTicketProcessor settleTicketProcessor) {
        this.settleTicketProcessor = settleTicketProcessor;
    }

    @Override
    public void cardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) {
        Window focusedWindow = POSUtil.getFocusedWindow();
        try {
            switch (selectedPaymentType) {
                case CREDIT_CARD: 
                case DEBIT_CARD: {
                    this.creditCardInputted(inputter, selectedPaymentType, cardType);
                }
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(focusedWindow, this.settleTicketProcessor.getRefreshableView());
        }
        catch (PosException e) {
            POSMessageDialog.showError(focusedWindow, e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(focusedWindow, Messages.getString("SettleTicketProcessor.1"), e);
        }
    }

    private void creditCardInputted(CardInputProcessor inputter, PaymentType selectedPaymentType, String cardType) throws Exception {
        PosTransaction transaction = selectedPaymentType.createTransaction();
        transaction.setTicket(this.settleTicketProcessor.getTicket());
        transaction.setCardType(cardType);
        PaymentGatewayPlugin paymentGateway = CardConfig.getPaymentGateway();
        if (paymentGateway == null) {
            throw new PosException(Messages.getString("SettleTicketProcessor.2"));
        }
        if (inputter instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)inputter;
            String cardString = swipeCardDialog.getCardString();
            if (StringUtils.isEmpty((String)cardString) || cardString.length() < 16) {
                throw new PosException(Messages.getString("SettleTicketDialog.16"));
            }
            this.processCardSwip(transaction, paymentGateway, cardString);
        } else if (inputter instanceof ManualCardEntryDialog) {
            this.processManualCardEntry(inputter, transaction, paymentGateway);
        } else if (inputter instanceof AuthorizationCodeDialog) {
            this.processCardAuthCodeInput(inputter, selectedPaymentType, cardType, transaction);
        }
    }

    private void processCardSwip(final PosTransaction transaction, final PaymentGatewayPlugin paymentGateway, final String cardString) {
        final BusyDialog waitDialog = new BusyDialog();
        SwingWorker<Double, Void> worker = new SwingWorker<Double, Void>(){

            @Override
            protected Double doInBackground() throws Exception {
                Ticket ticket = CreditCardInputListener.this.settleTicketProcessor.getTicket();
                Double dueAmount = ticket.getDueAmount();
                CardProcessor cardProcessor = paymentGateway.getProcessor();
                transaction.setCardTrack(cardString);
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                transaction.setCardReader(CardReader.SWIPE.name());
                CreditCardInputListener.this.settleTicketProcessor.setTransactionAmounts(transaction, Boolean.TRUE);
                if (ticket.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(transaction);
                } else {
                    cardProcessor.chargeAmount(transaction);
                }
                CreditCardInputListener.this.settleTicketProcessor.settleTicket(transaction, null, true, false);
                return dueAmount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Double dueAmount = (Double)this.get();
                    CreditCardInputListener.this.settleTicketProcessor.doAfterSettleTask(transaction, dueAmount, true);
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof PosException) {
                        POSMessageDialog.showError(cause.getMessage());
                    } else if (cause instanceof StaleStateException) {
                        POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), CreditCardInputListener.this.settleTicketProcessor.getRefreshableView());
                    } else {
                        POSMessageDialog.showError(cause.getMessage(), cause);
                    }
                    Ticket ticket = CreditCardInputListener.this.settleTicketProcessor.getTicket();
                    double surchargeAmount = transaction.getSurchargeAmount();
                    ticket.setTotalSurchargeAmount(ticket.getTotalSurchargeAmount() - surchargeAmount);
                    Iterator<TicketItem> iterator = ticket.getTicketItems().iterator();
                    while (iterator.hasNext()) {
                        TicketItem ticketItem = iterator.next();
                        if (!ticketItem.getTransactionUUId().equals(transaction.getUUID())) continue;
                        iterator.remove();
                    }
                    ticket.calculatePrice();
                }
                finally {
                    waitDialog.dispose();
                }
            }
        };
        worker.execute();
        waitDialog.setVisible(true);
    }

    private void processManualCardEntry(final CardInputProcessor inputter, final PosTransaction transaction, final PaymentGatewayPlugin paymentGateway) throws Exception {
        final BusyDialog waitDialog = new BusyDialog();
        SwingWorker<Double, Void> worker = new SwingWorker<Double, Void>(){

            @Override
            protected Double doInBackground() throws Exception {
                Double dueAmount = CreditCardInputListener.this.settleTicketProcessor.getTicket().getDueAmount();
                CardProcessor cardProcessor = paymentGateway.getProcessor();
                ManualCardEntryDialog mDialog = (ManualCardEntryDialog)inputter;
                transaction.setCaptured(false);
                transaction.setCardMerchantGateway(paymentGateway.getProductName());
                transaction.setCardReader(CardReader.MANUAL.name());
                transaction.setCardHolderName(mDialog.getCardHolderName());
                transaction.setCardNumber(mDialog.getCardNo());
                transaction.setCardExpMonth(mDialog.getExpMonth());
                transaction.setCardExpYear(mDialog.getExpYear());
                transaction.setCardCVV(mDialog.getCardCVV());
                CreditCardInputListener.this.settleTicketProcessor.setTransactionAmounts(transaction, Boolean.TRUE);
                if (CreditCardInputListener.this.settleTicketProcessor.getTicket().getOrderType().isPreAuthCreditCard().booleanValue()) {
                    cardProcessor.preAuth(transaction);
                } else {
                    cardProcessor.chargeAmount(transaction);
                }
                CreditCardInputListener.this.settleTicketProcessor.settleTicket(transaction, null, true, false);
                return dueAmount;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Double dueAmount = (Double)this.get();
                    CreditCardInputListener.this.settleTicketProcessor.doAfterSettleTask(transaction, dueAmount, true);
                }
                catch (Exception e) {
                    waitDialog.dispose();
                    Throwable cause = e.getCause();
                    if (cause instanceof PosException) {
                        POSMessageDialog.showError(cause.getMessage());
                    } else if (cause instanceof StaleStateException) {
                        POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), CreditCardInputListener.this.settleTicketProcessor.getRefreshableView());
                    } else {
                        POSMessageDialog.showError(cause.getMessage(), cause);
                    }
                    Ticket ticket = CreditCardInputListener.this.settleTicketProcessor.getTicket();
                    double surchargeAmount = transaction.getSurchargeAmount();
                    ticket.setTotalSurchargeAmount(ticket.getTotalSurchargeAmount() - surchargeAmount);
                    Iterator<TicketItem> iterator = ticket.getTicketItems().iterator();
                    while (iterator.hasNext()) {
                        TicketItem ticketItem = iterator.next();
                        if (!ticketItem.getTransactionUUId().equals(transaction.getUUID())) continue;
                        iterator.remove();
                    }
                }
                finally {
                    waitDialog.dispose();
                }
            }
        };
        worker.execute();
        waitDialog.setVisible(true);
    }

    private void processCardAuthCodeInput(final CardInputProcessor inputter, PaymentType selectedPaymentType, final String cardType, final PosTransaction selectedTransaction) throws Exception {
        final BusyDialog waitDialog = new BusyDialog();
        SwingWorker<Double, Void> worker = new SwingWorker<Double, Void>(){

            @Override
            protected Double doInBackground() throws Exception {
                Double dueAmount = CreditCardInputListener.this.settleTicketProcessor.getTicket().getDueAmount();
                AuthorizationCodeDialog authDialog = (AuthorizationCodeDialog)inputter;
                String authorizationCode = authDialog.getAuthorizationCode();
                if (StringUtils.isEmpty((String)authorizationCode)) {
                    throw new PosException(Messages.getString("SettleTicketDialog.17"));
                }
                selectedTransaction.setCardType(cardType);
                selectedTransaction.setCaptured(true);
                selectedTransaction.setAuthorizable(false);
                selectedTransaction.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
                selectedTransaction.setCardAuthCode(authorizationCode);
                CreditCardInputListener.this.settleTicketProcessor.setTransactionAmounts(selectedTransaction, Boolean.TRUE);
                CreditCardInputListener.this.settleTicketProcessor.settleTicket(selectedTransaction, null, true, false);
                return dueAmount;
            }

            @Override
            protected void done() {
                try {
                    Double dueAmount = (Double)this.get();
                    CreditCardInputListener.this.settleTicketProcessor.doAfterSettleTask(selectedTransaction, dueAmount, true);
                }
                catch (Exception e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof PosException) {
                        POSMessageDialog.showError(cause.getMessage());
                    } else if (cause instanceof StaleStateException) {
                        POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), CreditCardInputListener.this.settleTicketProcessor.getRefreshableView());
                    } else {
                        POSMessageDialog.showError(cause.getMessage(), cause);
                    }
                }
                finally {
                    waitDialog.dispose();
                }
            }
        };
        worker.execute();
        waitDialog.setVisible(true);
    }
}

