/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.NumericKeypad;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class GratuityInputDialog
extends OkCancelOptionDialog {
    private DoubleTextField doubleTextField;
    private Double subTotalAmount;

    public GratuityInputDialog() {
        super(POSUtil.getFocusedWindow());
        this.initUi();
    }

    private void initUi() {
        this.setCaption(Messages.getString("GratuityInputDialog.0"));
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        this.doubleTextField = new DoubleTextField();
        this.doubleTextField.setHorizontalAlignment(11);
        this.doubleTextField.setFocusCycleRoot(true);
        this.doubleTextField.setFont(this.doubleTextField.getFont().deriveFont(1, PosUIManager.getNumberFieldFontSize()));
        this.doubleTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    GratuityInputDialog.this.doOk();
                }
            }
        });
        panel.add((Component)this.doubleTextField, "cell 0 0,alignx left,height 40px,aligny top");
        NumericKeypad numericKeypad = new NumericKeypad();
        panel.add((Component)numericKeypad, "cell 0 1");
        panel.add((Component)this.createPercentagePanel(), "cell 0 2");
        this.getContentPanel().add(panel);
    }

    private JPanel createPercentagePanel() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("inset 0", "[grow,fill]", "[grow,fill]"));
        Font buttonFont = UIManager.getFont("Button.font").deriveFont((float)PosUIManager.getFontSize(18));
        PosButton btn10Per = new PosButton("10%");
        btn10Per.setFont(buttonFont);
        btn10Per.addActionListener(e -> this.calculateGratuity(10.0));
        PosButton btn12Per = new PosButton("12%");
        btn12Per.setFont(buttonFont);
        btn12Per.addActionListener(e -> this.calculateGratuity(12.0));
        PosButton btn15Per = new PosButton("15%");
        btn15Per.setFont(buttonFont);
        btn15Per.addActionListener(e -> this.calculateGratuity(15.0));
        PosButton btn18Per = new PosButton("18%");
        btn18Per.setFont(buttonFont);
        btn18Per.addActionListener(e -> this.calculateGratuity(18.0));
        PosButton btn20Per = new PosButton("20%");
        btn20Per.setFont(buttonFont);
        btn20Per.addActionListener(e -> this.calculateGratuity(20.0));
        PosButton btn25Per = new PosButton("25%");
        btn25Per.setFont(buttonFont);
        btn25Per.addActionListener(e -> this.calculateGratuity(25.0));
        panel.add(btn10Per);
        panel.add(btn12Per);
        panel.add((Component)btn15Per, "wrap");
        panel.add(btn18Per);
        panel.add(btn20Per);
        panel.add(btn25Per);
        return panel;
    }

    private void calculateGratuity(double gratuityPercentage) {
        double gratuityAmount = 0.0;
        if (gratuityPercentage > 0.0) {
            gratuityAmount = this.subTotalAmount * (gratuityPercentage / 100.0);
        }
        this.setGratuity(gratuityAmount > 0.0 ? gratuityAmount : 0.0);
    }

    @Override
    public void doOk() {
        if (this.doubleTextField.getText().startsWith("-")) {
            POSMessageDialog.showError(this, Messages.getString("GratuityDialog.30"));
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    public void setGratuity(double amount) {
        this.doubleTextField.setText(NumberUtil.formatAmount(amount));
    }

    public double getGratuityAmount() {
        return this.doubleTextField.getDoubleOrZero();
    }

    public void setSubTotalAmount(Double subTotalAmount) {
        this.subTotalAmount = subTotalAmount;
    }
}

