/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment.creditbook;

import com.floreantpos.Messages;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.Customer;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JScrollPane;

public class CBTBtnwiseSelectionDialog
extends OkCancelOptionDialog
implements ActionListener {
    private Customer member;
    private List<CreditBookType> creditBookTypes;
    private CreditBookType creditBookType;

    public CBTBtnwiseSelectionDialog(Customer member, List<CreditBookType> creditBookTypes) {
        super(POSUtil.getFocusedWindow());
        this.member = member;
        this.creditBookTypes = creditBookTypes;
        this.setTitle(AppProperties.getAppName());
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPanel().setLayout(new BorderLayout(5, 5));
        this.setCaption(Messages.getString("MEMBER") + ": " + this.member.getName());
        ScrollableFlowPanel buttonPanel = new ScrollableFlowPanel();
        ButtonGroup btnGroup = new ButtonGroup();
        for (CreditBookType creditBookType : this.creditBookTypes) {
            POSToggleButton cBookTypeBtn = new POSToggleButton(creditBookType.getValue());
            cBookTypeBtn.putClientProperty(creditBookType.getValue(), creditBookType);
            cBookTypeBtn.addActionListener(this);
            btnGroup.add(cBookTypeBtn);
            buttonPanel.add(cBookTypeBtn);
        }
        this.getContentPanel().add(new JScrollPane(buttonPanel));
        this.setOkButtonVisible(false);
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    public CreditBookType getSelectedCreditBooktype() {
        return this.creditBookType;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        POSToggleButton tglButton = (POSToggleButton)e.getSource();
        CreditBookType creditBookType = (CreditBookType)tglButton.getClientProperty(tglButton.getActionCommand());
        if (creditBookType == null) {
            return;
        }
        if (tglButton.isSelected()) {
            this.creditBookType = creditBookType;
            this.doOk();
        }
    }
}

