/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.voidticket;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosOverflowCombobox;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.NumberSelectionView;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class VoidTicketItemDialog
extends OkCancelOptionDialog {
    private TicketItem ticketItem;
    private PosOverflowCombobox cbVoidItemReason;
    private POSToggleButton tbItemWasted;
    private VoidReason voidReason;
    private ComboBoxModel<VoidReason> comboBoxModel;
    private NumberSelectionView numberSelectionView;
    private Ticket ticket;
    private double voidQuantity;
    private boolean itemReturned;
    private TicketView ticketView;

    public VoidTicketItemDialog(Ticket ticket, TicketItem ticketItem) {
        this(ticket, ticketItem, false);
    }

    public VoidTicketItemDialog(Ticket ticket, TicketItem ticketItem, boolean itemReturned) {
        super(POSUtil.getFocusedWindow(), Messages.getString("VoidTicketItemDialog.0"));
        this.ticket = ticket;
        this.ticketItem = ticketItem;
        this.itemReturned = itemReturned;
        this.inItComponents();
        this.updateView();
        if (itemReturned) {
            this.setTitle("Return item");
        } else {
            this.setTitle("Void item");
        }
    }

    public void inItComponents() {
        TitlePanel titlePanel = new TitlePanel();
        if (this.itemReturned) {
            titlePanel.setTitle("Return " + this.ticketItem.getName());
        } else {
            titlePanel.setTitle(Messages.getString("VOID_TICKET_BUTTON_TEXT") + " " + this.ticketItem.getName());
        }
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[][][grow]"));
        this.numberSelectionView = new NumberSelectionView();
        this.numberSelectionView.setDecimalAllowed(this.ticketItem.isFractionalUnit());
        this.numberSelectionView.setBorder(null);
        this.numberSelectionView.setVisibleControlsButton(true);
        JLabel lblReason = new JLabel(Messages.getString("VoidItemViewerTableModel.1"));
        if (this.itemReturned) {
            lblReason.setText("Return reason");
        }
        this.comboBoxModel = new ComboBoxModel();
        this.cbVoidItemReason = new PosOverflowCombobox();
        this.cbVoidItemReason.setModel(this.comboBoxModel);
        this.cbVoidItemReason.setFocusable(false);
        PosButton addReasonBtn = new PosButton("+");
        addReasonBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoidTicketItemDialog.this.doAddNewVoidReason();
            }
        });
        int comboWidth = PosUIManager.getSize(232);
        this.tbItemWasted = new POSToggleButton(Messages.getString("VoidTicketItemDialog.3"));
        centerPanel.add((Component)lblReason, "wrap");
        centerPanel.add((Component)this.cbVoidItemReason, "h 50!,w " + comboWidth + "!,growx,split 3");
        centerPanel.add((Component)addReasonBtn, "h 50!,growx");
        centerPanel.add((Component)this.tbItemWasted, "h 50!,growx");
        this.add((Component)centerPanel, "Center");
        centerPanel.add((Component)this.numberSelectionView, "newline,span,grow,center,gaptop 5");
    }

    private void updateView() {
        this.comboBoxModel.setDataList(VoidReasonDAO.getInstance().findAll());
        if (this.cbVoidItemReason.getMaximumRowCount() > 5) {
            this.cbVoidItemReason.setMaximumRowCount(5);
        }
        this.numberSelectionView.setValue(Math.abs(this.ticketItem.getQuantity()));
        if (this.comboBoxModel.getSize() > 0) {
            this.cbVoidItemReason.setSelectedIndex(0);
        }
    }

    private boolean updateModel() {
        try {
            if (StringUtils.isBlank((String)this.numberSelectionView.getText())) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("VoidTicketItemDialog.2"));
                return false;
            }
            if (this.numberSelectionView.getValue() == 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("VoidTicketItemDialog.4"));
                return false;
            }
            if (this.numberSelectionView.getValue() < 0.0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("VoidTicketItemDialog.5"));
                return false;
            }
            this.voidQuantity = Math.abs(this.numberSelectionView.getValue());
            String voidReasonText = null;
            this.voidReason = (VoidReason)this.cbVoidItemReason.getSelectedItem();
            if (this.voidReason != null) {
                voidReasonText = this.voidReason.getReasonText();
            }
            boolean itemWasted = this.tbItemWasted.isSelected();
            if (this.itemReturned) {
                TicketItem returnedItem = VoidTicketItemDialog.returnItem(this.ticket, this.ticketItem, this.voidQuantity, voidReasonText, itemWasted);
                if (this.ticketView != null) {
                    this.ticketView.addTicketItem(returnedItem);
                }
            } else {
                this.ticket.voidItem(this.ticketItem, voidReasonText, itemWasted, this.voidQuantity);
            }
            this.ticketItem.calculatePrice();
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
            return false;
        }
    }

    public static TicketItem returnItem(Ticket ticket, TicketItem ticketItem, Double returnQuantity, String voidReasonText, boolean itemWasted) {
        if (!ticket.isItemReturnable(ticketItem, returnQuantity)) {
            throw new PosException(ticketItem.getNameDisplay() + "\n\nReturn quantity cannot be greater than purchase quantity.");
        }
        TicketItem returnedItem = ticketItem.cloneAsNew();
        returnedItem.setCookingInstructionsProperty(null);
        returnedItem.markVoided(voidReasonText, itemWasted, returnQuantity, true);
        returnedItem.setVoidedItemId(ticketItem.getId());
        return returnedItem;
    }

    @Override
    public void doOk() {
        if (!this.updateModel()) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doAddNewVoidReason() {
        try {
            NotesDialog noteDialogue = new NotesDialog();
            noteDialogue.setTitle(Messages.getString("VoidTicketItemDialog.7"));
            noteDialogue.open();
            if (noteDialogue.isCanceled()) {
                return;
            }
            String note = noteDialogue.getNote();
            if (StringUtils.isNotBlank((String)note) && note.length() > 120) {
                POSMessageDialog.showError(this, Messages.getString("VoidReasonDialog.2"));
                return;
            }
            for (VoidReason voidReason : this.comboBoxModel.getDataList()) {
                if (!voidReason.getReasonText().equalsIgnoreCase(note)) continue;
                this.comboBoxModel.setSelectedItem(voidReason);
                return;
            }
            this.voidReason = new VoidReason();
            this.voidReason.setReasonText(note);
            VoidReasonDAO.getInstance().saveOrUpdate(this.voidReason);
            this.comboBoxModel.addElement(this.voidReason);
            this.comboBoxModel.setSelectedItem(this.voidReason);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, Messages.getString("VoidTicketItemDialog.8"), e);
        }
    }

    public double getVoidQuantity() {
        return this.voidQuantity;
    }

    public TicketView getTicketView() {
        return this.ticketView;
    }

    public void setTicketView(TicketView ticketView) {
        this.ticketView = ticketView;
    }
}

