/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.db.update.UpdateDBTo101;
import com.floreantpos.db.update.UpdateDBTo104;
import com.floreantpos.db.update.UpdateDBTo122;
import com.floreantpos.db.update.UpdateDBTo129;
import com.floreantpos.db.update.UpdateDBTo135;
import com.floreantpos.db.update.UpdateDBTo151;
import com.floreantpos.db.update.UpdateDBTo160;
import com.floreantpos.db.update.UpdateDBTo165;
import com.floreantpos.db.update.UpdateDBTo171;
import com.floreantpos.db.update.UpdateDBTo185;
import com.floreantpos.db.update.UpdateDBTo188;
import com.floreantpos.db.update.UpdateDBTo194;
import com.floreantpos.db.update.UpdateDBTo209;
import com.floreantpos.db.update.UpdateDBTo210;
import com.floreantpos.db.update.UpdateDBTo213;
import com.floreantpos.db.update.UpdateDBTo224;
import com.floreantpos.db.update.UpdateDBTo225;
import com.floreantpos.db.update.UpdateDBTo227;
import com.floreantpos.db.update.UpdateDBTo232;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DefaultDataInserter;
import com.floreantpos.versioning.VersionInfo;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.exception.SQLGrammarException;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaExport;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;

public class DatabaseUtil {
    public static final Integer DATABASE_VERSION = 233;
    private static Log logger = LogFactory.getLog(DatabaseUtil.class);

    public static void checkConnection(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password) throws DatabaseConnectionException {
        try {
            Class.forName(hibernateConnectionDriverClass);
            DriverManager.getConnection(connectionString, user, password);
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(Messages.getString("DatabaseUtil.0") + e.getMessage());
        }
    }

    public static void initialize() throws DatabaseConnectionException {
        _RootDAO.initialize();
    }

    public static void initialize(String hibernanetCfgFile) throws DatabaseConnectionException {
        _RootDAO.initialize(hibernanetCfgFile);
    }

    public static void initialize(String hibernanetCfgFile, String hibernateDialectClass, String driverClass, String connectString, String databaseUser, String databasePassword) {
        _RootDAO.initialize(hibernanetCfgFile, hibernateDialectClass, driverClass, connectString, databaseUser, databasePassword);
    }

    public static void initialize(String hibernanetCfgFile, Map<String, String> properties) {
        _RootDAO.initialize(hibernanetCfgFile, properties);
    }

    public static void initialize(Map<String, String> properties) {
        _RootDAO.initialize(properties);
    }

    public static boolean createDatabase(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password, boolean exportSampleData) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), connectionString, hibernateDialect, hibernateConnectionDriverClass, user, password, exportSampleData, false);
    }

    public static boolean createDatabase(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password, boolean exportSampleData, boolean testData) {
        return DatabaseUtil.createDatabase(Application.getInstance().getHibernateConfigurationFileName(), connectionString, hibernateDialect, hibernateConnectionDriverClass, user, password, exportSampleData, testData);
    }

    public static boolean createDatabase(String hibernateCfgFileName, String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password, boolean exportSampleData, boolean testData) {
        try {
            _RootDAO.releaseConnection();
            StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().configure(hibernateCfgFileName);
            registryBuilder.applySetting("hibernate.dialect", (Object)hibernateDialect);
            registryBuilder.applySetting("hibernate.connection.driver_class", (Object)hibernateConnectionDriverClass);
            registryBuilder.applySetting("hibernate.connection.url", (Object)connectionString);
            registryBuilder.applySetting("hibernate.connection.username", (Object)user);
            registryBuilder.applySetting("hibernate.connection.password", (Object)password);
            registryBuilder.applySetting("hibernate.hbm2ddl.auto", (Object)"create");
            registryBuilder.applySetting("hibernate.c3p0.checkoutTimeout", (Object)"0");
            registryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
            StandardServiceRegistry standardRegistry = registryBuilder.build();
            Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
            SchemaExport schemaExport = new SchemaExport();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE);
            schemaExport.create(enumSet, metaData);
            _RootDAO.setSessionFactory(metaData.buildSessionFactory());
            DefaultDataInserter dataInserter = new DefaultDataInserter();
            dataInserter.insertDefaultData(233, false);
            if (!exportSampleData) {
                StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
                return true;
            }
            if (testData) {
                dataInserter.createSampleTestData();
            } else {
                dataInserter.createSampleData(false);
            }
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
            return true;
        }
        catch (Exception e) {
            PosLog.error(DatabaseUtil.class, e);
            logger.error((Object)e);
            return false;
        }
    }

    public static void updateLegacyDatabase() {
    }

    public static boolean updateDatabase(String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password) {
        return DatabaseUtil.updateDatabase(Application.getInstance().getHibernateConfigurationFileName(), connectionString, hibernateDialect, hibernateConnectionDriverClass, user, password);
    }

    public static boolean updateDatabase(String hibernateCfgFileName, String connectionString, String hibernateDialect, String hibernateConnectionDriverClass, String user, String password) {
        try {
            Object dataConvertionUtil;
            Integer databaseVersion;
            _RootDAO.releaseConnection();
            StandardServiceRegistryBuilder registryBuilder = new StandardServiceRegistryBuilder().configure(hibernateCfgFileName);
            registryBuilder.applySetting("hibernate.dialect", (Object)hibernateDialect);
            registryBuilder.applySetting("hibernate.connection.driver_class", (Object)hibernateConnectionDriverClass);
            registryBuilder.applySetting("hibernate.connection.url", (Object)connectionString);
            registryBuilder.applySetting("hibernate.connection.username", (Object)user);
            registryBuilder.applySetting("hibernate.connection.password", (Object)password);
            registryBuilder.applySetting("hibernate.max_fetch_depth", (Object)"3");
            registryBuilder.applySetting("hibernate.connection.isolation", (Object)String.valueOf(1));
            registryBuilder.applySetting("hibernate.cache.use_second_level_cache", (Object)"false");
            StandardServiceRegistry standardRegistry = registryBuilder.build();
            Metadata metaData = new MetadataSources((ServiceRegistry)standardRegistry).getMetadataBuilder().build();
            SchemaUpdate schemaUpdate = new SchemaUpdate();
            EnumSet<TargetType> enumSet = EnumSet.of(TargetType.DATABASE, TargetType.STDOUT);
            schemaUpdate.execute(enumSet, metaData);
            SessionFactory sessionFactory = metaData.buildSessionFactory();
            _RootDAO.setSessionFactory(sessionFactory);
            Store store = StoreDAO.getRestaurant();
            Integer n = databaseVersion = store == null ? null : store.getDatabaseVersion();
            if (databaseVersion == null || databaseVersion < 135) {
                dataConvertionUtil = new UpdateDBTo135(sessionFactory);
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 101) {
                dataConvertionUtil = new UpdateDBTo101(connectionString, user, password, sessionFactory);
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 104) {
                dataConvertionUtil = new UpdateDBTo104();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 122) {
                dataConvertionUtil = new UpdateDBTo122();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 129) {
                dataConvertionUtil = new UpdateDBTo129();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 151) {
                dataConvertionUtil = new UpdateDBTo151();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 160) {
                dataConvertionUtil = new UpdateDBTo160(sessionFactory);
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 165) {
                dataConvertionUtil = new UpdateDBTo165();
                dataConvertionUtil.update(sessionFactory);
            }
            if (databaseVersion == null || databaseVersion < 171) {
                dataConvertionUtil = new UpdateDBTo171(sessionFactory);
                dataConvertionUtil.updateTickets();
                dataConvertionUtil.updateTransactions();
            }
            if (databaseVersion == null || databaseVersion < 185) {
                dataConvertionUtil = new UpdateDBTo185();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 188) {
                dataConvertionUtil = new UpdateDBTo188(schemaUpdate, enumSet, metaData, hibernateDialect, sessionFactory, user);
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 195) {
                dataConvertionUtil = new UpdateDBTo194();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 208) {
                dataConvertionUtil = new UpdateDBTo227(connectionString, user, password);
                ((UpdateDBTo227)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 209) {
                dataConvertionUtil = new UpdateDBTo209(connectionString, user, password);
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 210) {
                dataConvertionUtil = new UpdateDBTo210(connectionString, user, password);
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 213) {
                dataConvertionUtil = new UpdateDBTo213();
                dataConvertionUtil.update();
            }
            if (databaseVersion == null || databaseVersion < 224) {
                dataConvertionUtil = new UpdateDBTo224();
                ((UpdateDBTo224)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 225) {
                dataConvertionUtil = new UpdateDBTo225();
                ((UpdateDBTo225)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 227) {
                dataConvertionUtil = new UpdateDBTo227(connectionString, user, password);
                ((UpdateDBTo227)dataConvertionUtil).update();
            }
            if (databaseVersion == null || databaseVersion < 232) {
                dataConvertionUtil = new UpdateDBTo232(connectionString, user, password);
                ((UpdateDBTo232)dataConvertionUtil).update();
            }
            if ((store = StoreDAO.getRestaurant()) != null) {
                store.setDatabaseVersion(233);
                store.setSoftwareVersion(VersionInfo.getVersion());
                store.setSoftwareNumericVersion(VersionInfo.getNumericVersion());
                StoreDAO.getInstance().update(store);
            }
            sessionFactory.close();
            StandardServiceRegistryBuilder.destroy((ServiceRegistry)standardRegistry);
            return true;
        }
        catch (Exception e) {
            PosLog.error(DatabaseUtil.class, e);
            logger.error((Object)e);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded() {
        try {
            Store store = StoreDAO.getRestaurant();
            if (store == null) {
                throw new PosException(Messages.getString("DatabaseUtil.3") + Messages.getString("DatabaseUtil.4"));
            }
            Integer databaseVersion = store.getDatabaseVersion();
            return databaseVersion == null || databaseVersion < 233;
        }
        catch (SQLGrammarException e) {
            Pattern pattern;
            boolean found;
            String message;
            Throwable cause = e.getCause();
            if (cause != null && (message = cause.getMessage()) != null && (found = (pattern = Pattern.compile("Column .* is either not in any table")).matcher(message).find())) {
                return true;
            }
            logger.error((Object)e);
            return false;
        }
    }

    public static boolean isDbUpdateNeeded(Integer databaseVersionInDb) {
        return databaseVersionInDb == null || databaseVersionInDb < 233;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getStoreProperties(String connectionString, String hibernateConnectionDriverClass, String user, String password) throws Exception {
        Class.forName(hibernateConnectionDriverClass);
        try (Connection connection = null;){
            String errorMessage = Messages.getString("DatabaseUtil.6");
            errorMessage = String.format(errorMessage, VersionInfo.getAppName());
            connection = DriverManager.getConnection(connectionString, user, password);
            DatabaseMetaData metaData = connection.getMetaData();
            String actualTableName = DatabaseUtil.getActualTableName(metaData, "store_properties");
            if (actualTableName == null) {
                throw new PosException(errorMessage);
            }
            String propertyNameCol = DatabaseUtil.getActualColumnName(metaData, actualTableName, "property_name");
            String propertyValueCol = DatabaseUtil.getActualColumnName(metaData, actualTableName, "property_value");
            if (propertyNameCol == null || propertyValueCol == null) {
                throw new PosException(errorMessage);
            }
            String sql = String.format("select * from %s", actualTableName);
            HashMap<String, String> storePropertes = new HashMap<String, String>();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            while (resultSet.next()) {
                String propertyName = resultSet.getString(propertyNameCol);
                String propertyValue = resultSet.getString(propertyValueCol);
                storePropertes.put(propertyName, propertyValue);
            }
            resultSet.close();
            statement.close();
            HashMap<String, String> hashMap = storePropertes;
            return hashMap;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = null;){
            resultSet = metaData.getTables(null, null, null, new String[]{"TABLE"});
            ArrayList<String> tableNameList = new ArrayList<String>();
            while (resultSet.next()) {
                String tableName2 = resultSet.getString("TABLE_NAME");
                tableNameList.add(tableName2.toLowerCase());
            }
            if (tableNameList.contains(tableName.toLowerCase())) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualTableName(DatabaseMetaData metaData, String tableName) throws SQLException {
        try (ResultSet resultSet = null;){
            resultSet = metaData.getTables(null, null, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                String tableName2 = resultSet.getString("TABLE_NAME");
                if (!tableName2.equalsIgnoreCase(tableName)) continue;
                String string = tableName2;
                return string;
            }
            String string = null;
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getActualColumnName(DatabaseMetaData metaData, String actutalTableName, String virtualColumnName) throws SQLException {
        try (ResultSet sourcecolumns = null;){
            sourcecolumns = metaData.getColumns(null, null, actutalTableName, null);
            while (sourcecolumns.next()) {
                String columnName = sourcecolumns.getString("COLUMN_NAME");
                if (!columnName.equalsIgnoreCase(virtualColumnName)) continue;
                String string = columnName;
                return string;
            }
            String string = null;
            return string;
        }
    }
}

