/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.model.Address;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.AttributeGroup;
import com.floreantpos.model.Currency;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Discount;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.InventoryVendor;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PackagingUnit;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecepieItem;
import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.Store;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AttributeGroupDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DiscountDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuItemModifierPageItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuItemSizeDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.ext.DeviceType;
import com.floreantpos.util.NameBaseIdGenerator;
import com.floreantpos.util.ReceiptUtil;
import com.floreantpos.util.ShiftUtil;
import com.orocube.common.util.TerminalUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DefaultDataInserter {
    private TaxGroup taxGroupSix33;
    private TaxGroup taxGroupSix01 = new TaxGroup("taxgroup2", "6.01");
    private TaxGroup taxGroupnineteen32 = new TaxGroup("taxgroup3", "19.32");
    private ModifierGroup cheeseModifierGroup;
    private ModifierGroup bevarageModifierGroup;
    private ModifierGroup toppingsModifierGroup;
    private MenuModifier americanCheese;
    private MenuModifier gouda;
    private MenuModifier chadder;
    private MenuModifier brie;
    private MenuModifier lemon;
    private MenuModifier salt;
    private MenuModifier mashroom;
    private MenuModifier pepparoni;
    private MenuModifier sausage;
    private MenuModifier onionsModifier;
    private InventoryUnit unitPiece;
    private InventoryUnit unitKg;
    private MenuItem beefBurger;
    private MenuItem bread;
    private MenuItem meat;
    private InventoryUnit unitGram;
    private InventoryUnit unitTon;
    private Attribute smallSize;
    private Attribute mediumSize;
    private Attribute largeSize;
    Date now = StoreDAO.getServerTimestamp();

    public void insertDefaultData(int databaseVersion, boolean isCloud) {
        this.createStore(databaseVersion);
        this.createShifts();
        if (!isCloud) {
            this.createTerminal();
            this.createDefaultUser();
        }
        this.createDefaultTax();
        this.createDefaultCurrency();
        this.createDefaultFloor();
    }

    public void createSampleTestData() {
        this.createOrderTypes();
        this.createAttributes();
        this.createPizzaCrust();
        this.createInventoryData();
        this.createMenuItemData(true);
        this.createRecipe();
        this.createMenuItemSize();
        this.createSampleCurrencies();
        this.createSampleTaxes();
        this.createMultipliers();
        this.createDiscounts();
    }

    public void createSampleData(boolean isCloud) {
        if (!isCloud) {
            this.createSampleUsers();
        }
        this.createOrderTypes(true);
        this.createAttributes();
        this.createPizzaCrust();
        this.createInventoryData();
        this.createMenuItemData(false);
        this.createMenuItemSize();
        this.createMultipliers();
        this.createDiscounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMenuItemSize() {
        Session session = null;
        Transaction tx = null;
        MenuItemSizeDAO menuItemSizeDAO = MenuItemSizeDAO.getInstance();
        try {
            session = menuItemSizeDAO.createNewSession();
            tx = session.beginTransaction();
            String small = Messages.getString("DatabaseUtil.21");
            String medium = Messages.getString("DatabaseUtil.22");
            String large = Messages.getString("DatabaseUtil.23");
            MenuItemSize menuItemSize = new MenuItemSize(small.toLowerCase());
            menuItemSize.setName(small);
            menuItemSize.setSortOrder(0);
            menuItemSize.setLastUpdateTime(this.now);
            session.save((Object)menuItemSize);
            menuItemSize = new MenuItemSize(medium.toLowerCase());
            menuItemSize.setName(medium);
            menuItemSize.setSortOrder(1);
            menuItemSize.setLastUpdateTime(this.now);
            session.save((Object)menuItemSize);
            menuItemSize = new MenuItemSize(large.toLowerCase());
            menuItemSize.setName(large);
            menuItemSize.setSortOrder(2);
            menuItemSize.setLastUpdateTime(this.now);
            session.save((Object)menuItemSize);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            menuItemSizeDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPizzaCrust() {
        Session session = null;
        Transaction tx = null;
        PizzaCrustDAO pizzaCrustDAO = PizzaCrustDAO.getInstance();
        try {
            session = pizzaCrustDAO.createNewSession();
            tx = session.beginTransaction();
            String pan = Messages.getString("DatabaseUtil.24");
            String handToss = Messages.getString("DatabaseUtil.25");
            PizzaCrust crust = new PizzaCrust(pan.toLowerCase());
            crust.setName(pan);
            crust.setSortOrder(0);
            crust.setLastUpdateTime(this.now);
            session.save((Object)crust);
            crust = new PizzaCrust(handToss.toLowerCase());
            crust.setName(handToss);
            crust.setSortOrder(1);
            crust.setLastUpdateTime(this.now);
            session.save((Object)crust);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            pizzaCrustDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSampleCurrencies() {
        Session session = null;
        Transaction tx = null;
        CurrencyDAO currencyDAO = CurrencyDAO.getInstance();
        try {
            session = currencyDAO.createNewSession();
            tx = session.beginTransaction();
            Currency currency = new Currency("euro");
            currency = new Currency();
            currency.setName("EUR");
            currency.setSymbol("E");
            currency.setExchangeRate(0.8);
            currency.setLastUpdateTime(this.now);
            session.save((Object)currency);
            currency = new Currency("brazil");
            currency.setName("BRL");
            currency.setSymbol("B");
            currency.setExchangeRate(3.47);
            currency.setLastUpdateTime(this.now);
            session.save((Object)currency);
            currency = new Currency("argentinepeso");
            currency.setName("ARS");
            currency.setSymbol("P");
            currency.setExchangeRate(13.89);
            currency.setLastUpdateTime(this.now);
            session.save((Object)currency);
            currency = new Currency("guarani");
            currency.setName("PYG");
            currency.setSymbol("P");
            currency.setLastUpdateTime(this.now);
            currency.setExchangeRate(5639.78);
            session.save((Object)currency);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            currencyDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultCurrency() {
        Session session = null;
        Transaction tx = null;
        CurrencyDAO currencyDAO = CurrencyDAO.getInstance();
        try {
            session = currencyDAO.createNewSession();
            tx = session.beginTransaction();
            Currency currency = new Currency("usd");
            currency.setName("US Dollar");
            currency.setCode("USD");
            currency.setSymbol("$");
            currency.setExchangeRate(1.0);
            currency.setMain(true);
            currency.setLastUpdateTime(this.now);
            session.save((Object)currency);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            currencyDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultTax() {
        Session session = null;
        Transaction tx = null;
        TaxGroupDAO taxGroupDAO = TaxGroupDAO.getInstance();
        try {
            session = taxGroupDAO.createNewSession();
            tx = session.beginTransaction();
            Tax tax = new Tax();
            tax.setName("US");
            tax.setRate(6.33);
            tax.setLastUpdateTime(this.now);
            this.taxGroupSix33 = new TaxGroup("taxgroup1", "US");
            this.taxGroupSix33.addTotaxes(tax);
            this.taxGroupSix33.setLastUpdateTime(this.now);
            session.save((Object)tax);
            session.save((Object)this.taxGroupSix33);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            taxGroupDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultUser() {
        Session session = null;
        Transaction tx = null;
        UserTypeDAO userTypeDAO = UserTypeDAO.getInstance();
        try {
            session = userTypeDAO.createNewSession();
            tx = session.beginTransaction();
            UserType administrator = new UserType();
            administrator.setId(POSConstants.ADMINISTRATOR.toLowerCase());
            administrator.setName(POSConstants.ADMINISTRATOR);
            administrator.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
            administrator.setLastUpdateTime(this.now);
            session.save((Object)administrator);
            User administratorUser = new User();
            administratorUser.setId("123");
            administratorUser.setEncryptedPassword("1111");
            administratorUser.setFirstName("admin");
            administratorUser.setLastName("s");
            administratorUser.setType(administrator);
            administratorUser.setRoot(true);
            administratorUser.setActive(true);
            administratorUser.setLastUpdateTime(this.now);
            session.save((Object)administratorUser);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            userTypeDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStore(int databaseVersion) {
        Session session = null;
        Transaction tx = null;
        StoreDAO storeDAO = StoreDAO.getInstance();
        try {
            session = storeDAO.createNewSession();
            tx = session.beginTransaction();
            Store store = new Store();
            store.setId("1");
            store.setUuid(UUID.randomUUID().toString());
            store.setName("Demo Restaurant");
            String outletName = "Main";
            store.setOutletName(outletName);
            store.setDefaultOutletId(NameBaseIdGenerator.generateId(outletName));
            store.setAddressLine1("203 West Main Street");
            store.setAddressLine1(" South Carolina");
            store.setTelephone("+0123456789");
            store.setProperties(new HashMap<String, String>());
            store.setDatabaseVersion(databaseVersion);
            store.setLastUpdateTime(this.now);
            ReceiptUtil.populateDefaultTicketReceiptProperties(store);
            ReceiptUtil.populateDefaultKitchenReceiptProperties(store);
            session.saveOrUpdate((Object)store);
            Outlet outlet = new Outlet(NameBaseIdGenerator.generateId(outletName));
            outlet.setName(outletName);
            outlet.setLastUpdateTime(this.now);
            Address address = new Address();
            address.setAddressLine(store.getAddressLine1());
            address.setLastUpdateTime(this.now);
            outlet.setAddress(address);
            session.saveOrUpdate((Object)address);
            session.save((Object)outlet);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            storeDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTerminal() {
        Session session = null;
        Transaction tx = null;
        TerminalDAO terminalDAO = TerminalDAO.getInstance();
        try {
            session = terminalDAO.createNewSession();
            tx = session.beginTransaction();
            Terminal terminal = new Terminal();
            terminal.setId(terminalDAO.createNewTerminalId(TerminalUtil.getSystemUID()));
            terminal.setDefaultPassLength(4);
            terminal.setTerminalKey(TerminalUtil.getSystemUID());
            terminal.setName(terminalDAO.createNewTerminalName(session));
            terminal.setLastUpdateTime(this.now);
            terminal.setDeviceType(DeviceType.DESKTOP.getDeviceType());
            session.saveOrUpdate((Object)terminal);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            terminalDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDiscounts() {
        Session session = null;
        Transaction tx = null;
        DiscountDAO discountDao = DiscountDAO.getInstance();
        try {
            session = discountDao.createNewSession();
            tx = session.beginTransaction();
            Discount discount1 = new Discount();
            discount1.setId("buy1get1");
            discount1.setName(Messages.getString("DatabaseUtil.18", "Buy 1 and get 1 free"));
            discount1.setType(1);
            discount1.setValue(100.0);
            discount1.setAutoApply(false);
            discount1.setMinimumBuy(2.0);
            discount1.setQualificationType(0);
            discount1.setApplyToAll(true);
            discount1.setNeverExpire(true);
            discount1.setEnabled(true);
            discount1.setLastUpdateTime(this.now);
            session.save((Object)discount1);
            Discount discount2 = new Discount();
            discount2.setId("buy2get1");
            discount2.setName(Messages.getString("DatabaseUtil.19", "Buy 2 and get 1 free"));
            discount2.setType(1);
            discount2.setValue(100.0);
            discount2.setAutoApply(true);
            discount2.setMinimumBuy(3.0);
            discount2.setQualificationType(0);
            discount2.setApplyToAll(true);
            discount2.setNeverExpire(true);
            discount2.setEnabled(true);
            discount2.setLastUpdateTime(this.now);
            session.save((Object)discount2);
            Discount discount3 = new Discount();
            discount3.setId("10%onItem");
            discount3.setName(Messages.getString("DatabaseUtil.20", "10% Off on Item"));
            discount3.setType(1);
            discount3.setValue(10.0);
            discount3.setAutoApply(false);
            discount3.setMinimumBuy(1.0);
            discount3.setQualificationType(0);
            discount3.setApplyToAll(true);
            discount3.setNeverExpire(true);
            discount3.setEnabled(true);
            discount3.setLastUpdateTime(this.now);
            session.save((Object)discount3);
            Discount discount4 = new Discount();
            discount4.setId("10%onTicket");
            discount4.setName("10% on Ticket");
            discount4.setType(1);
            discount4.setValue(10.0);
            discount4.setAutoApply(false);
            discount4.setMinimumBuy(1.0);
            discount4.setQualificationType(1);
            discount4.setApplyToAll(true);
            discount4.setNeverExpire(true);
            discount4.setEnabled(true);
            discount4.setLastUpdateTime(this.now);
            session.save((Object)discount4);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            discountDao.closeSession(session);
        }
    }

    private void createOrderTypes() {
        this.createOrderTypes(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createOrderTypes(boolean isCloud) {
        Session session = null;
        Transaction tx = null;
        OrderTypeDAO orderTypeDAO = OrderTypeDAO.getInstance();
        try {
            session = orderTypeDAO.createNewSession();
            tx = session.beginTransaction();
            OrderType orderType = new OrderType("dine_in");
            orderType.setName(Messages.getString("DatabaseUtil.14"));
            orderType.setShowTableSelection(true);
            orderType.setCloseOnPaid(true);
            orderType.setEnabled(true);
            orderType.setShouldPrintToKitchen(true);
            orderType.setShowInLoginScreen(true);
            orderType.setSortOrder(1);
            orderType.setLastUpdateTime(this.now);
            session.save((Object)orderType);
            orderType = new OrderType("take_out");
            orderType.setName(Messages.getString("DatabaseUtil.15"));
            orderType.setShowTableSelection(false);
            orderType.setCloseOnPaid(true);
            orderType.setEnabled(true);
            orderType.setPrepaid(true);
            orderType.setShouldPrintToKitchen(true);
            orderType.setShowInLoginScreen(true);
            orderType.setSortOrder(2);
            orderType.setLastUpdateTime(this.now);
            session.save((Object)orderType);
            if (!isCloud) {
                orderType = new OrderType("retail");
                orderType.setName(Messages.getString("DatabaseUtil.16"));
                orderType.setShowTableSelection(false);
                orderType.setCloseOnPaid(true);
                orderType.setEnabled(true);
                orderType.setRetailOrder(true);
                orderType.setShouldPrintToKitchen(false);
                orderType.setShowInLoginScreen(true);
                orderType.setSortOrder(3);
                orderType.setLastUpdateTime(this.now);
                session.save((Object)orderType);
                orderType = new OrderType("home_delivery");
                orderType.setName(Messages.getString("DatabaseUtil.17"));
                orderType.setShowTableSelection(false);
                orderType.setCloseOnPaid(false);
                orderType.setEnabled(true);
                orderType.setShouldPrintToKitchen(true);
                orderType.setShowInLoginScreen(true);
                orderType.setRequiredCustomerData(true);
                orderType.setDelivery(true);
                orderType.setSortOrder(4);
                orderType.setLastUpdateTime(this.now);
                session.save((Object)orderType);
            }
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            orderTypeDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSampleUsers() {
        Session session = null;
        Transaction tx = null;
        UserDAO userDAO = UserDAO.getInstance();
        try {
            session = userDAO.createNewSession();
            tx = session.beginTransaction();
            UserType manager = new UserType();
            manager.setId(POSConstants.MANAGER.toLowerCase());
            manager.setName(POSConstants.MANAGER);
            manager.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.permissions)));
            manager.setLastUpdateTime(this.now);
            session.save((Object)manager);
            UserType cashier = new UserType();
            cashier.setId(POSConstants.CASHIER.toLowerCase());
            cashier.setName(POSConstants.CASHIER);
            cashier.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET, UserPermission.SPLIT_TICKET, UserPermission.EDIT_OTHER_USERS_TICKETS)));
            cashier.setLastUpdateTime(this.now);
            session.save((Object)cashier);
            UserType server = new UserType();
            server.setId("server");
            server.setName("SERVER");
            server.setPermissions(new HashSet<UserPermission>(Arrays.asList(UserPermission.CREATE_TICKET, UserPermission.SETTLE_TICKET, UserPermission.SPLIT_TICKET)));
            server.setLastUpdateTime(this.now);
            session.save((Object)server);
            this.createManagerUser(manager, cashier, server);
            User cashierUser = new User();
            cashierUser.setId("125");
            cashierUser.setEncryptedPassword("3333");
            cashierUser.setFirstName("Cashier");
            cashierUser.setLastName("C");
            cashierUser.setType(cashier);
            cashierUser.setRoot(true);
            cashierUser.setActive(true);
            cashierUser.setLastUpdateTime(this.now);
            session.save((Object)cashierUser);
            User serverUser = new User();
            serverUser.setId("126");
            serverUser.setEncryptedPassword("4444");
            serverUser.setFirstName("John");
            serverUser.setLastName("Doe");
            serverUser.setType(server);
            serverUser.setRoot(true);
            serverUser.setActive(true);
            serverUser.setStaffBank(true);
            serverUser.setAutoStartStaffBank(true);
            serverUser.setLastUpdateTime(this.now);
            session.save((Object)serverUser);
            serverUser = new User();
            serverUser.setId("127");
            serverUser.setEncryptedPassword("6666");
            serverUser.setFirstName("Juthi");
            serverUser.setLastName("M");
            serverUser.setType(server);
            serverUser.setRoot(true);
            serverUser.setActive(true);
            serverUser.setLastUpdateTime(this.now);
            session.save((Object)serverUser);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            userDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createSampleTaxes() {
        Session session = null;
        Transaction tx = null;
        TaxGroupDAO taxGroupDAO = TaxGroupDAO.getInstance();
        try {
            session = taxGroupDAO.createNewSession();
            tx = session.beginTransaction();
            Tax five89 = new Tax("five89", "five 89", 5.89);
            five89.setLastUpdateTime(this.now);
            session.save((Object)five89);
            Tax zero12 = new Tax("zero12", "zero 12", 0.12);
            zero12.setLastUpdateTime(this.now);
            session.save((Object)zero12);
            Tax fifteen45 = new Tax("fifteen45", "fifteen 45", 15.45);
            fifteen45.setLastUpdateTime(this.now);
            session.save((Object)fifteen45);
            Tax three87 = new Tax("three87", "three87", 3.87);
            three87.setLastUpdateTime(this.now);
            session.save((Object)three87);
            this.taxGroupSix01.addTotaxes(five89);
            this.taxGroupSix01.addTotaxes(zero12);
            this.taxGroupSix01.setLastUpdateTime(this.now);
            session.save((Object)this.taxGroupSix01);
            this.taxGroupnineteen32.addTotaxes(fifteen45);
            this.taxGroupnineteen32.addTotaxes(three87);
            this.taxGroupnineteen32.setLastUpdateTime(this.now);
            session.save((Object)this.taxGroupnineteen32);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            taxGroupDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMenuItemData(boolean isTestData) {
        Session session = null;
        Transaction tx = null;
        MenuCategoryDAO menuCategoryDAO = MenuCategoryDAO.getInstance();
        try {
            session = menuCategoryDAO.createNewSession();
            tx = session.beginTransaction();
            MenuCategory fastfood = new MenuCategory();
            fastfood.setId("fastfood");
            fastfood.setName("FASTFOOD");
            fastfood.setVisible(true);
            fastfood.setSortOrder(1);
            fastfood.setLastUpdateTime(this.now);
            session.save((Object)fastfood);
            MenuCategory drinks = new MenuCategory();
            drinks.setId("drinks");
            drinks.setName("DRINKS");
            drinks.setVisible(true);
            drinks.setSortOrder(2);
            drinks.setLastUpdateTime(this.now);
            session.save((Object)drinks);
            MenuGroup burgerGroup = new MenuGroup();
            burgerGroup.setId("burger");
            burgerGroup.setName("BURGER");
            burgerGroup.setVisible(true);
            burgerGroup.setMenuCategoryId(fastfood.getId());
            burgerGroup.setSortOrder(1);
            burgerGroup.setLastUpdateTime(this.now);
            session.save((Object)burgerGroup);
            MenuGroup beverageGroup = new MenuGroup();
            beverageGroup.setId("beverage");
            beverageGroup.setName("BEVERAGE");
            beverageGroup.setVisible(true);
            beverageGroup.setMenuCategoryId(drinks.getId());
            beverageGroup.setSortOrder(2);
            beverageGroup.setLastUpdateTime(this.now);
            session.save((Object)beverageGroup);
            MenuGroup sandwichGroup = new MenuGroup();
            sandwichGroup.setId("sandwich");
            sandwichGroup.setName("SANDWICH");
            sandwichGroup.setVisible(true);
            sandwichGroup.setMenuCategoryId(fastfood.getId());
            sandwichGroup.setSortOrder(3);
            sandwichGroup.setLastUpdateTime(this.now);
            session.save((Object)sandwichGroup);
            this.createMenuModifiers(session);
            MenuItem americanBurger = new MenuItem("americanBurger", "American Burger", 77.99);
            americanBurger.setUnit(this.unitPiece);
            americanBurger.setCost(5.5);
            americanBurger.setVisible(true);
            americanBurger.setReorderLevel(5.0);
            americanBurger.setReplenishLevel(10.0);
            americanBurger.setMenuGroup(burgerGroup);
            americanBurger.setTaxGroup(this.taxGroupnineteen32);
            americanBurger.setLastUpdateTime(this.now);
            session.save((Object)americanBurger);
            this.beefBurger = new MenuItem("beefBurger", "Beef Burger", 99.33);
            this.beefBurger.setUnit(this.unitPiece);
            this.beefBurger.setCost(1.5);
            this.beefBurger.setVisible(true);
            this.beefBurger.setReorderLevel(5.0);
            this.beefBurger.setReplenishLevel(10.0);
            this.beefBurger.setMenuGroup(burgerGroup);
            this.beefBurger.setTaxGroup(this.taxGroupSix33);
            this.beefBurger.setLastUpdateTime(this.now);
            session.save((Object)this.beefBurger);
            MenuItem customBurger = new MenuItem("customBurger", "Custom Burger", 45.66);
            if (isTestData) {
                customBurger.setUnit(this.unitPiece);
                customBurger.setCost(5.5);
                customBurger.setReorderLevel(5.0);
                customBurger.setReplenishLevel(10.0);
                customBurger.setMenuGroup(burgerGroup);
                customBurger.setTaxGroup(this.taxGroupSix33);
                customBurger.setHasModifiers(true);
                customBurger.setHasMandatoryModifiers(true);
                customBurger.setLastUpdateTime(this.now);
                this.createCheeseMenuModifierSpec(customBurger);
                session.save((Object)customBurger);
            }
            MenuItem numbBurger = new MenuItem("numbBurger", "Numb Burger", 23.32);
            if (isTestData) {
                numbBurger.setUnit(this.unitPiece);
                numbBurger.setCost(5.5);
                numbBurger.setReorderLevel(5.0);
                numbBurger.setReplenishLevel(10.0);
                numbBurger.setMenuGroup(burgerGroup);
                numbBurger.setTaxGroup(this.taxGroupSix01);
                numbBurger.setHasModifiers(true);
                numbBurger.setHasMandatoryModifiers(true);
                numbBurger.setLastUpdateTime(this.now);
                this.createCheeseMenuModifierSpec(numbBurger);
                session.save((Object)numbBurger);
            }
            MenuItem cheeseBurger = new MenuItem("cheeseBurger", "Cheese Burger", 75.89);
            cheeseBurger.setUnit(this.unitPiece);
            cheeseBurger.setCost(5.5);
            cheeseBurger.setReorderLevel(5.0);
            cheeseBurger.setReplenishLevel(10.0);
            cheeseBurger.setMenuGroup(burgerGroup);
            cheeseBurger.setHasModifiers(true);
            cheeseBurger.setHasMandatoryModifiers(true);
            cheeseBurger.setTaxGroup(this.taxGroupnineteen32);
            cheeseBurger.setLastUpdateTime(this.now);
            this.createToppingsMenuModifierSpec(cheeseBurger);
            session.save((Object)cheeseBurger);
            MenuItem chickenBurger = new MenuItem("chickenBurger", "Chicken Burger", 89.99);
            chickenBurger.setUnit(this.unitPiece);
            chickenBurger.setCost(5.5);
            chickenBurger.setReorderLevel(5.0);
            chickenBurger.setReplenishLevel(10.0);
            chickenBurger.setMenuGroup(burgerGroup);
            chickenBurger.setTaxGroup(this.taxGroupSix33);
            chickenBurger.setLastUpdateTime(this.now);
            session.save((Object)chickenBurger);
            MenuItem nullBurger = new MenuItem("nullBurger", "Null Burger", 66.99);
            if (isTestData) {
                nullBurger.setUnit(this.unitPiece);
                nullBurger.setCost(5.5);
                nullBurger.setReorderLevel(5.0);
                nullBurger.setReplenishLevel(10.0);
                nullBurger.setMenuGroup(burgerGroup);
                nullBurger.setLastUpdateTime(this.now);
                session.save((Object)nullBurger);
            }
            MenuItem hamBurger = new MenuItem("hamBurger", "Ham Burger", 85.35);
            if (isTestData) {
                hamBurger.setUnit(this.unitPiece);
                hamBurger.setCost(5.5);
                hamBurger.setReorderLevel(5.0);
                hamBurger.setReplenishLevel(10.0);
                hamBurger.setMenuGroup(burgerGroup);
                hamBurger.setHasModifiers(true);
                hamBurger.setHasMandatoryModifiers(true);
                hamBurger.setLastUpdateTime(this.now);
                this.createToppingsMenuModifierSpec(hamBurger);
                session.save((Object)hamBurger);
            }
            this.bread = new MenuItem("bread", "Bread", 10.0);
            if (isTestData) {
                this.bread.setUnit(this.unitPiece);
                this.bread.setCost(3.0);
                this.bread.setReorderLevel(5.0);
                this.bread.setReplenishLevel(10.0);
                this.bread.setMenuGroup(burgerGroup);
                this.bread.setLastUpdateTime(this.now);
                session.save((Object)this.bread);
            }
            if (isTestData) {
                this.meat = new MenuItem("meat", "Meat", 400.0);
                this.meat.setUnit(this.unitKg);
                this.meat.setCost(250.0);
                this.meat.setReorderLevel(5.0);
                this.meat.setReplenishLevel(10.0);
                this.meat.setMenuGroup(burgerGroup);
                this.meat.setLastUpdateTime(this.now);
                session.save((Object)this.meat);
            }
            MenuItem coke = new MenuItem("coke", "COKE", 14.99);
            coke.setReorderLevel(5.0);
            coke.setReplenishLevel(10.0);
            coke.setUnit(this.unitPiece);
            coke.setCost(1.5);
            coke.setMenuGroup(beverageGroup);
            coke.setTaxGroup(this.taxGroupSix01);
            coke.setHasVariant(true);
            coke.setShouldPrintToKitchen(false);
            coke.setLastUpdateTime(this.now);
            session.save((Object)coke);
            this.doCreateVariantForCoke(coke, session);
            MenuItem pepsi = new MenuItem("pepsi", "PEPSI", 7.77);
            if (isTestData) {
                pepsi.setReorderLevel(5.0);
                pepsi.setReplenishLevel(10.0);
                pepsi.setUnit(this.unitPiece);
                pepsi.setCost(1.5);
                pepsi.setMenuGroup(beverageGroup);
                pepsi.setTaxGroup(this.taxGroupnineteen32);
                pepsi.setLastUpdateTime(this.now);
                pepsi.setHasVariant(true);
                pepsi.setHasModifiers(true);
                pepsi.setHasMandatoryModifiers(true);
                pepsi.setShouldPrintToKitchen(false);
                this.createBeverageMenuModifierSpec(pepsi);
                session.save((Object)pepsi);
                this.doCreateVariantForPepsi(pepsi, session);
            }
            MenuItem fanta = new MenuItem("fanta", "FANTA", 8.91);
            fanta.setMenuGroup(beverageGroup);
            fanta.setReorderLevel(5.0);
            fanta.setReplenishLevel(10.0);
            fanta.setTaxGroup(this.taxGroupSix01);
            fanta.setUnit(this.unitPiece);
            fanta.setCost(1.5);
            fanta.setShouldPrintToKitchen(false);
            fanta.setLastUpdateTime(this.now);
            session.save((Object)fanta);
            MenuItem sprite = new MenuItem("sprite", "SPRITE", 11.13);
            sprite.setMenuGroup(beverageGroup);
            sprite.setReorderLevel(5.0);
            sprite.setReplenishLevel(10.0);
            sprite.setTaxGroup(this.taxGroupSix33);
            sprite.setUnit(this.unitPiece);
            sprite.setCost(1.5);
            sprite.setShouldPrintToKitchen(false);
            sprite.setLastUpdateTime(this.now);
            session.save((Object)sprite);
            MenuItem chickenSandwich = new MenuItem("chickenSandwich", "CHICKEN SANDWICH", 51.32);
            chickenSandwich.setTaxGroup(this.taxGroupnineteen32);
            chickenSandwich.setMenuGroup(sandwichGroup);
            chickenSandwich.setReorderLevel(5.0);
            chickenSandwich.setReplenishLevel(10.0);
            chickenSandwich.setVisible(true);
            chickenSandwich.setUnit(this.unitPiece);
            chickenSandwich.setCost(1.5);
            chickenSandwich.setLastUpdateTime(this.now);
            session.save((Object)chickenSandwich);
            MenuItem beefSandwich = new MenuItem("beeefSandwich", "BEEF SANDWICH", 113.45);
            beefSandwich.setTaxGroup(this.taxGroupSix01);
            beefSandwich.setMenuGroup(sandwichGroup);
            beefSandwich.setReorderLevel(5.0);
            beefSandwich.setVisible(true);
            beefSandwich.setReplenishLevel(10.0);
            beefSandwich.setUnit(this.unitPiece);
            beefSandwich.setCost(1.5);
            beefSandwich.setLastUpdateTime(this.now);
            session.save((Object)beefSandwich);
            MenuItem hamSandwich = new MenuItem("hamSandwich", "HAM SANDWICH", 53.37);
            hamSandwich.setMenuGroup(sandwichGroup);
            hamSandwich.setReorderLevel(5.0);
            hamSandwich.setVisible(true);
            hamSandwich.setReplenishLevel(10.0);
            hamSandwich.setTaxGroup(this.taxGroupSix33);
            hamSandwich.setUnit(this.unitPiece);
            hamSandwich.setCost(1.5);
            hamSandwich.setLastUpdateTime(this.now);
            session.save((Object)hamSandwich);
            MenuPage burgerPage = new MenuPage();
            burgerPage.setName("burgers");
            burgerPage.setCols(4);
            burgerPage.setRows(4);
            burgerPage.setButtonHeight(100);
            burgerPage.setButtonWidth(120);
            burgerPage.setVisible(true);
            burgerPage.setMenuGroupId(burgerGroup.getId());
            burgerPage.setLastUpdateTime(this.now);
            session.save((Object)burgerPage);
            MenuPageItem menuPageItem = new MenuPageItem(0, 0, americanBurger, burgerPage);
            menuPageItem.setMenuPageId(burgerPage.getId());
            session.save((Object)menuPageItem);
            MenuPageItem menuPageItem2 = new MenuPageItem(1, 0, this.beefBurger, burgerPage);
            menuPageItem2.setMenuPageId(burgerPage.getId());
            session.save((Object)menuPageItem2);
            MenuPageItem menuPageItem3 = new MenuPageItem(2, 0, chickenBurger, burgerPage);
            menuPageItem3.setMenuPageId(burgerPage.getId());
            session.save((Object)menuPageItem3);
            MenuPageItem menuPageItem4 = new MenuPageItem(3, 0, cheeseBurger, burgerPage);
            menuPageItem4.setMenuPageId(burgerPage.getId());
            session.save((Object)menuPageItem4);
            if (isTestData) {
                MenuPageItem menuPageItem5 = new MenuPageItem(0, 1, customBurger, burgerPage);
                menuPageItem5.setMenuPageId(burgerPage.getId());
                session.save((Object)menuPageItem5);
            }
            if (isTestData) {
                MenuPageItem menuPageItem6 = new MenuPageItem(1, 1, hamBurger, burgerPage);
                menuPageItem6.setMenuPageId(burgerPage.getId());
                session.save((Object)menuPageItem6);
            }
            if (isTestData) {
                MenuPageItem menuPageItem7 = new MenuPageItem(2, 1, nullBurger, burgerPage);
                menuPageItem7.setMenuPageId(burgerPage.getId());
                session.save((Object)menuPageItem7);
                MenuPageItem menuPageItem8 = new MenuPageItem(3, 1, numbBurger, burgerPage);
                menuPageItem8.setMenuPageId(burgerPage.getId());
                session.save((Object)menuPageItem8);
            }
            burgerPage.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)burgerPage);
            MenuPage sandwichPage = new MenuPage();
            sandwichPage.setName("page 1");
            sandwichPage.setCols(4);
            sandwichPage.setRows(4);
            sandwichPage.setButtonHeight(100);
            sandwichPage.setButtonWidth(120);
            sandwichPage.setVisible(true);
            sandwichPage.setMenuGroupId(sandwichGroup.getId());
            sandwichPage.setLastUpdateTime(this.now);
            session.save((Object)sandwichPage);
            MenuPageItem sandwichItem1 = new MenuPageItem(0, 0, beefSandwich, sandwichPage);
            sandwichItem1.setMenuPage(sandwichPage);
            session.save((Object)sandwichItem1);
            MenuPageItem sandwichItem2 = new MenuPageItem(1, 0, chickenSandwich, sandwichPage);
            sandwichItem2.setMenuPage(sandwichPage);
            session.save((Object)sandwichItem2);
            MenuPageItem sandwichItem3 = new MenuPageItem(2, 0, hamSandwich, sandwichPage);
            sandwichItem3.setMenuPage(sandwichPage);
            session.save((Object)sandwichItem3);
            session.saveOrUpdate((Object)sandwichPage);
            MenuPage drinksPage = new MenuPage();
            drinksPage.setName("page 1");
            drinksPage.setCols(4);
            drinksPage.setRows(4);
            drinksPage.setButtonHeight(100);
            drinksPage.setButtonWidth(120);
            drinksPage.setVisible(true);
            drinksPage.setMenuGroupId(beverageGroup.getId());
            drinksPage.setLastUpdateTime(this.now);
            session.save((Object)drinksPage);
            MenuPageItem cokeItem = new MenuPageItem(1, 0, coke, drinksPage);
            cokeItem.setMenuPageId(drinksPage.getId());
            session.save((Object)cokeItem);
            MenuPageItem fantaItem = new MenuPageItem(2, 0, fanta, drinksPage);
            fantaItem.setMenuPageId(drinksPage.getId());
            session.save((Object)fantaItem);
            MenuPageItem spriteItem = new MenuPageItem(3, 0, sprite, drinksPage);
            spriteItem.setMenuPageId(drinksPage.getId());
            session.save((Object)spriteItem);
            if (isTestData) {
                MenuPageItem pepsiItem = new MenuPageItem(0, 1, pepsi, drinksPage);
                pepsiItem.setMenuPageId(drinksPage.getId());
                session.save((Object)pepsiItem);
            }
            session.saveOrUpdate((Object)drinksPage);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            menuCategoryDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRecipe() {
        Session session = null;
        Transaction tx = null;
        RecepieDAO recepieDAO = RecepieDAO.getInstance();
        try {
            session = recepieDAO.createNewSession();
            tx = session.beginTransaction();
            Recepie recipe = new Recepie();
            recipe.setName("Beef Burger Recipe");
            recipe.setPortion(1.0);
            recipe.setYield(1.0);
            recipe.setCookingTime(60);
            recipe.setMenuItem(this.beefBurger);
            recipe.setYieldUnit(this.unitPiece.getCode());
            recipe.setPortionUnit(this.unitPiece.getUniqueCode());
            RecepieItem breadItem = new RecepieItem();
            breadItem.setInventoryItem(this.bread);
            breadItem.setQuantity(1.0);
            breadItem.setPercentage(100.0);
            breadItem.setUnit(this.unitPiece);
            breadItem.setUnitCode(this.unitPiece.getCode());
            recipe.addTorecepieItems(breadItem);
            RecepieItem meatItem = new RecepieItem();
            meatItem.setInventoryItem(this.meat);
            meatItem.setPercentage(10.0);
            meatItem.setQuantity(100.0);
            meatItem.setUnit(this.unitGram);
            meatItem.setUnitCode(this.unitGram.getCode());
            recipe.addTorecepieItems(meatItem);
            session.save((Object)recipe);
            this.beefBurger.setDefaultRecipeId(recipe.getId());
            session.update((Object)this.beefBurger);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            recepieDAO.closeSession(session);
        }
    }

    private void createMenuModifiers(Session session) {
        this.americanCheese = new MenuModifier("americanCheese");
        this.americanCheese.setName("American");
        this.americanCheese.setPrice(2.99);
        this.americanCheese.setTaxGroup(this.taxGroupnineteen32);
        this.americanCheese.setLastUpdateTime(this.now);
        session.save((Object)this.americanCheese);
        this.gouda = new MenuModifier("gouda");
        this.gouda.setName("Gouda");
        this.gouda.setPrice(1.0);
        this.gouda.setTaxGroup(this.taxGroupSix33);
        this.gouda.setLastUpdateTime(this.now);
        session.save((Object)this.gouda);
        this.chadder = new MenuModifier("chadder");
        this.chadder.setName("Chadder");
        this.chadder.setPrice(1.25);
        this.chadder.setTaxGroup(this.taxGroupSix33);
        this.chadder.setLastUpdateTime(this.now);
        session.save((Object)this.chadder);
        this.brie = new MenuModifier("brie");
        this.brie.setName("Brie");
        this.brie.setPrice(2.0);
        this.brie.setTaxGroup(this.taxGroupSix33);
        this.brie.setLastUpdateTime(this.now);
        session.save((Object)this.brie);
        this.cheeseModifierGroup = new ModifierGroup("cheese");
        this.cheeseModifierGroup.setName("Cheese");
        this.cheeseModifierGroup.addTomodifiers(this.americanCheese);
        this.cheeseModifierGroup.addTomodifiers(this.gouda);
        this.cheeseModifierGroup.addTomodifiers(this.chadder);
        this.cheeseModifierGroup.addTomodifiers(this.brie);
        this.cheeseModifierGroup.setLastUpdateTime(this.now);
        session.save((Object)this.cheeseModifierGroup);
        this.lemon = new MenuModifier("lemon");
        this.lemon.setName("Lemon");
        this.lemon.setPrice(0.79);
        this.lemon.setTaxGroup(this.taxGroupSix01);
        this.lemon.setLastUpdateTime(this.now);
        session.save((Object)this.lemon);
        this.salt = new MenuModifier("salt");
        this.salt.setName("Salt");
        this.salt.setPrice(0.27);
        this.salt.setLastUpdateTime(this.now);
        session.save((Object)this.salt);
        this.bevarageModifierGroup = new ModifierGroup("beverages");
        this.bevarageModifierGroup.setName("Beverages");
        this.bevarageModifierGroup.addTomodifiers(this.lemon);
        this.bevarageModifierGroup.addTomodifiers(this.salt);
        this.bevarageModifierGroup.setLastUpdateTime(this.now);
        session.save((Object)this.bevarageModifierGroup);
        this.mashroom = new MenuModifier("mashroom");
        this.mashroom.setName("Mashroom");
        this.mashroom.setPrice(1.0);
        this.mashroom.setLastUpdateTime(this.now);
        session.save((Object)this.mashroom);
        this.pepparoni = new MenuModifier("pepparoni");
        this.pepparoni.setName("Pepparoni");
        this.pepparoni.setPrice(3.33);
        this.pepparoni.setTaxGroup(this.taxGroupSix01);
        this.pepparoni.setLastUpdateTime(this.now);
        session.save((Object)this.pepparoni);
        this.sausage = new MenuModifier("sausage");
        this.sausage.setName("Sausage");
        this.sausage.setPrice(1.25);
        this.sausage.setLastUpdateTime(this.now);
        session.save((Object)this.sausage);
        this.onionsModifier = new MenuModifier("onion");
        this.onionsModifier.setName("Onions");
        this.onionsModifier.setExtraPrice(2.75);
        this.onionsModifier.setShouldPrintToKitchen(true);
        this.onionsModifier.setPrice(2.0);
        this.onionsModifier.setLastUpdateTime(this.now);
        session.save((Object)this.onionsModifier);
        this.toppingsModifierGroup = new ModifierGroup("toppings");
        this.toppingsModifierGroup.setName("Toppings");
        this.toppingsModifierGroup.addTomodifiers(this.mashroom);
        this.toppingsModifierGroup.addTomodifiers(this.pepparoni);
        this.toppingsModifierGroup.addTomodifiers(this.sausage);
        this.toppingsModifierGroup.addTomodifiers(this.onionsModifier);
        this.toppingsModifierGroup.setLastUpdateTime(this.now);
        session.save((Object)this.toppingsModifierGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createCheeseMenuModifierSpec(MenuItem menuItem) {
        Session session = null;
        Transaction tx = null;
        MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = MenuItemModifierPageItemDAO.getInstance();
        try {
            session = menuItemModifierPageItemDAO.createNewSession();
            tx = session.beginTransaction();
            MenuItemModifierSpec cheeseModifierGroupSpec = new MenuItemModifierSpec();
            cheeseModifierGroupSpec.setModifierGroup(this.cheeseModifierGroup);
            cheeseModifierGroupSpec.setName("Cheese");
            cheeseModifierGroupSpec.setMinQuantity(1);
            cheeseModifierGroupSpec.setMaxQuantity(2);
            cheeseModifierGroupSpec.setSortOrder(0);
            cheeseModifierGroupSpec.setEnable(true);
            cheeseModifierGroupSpec.setJumpGroup(true);
            cheeseModifierGroupSpec.setLastUpdateTime(this.now);
            session.save((Object)cheeseModifierGroupSpec);
            MenuItemModifierPage cheeseModifierSpecPage = new MenuItemModifierPage();
            cheeseModifierSpecPage.setName("Page 1");
            cheeseModifierSpecPage.setButtonHeight(100);
            cheeseModifierSpecPage.setButtonWidth(100);
            cheeseModifierSpecPage.setRows(4);
            cheeseModifierSpecPage.setCols(4);
            cheeseModifierSpecPage.setVisible(true);
            cheeseModifierSpecPage.setSortOrder(1);
            cheeseModifierSpecPage.setFlixibleButtonSize(false);
            cheeseModifierSpecPage.setModifierSpecId(cheeseModifierGroupSpec.getId());
            cheeseModifierSpecPage.setLastUpdateTime(this.now);
            session.save((Object)cheeseModifierSpecPage);
            MenuItemModifierPageItem cheesePageItem = new MenuItemModifierPageItem(0, 0, this.americanCheese, cheeseModifierSpecPage);
            cheesePageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)cheesePageItem);
            cheeseModifierSpecPage.addTopageItems(cheesePageItem);
            MenuItemModifierPageItem goudaPageItem = new MenuItemModifierPageItem(1, 0, this.gouda, cheeseModifierSpecPage);
            goudaPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)goudaPageItem);
            cheeseModifierSpecPage.addTopageItems(goudaPageItem);
            MenuItemModifierPageItem briePageItem = new MenuItemModifierPageItem(2, 0, this.brie, cheeseModifierSpecPage);
            briePageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)briePageItem);
            cheeseModifierSpecPage.addTopageItems(briePageItem);
            MenuItemModifierPageItem cheddarPageItem = new MenuItemModifierPageItem(3, 0, this.chadder, cheeseModifierSpecPage);
            cheddarPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)cheddarPageItem);
            cheeseModifierSpecPage.addTopageItems(cheddarPageItem);
            cheeseModifierGroupSpec.addTomodifierPages(cheeseModifierSpecPage);
            menuItem.addTomenuItemModiferSpecs(cheeseModifierGroupSpec);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            menuItemModifierPageItemDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBeverageMenuModifierSpec(MenuItem menuItem) {
        Session session = null;
        Transaction tx = null;
        MenuItemModifierPageItemDAO menuItemModifierPageItemDAO = MenuItemModifierPageItemDAO.getInstance();
        try {
            session = menuItemModifierPageItemDAO.createNewSession();
            tx = session.beginTransaction();
            MenuItemModifierSpec beverageModifierGroupSpec = new MenuItemModifierSpec();
            beverageModifierGroupSpec.setModifierGroup(this.toppingsModifierGroup);
            beverageModifierGroupSpec.setName("Beverage");
            beverageModifierGroupSpec.setMinQuantity(1);
            beverageModifierGroupSpec.setMaxQuantity(2);
            beverageModifierGroupSpec.setSortOrder(0);
            beverageModifierGroupSpec.setEnable(true);
            beverageModifierGroupSpec.setJumpGroup(true);
            beverageModifierGroupSpec.setLastUpdateTime(this.now);
            session.save((Object)beverageModifierGroupSpec);
            MenuItemModifierPage beverageModifierSpecPage = new MenuItemModifierPage();
            beverageModifierSpecPage.setName("Page 1");
            beverageModifierSpecPage.setButtonHeight(100);
            beverageModifierSpecPage.setButtonWidth(100);
            beverageModifierSpecPage.setRows(4);
            beverageModifierSpecPage.setCols(4);
            beverageModifierSpecPage.setVisible(true);
            beverageModifierSpecPage.setSortOrder(1);
            beverageModifierSpecPage.setFlixibleButtonSize(false);
            beverageModifierSpecPage.setModifierSpecId(beverageModifierGroupSpec.getId());
            beverageModifierSpecPage.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)beverageModifierSpecPage);
            MenuItemModifierPageItem saltPageItem = new MenuItemModifierPageItem(0, 0, this.salt, beverageModifierSpecPage);
            saltPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)saltPageItem);
            beverageModifierSpecPage.addTopageItems(saltPageItem);
            MenuItemModifierPageItem lemonPageItem = new MenuItemModifierPageItem(1, 0, this.lemon, beverageModifierSpecPage);
            lemonPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)lemonPageItem);
            beverageModifierSpecPage.addTopageItems(lemonPageItem);
            beverageModifierGroupSpec.addTomodifierPages(beverageModifierSpecPage);
            menuItem.addTomenuItemModiferSpecs(beverageModifierGroupSpec);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            menuItemModifierPageItemDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createToppingsMenuModifierSpec(MenuItem menuItem) {
        Session session = null;
        Transaction tx = null;
        MenuItemModifierSpecDAO menuItemModifierSpecDAO = MenuItemModifierSpecDAO.getInstance();
        try {
            session = menuItemModifierSpecDAO.createNewSession();
            tx = session.beginTransaction();
            MenuItemModifierSpec toppingsModifierGroupSpec = new MenuItemModifierSpec();
            toppingsModifierGroupSpec.setModifierGroup(this.toppingsModifierGroup);
            toppingsModifierGroupSpec.setName("toppings");
            toppingsModifierGroupSpec.setMinQuantity(1);
            toppingsModifierGroupSpec.setMaxQuantity(2);
            toppingsModifierGroupSpec.setSortOrder(0);
            toppingsModifierGroupSpec.setEnable(true);
            toppingsModifierGroupSpec.setJumpGroup(true);
            toppingsModifierGroupSpec.setLastUpdateTime(this.now);
            session.save((Object)toppingsModifierGroupSpec);
            MenuItemModifierPage toppingsModifierSpecPage = new MenuItemModifierPage();
            toppingsModifierSpecPage.setName("Page 1");
            toppingsModifierSpecPage.setButtonHeight(100);
            toppingsModifierSpecPage.setButtonWidth(100);
            toppingsModifierSpecPage.setRows(4);
            toppingsModifierSpecPage.setCols(4);
            toppingsModifierSpecPage.setVisible(true);
            toppingsModifierSpecPage.setSortOrder(1);
            toppingsModifierSpecPage.setFlixibleButtonSize(false);
            toppingsModifierSpecPage.setModifierSpecId(toppingsModifierGroupSpec.getId());
            toppingsModifierSpecPage.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)toppingsModifierSpecPage);
            MenuItemModifierPageItem mashroomPageItem = new MenuItemModifierPageItem(0, 0, this.mashroom, toppingsModifierSpecPage);
            mashroomPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)mashroomPageItem);
            toppingsModifierSpecPage.addTopageItems(mashroomPageItem);
            MenuItemModifierPageItem pepproniPageItem = new MenuItemModifierPageItem(1, 0, this.pepparoni, toppingsModifierSpecPage);
            pepproniPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)pepproniPageItem);
            toppingsModifierSpecPage.addTopageItems(pepproniPageItem);
            MenuItemModifierPageItem sausagePageItem = new MenuItemModifierPageItem(2, 0, this.sausage, toppingsModifierSpecPage);
            sausagePageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)sausagePageItem);
            toppingsModifierSpecPage.addTopageItems(sausagePageItem);
            MenuItemModifierPageItem onionPageItem = new MenuItemModifierPageItem(3, 0, this.onionsModifier, toppingsModifierSpecPage);
            onionPageItem.setLastUpdateTime(this.now);
            session.saveOrUpdate((Object)onionPageItem);
            toppingsModifierSpecPage.addTopageItems(onionPageItem);
            toppingsModifierGroupSpec.addTomodifierPages(toppingsModifierSpecPage);
            menuItem.addTomenuItemModiferSpecs(toppingsModifierGroupSpec);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            menuItemModifierSpecDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMultipliers() {
        Session session = null;
        Transaction tx = null;
        MultiplierDAO multiplierDAO = MultiplierDAO.getInstance();
        try {
            session = multiplierDAO.createNewSession();
            tx = session.beginTransaction();
            Multiplier regular = new Multiplier("Regular");
            regular.setRate(100.0);
            regular.setTicketPrefix("Regular");
            regular.setDefaultMultiplier(true);
            regular.setSortOrder(1);
            regular.setLastUpdateTime(this.now);
            session.save((Object)regular);
            Multiplier extra = new Multiplier("extra");
            extra.setRate(200.0);
            extra.setTicketPrefix("Extra");
            extra.setSortOrder(2);
            extra.setLastUpdateTime(this.now);
            session.save((Object)extra);
            Multiplier half = new Multiplier("half");
            half.setRate(50.0);
            half.setTicketPrefix("Half");
            half.setSortOrder(3);
            half.setLastUpdateTime(this.now);
            session.save((Object)half);
            Multiplier quarter = new Multiplier("quarter");
            quarter.setRate(25.0);
            quarter.setTicketPrefix("Quarter");
            quarter.setSortOrder(4);
            quarter.setLastUpdateTime(this.now);
            session.save((Object)quarter);
            Multiplier tripple = new Multiplier("tripple");
            tripple.setRate(300.0);
            tripple.setTicketPrefix("Tripple");
            tripple.setSortOrder(5);
            tripple.setLastUpdateTime(this.now);
            session.save((Object)tripple);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            multiplierDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createShifts() {
        Session session = null;
        Transaction tx = null;
        DayPartDAO dayPartDAO = DayPartDAO.getInstance();
        try {
            session = dayPartDAO.createNewSession();
            tx = session.beginTransaction();
            DayPart regularShift = new DayPart();
            regularShift.setId("regular");
            regularShift.setName("Regular");
            Date shiftStartTime = ShiftUtil.buildShiftStartTime(10, 0, 0, 6, 0, 1);
            Date shiftEndTime = ShiftUtil.buildShiftEndTime(10, 0, 0, 6, 0, 1);
            regularShift.setStartTime(shiftStartTime);
            regularShift.setEndTime(shiftEndTime);
            long length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
            regularShift.setShiftLength(length);
            regularShift.setLastUpdateTime(this.now);
            session.save((Object)regularShift);
            DayPart eveningShift = new DayPart();
            eveningShift.setId("evening");
            eveningShift.setName("Evening");
            shiftStartTime = ShiftUtil.buildShiftStartTime(6, 0, 1, 2, 0, 0);
            shiftEndTime = ShiftUtil.buildShiftEndTime(6, 0, 1, 2, 0, 0);
            eveningShift.setStartTime(shiftStartTime);
            eveningShift.setEndTime(shiftEndTime);
            length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
            eveningShift.setShiftLength(length);
            eveningShift.setLastUpdateTime(this.now);
            session.save((Object)eveningShift);
            DayPart nightShift = new DayPart();
            nightShift.setId("night");
            nightShift.setName("Night");
            shiftStartTime = ShiftUtil.buildShiftStartTime(2, 0, 0, 10, 0, 0);
            shiftEndTime = ShiftUtil.buildShiftEndTime(2, 0, 0, 10, 0, 0);
            nightShift.setStartTime(shiftStartTime);
            nightShift.setEndTime(shiftEndTime);
            length = Math.abs(shiftStartTime.getTime() - shiftEndTime.getTime());
            nightShift.setShiftLength(length);
            nightShift.setLastUpdateTime(this.now);
            session.save((Object)nightShift);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            dayPartDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAttributes() {
        Session session = null;
        Transaction tx = null;
        AttributeGroupDAO attributeGroupDAO = AttributeGroupDAO.getInstance();
        try {
            session = attributeGroupDAO.createNewSession();
            tx = session.beginTransaction();
            AttributeGroup sizeGroup = new AttributeGroup("size");
            sizeGroup.setName("Size");
            sizeGroup.setLastUpdateTime(this.now);
            session.save((Object)sizeGroup);
            this.smallSize = new Attribute("small");
            this.smallSize.setName("Small");
            this.smallSize.setSortOrder(0);
            this.smallSize.setGroup(sizeGroup);
            this.smallSize.setLastUpdateTime(this.now);
            session.save((Object)this.smallSize);
            this.mediumSize = new Attribute("medium");
            this.mediumSize.setName("Medium");
            this.mediumSize.setSortOrder(1);
            this.mediumSize.setGroup(sizeGroup);
            this.mediumSize.setLastUpdateTime(this.now);
            session.save((Object)this.mediumSize);
            this.largeSize = new Attribute("large");
            this.largeSize.setName("Large");
            this.largeSize.setSortOrder(2);
            this.largeSize.setGroup(sizeGroup);
            this.largeSize.setLastUpdateTime(this.now);
            session.save((Object)this.largeSize);
            AttributeGroup crustGroup = new AttributeGroup();
            crustGroup.setName("Crust");
            crustGroup.setLastUpdateTime(this.now);
            session.save((Object)crustGroup);
            Attribute pan = new Attribute("pan");
            pan.setName("Pan");
            pan.setSortOrder(0);
            pan.setLastUpdateTime(this.now);
            pan.setGroup(crustGroup);
            session.save((Object)pan);
            Attribute handTossed = new Attribute("hand_tossed");
            handTossed.setName("Hand tossed");
            handTossed.setSortOrder(1);
            handTossed.setLastUpdateTime(this.now);
            handTossed.setGroup(crustGroup);
            session.save((Object)handTossed);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            attributeGroupDAO.closeSession(session);
        }
    }

    private void doCreateVariantForCoke(MenuItem item, Session session) {
        MenuItem largeItem = new MenuItem();
        largeItem.setId("large-" + item.getId());
        largeItem.setName("Large " + item.getName());
        largeItem.setParentMenuItemId(item.getId());
        largeItem.setMenuGroupId(item.getMenuGroupId());
        largeItem.setMenuCategoryId(item.getMenuCategoryId());
        largeItem.setUnit(item.getUnit());
        largeItem.setVariant(true);
        largeItem.setPrice(4.89);
        largeItem.setShouldPrintToKitchen(false);
        largeItem.setInventoryItem(item.isInventoryItem());
        largeItem.setAttributes(Arrays.asList(this.largeSize));
        largeItem.setLastUpdateTime(this.now);
        session.save((Object)largeItem);
        MenuItem mediumItem = new MenuItem();
        mediumItem.setId("medium-" + item.getId());
        mediumItem.setName("Medium " + item.getName());
        mediumItem.setParentMenuItemId(item.getId());
        mediumItem.setMenuGroupId(item.getMenuGroupId());
        mediumItem.setMenuCategoryId(item.getMenuCategoryId());
        mediumItem.setUnit(item.getUnit());
        mediumItem.setVariant(true);
        mediumItem.setPrice(2.97);
        mediumItem.setShouldPrintToKitchen(false);
        mediumItem.setInventoryItem(item.isInventoryItem());
        mediumItem.setAttributes(Arrays.asList(this.mediumSize));
        mediumItem.setLastUpdateTime(this.now);
        session.save((Object)mediumItem);
        MenuItem smallItem = new MenuItem();
        smallItem.setId("small-" + item.getId());
        smallItem.setName("Small " + item.getName());
        smallItem.setParentMenuItemId(item.getId());
        smallItem.setMenuGroupId(item.getMenuGroupId());
        smallItem.setMenuCategoryId(item.getMenuCategoryId());
        smallItem.setUnit(item.getUnit());
        smallItem.setVariant(true);
        smallItem.setPrice(1.32);
        smallItem.setShouldPrintToKitchen(false);
        smallItem.setInventoryItem(item.isInventoryItem());
        smallItem.setAttributes(Arrays.asList(this.smallSize));
        smallItem.setLastUpdateTime(this.now);
        session.save((Object)smallItem);
    }

    private void doCreateVariantForPepsi(MenuItem item, Session session) {
        MenuItem largeItem = new MenuItem();
        largeItem.setId("large-" + item.getId());
        largeItem.setName("Large " + item.getName());
        largeItem.setParentMenuItemId(item.getId());
        largeItem.setMenuGroupId(item.getMenuGroupId());
        largeItem.setMenuCategoryId(item.getMenuCategoryId());
        largeItem.setUnit(item.getUnit());
        largeItem.setVariant(true);
        largeItem.setPrice(2.33);
        largeItem.setInventoryItem(item.isInventoryItem());
        largeItem.setAttributes(Arrays.asList(this.largeSize));
        largeItem.setShouldPrintToKitchen(false);
        largeItem.setLastUpdateTime(this.now);
        session.save((Object)largeItem);
        MenuItem mediumItem = new MenuItem();
        mediumItem.setId("medium-" + item.getId());
        mediumItem.setName("Medium " + item.getName());
        mediumItem.setParentMenuItemId(item.getId());
        mediumItem.setMenuGroupId(item.getMenuGroupId());
        mediumItem.setMenuCategoryId(item.getMenuCategoryId());
        mediumItem.setUnit(item.getUnit());
        mediumItem.setVariant(true);
        mediumItem.setPrice(1.67);
        mediumItem.setShouldPrintToKitchen(false);
        mediumItem.setInventoryItem(item.isInventoryItem());
        mediumItem.setAttributes(Arrays.asList(this.mediumSize));
        mediumItem.setLastUpdateTime(this.now);
        session.save((Object)mediumItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createInventoryData() {
        Session session = null;
        Transaction tx = null;
        InventoryUnitDAO inventoryUnitDAO = InventoryUnitDAO.getInstance();
        try {
            session = inventoryUnitDAO.createNewSession();
            tx = session.beginTransaction();
            InventoryUnitGroup group = new InventoryUnitGroup("measurement");
            group.setName("Measurement");
            group.setLastUpdateTime(this.now);
            session.save((Object)group);
            this.unitPiece = new InventoryUnit("each");
            this.unitPiece.setBaseUnit(true);
            this.unitPiece.setCode("ea");
            this.unitPiece.setName("Each");
            this.unitPiece.setConversionRate(1.0);
            this.unitPiece.setUnitGroupId(group.getId());
            this.unitPiece.setLastUpdateTime(this.now);
            session.save((Object)this.unitPiece);
            InventoryUnitGroup weight = new InventoryUnitGroup("weight");
            weight.setName("Weight");
            weight.setLastUpdateTime(this.now);
            session.save((Object)weight);
            this.unitGram = new InventoryUnit("gram");
            this.unitGram.setCode("g");
            this.unitGram.setName("gram");
            this.unitGram.setConversionRate(1000.0);
            this.unitGram.setUnitGroupId(weight.getId());
            this.unitGram.setLastUpdateTime(this.now);
            session.save((Object)this.unitGram);
            this.unitKg = new InventoryUnit("kilogram");
            this.unitKg.setBaseUnit(true);
            this.unitKg.setCode("kg");
            this.unitKg.setName("Kilo gram");
            this.unitKg.setConversionRate(1.0);
            this.unitKg.setUnitGroupId(weight.getId());
            this.unitKg.setLastUpdateTime(this.now);
            session.save((Object)this.unitKg);
            this.unitTon = new InventoryUnit("ton");
            this.unitTon.setBaseUnit(true);
            this.unitTon.setCode("ton");
            this.unitTon.setName("Ton");
            this.unitTon.setConversionRate(1.0);
            this.unitTon.setUnitGroupId(weight.getId());
            this.unitTon.setLastUpdateTime(this.now);
            session.save((Object)this.unitTon);
            PackagingUnit packagingUnit = new PackagingUnit("box");
            packagingUnit.setCode("box");
            packagingUnit.setName("Box");
            packagingUnit.setLastUpdateTime(this.now);
            session.save((Object)packagingUnit);
            packagingUnit = new PackagingUnit("cartoon");
            packagingUnit.setCode("cartoon");
            packagingUnit.setName("Cartoon");
            packagingUnit.setLastUpdateTime(this.now);
            session.save((Object)packagingUnit);
            InventoryLocation location = new InventoryLocation("store");
            location.setName("Store");
            location.setDefaultInLocation(true);
            location.setDefaultOutLocation(true);
            location.setSortOrder(0);
            location.setVisible(true);
            location.setRoot(true);
            location.setLastUpdateTime(this.now);
            session.save((Object)location);
            InventoryVendor vendor = new InventoryVendor("cash");
            vendor.setName("Cash");
            vendor.setVisible(true);
            vendor.setLastUpdateTime(this.now);
            session.save((Object)vendor);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            inventoryUnitDAO.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDefaultFloor() {
        Session session = null;
        Transaction tx = null;
        ShopTableDAO shopTableDAO = ShopTableDAO.getInstance();
        try {
            session = shopTableDAO.createNewSession();
            tx = session.beginTransaction();
            ShopFloor floor = new ShopFloor("mainfloor");
            floor.setName("Main Floor");
            List<ShopTable> tableList = ShopTableDAO.getInstance().findAll();
            HashSet<ShopTable> shopTables = new HashSet<ShopTable>();
            if (tableList != null && !tableList.isEmpty()) {
                for (int i = 0; i < tableList.size(); ++i) {
                    ShopTable shopTable = tableList.get(i);
                    shopTable.setX(this.getPositionX().get(i));
                    shopTable.setY(this.getPositionY().get(i));
                    shopTable.setLastUpdateTime(this.now);
                    session.saveOrUpdate((Object)shopTable);
                    shopTables.add(shopTable);
                    if (i != 13) {
                        continue;
                    }
                    break;
                }
            } else {
                for (int i = 0; i < this.getPositionX().size(); ++i) {
                    ShopTable shopTable = new ShopTable(floor, this.getPositionX().get(i), this.getPositionY().get(i), i + 1);
                    shopTable.setLastUpdateTime(this.now);
                    ShopTableStatus shopTableStatus = new ShopTableStatus();
                    Integer tableId = shopTable.getId();
                    shopTableStatus.setId(tableId);
                    shopTableStatus.setTableStatus(TableStatus.Available);
                    shopTableStatus.setLastUpdateTime(this.now);
                    session.save((Object)shopTableStatus);
                    shopTable.setShopTableStatus(shopTableStatus);
                    shopTables.add(shopTable);
                }
            }
            floor.setTables(shopTables);
            floor.setLastUpdateTime(this.now);
            session.save((Object)floor);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            shopTableDAO.closeSession(session);
        }
    }

    private List<Integer> getPositionX() {
        ArrayList<Integer> positionX = new ArrayList<Integer>();
        positionX.add(19);
        positionX.add(161);
        positionX.add(309);
        positionX.add(17);
        positionX.add(162);
        positionX.add(318);
        positionX.add(18);
        positionX.add(161);
        positionX.add(330);
        positionX.add(22);
        positionX.add(169);
        positionX.add(329);
        positionX.add(487);
        positionX.add(661);
        return positionX;
    }

    private List<Integer> getPositionY() {
        ArrayList<Integer> positionY = new ArrayList<Integer>();
        positionY.add(12);
        positionY.add(12);
        positionY.add(14);
        positionY.add(132);
        positionY.add(136);
        positionY.add(140);
        positionY.add(258);
        positionY.add(258);
        positionY.add(260);
        positionY.add(382);
        positionY.add(381);
        positionY.add(387);
        positionY.add(391);
        positionY.add(390);
        return positionY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createManagerUser(UserType manager, UserType cashier, UserType server) {
        Session session = null;
        Transaction tx = null;
        UserDAO userDAO = UserDAO.getInstance();
        try {
            session = userDAO.createNewSession();
            tx = session.beginTransaction();
            User managerUser = new User();
            managerUser.setId("124");
            managerUser.setEncryptedPassword("2222");
            managerUser.setFirstName("Manager");
            managerUser.setLastName("M");
            managerUser.setType(manager);
            managerUser.setRoot(true);
            managerUser.setActive(true);
            managerUser.setStaffBank(true);
            managerUser.setLastUpdateTime(this.now);
            User cashierUser = new User();
            cashierUser.setId("981");
            cashierUser.setFirstName("Manager");
            cashierUser.setLastName("M");
            cashierUser.setType(cashier);
            cashierUser.setParentUser(managerUser);
            cashierUser.setActive(true);
            cashierUser.setStaffBank(true);
            cashierUser.setLastUpdateTime(this.now);
            User serverUser = new User();
            serverUser.setId("890");
            serverUser.setFirstName("Manager");
            serverUser.setLastName("M");
            serverUser.setType(server);
            serverUser.setParentUser(managerUser);
            serverUser.setActive(true);
            serverUser.setStaffBank(true);
            serverUser.setAutoStartStaffBank(true);
            serverUser.setLastUpdateTime(this.now);
            session.save((Object)managerUser);
            session.save((Object)cashierUser);
            session.save((Object)serverUser);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
                PosLog.error(this.getClass(), e);
            }
        }
        finally {
            userDAO.closeSession(session);
        }
    }
}

