/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.POSUtil;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;

public class MailTemplateUtil {
    public static String getTemplate(Store store, String propertyName) {
        String property = POSUtil.readLongProperty(store.getProperties(), propertyName);
        if (StringUtils.isBlank((String)property)) {
            property = "Ticket Receipt";
        }
        return property;
    }

    public static String process(String templateText, HashMap<String, Object> params) throws ParseException {
        int indexOf = templateText.indexOf("$!storeLogo");
        if (indexOf >= 0) {
            Image image = (Image)params.get("storeLogoIcon");
            if (image == null) {
                DataProvider.get().refreshStore();
                Store store = DataProvider.get().getStore();
                ImageIcon storeLogo = store.getStoreLogo();
                if (storeLogo != null) {
                    image = store.getStoreLogo().getImage();
                }
            }
            if (image != null) {
                String imageTag = "<img src='data:image/png;base64, " + MailTemplateUtil.convertImageToBase64String(image) + "' alt='img_alt' width='" + image.getWidth(null) + "' height='" + image.getHeight(null) + "' />";
                templateText = templateText.replaceAll(Pattern.quote("$!storeLogo"), Matcher.quoteReplacement(imageTag));
            }
        }
        VelocityContext vc = new VelocityContext();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            vc.put(entry.getKey(), entry.getValue());
        }
        StringWriter sw = new StringWriter();
        RuntimeServices runtimeServices = RuntimeSingleton.getRuntimeServices();
        StringReader reader = new StringReader(templateText);
        Template template = new Template();
        template.setRuntimeServices(runtimeServices);
        template.setData((Object)runtimeServices.parse((Reader)reader, "Template name"));
        template.initDocument();
        template.merge((Context)vc, (Writer)sw);
        return sw.toString();
    }

    private static String convertImageToBase64String(Image img) {
        BufferedImage image = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D g = image.createGraphics();
        g.drawImage(img, 0, 0, null);
        g.dispose();
        ByteArrayOutputStream b = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", b);
        }
        catch (Exception ex) {
            PosLog.error(MailTemplateUtil.class, ex.getMessage(), ex);
        }
        byte[] imageInByte = b.toByteArray();
        return Base64.encodeBase64String((byte[])imageInByte);
    }
}

