/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.GenericDAO;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerator;

public class NameBaseIdGenerator
implements IdentifierGenerator {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable generate(SessionImplementor sessionIm, Object object) throws HibernateException {
        Class<?> clazz = object.getClass();
        try {
            Object id;
            Method method = clazz.getMethod("getId", null);
            if (method != null && (id = method.invoke(object, (Object[])null)) != null) {
                return (Serializable)id;
            }
            method = clazz.getMethod("getName", null);
            if (method == null) {
                throw new HibernateException(clazz.getName() + Messages.getString("NameBaseIdGenerator.2"));
            }
            String name = (String)method.invoke(object, (Object[])null);
            if (name == null) {
                throw new HibernateException(Messages.getString("NameBaseIdGenerator.3") + clazz.getName());
            }
            try (Session session = GenericDAO.getInstance().createNewSession();){
                String string = NameBaseIdGenerator.generateId(name, clazz, 0, session);
                return string;
            }
        }
        catch (Exception e) {
            throw new HibernateException((Throwable)e);
        }
    }

    public static String generateId(String name, Class<? extends Object> clazz, int count, Session session) {
        Object object;
        Class<? extends Object> superclass;
        String id = String.valueOf(Math.abs(name.hashCode()));
        if (count > 0) {
            id = id + "_" + count;
        }
        if ((superclass = clazz.getSuperclass().getSuperclass()) == Shift.class) {
            clazz = Shift.class;
        }
        if ((object = session.get(clazz, (Serializable)((Object)id))) == null) {
            return id;
        }
        return NameBaseIdGenerator.generateId(name, clazz, ++count, session);
    }

    public static String generateId(String name) {
        return String.valueOf(Math.abs(name.hashCode()));
    }
}

