/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.kitchendisplay.LineDisplayWindow;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.imageio.ImageIO;
import javax.sql.rowset.serial.SerialBlob;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import org.apache.commons.lang.StringUtils;

public class POSUtil {
    public static Window getFocusedWindow() {
        Window focusedWindow = FocusManager.getCurrentManager().getFocusedWindow();
        return POSUtil.getShowingWindow(focusedWindow);
    }

    private static Window getShowingWindow(Window window) {
        if (window == null) {
            return window;
        }
        if (window.isShowing()) {
            return window;
        }
        Container parent = window.getParent();
        if (parent instanceof Window) {
            return POSUtil.getShowingWindow((Window)parent);
        }
        return window;
    }

    public static Image getScaledImage(Image srcImg, int w, int h) {
        BufferedImage resizedImg = new BufferedImage(w, h, 2);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(srcImg, 0, 0, w, h, null);
        g2.dispose();
        return resizedImg;
    }

    public static BufferedImage convertBlackAndWhiteImage(Image orginalImage) {
        int width = orginalImage.getWidth(null);
        int height = orginalImage.getHeight(null);
        BufferedImage resizedImg = new BufferedImage(width, height, 1);
        Graphics2D g2 = resizedImg.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.drawImage(orginalImage, 0, 0, Color.WHITE, null);
        g2.dispose();
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                Color c = new Color(resizedImg.getRGB(j, i));
                int red = (int)((double)c.getRed() * 0.299);
                int green = (int)((double)c.getGreen() * 0.587);
                int blue = (int)((double)c.getBlue() * 0.114);
                Color newColor = new Color(red + green + blue, red + green + blue, red + green + blue);
                resizedImg.setRGB(j, i, newColor.getRGB());
            }
        }
        return resizedImg;
    }

    public static ImageIcon convertToButtonImage(ImageIcon imageIcon) {
        return POSUtil.scaleImage(imageIcon, 80);
    }

    public static ImageIcon convertToBigButtonImage(ImageIcon image) {
        return POSUtil.scaleImage(image, 200);
    }

    public static ImageIcon scaleImage(ImageIcon image, int maxSize) {
        if (image == null) {
            return null;
        }
        int iconHeight = image.getIconHeight();
        int iconWidth = image.getIconWidth();
        if (iconWidth > iconHeight) {
            int width = maxSize;
            int height = iconHeight * width / iconWidth;
            Image scaledImage = image.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), 4);
            return new ImageIcon(scaledImage);
        }
        int height = maxSize;
        int width = iconWidth * height / iconHeight;
        Image scaledImage = image.getImage().getScaledInstance(PosUIManager.getSize(width), PosUIManager.getSize(height), 4);
        return new ImageIcon(scaledImage);
    }

    public static BackOfficeWindow getBackOfficeWindow() {
        return BackOfficeWindow.getInstance();
    }

    public static LineDisplayWindow getLineDisplayWindow() {
        Window[] windows;
        for (Window window : windows = Window.getWindows()) {
            if (!(window instanceof LineDisplayWindow)) continue;
            return (LineDisplayWindow)window;
        }
        return null;
    }

    public static boolean isBlankOrNull(String str) {
        if (str == null) {
            return true;
        }
        return str.trim().equals("");
    }

    public static String escapePropertyKey(String propertyKey) {
        return propertyKey.replaceAll("\\s+", "_");
    }

    public static boolean getBoolean(String b) {
        if (b == null) {
            return false;
        }
        return Boolean.valueOf(b);
    }

    public static boolean getBoolean(Boolean b) {
        if (b == null) {
            return false;
        }
        return b;
    }

    public static boolean getBoolean(Boolean b, boolean defaultValue) {
        if (b == null) {
            return defaultValue;
        }
        return b;
    }

    public static double getDouble(Double d) {
        if (d == null) {
            return 0.0;
        }
        return d;
    }

    public static Integer getInteger(Object result) {
        if (result != null && result instanceof Number) {
            return ((Number)result).intValue();
        }
        return 0;
    }

    public static double getDoubleAmount(Object result) {
        if (result != null && result instanceof Number) {
            return ((Number)result).doubleValue();
        }
        return 0.0;
    }

    public static double getRoundedDouble(Object result) {
        if (result != null && result instanceof Number) {
            return NumberUtil.round(((Number)result).doubleValue());
        }
        return 0.0;
    }

    public static int getInteger(Integer d) {
        if (d == null) {
            return 0;
        }
        return d;
    }

    public static int parseInteger(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            return 0;
        }
    }

    public static int parseInteger(String s, String parseErrorMessage) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception x) {
            throw new PosException(parseErrorMessage);
        }
    }

    public static double parseDouble(String s) {
        return NumberUtil.parseOrGetZero(s).doubleValue();
    }

    public static double parseDouble(String s, String parseErrorMessage, boolean mandatory) {
        if (mandatory && StringUtils.isBlank((String)s)) {
            throw new PosException(Messages.getString("POSUtil.1"));
        }
        try {
            return NumberUtil.parse(s).doubleValue();
        }
        catch (Exception x) {
            if (mandatory) {
                throw new PosException(parseErrorMessage);
            }
            return 0.0;
        }
    }

    public static String encodeURLString(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (Exception x) {
            return s;
        }
    }

    public static boolean isValidPassword(char[] password) {
        for (char c : password) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkDrawerAssignment() {
        Terminal terminal = Application.getInstance().getTerminal();
        User currentUser = Application.getCurrentUser();
        return POSUtil.checkDrawerAssignment(terminal, currentUser);
    }

    public static boolean checkDrawerAssignment(Terminal terminal, User user) {
        if (TerminalDAO.getInstance().isDrawerAssigned(terminal)) {
            return true;
        }
        if (user.isStaffBank().booleanValue() && user.isStaffBankStarted().booleanValue()) {
            return true;
        }
        POSUtil.showUnableToAcceptPayment();
        return false;
    }

    private static void showUnableToAcceptPayment() {
        POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SwitchboardView.18"));
    }

    public static Blob convertImageToBlob(File imageFile, int targetSize) throws Exception {
        int type;
        int iconHeight;
        if (imageFile == null) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(imageFile);
        int iconWidth = bufferedImage.getWidth();
        if (iconWidth > (iconHeight = bufferedImage.getHeight())) {
            int width = targetSize;
            int height = iconHeight * width / iconWidth;
            type = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, width, height, type);
        } else {
            int height = targetSize;
            int width = iconWidth * height / iconHeight;
            type = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, width, height, type);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        String imageName = imageFile.getName();
        int lastIndexOfImage = imageName.lastIndexOf(".");
        String imageExtension = imageName.substring(lastIndexOfImage + 1);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        }
        byte[] byteArray = outputStream.toByteArray();
        outputStream.close();
        if (byteArray.length > 0x3200000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byteArray);
    }

    @Deprecated
    public static Blob convertImageToBlob(File imageFile) throws Exception {
        int lastIndexOfImage;
        if (imageFile == null) {
            return null;
        }
        BufferedImage bufferedImage = ImageIO.read(imageFile);
        if (bufferedImage.getWidth() > 400 || bufferedImage.getHeight() > 400) {
            int type = bufferedImage.getType() == 0 ? 2 : bufferedImage.getType();
            bufferedImage = POSUtil.resizeImage(bufferedImage, 400, 400, type);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        String imageName = imageFile.getName();
        String imageExtension = imageName.substring((lastIndexOfImage = imageName.lastIndexOf(".")) + 1);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        }
        byte[] byteArray = outputStream.toByteArray();
        if (byteArray.length > 500000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byteArray);
    }

    public static Blob convertImageToBlob(BufferedImage bufferedImage, String imageExtension) throws Exception {
        if (bufferedImage == null) {
            return null;
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)bufferedImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)bufferedImage, "gif", outputStream);
        }
        byte[] byteArray = outputStream.toByteArray();
        if (byteArray.length > 500000) {
            throw new RuntimeException(Messages.getString("POSUtil.0"));
        }
        return new SerialBlob(byteArray);
    }

    public static Blob convertScaledImageToBlob(File imageFile) throws Exception {
        int lastIndexOfImage;
        if (imageFile == null) {
            return null;
        }
        int width = 120;
        int height = 120;
        BufferedImage originalImage = ImageIO.read(imageFile);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(50000);
        int type = originalImage.getType() == 0 ? 2 : originalImage.getType();
        BufferedImage resizeImage = POSUtil.resizeImage(originalImage, width, height, type);
        String imageName = imageFile.getName();
        String imageExtension = imageName.substring((lastIndexOfImage = imageName.lastIndexOf(".")) + 1);
        if (imageExtension.equals("jpg")) {
            ImageIO.write((RenderedImage)resizeImage, "jpg", outputStream);
        } else if (imageExtension.equals("jpeg")) {
            ImageIO.write((RenderedImage)resizeImage, "jpeg", outputStream);
        } else if (imageExtension.equals("png")) {
            ImageIO.write((RenderedImage)resizeImage, "png", outputStream);
        } else {
            ImageIO.write((RenderedImage)resizeImage, "gif", outputStream);
        }
        return new SerialBlob(outputStream.toByteArray());
    }

    private static BufferedImage resizeImage(BufferedImage originalImage, int IMG_WIDTH, int IMG_HEIGHT, int type) {
        BufferedImage resizedImage = new BufferedImage(IMG_WIDTH, IMG_HEIGHT, type);
        Graphics2D g = resizedImage.createGraphics();
        g.drawImage(originalImage, 0, 0, IMG_WIDTH, IMG_HEIGHT, null);
        g.dispose();
        return resizedImage;
    }

    public static User getUserWithPermission(UserPermission requiredPermission) {
        String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("PosAction.0"));
        if (StringUtils.isEmpty((String)password)) {
            return null;
        }
        User user = UserDAO.getInstance().findUserBySecretKey(password);
        if (user == null) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.1"));
            return null;
        }
        if (!user.hasPermission(requiredPermission)) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("PosAction.2"));
            return null;
        }
        return user;
    }

    public static void storeLongProperty(Map<String, String> propertyMap, String propertyName, String propertyValue, int length) {
        block4: {
            String nameToStore;
            Set<String> keys = propertyMap.keySet();
            HashSet<String> existingKeys = new HashSet<String>();
            for (String key : keys) {
                if (!key.startsWith(propertyName)) continue;
                existingKeys.add(key);
            }
            for (String string : existingKeys) {
                propertyMap.remove(string);
            }
            if (propertyValue.length() <= length) {
                propertyMap.put(propertyName + "1", propertyValue);
                return;
            }
            int count = 1;
            String valueToStore = "";
            do {
                valueToStore = propertyValue.substring(0, length);
                propertyValue = propertyValue.substring(length);
                nameToStore = propertyName + count++;
                propertyMap.put(nameToStore, valueToStore);
            } while (propertyValue.length() >= length);
            if (!StringUtils.isNotEmpty((String)propertyValue)) break block4;
            nameToStore = propertyName + count++;
            propertyMap.put(nameToStore, propertyValue);
        }
    }

    public static String readLongProperty(Map<String, String> propertyMap, String propertyName) {
        ArrayList<Integer> propertyNumbers = new ArrayList<Integer>();
        StringBuilder stringBuilder = new StringBuilder();
        Set<String> keys = propertyMap.keySet();
        for (String key : keys) {
            if (!key.startsWith(propertyName)) continue;
            String numberString = key.replaceAll(propertyName, "");
            try {
                propertyNumbers.add(Integer.parseInt(numberString));
            }
            catch (Exception exception) {}
        }
        if (propertyNumbers.size() == 0) {
            return null;
        }
        Collections.sort(propertyNumbers);
        for (Integer integer : propertyNumbers) {
            String string = propertyMap.get(propertyName + integer);
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static void removeLongProperty(Map<String, String> propertyMap, String propertyName) {
        Iterator<Map.Entry<String, String>> it = propertyMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getKey().startsWith(propertyName)) continue;
            it.remove();
        }
    }

    public static Set copySelectedValues(Set toCollection, Set selectedValues) {
        if (toCollection == null) {
            toCollection = new LinkedHashSet();
            toCollection.addAll(selectedValues);
            return toCollection;
        }
        Iterator iterator = toCollection.iterator();
        while (iterator.hasNext()) {
            Object existingValue = iterator.next();
            if (selectedValues.contains(existingValue)) continue;
            iterator.remove();
        }
        toCollection.addAll(selectedValues);
        return toCollection;
    }

    public static List copySelectedValues(List toCollection, List selectedValues) {
        if (toCollection == null) {
            toCollection = new ArrayList();
            toCollection.addAll(selectedValues);
            return toCollection;
        }
        Iterator iterator = toCollection.iterator();
        while (iterator.hasNext()) {
            Object existingValue = iterator.next();
            if (selectedValues.contains(existingValue)) continue;
            iterator.remove();
        }
        toCollection.addAll(selectedValues);
        return toCollection;
    }

    public static List copySelectedValuesWithoutDuplicate(List toCollection, List selectedValues) {
        if (toCollection == null) {
            toCollection = new ArrayList();
            toCollection.addAll(selectedValues);
            return toCollection;
        }
        toCollection.clear();
        toCollection.addAll(selectedValues);
        return toCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] compress(String data) throws IOException {
        try (ByteArrayOutputStream bos = null;){
            bos = new ByteArrayOutputStream(data.length());
            GZIPOutputStream gzip = new GZIPOutputStream(bos);
            gzip.write(data.getBytes("UTF-8"));
            gzip.close();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decompress(byte[] compressed) throws IOException {
        ByteArrayInputStream bis = null;
        GZIPInputStream gis = null;
        BufferedReader br = null;
        try {
            String line;
            bis = new ByteArrayInputStream(compressed);
            gis = new GZIPInputStream(bis);
            br = new BufferedReader(new InputStreamReader((InputStream)gis, "UTF-8"));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            if (br != null) {
                br.close();
            }
            if (gis != null) {
                gis.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }

    public static boolean isWindowsOs() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.indexOf("win") >= 0;
    }

    public static void openURLToBrowser(String url) {
        try {
            Desktop desktop;
            Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
            if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
                desktop.browse(new URI(url));
            }
        }
        catch (Exception e0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e0.getMessage(), e0);
        }
    }

    public static boolean isAllowLocalItem() {
        String allowLocalItemProperty = System.getProperty("allowLocalItem");
        if (StringUtils.isEmpty((String)allowLocalItemProperty)) {
            return true;
        }
        return Boolean.valueOf(allowLocalItemProperty);
    }

    public static String toFormattedString(List<?> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        String string = list.toString();
        return string.substring(1, string.length() - 1);
    }

    public static int getIntegerOrZero(String property) {
        try {
            return Integer.parseInt(property);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static boolean validatePhoneNo(String mobileNumber) {
        if (StringUtils.isBlank((String)mobileNumber)) {
            return false;
        }
        String regex = "^[+]?(?:[0-9] ?){3,14}[0-9]$";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(mobileNumber);
        return matcher.matches();
    }

    public static List<String> getStringIds(List<? extends Object> list, Class<?> clazz) {
        ArrayList<String> idList = new ArrayList<String>();
        if (list != null) {
            try {
                for (Object object : list) {
                    Object id;
                    Method method = clazz.getMethod("getId", null);
                    if (method == null || (id = method.invoke(object, (Object[])null)) == null) continue;
                    idList.add((String)id);
                }
            }
            catch (Exception e) {
                PosLog.error(POSUtil.class, e);
            }
        }
        return idList;
    }

    public static List<Integer> getIntegerIds(List<? extends Object> list, Class<?> clazz) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        if (list != null) {
            try {
                for (Object object : list) {
                    Object id;
                    Method method = clazz.getMethod("getId", null);
                    if (method == null || (id = method.invoke(object, (Object[])null)) == null) continue;
                    idList.add((Integer)id);
                }
            }
            catch (Exception e) {
                PosLog.error(POSUtil.class, e);
            }
        }
        return idList;
    }

    public static String createNameString(List<? extends Object> list, Class<?> clazz) {
        return POSUtil.createStringByField(list, clazz, null);
    }

    public static String createStringByField(List<? extends Object> list, Class<?> clazz, String fieldName) {
        return POSUtil.createStringByField(list, clazz, fieldName, Boolean.FALSE);
    }

    public static String createStringByField(List<? extends Object> list, Class<?> clazz, String fieldName, boolean includeQuotes) {
        if (list == null || list.isEmpty()) {
            return POSConstants.ALL;
        }
        String orderTypeNames = "";
        try {
            Iterator<? extends Object> iterator = list.iterator();
            while (iterator.hasNext()) {
                Object name;
                Object model = iterator.next();
                Method method = clazz.getMethod(fieldName == null ? "getName" : fieldName, null);
                if (method != null && (name = method.invoke(model, (Object[])null)) != null) {
                    orderTypeNames = includeQuotes ? orderTypeNames + "'" + (String)name + "'" : orderTypeNames + (String)name;
                }
                if (!iterator.hasNext()) continue;
                orderTypeNames = orderTypeNames + ", ";
            }
        }
        catch (Exception e) {
            PosLog.error(POSUtil.class, e);
        }
        return orderTypeNames;
    }

    public static String doDuplicateName(String existingName) {
        String newName = new String();
        int lastIndexOf = existingName.lastIndexOf(" ");
        if (lastIndexOf == -1) {
            newName = existingName + " 1";
        } else {
            String itemCountProcessName = existingName.substring(lastIndexOf + 1, existingName.length()).trim();
            if (!StringUtils.isEmpty((String)itemCountProcessName) && StringUtils.isNumeric((String)itemCountProcessName)) {
                Integer count = Integer.valueOf(itemCountProcessName);
                count = count + 1;
                newName = existingName.replace(itemCountProcessName, String.valueOf(count));
            } else {
                newName = existingName.trim() + " 1";
            }
        }
        return newName;
    }

    public static String[] getStringArray(List<String> arr) {
        String[] str = new String[arr.size()];
        for (int j = 0; j < arr.size(); ++j) {
            str[j] = arr.get(j);
        }
        return str;
    }

    public static boolean isNullOrEmpty(Collection collection) {
        if (collection == null) {
            return true;
        }
        return collection.isEmpty();
    }
}

