/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.CreditBook;
import com.floreantpos.model.CreditBookType;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.MemberType;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.CreditBookDAO;
import com.floreantpos.model.dao.CreditBookTypeDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.ImageUploaderDialog;
import com.floreantpos.util.JsonUtil;
import com.floreantpos.util.NumberUtil;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncView;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class MemberSyncable
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;

    @Override
    public void doSync() throws Exception {
        if (this.syncView == null) {
            return;
        }
        String sfMemberSyncTime = this.getSFMemberSyncTime();
        JsonArray creditBookTypes = SFUtil.getCreditBookTypes();
        JsonArray members = SFUtil.getMembers(sfMemberSyncTime);
        JsonArray creditBooks = SFUtil.getCreditBooks();
        Date syncedTime = new Date();
        int maxSize = (creditBookTypes != null ? creditBookTypes.size() : 0) + (members != null ? members.size() : 0);
        if (maxSize == 0) {
            return;
        }
        this.syncView.setProgressMaximum(maxSize);
        this.count = 0;
        this.doSyncAll(creditBookTypes, members, creditBooks, syncedTime);
    }

    private void doSyncAll(JsonArray creditBookTypes, JsonArray members, JsonArray creditBooks, Date syncedTime) throws Exception {
        this.doSyncCreditBookTypes(creditBookTypes);
        if (members == null) {
            this.syncView.setCanceled(false);
            return;
        }
        this.doSyncMembers(members);
        this.doSyncCreditBook(creditBooks);
        this.doUpdateSyncTime(syncedTime);
    }

    private void doUpdateSyncTime(Date syncDate) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("salesforce.memberSyncTime", SFDateUtil.formatDateAsSFFormat(syncDate));
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doSyncMembers(JsonArray members) throws Exception {
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            this.syncView.checkCancelStatus();
            JsonObject itemObject = (JsonObject)iterator.next();
            MemberSyncable.extractAndSaveMember(itemObject);
            this.syncView.setProgressValue(++this.count);
        }
    }

    public static void extractAndSaveMember(JsonObject itemObject) throws Exception {
        String memberTypeName = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"recordTypeName"));
        MemberType memberType = MemberType.fromName(memberTypeName);
        if (memberType == MemberType.Prospect) {
            return;
        }
        String id = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"Id"));
        String memberId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"customerId"));
        String firstName = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"firstName"));
        String lastName = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"lastName"));
        String salutation = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"salutation"));
        String birthdate = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"birthDate"));
        String phone = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"phone"));
        String homePhone = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"homePhone"));
        String email = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"email"));
        String balance = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"accountBalance"));
        String lastUpdateDate = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"lastModifiedDate"));
        String status = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"status"));
        boolean active = "Active".equalsIgnoreCase(status);
        Boolean taxExempt = JsonUtil.getBoolean(itemObject, "taxExempt");
        String taxExemptNo = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"taxExemptNumber"));
        String ftPhotoUrl = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"ftPhotoUrl"));
        Boolean restrictFromPos = JsonUtil.getBoolean(itemObject, "restrictFromPos");
        String membershipType = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"mship"));
        boolean newItem = false;
        Customer member = CustomerDAO.getInstance().get(id);
        if (member == null) {
            member = new Customer();
            member.setId(id);
            newItem = true;
        }
        member.setMemberId(memberId);
        member.setFirstName(firstName);
        member.setLastName(lastName);
        member.setSalutation(salutation);
        member.setDob(birthdate);
        member.setWorkPhoneNo(phone);
        member.setHomePhoneNo(homePhone);
        member.setEmail(email);
        member.setMemberType(memberType);
        member.setMemberShipTypeName(memberTypeName);
        member.setLastUpdateDate(SFDateUtil.parseBySFDate(lastUpdateDate));
        member.setBalance(NumberUtil.parseOrGetZero(balance).doubleValue());
        member.setTaxExempt(taxExempt);
        member.setRestrictedFromPOS(restrictFromPos);
        member.setActive(active);
        member.setMemberShipTypeName(membershipType);
        member.addProperty("taxExemptNo", taxExemptNo);
        member.addProperty("allergy", JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"allergy")));
        member.addProperty("foodPref", JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"foodPref")));
        member.addProperty("drinkPref", JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"drinkPref")));
        member.setBlueFlag(JsonUtil.getBooleanNotNull(itemObject, "blueFlag"));
        member.setGreenFlag(JsonUtil.getBooleanNotNull(itemObject, "greenFlag"));
        member.setOrangeFlag(JsonUtil.getBooleanNotNull(itemObject, "orangeFlag"));
        member.setPurpleFlag(JsonUtil.getBooleanNotNull(itemObject, "purpleFlag"));
        member.setRedFlag(JsonUtil.getBooleanNotNull(itemObject, "redFlag"));
        member.setYellowFlag(JsonUtil.getBooleanNotNull(itemObject, "yellowFlag"));
        if (StringUtils.isNotEmpty((String)ftPhotoUrl)) {
            MemberSyncable.setMemberImage(ftPhotoUrl, member);
        }
        if (newItem) {
            CustomerDAO.getInstance().save(member);
        } else {
            CustomerDAO.getInstance().update(member);
        }
        PosLog.debug(MemberSyncable.class, "ID: " + member.getId());
    }

    private static void setMemberImage(String ftPhotoUrl, Customer member) throws MalformedURLException, IOException {
        try {
            URL url = new URL(ftPhotoUrl);
            url.openConnection();
            InputStream openStream = url.openStream();
            byte[] byteArray = IOUtils.toByteArray((InputStream)openStream);
            openStream.close();
            int imageSizeInKb = byteArray.length / 1024;
            BufferedImage image = ImageIO.read(url);
            if (imageSizeInKb > 1000 && (byteArray = ImageUploaderDialog.convertImageToByteArray(image = ImageUploaderDialog.doScaleImageWithRatio(image, false, image.getWidth(), image.getHeight()))) != null && (imageSizeInKb = byteArray.length / 1024) > 1000) {
                throw new PosException(Messages.getString("ImageUploaderDialog.0"));
            }
            ImageResource imageResource = ImageResourceDAO.getInstance().get(ftPhotoUrl);
            if (imageResource == null) {
                imageResource = new ImageResource();
                imageResource.setId(ftPhotoUrl);
                ImageResourceDAO.getInstance().save(imageResource);
            }
            imageResource.setImageBytes(byteArray);
            imageResource.setImageCategory(ImageResource.IMAGE_CATEGORY.PEOPLE);
            ImageResourceDAO.getInstance().update(imageResource);
            member.setImageId(imageResource.getId());
        }
        catch (MalformedURLException url) {
        }
        catch (Exception e) {
            PosLog.error(MemberSyncable.class, e);
        }
    }

    private void doSyncCreditBook(JsonArray creditBooks) {
        try {
            Iterator iterator = creditBooks.iterator();
            while (iterator.hasNext()) {
                CreditBookType creditBookType;
                this.syncView.checkCancelStatus();
                JsonObject itemObject = (JsonObject)iterator.next();
                String id = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"Id"));
                String name = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"recordName"));
                String memberId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"memberId"));
                String createdDate = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"createdDate"));
                String expiryDate = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"expiryDate"));
                String lastModifiedDate = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"lastModifiedDate"));
                double amount = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"amount"));
                double balance = JsonUtil.getDoubleValue((JsonValue)itemObject.get((Object)"balance"));
                String creditBookTypeId = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"creditBookType"));
                Boolean expired = JsonUtil.getBoolean(itemObject, "expired");
                if (StringUtils.isNotEmpty((String)creditBookTypeId) && (creditBookType = CreditBookTypeDAO.getInstance().get(creditBookTypeId)) == null) {
                    creditBookType = new CreditBookType(creditBookTypeId);
                    creditBookType.setLabel(creditBookTypeId);
                    creditBookType.setValue(creditBookTypeId);
                    creditBookType.setActive(true);
                    CreditBookTypeDAO.getInstance().save(creditBookType);
                }
                CreditBook creditBook = CreditBookDAO.getInstance().get(id);
                boolean newItem = false;
                if (creditBook == null) {
                    creditBook = new CreditBook();
                    creditBook.setId(id);
                    newItem = true;
                }
                creditBook.setName(name);
                if (StringUtils.isNotBlank((String)memberId) && CustomerDAO.getInstance().get(memberId) != null) {
                    creditBook.setCustomerId(memberId);
                }
                creditBook.setCreatedDate(SFDateUtil.parseBySFDate(createdDate));
                creditBook.setLastModifiedDate(SFDateUtil.parseBySFDate(lastModifiedDate));
                creditBook.setCreditBookTypeId(creditBookTypeId);
                creditBook.setExpired(expired);
                creditBook.setExpiryDate(SFDateUtil.parseBySFFormat3Date(expiryDate));
                creditBook.setAmount(amount);
                creditBook.setBalance(balance);
                if (newItem) {
                    CreditBookDAO.getInstance().save(creditBook);
                } else {
                    CreditBookDAO.getInstance().update(creditBook);
                }
                this.syncView.setProgressValue(++this.count);
            }
        }
        catch (Exception e) {
            PosLog.error(MemberSyncable.class, e.getMessage());
        }
    }

    private void doSyncCreditBookTypes(JsonArray creditBookTypes) {
        try {
            Iterator iterator = creditBookTypes.iterator();
            while (iterator.hasNext()) {
                this.syncView.checkCancelStatus();
                JsonObject itemObject = (JsonObject)iterator.next();
                Boolean active = JsonUtil.getBoolean(itemObject, "active");
                Boolean defaultValue = JsonUtil.getBoolean(itemObject, "defaultValue");
                String label = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"label"));
                String value = JsonUtil.getStringValue((JsonValue)itemObject.get((Object)"value"));
                CreditBookType creditBookType = CreditBookTypeDAO.getInstance().get(value);
                boolean newCB = false;
                if (creditBookType == null) {
                    creditBookType = new CreditBookType(value);
                    newCB = true;
                }
                creditBookType.setActive(active);
                creditBookType.setDefaultValue(defaultValue);
                creditBookType.setLabel(label);
                creditBookType.setValue(value);
                if (newCB) {
                    CreditBookTypeDAO.getInstance().save(creditBookType);
                } else {
                    CreditBookTypeDAO.getInstance().update(creditBookType);
                }
                this.syncView.setProgressValue(++this.count);
            }
        }
        catch (Exception e) {
            PosLog.error(MemberSyncable.class, e.getMessage());
            throw e;
        }
    }

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }

    public String getSFMemberSyncTime() {
        Store store = DataProvider.get().getStore();
        return store.getProperty("salesforce.memberSyncTime");
    }
}

