/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.config.AppProperties;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.foretees.salesforce.sync.SyncErrorItemsInfoDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;

public class SyncErrorDialog
extends POSDialog {
    private JLabel lblErrorMessage;
    private List<Object> items;

    public SyncErrorDialog(Dialog parent) {
        super(parent, true);
        this.initComponents();
    }

    private void initComponents() {
        this.setTitle(AppProperties.getAppName());
        this.setDefaultCloseOperation(2);
        this.setSize(PosUIManager.getSize(400, 150));
        this.setLayout((LayoutManager)new MigLayout("center, fillx"));
        JLabel lblErrorIcon = new JLabel(UIManager.getIcon("OptionPane.errorIcon"));
        this.lblErrorMessage = new JLabel();
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("center, fillx"));
        PosButton btnDetails = new PosButton("Details");
        PosButton btnCancel = new PosButton("Cancel");
        bottomPanel.add(btnDetails);
        bottomPanel.add(btnCancel);
        btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SyncErrorDialog.this.doShowDetails();
            }
        });
        btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyncErrorDialog.this.setCanceled(true);
                SyncErrorDialog.this.dispose();
            }
        });
        this.add((Component)lblErrorIcon, "center, split 2");
        this.add((Component)this.lblErrorMessage, "wrap");
        this.add((Component)bottomPanel, "center");
    }

    public void setErrorMessage(String errMsg) {
        this.lblErrorMessage.setText(errMsg);
    }

    public void setErrorItems(List<Object> objects) {
        this.items = objects;
    }

    private void doShowDetails() {
        try {
            if (this.items == null) {
                return;
            }
            this.dispose();
            SyncErrorItemsInfoDialog paymentDialog = new SyncErrorItemsInfoDialog(this.items);
            paymentDialog.open();
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }
}

