/*
 * Decompiled with CFR 0.152.
 */
package com.foretees.salesforce.sync;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.SFSyncErrorLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.SFSyncDAO;
import com.floreantpos.model.dao.SFSyncErrorLogDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.foretees.salesforce.sync.SFDateUtil;
import com.foretees.salesforce.sync.SFException;
import com.foretees.salesforce.sync.SFUtil;
import com.foretees.salesforce.sync.SalesForceSyncable;
import com.foretees.salesforce.sync.SyncView;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateItemCostSync
implements SalesForceSyncable {
    private SyncView syncView;
    private int count;
    private List<MenuItem> menuItems;
    private Map<String, String> errorMap = new HashMap<String, String>();
    private List<MenuItem> errornuousItemList = new ArrayList<MenuItem>();
    public boolean hasSyncError;
    private String currentErrorMessage;
    private ArrayList<Object> errorItems;

    public SyncView getSyncView() {
        return this.syncView;
    }

    public void setSyncView(SyncView syncView) {
        this.syncView = syncView;
    }

    @Override
    public void doSync() throws Exception {
        if (this.syncView == null) {
            return;
        }
        this.errornuousItemList.clear();
        this.errorMap.clear();
        this.hasSyncError = false;
        this.currentErrorMessage = "";
        Store store = Application.getInstance().getStore();
        String syncTimeStr = store.getProperty("salesforce.updateItemSyncTime");
        Date prevSyncTime = StringUtils.isNotEmpty((String)syncTimeStr) ? SFDateUtil.parseBySFDate(syncTimeStr) : null;
        Date syncedTime = new Date();
        this.menuItems = SFSyncDAO.getInstance().getMenuItemsToUploadCostAndBalance(prevSyncTime);
        if (this.menuItems == null || this.menuItems.isEmpty()) {
            throw new PosException("No data to post.");
        }
        HashMap<String, MenuItemCostSyncModel> map = new HashMap<String, MenuItemCostSyncModel>();
        for (MenuItem menuItem : this.menuItems) {
            if (!menuItem.isVariant().booleanValue()) {
                this.addMenuItemToMap(map, menuItem);
                continue;
            }
            String parentMenuItemId = menuItem.getParentMenuItem().getId();
            MenuItemCostSyncModel menuItemInMap = (MenuItemCostSyncModel)map.get(parentMenuItemId);
            if (menuItemInMap != null) continue;
            MenuItem parentMenuItem = MenuItemDAO.getInstance().get(parentMenuItemId);
            this.addMenuItemToMap(map, parentMenuItem);
        }
        ArrayList<MenuItemCostSyncModel> list = new ArrayList<MenuItemCostSyncModel>(map.values());
        if (list == null || list.isEmpty()) {
            throw new PosException("No data to post.");
        }
        int itemsToUpload = list.size();
        this.count = 1;
        this.syncView.setSyncMessage("Total items to upload: " + itemsToUpload);
        this.syncView.setProgressMaximum(itemsToUpload);
        this.doUploadItems(list);
        this.logResult();
        this.doUpdateSyncTime(syncedTime);
        if (this.syncView != null) {
            this.syncView.dispose();
        }
    }

    private void addMenuItemToMap(Map<String, MenuItemCostSyncModel> map, MenuItem menuItem) {
        MenuItemDAO.getInstance().initialize(menuItem);
        MenuItemCostSyncModel costSyncModel = new MenuItemCostSyncModel();
        costSyncModel.setMenuItemId(menuItem.getId());
        costSyncModel.setMenuItemCost(menuItem.getCost());
        costSyncModel.setDescription(menuItem.getDescription());
        costSyncModel.setQuantityOnHand(menuItem.getUnitOnHand());
        costSyncModel.setChargeItemType(menuItem.getCmsTypeName());
        map.put(menuItem.getId(), costSyncModel);
    }

    private void doUpdateSyncTime(Date syncedTime) {
        try {
            DataProvider.get().refreshStore();
            Store store = DataProvider.get().getStore();
            store.addProperty("salesforce.updateItemSyncTime", SFDateUtil.formatDateAsSFFormat(syncedTime));
            StoreDAO.getInstance().saveOrUpdate(store);
            DataProvider.get().refreshStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void doUploadItems(List<MenuItemCostSyncModel> itemCostSyncList) throws Exception, IOException, SFException {
        boolean hasError;
        this.syncView.checkCancelStatus();
        JSONArray rootArray = new JSONArray();
        for (MenuItemCostSyncModel itemCostSyncModel : itemCostSyncList) {
            JSONObject menuItemObj = new JSONObject();
            this.createMenuItemObj(menuItemObj, itemCostSyncModel);
            rootArray.put((Object)menuItemObj);
            this.syncView.setProgressValue(this.count++);
        }
        PosLog.info(UpdateItemCostSync.class, rootArray.toString());
        HttpResponse response = SFUtil.postSfService(rootArray.toString(), SFUtil.POST_SERVICE_TYPE.UPDATE_ITEM);
        if (response == null) {
            throw new PosException("No response found from salesforce..");
        }
        boolean bl = hasError = !this.verifySFResponse(response);
        if (hasError) {
            PosLog.error(UpdateItemCostSync.class, this.currentErrorMessage);
        }
    }

    private void createMenuItemObj(JSONObject menuItemObj, MenuItemCostSyncModel costSyncModel) {
        menuItemObj.put("chargeItem_Id", (Object)costSyncModel.getMenuItemId());
        menuItemObj.put("chargeItem_cost", costSyncModel.getMenuItemCost());
        menuItemObj.put("chargeItem_quantityOnHand", costSyncModel.getQuantityOnHand());
        menuItemObj.put("chargeItem_description", (Object)costSyncModel.getDescription());
        menuItemObj.put("chargeItem_type", (Object)costSyncModel.getChargeItemType());
    }

    private boolean verifySFResponse(HttpResponse response) throws SFException, ParseException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            String sfdcError = EntityUtils.toString((HttpEntity)response.getEntity());
            throw new SFException(sfdcError, statusCode);
        }
        byte[] bytes = EntityUtils.toByteArray((HttpEntity)response.getEntity());
        JSONObject jsonObject = new JSONObject(new String(bytes));
        String jsonStatusCode = (String)jsonObject.get("statusCode");
        if (!"200".equals(jsonStatusCode)) {
            Object msgObj = jsonObject.get("message");
            if (msgObj != null) {
                String errorMessage;
                this.currentErrorMessage = errorMessage = msgObj.toString();
            }
            this.hasSyncError = true;
            return false;
        }
        return true;
    }

    private void logResult() {
        String errorLogString;
        StringBuffer buffer = new StringBuffer();
        if (this.errornuousItemList.size() > 0) {
            buffer.append("Error syncing the following items:\n");
            for (MenuItem menuItem : this.errornuousItemList) {
                buffer.append(String.format("item id: %s, item name: %s, cost %s, error reason: %s", menuItem.getId(), menuItem.getName(), menuItem.getCost(), this.errorMap.get(menuItem.getId())));
                buffer.append("\n");
            }
        }
        if (StringUtils.isNotEmpty((String)(errorLogString = buffer.toString()))) {
            PosLog.error(this.getClass(), "Sync error------------------------\n" + errorLogString);
        }
        if (this.hasSyncError) {
            this.errorItems = new ArrayList();
            this.errorItems.addAll(this.errornuousItemList);
            ArrayList<SFSyncErrorLog> errorLogs = new ArrayList<SFSyncErrorLog>();
            for (Map.Entry<String, String> entry : this.errorMap.entrySet()) {
                SFSyncErrorLog errorLog = new SFSyncErrorLog();
                errorLog.setId(entry.getKey());
                String reason = entry.getValue() != null ? entry.getValue().substring(0, Math.min(entry.getValue().length(), 255)) : "";
                errorLog.setErrorReason(reason);
                errorLogs.add(errorLog);
            }
            SFSyncErrorLogDAO.getInstance().saveAll(errorLogs);
        }
    }

    public class MenuItemCostSyncModel {
        private String menuItemId;
        private double menuItemCost;
        private double quantityOnHand;
        private String description;
        private String chargeItemType;

        public String getMenuItemId() {
            return this.menuItemId;
        }

        public void setMenuItemId(String menuItemId) {
            this.menuItemId = menuItemId;
        }

        public double getMenuItemCost() {
            return this.menuItemCost;
        }

        public void setMenuItemCost(double menuItemCost) {
            this.menuItemCost = menuItemCost;
        }

        public double getQuantityOnHand() {
            return this.quantityOnHand;
        }

        public void setQuantityOnHand(double quantityOnHand) {
            this.quantityOnHand = quantityOnHand;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getChargeItemType() {
            return this.chargeItemType;
        }

        public void setChargeItemType(String chargeItemType) {
            this.chargeItemType = chargeItemType;
        }
    }
}

